% Demonstration of MathViews syntax.
% This file tests many MathViews features for compatibility
% and enhancements.
% Use the program menu to step through this file.

clear
A=[1 2 3; 4 5 6; 7 8 0]
x=[-1.3,4/5,4*atan(1)]
B=A'
C=A*B
det(A)
inv(A)
inv(A)*A
D=1:3:18
D=1:4
w=0:.1:.5
w=0:0.1:0.5
x=[1 2 3
     4 5 6
     0 9 0]
any(x)
all(x)

Y=sin(D)
t=(0:8)'

x=-5:5+0.1
y=sqrt(x)
z=log(x+0.1)
y.^2

x=eye(4)
for col=x
    col
end
x=[x col]
size(x)
ans
[m,n]=size(x)
m
n

i=1
while i<8
      i=i+1
end
i=1
while i<4
     ++i
end

x=6
y=9
z=3
if y<x
   z=2*z
elseif z>x
   z=3*z
else
   z=4*z
end

if y<=x
   z *= z
end

x=[1:8;43:50;19:-1:12]
y=x(1:2,1:2)
x(1:2,:)
y(:)
x(:,1:4)
x(:,8:-1:1)
x(3:-1:1,8:-1:1)
x(:,:)
x(1:2,1:2)=x(1:2,4:5)
x(:,1:2)=x(:,4:5)


A=rand(5,3)/2000
x=rand(3,1)/2000
b=A*x
A\b
ans-x

fac(5)

t1=clock
w=blackman(n)'
t2=clock
t2-t1

t1=clock
w=blackman(n)'  % should be faster
t2=clock
t2-t1

x=6
y=9
z=2
if y>x,  z=z*z; end

x=sqrt(-10.1:1:2)
imag(x)
imag(log(sqrt(x)))

% m-files
n=5

x1=hilb(n)
x2=invhilb(n)
x1*x2

dft(1:n)

angle(sqrt(-1)+1)*2
cov(1:8)
isempty([])
isempty(1:6)
length([])
length(1:19)
length([1 2 3;4 5 6])

A=[1 2;3 4]
B=[0 1;-1 0]

x=1:8
x(1:8)
%x(1:8,:) % should report an error

rem(1:9,2)

% logical operators
2 < 4
x=1:8
4<x

% assignment
x=zeros(3,4)
y=1:12
x(:)=y

%svd
x=[1 2 3;4 6 1]
[x1,x2,x3]= svd(x)
x1'*x1
x2'*x2
x3'*x3

%matrix operations
x=[1 2 3;4 5 6;7 8 9;10 11 12]
x/3
3/x
y=[2 3 2 ;3 4 3;4 5 4;5 6 5]
x./y
y./x
x.\y
y.\x
a=[5 7 6 5;7 10 8 7;6 8 10 9;5 7 9 10]
b=[23 32 33 31]'
x=a\b
a*x-b
%a\(b')                % should report an error
inv(a)
a*inv(a)

%Jess
A=[1:3;3:-1:1;4 7 1]
B=[1 -1 -3 7;2 0 5 -5;3 1 7 3]
X=A\B

who
whos
save ezdsp
clear
who
whos
load ezdsp
who
whos

% m-file to demonstrate graphics
all_grp

% EZDSP enhancements
x=[1:8;43:50;19:-1:12]   % working variable

% shifting
x >> [1 2]
x >> [-1 -2]

% rotation
x <> [0 2]
x <> [0 -2]
x <> [1 2]

% C style assignments
x= 1:6
x += 3
x -= 4
x *= 3
x /= 6

% user interaction
pause(1)
pause(5)
pause
velocity=input('enter value for velocity')

%invoke the editor
!mathpad startup.m

disp('write to the output window')
%error('Example of error reporting')
