function [pg, cg, enbw, sl, wcpl] = wmerit(win)
%[pg, enbw, sl, wcpl] = wmerit(win)
%Computes figures of merit for a window 
%See F. J. Harris, "On the Use of Windows for Harmonic Analysis with
%the Discrete Fourier Transform", Proc. of IEEE, Vol. 66, No. 1, Jan 1978
%win  - is the window
%pg   - processing gain (power)
%cg   - coherent (voltage) gain (normalized to wrect(n) window)
%enbw - equivalent noise bandwidth  (bins)
%sl   - scalloping loss or picket-fence loss (power)
%wcpl - worst case processing loss

%       S.Halevy 7/31/92
%       Copyright (c) 1992 by the MathWizards

if ~isvector(win)
  error('vector argument is expected')
end
win  = win(:);
n    = length(win);
win /= max(win);         % all figures of merit required a normalized window

% CG - coherent voltage gain
%         coherent power gain 
cg = sum(win)/n;

% ENBW is measured in DFT bins, each bin has a width of fs/N
% where fs is the sampling frequency and N is the number of points

enbw = n*sum(win.^2)/(sum(win).^2);  % equivalent noise bandwidth (in bins)


% PG processing gain. The ratio of output signal-to-noise ratio (SNR)
% to the input SNR (it is a power ratio not a voltage ratio)

pg = 1 ./ enbw;


% SL is the scalloping loss or picket-fence effect loss. It is the
% loss associated for a sine wave mid-way between two frequency bins
% It represent the maximum reduction in processing gain due to the
% signal frequency
% use -20*log10(sl) to get Harris's results in dB

fc = exp(-pi * 1I * (0:n-1)/n);  % mid-way tone
sl = abs(fc * win)/sum(win);              % scalar = row * col

% WCPL is the worst case processing loss
% use -20*log10(wcpl) to convert to dB
wcpl = sqrt(pg)*sl;              % sqrt is needed to convert power to volt

