#include <errno.h>
#include <sys/doscalls.h>


/*
** AH = 0x44 ; AL = 09
** BL = drive
** ret: 1/0 remote or -1
*/
int dos_ioctl_remotedrive(unsigned char drive)
{
    struct REGPACK r;

    r.eax = 0x4409;
    r.ebx = drive;

    _intr(0x21, &r);

    if (r.eflags & 1) {
	_sys_doserror2errno( r.eax & 0xFFFF);
	return (-1);
    }
    else
	return (int) (r.edx & 0x1000) >> 12;
}
