#include <errno.h>
#include <sys/doscalls.h>

#define N_DOS_ERRORS 0x5A

#define RESERVED  EIO

static unsigned char dos_errors[N_DOS_ERRORS + 1] =
{
    0,			    /* 0x00  no error								 */
    EINVAL,		    /* 0x01  function number invalid				 */
    ENOENT,		    /* 0x02  file not found						 */
    ENOENT,		    /* 0x03  path not found						 */
    EMFILE,		    /* 0x04  too many open files					 */
    EACCES,		    /* 0x05  access denied						 */
    EBADF,		    /* 0x06  invalid handle						 */
    EIO,		    /* 0x07  memory control block destroyed		 */
    ENOMEM,		    /* 0x08  insufficient memory					 */
    EIO,		    /* 0x09  memory block address invalid			 */
    EINVAL,		    /* 0x0A  environment invalid					 */
    ENOEXEC,		    /* 0x0B  format invalid						 */
    EINVAL,		    /* 0x0C  access code invalid					 */
    EINVAL,		    /* 0x0D  data invalid							 */
    RESERVED,		    /* 0x0E  reserved								 */
    EACCES,		    /* 0x0F  invalid drive						 */
    EACCES,		    /* 0x10  attempted to remove current directory   */
    EXDEV,		    /* 0x11  not same device						 */
    ENOENT,		    /* 0x12  no more files						 */
    EIO,		    /* 0x13  disk write-protected					 */
    EIO,		    /* 0x14  unknown unit							 */
    EIO,		    /* 0x15  drive not ready						 */
    EIO,		    /* 0x16  unknown command						 */
    EIO,		    /* 0x17  data error 							 */
    EIO,		    /* 0x18  bad request structure length			 */
    EIO,		    /* 0x19  seek error 							 */
    EIO,		    /* 0x1A  unknown media type 					 */
    EIO,		    /* 0x1B  sector not found						 */
    ENOSPC,		    /* 0x1C  printer out of paper					 */
    EIO,		    /* 0x1D  write fault							 */
    EIO,		    /* 0x1E  read fault 							 */
    EIO,		    /* 0x1F  general failure						 */
    EACCES,		    /* 0x20  sharing violation						 */
    EACCES,		    /* 0x21  lock violation						 */
    EIO,		    /* 0x22  disk change invalid					 */
    EIO,		    /* 0x23  FCB unavailable						 */
    EIO,		    /* 0x24  sharing buffer overflow				 */
    EIO,		    /* 0x25  code page mismatch 					 */
    EIO,		    /* 0x26  cannot complete file operation		 */
    ENOSPC,		    /* 0x27  insufficient disk space				 */
    RESERVED,		    /* 0x28  reserved								 */
    RESERVED,		    /* 0x29  reserved								 */
    RESERVED,		    /* 0x2A  reserved								 */
    RESERVED,		    /* 0x2B  reserved								 */
    RESERVED,		    /* 0x2C  reserved								 */
    RESERVED,		    /* 0x2D  reserved								 */
    RESERVED,		    /* 0x2E  reserved								 */
    RESERVED,		    /* 0x2F  reserved								 */
    RESERVED,		    /* 0x30  reserved								 */
    RESERVED,		    /* 0x31  reserved								 */
    EIO,		    /* 0x32  network request not supported		 */
    EIO,		    /* 0x33  remote computer not listening		 */
    EIO,		    /* 0x34  duplicate name on network				 */
    EIO,		    /* 0x35  network name not found				 */
    EIO,		    /* 0x36  network busy							 */
    EIO,		    /* 0x37  network device no longer exists		 */
    EIO,		    /* 0x38  network BIOS command limit exceeded	 */
    EIO,		    /* 0x39  network adapter hardware error		 */
    EIO,		    /* 0x3A  incorrect response from network		 */
    EIO,		    /* 0x3B  unexpected network error				 */
    EIO,		    /* 0x3C  incompatible remote adapter			 */
    ENOSPC,		    /* 0x3D  print queue full						 */
    ENOSPC,		    /* 0x3E  queue not full						 */
    EIO,		    /* 0x3F  not enough space to print file		 */
    EIO,		    /* 0x40  network name was deleted				 */
    EACCES,		    /* 0x41  network: Access denied				 */
    EIO,		    /* 0x42  network device type incorrect		 */
    EIO,		    /* 0x43  network name not found				 */
    EIO,		    /* 0x44  network name limit exceeded			 */
    EIO,		    /* 0x45  network BIOS session limit exceeded	 */
    EIO,		    /* 0x46  temporarily paused 					 */
    EIO,		    /* 0x47  network request not accepted			 */
    EIO,		    /* 0x48  network print/disk redirection paused   */
    EACCES,		    /* 0x49  invalid network version				 */
    EIO,		    /* 0x4A  account expired						 */
    EIO,		    /* 0x4B  password expired						 */
    EIO,		    /* 0x4C  login attempt invalid at this time 	 */
    EIO,		    /* 0x4D  disk limit exceeded on network node	 */
    EIO,		    /* 0x4E  not logged in to network node		 */
    RESERVED,		    /* 0x4F  reserved								 */
    EEXIST,		    /* 0x50  file exists							 */
    RESERVED,		    /* 0x51  reserved								 */
    ENOENT,		    /* 0x52  cannot make directory				 */
    EIO,		    /* 0x53  fail on INT 24h						 */
    EIO,		    /* 0x54  too many redirections				 */
    EIO,		    /* 0x55  duplicate redirection				 */
    EIO,		    /* 0x56  invalid password						 */
    EINVAL,		    /* 0x57  invalid parameter						 */
    EIO,		    /* 0x58  network write fault					 */
    EIO,		    /* 0x59  function not supported on network		 */
    EIO 		    /* 0x5A  required system component not installed */
};

void _sys_doserror2errno(unsigned short error_dos)
{
    if (error_dos >= N_DOS_ERRORS)
	errno = EIO;
    else
	errno = dos_errors[error_dos];
}

