/*
	rtf2troff.h - rtf2troff defines, structures, externs
*/

# define	bcopy(src,dst,len)	((void) memcpy(dst,src,len))
typedef unsigned long	u_long;
/* troff versions understood */

# define	TROFF	0	/* generic troff */
# define	XROFF	1	/* Image Network xroff */
# define	PSTROFF	2	/* ditroff + public domain tpscript backend */

/* macro packages understood */

# define	noMacros	0
# define	meMacros	1
# define	mmMacros	2
# define	msMacros	3


/*
	macro/register names
*/

# define	mHeader		"He"
# define	mHeaderAll	"Ha"
# define	mHeaderFirst	"Hf"
# define	mHeaderLeft	"Hl"
# define	mHeaderRight	"Hr"
# define	mFooter		"Fo"
# define	mFooterAll	"Fa"
# define	mFooterFirst	"Ff"
# define	mFooterLeft	"Fl"
# define	mFooterRight	"Fr"

/* normally Hp > Tm > Bm > Fp */

# define	rTitlePageSpecial	"Tp"
# define	rTopMargin	"Tm"
# define	rHeaderPos	"Hp"
# define	rBottomMargin	"Bm"	/* from *top* of page! */
# define	rFooterPos	"Fp"	/* from *top* of page! */
# define	rHeaderAll	"Ha"
# define	rHeaderFirst	"Hf"
# define	rHeaderLeft	"Hl"
# define	rHeaderRight	"Hr"
# define	rFooterAll	"Fa"
# define	rFooterFirst	"Ff"
# define	rFooterLeft	"Fl"
# define	rFooterRight	"Fr"



/*
	rtfTabLeft is used to indicate the default tab type (left tab).
	RTF assumes that if some other type is not specified, a tab is
	a left tab and never indicates that explicitly.  It's given a
	number here so the writer can refer to it by a constant known
	to be different from the other tab types.  (All "real" token
	numbers are non-negative.)

	rtfLeaderMotion is used to indicate default tab char (motion only),
	which likewise is undefined in RTF.

	rtfNoDestination is used to indicate that a state has had no
	destination specified yet.

	rtfNoBorderType indicates that a paragraph has no borders.
*/

# define	rtfTabLeft		(-1)
# define	rtfLeaderMotion		(-1)
# define	rtfNoDestination	(-1)
# define	rtfNoBorderType		(-1)


# define	styleBold	0x0001
# define	styleItalic	0x0002
# define	styleStrikeThru	0x0004
# define	styleOutline	0x0008
# define	styleShadow	0x0010
# define	styleSmallCaps	0x0020
# define	styleAllCaps	0x0040
# define	styleInvisible	0x0080
# define	styleUnderline	0x0100
# define	styleWUnderline	0x0200

# define	StyleFontBits(s)	(s & (styleBold | styleItalic))

/*
	Values for operations that map border positions onto bits
	in flag word.
*/

# define	borderTop	0x0001
# define	borderBottom	0x0002
# define	borderLeft	0x0004
# define	borderRight	0x0008

/*
	Values for operations that map border positions to array indices.
	Must be zero-based and sequential.
*/

# define	topIndex	0
# define	leftIndex	1
# define	bottomIndex	2
# define	rightIndex	3


# define	lineBreakLen	60	/* break lines after 60 columns */


# define	maxIStack	10	/* internal state stack depth */
# define	maxWStack	3	/* written state stack depth */
# define	maxTab		20
# define	maxCell		20



typedef	struct State		State;
typedef	struct DocState		DocState;
typedef	struct SectState	SectState;
typedef	struct ParState		ParState;
typedef	struct CharState	CharState;

typedef	struct TblState		TblState;	/* this is separate */


/* document properties */

struct DocState
{
	int	landscape;		/* non-zero if landscape */
	double	pageWidth;		/* paper width */
	double	pageHeight;		/* paper height */
	double	leftMargin;		/* left margin */
	double	rightMargin;		/* right margin */
	double	topMargin;		/* top margin */
	double	bottomMargin;		/* bottom margin */
	double	tabWidth;		/* default tab width */
};


/* section properties */

struct SectState
{
	int	breakType;		/* section break type */
	int	pageStart;		/* section starting page number */
	int	pageRestart;		/* restart page numbering each sect. */
	double	headerPos;		/* from top of page */
	double	footerPos;		/* from bottom of page */
	int	titleSpecial;		/* first page special */
};


/* paragraph properties */

struct ParState
{
	double	firstIndent;		/* first indent */
	double	leftIndent;		/* left indent */
	double	rightIndent;		/* right indent */
	double	spaceBefore;		/* space before lines */
	double	spaceAfter;		/* space after lines */
	double	spaceBetween;		/* space between lines */
	int	tabFlag;		/* any tabs set yet? (0 = no) */
	int	nTabs;			/* number of tabs (0 = defaults) */
	double	tab[maxTab];		/* tab positions */
	int	tabType[maxTab];	/* tab types */
	int	tabChar;		/* tab (leader) character */
	int	justification;		/* justification */
	int	borderType;		/* type of border */
	int	borderFlags;		/* where to draw borders */
};


/* character properties */

struct CharState
{
	int	fontSize;		/* font (point) size */
	u_long	charStyle;		/* character style */
	double	superScript;		/* superscript */
	double	subScript;		/* subscript */
};

struct State
{
	int		destination;	/* state destination */
	DocState	docState;
	SectState	sectState;
	ParState	parState;
	CharState	charState;
};


/* table properties */

struct TblState
{
	int	tableHeader;		/* non-zero if table header written */
	int	nCells;			/* number of cells */
	int	curCell;		/* current cell (0-based) */
	double	cellPos[maxCell];	/* cell positions (right edge) */
	double	tableLeft;		/* table left edge position */
	double	cellGap;		/* horiz. gap between cells */
	int	border[maxCell][4];	/* cell borders */
};

extern int	tvers;		/* troff version */
extern int	mvers;		/* macro package version */

extern TblState	*its;
extern int	inTable;

extern FILE	*f;


extern State		*is;		/* current internal state */
extern DocState		*ids;		/* internal document state */
extern SectState	*iss;		/* internal section state */
extern ParState		*ips;		/* internal paragraph state */
extern CharState	*ics;		/* internal character state */

extern State		*ws;		/* written state */
extern DocState		*wds;		/* written document state */
extern SectState	*wss;		/* written section state */
extern ParState		*wps;		/* written paragraph state */
extern CharState	*wcs;		/* written character state */

extern int	docStateChanged;	/* document properties have changed */
extern int	sectStateChanged;	/* section properties have changed */
extern int	parStateChanged;	/* paragraph properties have changed */
extern int	charStateChanged;	/* character properties have changed */

# define	stateChanged	\
	(docStateChanged||sectStateChanged||parStateChanged||charStateChanged)


extern int	indirectionLevel;


extern void	InitState ();
extern void	CheckFinalState ();
extern void	PushIState ();
extern void	PopIState ();
extern void	PushWState ();
extern void	PopWState ();
extern void	BeginDiversion ();
extern void	EndDiversion ();
extern void	RestoreSectDefaults ();
extern void	RestoreParDefaults ();
extern void	RestoreCharDefaults ();


extern void	InitTabSet ();


extern int	MapBorderLocation ();


extern void	SelectFormatterMaps ();
extern void	SelectMacPackMaps ();
extern void	SelectCharSetMaps ();
extern char	*CharMapping ();


extern void	TblAttr ();
extern void	BeginTbl ();
extern void	EndTbl ();
extern void	BeginCell ();
extern void	EndCell ();


extern void	FlushState ();
extern void	FlushInitialState ();
extern void	FlushSectState ();
extern void	Flush ();
extern void	SaveTblFPV ();
extern void	FlushTblFPV ();

extern double	EnWidth ();

extern void	ResetPar ();
extern void	ResetParLine ();
extern void	Sect ();
extern void	Par ();
extern void	PutString ();
extern void	Comment ();
