/*
** TabDlg DLL
** Copyright (c) 1994 Edward McCreary.
** All rights reserved.
**
** Redistribution and use in source and binary forms are freely permitted
** provided that the above copyright notice and attibution and date of work
** and this paragraph are duplicated in all such forms.
** THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
** WARRANTIES OF MERCHANTIBILILTY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

/* one control in a tab */
typedef struct tagTabCtl
{
 WORD   wID;
 struct tagTabCtl   *next;
} TAB_CTL;

/* one tab with list of controls */
typedef struct tagTabEntry
{
 char       *name;
 int        nTabID;
 TAB_CTL    *controls;
 
 struct tagTabEntry *next;
} TAB_ENTRY;

/* store info for one frame control */
typedef struct tagFrame
{
 HWND       hWnd;       /* window handle of frame */
 HWND       hDlg;       /* dialog handle */
 WNDPROC    OldWndProc; /* original windows proc */
 WNDPROC    OldDlgProc; /* original dialog proc */
 TAB_ENTRY  *tab_list;  /* list of tabs */
 int        nTopTab;    /* id of top tab */
 int        nNextTab;   /* id of next tab to be created */
 BOOL       bUseShadow; /* put a shadow under tab title */
} FRAME_ENTRY;
 
#define MAX_ENTRY   32  /* maximum number of frames allowed to be registered */

LONG WINAPI __export FrameWndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
LONG WINAPI __export DlgWndProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);
void __export RegisterLibrary(void);
void __export UnRegisterFrame(HWND hWnd);
void __export UnRegisterLibrary(void);
void UpdateTabs(HWND hDlg);
void __export PaintFrame(FRAME_ENTRY *pFrame);
void __export PaintTabs(FRAME_ENTRY *pFrame,HDC hdc,LPRECT lprc);
void __export PaintDownTab(HDC hdc, LPRECT lprc);
void __export PaintUpTab(HDC hdc, LPRECT lprc);
void FreeTab(TAB_ENTRY *pTab);
FRAME_ENTRY __export *GetFrameEntry(HWND hDlg);
TAB_ENTRY __export *GetTabEntry(FRAME_ENTRY *pFrame,int nTabID);
int TabHit(HWND hDlg,WORD x, WORD y);
int GetTabWidth(FRAME_ENTRY *pFrame);
void DrawTabText(HDC hdc,LPRECT lprc,LPCSTR text,BOOL bTop, BOOL bShadow);
int __export GetLastTab(FRAME_ENTRY *pFrame);
BOOL WINAPI CreateSingleTab(HWND hDlg,HINSTANCE hInst, UINT wFrameID, 
    TAGTEMPLATE FAR *lpTemplate);
BOOL WINAPI __export AddControl(TAB_ENTRY *pTab, WORD wControlID);