/*
** TabDlg DLL
** Copyright (c) 1994 Edward McCreary.
** All rights reserved.
**
** Redistribution and use in source and binary forms are freely permitted
** provided that the above copyright notice and attibution and date of work
** and this paragraph are duplicated in all such forms.
** THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
** WARRANTIES OF MERCHANTIBILILTY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include "tabdlg2.h"
#include "common.h"
#include "dyndlg.h"

/*
**
** All of the code below is taken from Jeffery Richter's
** Windows 3.1:A Developer's Guide with slight modifications
*/

typedef struct {
   long dtStyle;
   BYTE dtItemCount;
   int  dtX;
   int  dtY;
   int  dtCX;
   int  dtCY;
// char dtMenuName[];      // Variable-length string.
// char dtClassName[];     // Variable-length string.
// char dtCaptionText[];   // Variable-length string.
} DLGTEMPLATE, FAR *LPDLGTEMPLATE;

typedef struct {
   short int PointSize;
// char  szTypeFace[];     // Variable-length string.
} FONTINFO, FAR *LPFONTINFO;

typedef struct {
   int  dtilX;
   int  dtilY;
   int  dtilCX;
   int  dtilCY;
   int  dtilID;
   long dtilStyle;
// char dtilClass[];       // Variable-length string.
// char dtilText[];        // Variable-length string.
// BYTE dtilInfo;          // # bytes in following memory block.
// BYTE dtilData;          // Variable-length memory block.
} DLGITEMTEMPLATE, FAR *LPDLGITEMTEMPLATE;


#define PREDEFINEDCNTRLBIT       0x80
#define BUTTONCNTRLCODE          0x80
#define EDITCNTRLCODE            0x81
#define STATICCNTRLCODE          0x82
#define LISTBOXCNTRLCODE         0x83
#define SCROLLBARCNTRLCODE       0x84
#define COMBOBOXCNTRLCODE        0x85

static char *szPredefinedClassNames[] =
   { "BUTTON", "EDIT", "STATIC",
   "LISTBOX", "SCROLLBAR", "COMBOBOX" };

BOOL WINAPI MergeControlsIntoDlg
      (HWND hDlg, UINT uIDChangeableArea,
      HINSTANCE hInstance, TAB_ENTRY *pTab,LPCSTR szDlgTemplate) 
{

   HWND hWndPrevChild = GetDlgItem(hDlg, uIDChangeableArea);
   HFONT hFont;
   LPBYTE p, lpszClass, lpszText, lpCreateParams;
   LPDLGTEMPLATE lpDlgTemplate;
   LPDLGITEMTEMPLATE lpDlgItemTemplate;
   LPFONTINFO lpFontInfo;
   HWND hWndChild;
   BYTE bNumControls;
   HRSRC hrsrcDialog;
   HGLOBAL hGlblDlgTemplate;
   RECT rc;

   hrsrcDialog =
      FindResource(hInstance, szDlgTemplate, RT_DIALOG);
   if (hrsrcDialog == NULL) return(FALSE);
   hGlblDlgTemplate = LoadResource(hInstance, hrsrcDialog);
   lpDlgTemplate = (LPDLGTEMPLATE) LockResource(hGlblDlgTemplate);
   if (lpDlgTemplate == NULL) return(FALSE);

   hFont = GetWindowFont(hDlg);

   // Ignore everything in Dialog Template except for the number 
   // of controls.
   bNumControls = lpDlgTemplate->dtItemCount;

   p = (LPBYTE) (&lpDlgTemplate->dtCY + 1);  // Start of Menu name
   while (*p++ != 0) ;           // Skip the menu name string
   while (*p++ != 0) ;           // Skip the Class name string
   while (*p++ != 0) ;           // Skip the Caption string
   lpFontInfo = (LPFONTINFO) p;  // Start of FONTINFO (if exists)

   // Find address of first DLGITEMTEMPLATE structure
   if (lpDlgTemplate->dtStyle & DS_SETFONT) {
      p = (LPBYTE) (&lpFontInfo->PointSize + 1);
      while (*p++ != 0) ;  // Skip the Type face name string
      lpDlgItemTemplate = (LPDLGITEMTEMPLATE) p;
   } else lpDlgItemTemplate = (LPDLGITEMTEMPLATE) lpFontInfo;

   // Create all of the child controls
   while (bNumControls-- != 0) {

      lpszClass = (LPBYTE) (&lpDlgItemTemplate->dtilStyle + 1);
      if (*lpszClass & PREDEFINEDCNTRLBIT) {
         lpszText = lpszClass + 1;
         lpszClass = (LPBYTE) szPredefinedClassNames
            [(WORD)(*lpszClass) - PREDEFINEDCNTRLBIT];
      } else for (lpszText = lpszClass; *lpszText++ != 0; ) ;

      // Find address of number-of-bytes-in-additional-data
      for (lpCreateParams = lpszText; *lpCreateParams++ != 0; ) ;

      // Do not create any windows with an ID of uIDChangeableArea
      // This control was used for reference when the template was
      // created and should not be created.
      if (lpDlgItemTemplate->dtilID == uIDChangeableArea)
         goto NextControl;
      
      /* add control to list in tab, em 5/9/94 */
      AddControl(pTab,lpDlgItemTemplate->dtilID);
      
      SetRect(&rc, lpDlgItemTemplate->dtilX,
         lpDlgItemTemplate->dtilY,
         lpDlgItemTemplate->dtilX + lpDlgItemTemplate->dtilCX,
         lpDlgItemTemplate->dtilY + lpDlgItemTemplate->dtilCY);
      MapDialogRect(hDlg, &rc);

      hWndChild = CreateWindowEx(WS_EX_NOPARENTNOTIFY,
         (LPCSTR) lpszClass, (LPCSTR) lpszText,
         lpDlgItemTemplate->dtilStyle,
         rc.left, rc.top,
         rc.right - rc.left, rc.bottom - rc.top,
         hDlg, (HMENU) lpDlgItemTemplate->dtilID, hInstance,
         lpCreateParams + 1); // +1 to point to 1st byte of data

      if (hWndChild == NULL) {
         // The child couldn't be create
         UnlockResource(hGlblDlgTemplate);
         FreeResource(hGlblDlgTemplate);
         return(FALSE);
      }

      // Tell the new control to use the same font as dialog box
      SetWindowFont(hWndChild, hFont, FALSE);

      // Fix the Z-Order of the controls
      SetWindowPos(hWndChild, hWndPrevChild, 0, 0, 0, 0,
         SWP_NOMOVE | SWP_NOSIZE);
      hWndPrevChild = hWndChild;

      NextControl:
      // Point to the next DlgItemTemplate
      lpDlgItemTemplate = (LPDLGITEMTEMPLATE)
         (lpCreateParams + 1 + *lpCreateParams);
   }

   UnlockResource(hGlblDlgTemplate);
   FreeResource(hGlblDlgTemplate);
   return(TRUE);
}
