// demoview.cpp : implementation of the CDemoView class
//

#include "stdafx.h"
#include "tab.h"

#include "tabdoc.h"
#include "tabview.h"
#include "drawview.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDrawView
#define BASE CScrollView
#define THIS CDrawView

IMPLEMENT_DYNCREATE(CDrawView, CScrollView)

BEGIN_MESSAGE_MAP(CDrawView, CScrollView)
	//{{AFX_MSG_MAP(CDrawView)
	ON_WM_LBUTTONDOWN()
	ON_COMMAND(ID_LOOK_CHICAGO, OnLookChicago)
	ON_COMMAND(ID_LOOK_MSWORD, OnLookMsword)
	ON_WM_SYSCOMMAND()
	ON_WM_ERASEBKGND()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDrawView construction/destruction

THIS::THIS()
{
}

THIS::~THIS()
{
}

/////////////////////////////////////////////////////////////////////////////
// CDrawView drawing

void THIS::OnDraw(CDC* pDC)
{
	CTabDoc* pDoc = GetDocument();
	CRect rect;
	int x=10,y=10;
	CRect clip,interSect;
	
	pDC->GetClipBox(&clip);
	
	for(int i=0;i<20;i++)
	{
		for(int j=0;j<20;j++)
		{
			rect.SetRect(x,y,x+50,y+50);
			if(interSect.IntersectRect(&rect,&clip))
				drawButton(pDC,rect,"TAB");
			x += 100;
		}
		if(i % 2)
			x = 10;
		else
			x = 60;
		y += 50;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CDemoView printing

BOOL THIS::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void THIS::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void THIS::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}




/////////////////////////////////////////////////////////////////////////////
// CDemoView diagnostics

#ifdef _DEBUG
void THIS::AssertValid() const
{
	CScrollView::AssertValid();
}

void THIS::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CTabDoc* THIS::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CTabDoc)));
	return (CTabDoc*) m_pDocument;
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDemoView message handlers

void THIS::OnLButtonDown(UINT nFlags, CPoint point)
{
	AfxMessageBox("Mouse is Down in CDrawView object");
}
void THIS::OnInitialUpdate()
{
	CSize size(1500,1500);
	SetScrollSizes(MM_TEXT,size);
}
void THIS::OnSysCommand(UINT nChar,LONG lParam)
{
	if(m_pTabView->doSysCommand(nChar,lParam))
		return;
	BASE::OnSysCommand(nChar,lParam);
}
void THIS::OnLookChicago()
{
	m_pTabView->setLAF(LAF_CHICAGO);
}

void THIS::OnLookMsword()
{
	m_pTabView->setLAF(LAF_MSWORD);
}

BOOL CDrawView::OnEraseBkgnd(CDC* pDC)
{
	
	CBrush backBrush(RGB(0,0,255));
	CBrush* pOldBrush = pDC->SelectObject(&backBrush);
	
	CRect rect;
	pDC->GetClipBox(&rect);	//erase the area needed
	pDC->PatBlt(rect.left,rect.top,rect.Width(),rect.Height(),PATCOPY);
	pDC->SelectObject(pOldBrush);
	return TRUE;
}
#define BKPEN()pDC->SelectObject(&blackPen)
#define LTPEN()pDC->SelectObject(&lightPen)
#define DKPEN()pDC->SelectObject(&darkPen)
void	THIS::drawButton(CDC* pDC, CRect rect, char* label)
{
    int oldMode = pDC->SetBkMode(TRANSPARENT);
  	COLORREF oldTextColor = pDC->SetTextColor(GetSysColor(COLOR_BTNTEXT));
	CPen darkPen(PS_SOLID,0,GetSysColor(COLOR_BTNSHADOW));
	CPen lightPen(PS_SOLID,0,GetSysColor(COLOR_BTNHIGHLIGHT));
	CPen* pOldPen = pDC->SelectObject(&darkPen);
//fill background
	CBrush backBrush(GetSysColor(COLOR_BTNFACE));
	CBrush* pOldBrush = pDC->SelectObject(&backBrush);
	pDC->PatBlt(rect.left,rect.top,rect.Width(),rect.Height(),PATCOPY);
	pDC->SelectObject(pOldBrush);
//dark
 	pDC->MoveTo(rect.left,rect.bottom);
 	pDC->LineTo(rect.right,rect.bottom);
 	pDC->LineTo(rect.right,rect.top);

 	pDC->MoveTo(rect.left+1,rect.bottom-1);
 	pDC->LineTo(rect.right-1,rect.bottom-1);
 	pDC->LineTo(rect.right-1,rect.top+1);
//light
	LTPEN();
 	pDC->MoveTo(rect.left,rect.bottom-1);
 	pDC->LineTo(rect.left,rect.top);
 	pDC->LineTo(rect.right-1,rect.top);

 	pDC->MoveTo(rect.left+1,rect.bottom-2);
 	pDC->LineTo(rect.left+1,rect.top+1);
 	pDC->LineTo(rect.right-2,rect.top+1);
//text
	if(label)
		pDC->DrawText(label,-1,&rect,DT_CENTER|DT_VCENTER|DT_SINGLELINE);
//cleanup
	pDC->SelectObject(pOldPen);
	pDC->SetTextColor(oldTextColor);
	pDC->SetBkMode(oldMode);
}
void THIS::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	switch(nChar)
	{
		case VK_HOME:
			OnScroll(MAKEWORD(SB_TOP,SB_TOP), 0);
			break;
		case VK_END:
			OnScroll(MAKEWORD(-1,SB_BOTTOM), 0);
			break;
		case VK_UP:
			OnScroll(MAKEWORD(-1,SB_LINEUP), 0);
			break;
		case VK_DOWN:
			OnScroll(MAKEWORD(-1,SB_LINEDOWN), 0);
			break;
		case VK_PRIOR:
			OnScroll(MAKEWORD(-1, SB_PAGEUP), 0);
			break;
		case VK_NEXT:
			OnScroll(MAKEWORD(-1, SB_PAGEDOWN), 0);
			break;
		case VK_LEFT:
			OnScroll(MAKEWORD(SB_PAGEUP,-1), 0);
			break;
		case VK_RIGHT:
			OnScroll(MAKEWORD(SB_PAGEDOWN,-1), 0);
			break;
		default:
			break;
	}
}
