/****************************************************************************

    PROGRAM:    Vlibdemo.exe

    PURPOSE:    To demonstrate the usage of Visualib(TM) functions.
    
    PROVIDER:   Visual Tech Co.
				P.O.Box 8735
				Fort Wayne, IN 46898-8735
				Tel. (219) 289-0235
				Fax. (816) 746-6618
    
    DATE:		Januray. 1994

****************************************************************************/

#include <windows.h>
#include <math.h>
#include <malloc.h>
#include "visualib.h"
#include "vlibdemo.h"
#include "demoproc.h"
#include "dialogs.h"

HINSTANCE	hInst;
short   viewer20 = 0, viewer21 = 0, viewer22 = 0;
short   viewer30 = 0, viewer31 = 0, viewer32 = 0,
		viewer33 = 0, viewer34 = 0, viewer35 = 0;
short   demo_function, animate_length;
short   light0 = 0, light1 = 0, light2 = 0, light3 = 0,
		light4 = 0, light5 = 0, light6 = 0, light7 = 0, light8 = 0;
short   mater0, mater1, mater2, mater3, mater4, mater5, mater6, mater7;
HGLOBAL hdib1 = NULL, hdib2 = NULL, hdib3 = NULL;
COLORREF	backcolor;
BOOL	withframe = FALSE;
HPALETTE	hpal;

void    FunctionDemos (HDC hdc); 

int PASCAL _export WinMain (HINSTANCE hInst, HINSTANCE hPrev, LPSTR CmdLine, int nCmdShow)
{
    MSG msg;

    if (hPrev)
        return (FALSE);

    if (!InitApplication (hInst))
        return (FALSE);
    
    if (!InitInstance (hInst, nCmdShow))
        return (FALSE);
    
    while (GetMessage (&msg, NULL, NULL, NULL)) {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }
    return (msg.wParam);
}

void    ViewerReset ()
{
    RECT    port;

	if (viewer21) {
		SetRect (&port, 10, 10, 110, 110);
		SetViewport (viewer21, port);
		SetWindow2D (viewer21, -10, -10, 10, 10);
	}

	if (viewer22) {
		SetRect (&port, 10, 10, 410, 227);
		SetViewport (viewer22, port);
		SetWindow2D (viewer22, 0, 0, 1, (REAL) (13.0 / 24.0));
	}

	if (viewer31) {
		SetRect (&port, 120, 10, 220, 110);
		SetViewport (viewer31, port);
		SetView3D (viewer31, 100, 100, 100, 0, 0, 0, 0);
		SetPerspective (viewer31, 45, 1, 1, 1000);
	}

	if (viewer32) {
		SetRect (&port, 230, 10, 330, 110);
		SetViewport (viewer32, port);
		SetView3D (viewer32, 100, 100, 100, 0, 0, 0, 0);
		SetPerspective (viewer32, 45, 1, 1, 1000);
	}

	if (viewer33) {
		SetRect (&port, 230, 130, 330, 230);
		SetViewport (viewer33, port);
		SetPolarView (viewer33, 1, 1, 0, 20, 75, 45, 0);
		SetPerspective (viewer33, 90, 1, 1, 1000);
	}

	if (viewer34) {
		SetRect (&port, 120, 130, 220, 230);
		SetViewport (viewer34, port);
		SetPolarView (viewer34, 0, 0, 0, 10, 45, 45, 0);
		SetProjection3D (viewer34, -10, -10, 10, 10, 1, 100, VL_ORTHOGONAL);
	}

	if (viewer35) {
		SetRect (&port, 10, 130, 110, 230);
		SetViewport (viewer35, port);
		SetPolarView (viewer35, 0, 0, 0, 20, 75, 45, 0);
		SetPerspective (viewer35, 90, 1, 1, 80);
	}
}

/****************************************************************************

    FUNCTION: InitApplication (HANDLE)

****************************************************************************/

BOOL InitApplication (HINSTANCE hInstance)
{
    WNDCLASS  wc;
    RECT    port;
	VECTOR3	parameter;
	HDC		hdc;

	if (!InitializeVisualib ())
		return (FALSE);

	hpal = SetRGBPalette ();

	light0 = CreateLight (NULL, VL_DISTLIGHT);
	if (light0) {
		SelectLight (light0);
		SetLightCoordinateType (VL_CURRENT, VL_WORLDLIGHT);
		VSET3 (parameter, 3, 1, 3);
		ShadingParameter (VL_CURRENT, VL_LIGHTDIRECTION, FALSE, parameter);
		ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (255, 255, 255));
	}

	light1 = CreateLight (NULL, VL_DISTLIGHT);
	if (light1) {
		SelectLight (light1);
		SetLightCoordinateType (VL_CURRENT, VL_WORLDLIGHT);
		VSET3 (parameter, 5, 1, 4);
		ShadingParameter (VL_CURRENT, VL_LIGHTDIRECTION, FALSE, parameter);
		ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (255, 255, 255));
		SwitchLight (VL_CURRENT, TRUE);
	}

	light2 = CreateLight (NULL, VL_POINTLIGHT);
	if (light2) {
		SelectLight (light2);
		VSET3 (parameter, -50, 0, 0);
		ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, FALSE, parameter);
		ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (51, 255, 51));
	}

	light3 = CreateLight (NULL, VL_POINTLIGHT);
	if (light3) {
		SelectLight (light3);
		VSET3 (parameter, 250, -20, 0);
		ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, FALSE, parameter);
		ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (51, 51, 255));
	}

	light4 = CreateLight (NULL, VL_SPOTLIGHT);
	if (light4) {
		SelectLight (light4);
		SetLightCoordinateType (VL_CURRENT, VL_WORLDLIGHT);
		VSET3 (parameter, 0, 100, 100);
		ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, FALSE, parameter);
		VSET3 (parameter, 0, -1, -1);
		ShadingParameter (VL_CURRENT, VL_LIGHTDIRECTION, FALSE, parameter);
		ShadingFactor (VL_CURRENT, VL_SPOTLIGHTANGLE, 20);
		ShadingFactor (VL_CURRENT, VL_SPOTLIGHTSPREAD, 50);
		ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (255, 0, 0));
	}

	light5 = CreateLight (NULL, VL_SPOTLIGHT);
	if (light5) {
		SelectLight (light5);
		SetLightCoordinateType (VL_CURRENT, VL_WORLDLIGHT);
		VSET3 (parameter, 100, 0, 100);
		ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, FALSE, parameter);
		VSET3 (parameter, -1, 0, -1);
		ShadingParameter (VL_CURRENT, VL_LIGHTDIRECTION, FALSE, parameter);
		ShadingFactor (VL_CURRENT, VL_SPOTLIGHTANGLE, 20);
		ShadingFactor (VL_CURRENT, VL_SPOTLIGHTSPREAD, 50);
		ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (0, 255, 0));
	}

	light6 = CreateLight (NULL, VL_SPOTLIGHT);
	if (light6) {
		SelectLight (light6);
		SetLightCoordinateType (VL_CURRENT, VL_WORLDLIGHT);
		VSET3 (parameter, 100, 100, 100);
		ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, FALSE, parameter);
		VSET3 (parameter, -1, -1, -1);
		ShadingParameter (VL_CURRENT, VL_LIGHTDIRECTION, FALSE, parameter);
		ShadingFactor (VL_CURRENT, VL_SPOTLIGHTANGLE, 20);
		ShadingFactor (VL_CURRENT, VL_SPOTLIGHTSPREAD, 50);
		ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (0, 0, 255));
	}

	light7 = CreateLight (NULL, VL_POINTLIGHT);
	if (light7) {
		SelectLight (light7);
		SetLightCoordinateType (VL_CURRENT, VL_WORLDLIGHT);
		VSET3 (parameter, 250, 0, 0);
		ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, FALSE, parameter);
		ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (255, 255, 255));
		ShadingFactor (VL_CURRENT, VL_LIGHTINTENSITY, 1);
	}

	light8 = CreateLight (NULL, VL_POINTLIGHT);
	if (light8) {
		SelectLight (light8);
		SetLightCoordinateType (VL_CURRENT, VL_WORLDLIGHT);
		VSET3 (parameter, 350, 150, 350);
		ShadingParameter (VL_CURRENT, VL_LIGHTLOCATION, FALSE, parameter);
		ShadingColor (VL_CURRENT, VL_LIGHTCOLOR, RGB (255, 255, 255));
		ShadingFactor (VL_CURRENT, VL_LIGHTINTENSITY, 1);
	}

	hdc = GetDC (NULL);
	if (GetDeviceCaps (hdc, BITSPIXEL) >= 8) {
		ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_PHONGSHADE);
		ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, TRUE);
	}
	else {
		ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_FLATSHADE);
		ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, FALSE);
	}
	ShadingOption (VL_CURRENT, VL_LOCALVIEWER, FALSE);
	ReleaseDC (NULL, hdc);
	
    ShadingOption (VL_CURRENT, VL_BACKFACEREMOVAL, TRUE);

	SelectMaterial (mater0 = CreateMaterial (NULL));
	ShadingColor (VL_CURRENT, VL_MATERIALSPECULAR, RGB (255, 255, 255));
	ShadingFactor (VL_CURRENT, VL_SPECULARREFLECT, 1);
	ShadingColor (VL_CURRENT, VL_MATERIALAMBIENT, RGB (255, 255, 255));
	ShadingFactor (VL_CURRENT, VL_AMBIENTREFLECT, 0.2f);
	ShadingColor (VL_CURRENT, VL_MATERIALDIFFUSE, RGB (255, 255, 255));
	ShadingFactor (VL_CURRENT, VL_SHININESS, 30);

	SelectMaterial (mater1 = CreateMaterial (NULL));
	ShadingColor (VL_CURRENT, VL_MATERIALSPECULAR, RGB (255, 255, 255));
	ShadingColor (VL_CURRENT, VL_MATERIALAMBIENT, RGB (0, 0, 0));
	ShadingFactor (VL_CURRENT, VL_AMBIENTREFLECT, 0.5f);
	ShadingColor (VL_CURRENT, VL_MATERIALDIFFUSE, RGB (255, 0, 0));
	ShadingFactor (VL_CURRENT, VL_SHININESS, 50);

	SelectMaterial (mater2 = CreateMaterial (NULL));
	ShadingColor (VL_CURRENT, VL_MATERIALSPECULAR, RGB (255, 255, 255));
	ShadingColor (VL_CURRENT, VL_MATERIALAMBIENT, RGB (255, 255, 255));
	ShadingFactor (VL_CURRENT, VL_AMBIENTREFLECT, 0.5f);
	ShadingColor (VL_CURRENT, VL_MATERIALDIFFUSE, RGB (0, 255, 0));
	ShadingFactor (VL_CURRENT, VL_SHININESS, 50);

	SelectMaterial (mater3 = CreateMaterial (NULL));
	ShadingColor (VL_CURRENT, VL_MATERIALSPECULAR, RGB (255, 255, 255));
	ShadingColor (VL_CURRENT, VL_MATERIALAMBIENT, RGB (255, 255, 255));
	ShadingFactor (VL_CURRENT, VL_AMBIENTREFLECT, 0.5f);
	ShadingColor (VL_CURRENT, VL_MATERIALDIFFUSE, RGB (0, 0, 255));
	ShadingFactor (VL_CURRENT, VL_SHININESS, 50);
	mater4 = CreateMaterial (NULL);
	mater5 = CreateMaterial (NULL);
	mater6 = CreateMaterial (NULL);
	mater7 = CreateMaterial (NULL);
    SelectMaterial (mater3);

    SetRect (&port, 0, 0, 400, 300);
    viewer20 = CreateViewer (NULL, port, VL_TWOD, VL_HORZFIT);
    SetWindow2D (viewer20, -10, -10, 10, 10); 
    viewer30 = CreateViewer (NULL, port, VL_THREED, VL_HORZFIT);
    SetView3D (viewer30, 100, 100, 100, 0, 0, 0, 0);
    SetPerspective (viewer30, 45, 1, 30, 1000);
    SetDepthBuffer (viewer30);

    viewer21 = CreateViewer (NULL, port, VL_TWOD, VL_HORZFIT);
    viewer22 = CreateViewer (NULL, port, VL_TWOD, VL_ALLFIT);
    viewer31 = CreateViewer (NULL, port, VL_THREED, VL_ALLFIT);
    viewer32 = CreateViewer (NULL, port, VL_THREED, VL_ALLFIT);
    viewer33 = CreateViewer (NULL, port, VL_THREED, VL_ALLFIT);
    viewer34 = CreateViewer (NULL, port, VL_THREED, VL_HORZFIT);
    viewer35 = CreateViewer (NULL, port, VL_THREED, VL_ALLFIT);

	ViewerReset ();

	demo_function = IDM_DEMO_START;
	wc.style = NULL;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon (hInstance, MAKEINTRESOURCE (VL_LOGO));
    wc.hCursor = LoadCursor (NULL, IDC_ARROW);
	backcolor = RGB (128, 128, 128);
    wc.hbrBackground = GetStockObject(GRAY_BRUSH);
    wc.lpszMenuName = "VlibDemo";
    wc.lpszClassName = "VlibDemoClass";

    return (RegisterClass (&wc));

}

/****************************************************************************

    FUNCTION:  InitInstance (HANDLE, int)

****************************************************************************/

BOOL InitInstance (HINSTANCE hInstance, int nCmdShow)
{
    HWND    hWnd;
    int     sw, sh, ww, wh;

    sw = GetSystemMetrics (0);
    sh = GetSystemMetrics (1);
    hInst = hInstance;

    ww = (int) (sw * 0.8f);
    wh = (int) (sh * 0.8f);
    sw = (int) (sw / 10);
    sh = (int) (sh / 10);
    hWnd = CreateWindow ("VlibDemoClass", "Visualib 2.05 Demonstration",
        WS_OVERLAPPEDWINDOW, sw, sh, ww, wh, NULL, NULL, hInstance, NULL);

    if (!hWnd)
        return (FALSE);

    ShowWindow (hWnd, nCmdShow);
    UpdateWindow (hWnd);
	PostMessage (hWnd, WM_COMMAND, IDM_DEMO_WITHFRAME, 0L);
	return (TRUE);
}

POINT3D surf[16] = {
    {-3, 0, 1}, {2, 1, 0}, {5, 0, 0}, {8, 0, 2},
    {-2, 2, 3}, {1, 4, 3}, {6, 4, 1}, {7, 2, 1},
    {-2, 5, 5}, {1, 7, 3}, {5, 5, 2}, {7, 6, 3},
    {-2, 8, 8}, {2, 9, 0}, {4, 7, 4}, {8, 9, 9}
};

REAL    sknot[20] = {0, 0, 0, 1, 1, 1, 2, 2, 3, 4, 4, 4};
REAL    tknot[20] = {0, 0, 0, 1, 1, 1, 2, 2, 3, 4, 4, 4};

void    ObjectMotion2D (HDC hdc)
{
    short   i;

    SelectViewer (viewer21);
    BeginDoubleBuffer (&hdc, VL_CURRENT);
	PenColor (hdc, VL_RED);
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
        BrushColor (hdc, VL_GREEN);
		Flower2D (hdc, 0, 0, 0, 6, 6, 10, 4.5f / 6);
        BrushColor (hdc, VL_RED);
        Star2D (hdc, 0, 0, 0, 4, 4, 5);
        Rotate2D (6);
        UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
        BrushColor (hdc, VL_GREEN);
        Flower2D (hdc, 0, 0, 0, 6, 6, 10, 4.5f / 6);
        BrushColor (hdc, VL_RED);
        Star2D (hdc, 0, 0, 0, 4, 4, 5);
        MoveViewer2D (VL_CURRENT, 0.25f, 0, TRUE);
        UpdateDoubleBuffer (hdc, VL_CURRENT);
    }

    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
        BrushColor (hdc, VL_GREEN);
        Flower2D (hdc, 0, 0, 0, 6, 6, 10, 4.5f / 6);
        BrushColor (hdc, VL_RED);
        Star2D (hdc, 0, 0, 0, 4, 4, 5);
        Scale2D ((REAL)1.06, (REAL)1.06);
        UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    EndDoubleBuffer (&hdc, VL_CURRENT);
	SetViewerName (VL_CURRENT, "2D Object Motion");
}

void    ViewerMotion3D (HDC hdc)
{
    short   i;

    SelectViewer (viewer31);
    BeginDoubleBuffer (&hdc, VL_CURRENT);
    SelectMaterial (mater1);
    for (i = 0; i < 3 * animate_length; i ++) {
		MoveViewer3D (VL_CURRENT, 0, 0, -10, TRUE);
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		if (!Cube (hdc, 50, 50, 25))
			goto exit;
		UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    SelectMaterial (mater2);
    for (i = 0; i < 3 * animate_length; i ++) {
        MoveViewer3D (VL_CURRENT, 0, 5, 0, TRUE);
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		if (!Cube (hdc, 50, 50, 25))
			goto exit;
		UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    SelectMaterial (mater3);
    for (i = 0; i < 3 * animate_length; i ++) {
        MoveViewer3D (VL_CURRENT, 5, 0, 0, TRUE);
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		if (!Cube (hdc, 50, 50, 25))
			goto exit;
		UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    SelectMaterial (mater0);
    for (i = 0; i < 5 * animate_length; i ++) {
        RotateViewer3D (VL_CURRENT, 6, 'z', FALSE);
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
        if (!Cube (hdc, 50, 50, 25))
			return;
        UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    SelectMaterial (mater1);
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
        RotateViewer3D (VL_CURRENT, 6, 'y', FALSE);
        if (!Cube (hdc, 50, 50, 25))
			goto exit;
		UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    SelectMaterial (mater2);
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
        RotateViewer3D (VL_CURRENT, 6, 'x', FALSE);
		if (!Cube (hdc, 50, 50, 25))
			goto exit;
		UpdateDoubleBuffer (hdc, VL_CURRENT);
	}
exit:
    EndDoubleBuffer (&hdc, VL_CURRENT);
	SetViewerName (VL_CURRENT, "Viewer Motion");
}

void    ObjectMotion3D (HDC hdc)
{
    short   i;

	if (!viewer32)
		return;

    SelectViewer (viewer32);
    BeginDoubleBuffer (&hdc, VL_CURRENT);
    SelectMaterial (mater1);
    for (i = 0; i <= 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		if (!Cylinder (hdc, 30, 40, 50))
			break;
		Rotate3D (3, 'z');
		Rotate3D (6, 'x');
		Rotate3D (3, 'y');
		UpdateDoubleBuffer (hdc, VL_CURRENT);
	}
    EndDoubleBuffer (&hdc, VL_CURRENT);
	SetViewerName (VL_CURRENT, "Object Motion");
}

void    ViewerZoom3D (HDC hdc)
{
    short   i;
    POINT3D p = {0, 0, 0};

    SelectViewer (viewer33);
    BeginDoubleBuffer (&hdc, VL_CURRENT);
    SelectMaterial (mater2);
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
        if (!Cone (hdc, 3, 5, 10))
			break;
		ZoomViewer3D (VL_CURRENT, 1.05f);
		UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    EndDoubleBuffer (&hdc, VL_CURRENT);
	SetViewerName (VL_CURRENT, "Viewer Zoom");
}

void    RotateStar (HDC hdc)
{
    short   i;

	if (!viewer35)
		return;
    SelectViewer (viewer35);

	SelectMaterial (mater1);
    BeginDoubleBuffer (&hdc, VL_CURRENT);
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		if (!SolidStar (hdc, 5, 20, 20, 5))
			break;
		MoveViewer3D (VL_CURRENT, 0, 0, -0.5f, TRUE);
		Rotate3D (6 * i, 'z');
		UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    EndDoubleBuffer (&hdc, VL_CURRENT);
	SetViewerName (VL_CURRENT, "Rotate Star");
}

void    Object3D (HDC hdc)
{
    short   i;

    SelectViewer (viewer31);
    BeginDoubleBuffer (&hdc, VL_CURRENT);
    Scale3D (20, 20, 20);
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		PenColor (hdc, VL_GREEN);
        Spring (hdc, 3, 2, 0.5f);
		PenColor (hdc, VL_NONE);
        Translate3D (0.05f, 0, 0);
        Rotate3D (-6, 'y');
        PushTransformation3D (NULL);
		SelectMaterial (mater3);
        Rotate3D (6 * i, 'z');
        Translate3D (0, 2, 0);
		Rotate3D (3, 'y');
		if (!Tetrahedron (hdc, 1))
			break;
        PushTransformation3D (NULL);
		SelectMaterial (mater1);
        Rotate3D (6, 'x');
        Translate3D (0, 0, 2);
        Rotate3D (3 * i, 'z');
		if (!Octahedron (hdc, 1))
			break;
        PopTransformation3D (NULL);
        PopTransformation3D (NULL);
        UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    EndDoubleBuffer (&hdc, VL_CURRENT);
    SetViewerName (VL_CURRENT, "3D Curve");
}

void    RotateFrame (HDC hdc)
{
    short   i;
	COORD	point[] = {0, 0, 0, 1, 1, -1, 1, 1, 1, -1, -1, 1, -1, 1, -1,
		1, -1, -1, 1, 1, 1, 1, -1, 1, -1, -1, 1, -1, 1, 1, -1, 1, -1,
		-1, -1, -1, 1, -1, -1, 1, 1, -1, -1, 1, 1,
		0, 0, 0, 1, -1, 1, -1, -1, -1, 0, 0, 0};
    
	if (!viewer32)
		return;
    SelectViewer (viewer32);
    BeginDoubleBuffer (&hdc, VL_CURRENT);
    Scale3D (30, 30, 30);
	PenColor (hdc, VL_BLUE);
    for (i = 0; i < 5 * animate_length; i++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		Polyline3D (hdc, VL_3D, point, 19);
        Rotate3D (6, 'z');
        UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    EndDoubleBuffer (&hdc, VL_CURRENT);
	SetViewerName (VL_CURRENT, "Rotate Frame");
}

void    RotateSurface (HDC hdc)
{
    short   i;

	if (!viewer35)
		return;

    SelectViewer (viewer35);
    SetViewerName (VL_CURRENT, "NURBS Surface");
	SelectMaterial (mater2);
    BeginDoubleBuffer (&hdc, VL_CURRENT);
	ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, TRUE);
    for (i = 0; i < 5 * animate_length; i++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		if (!NURBSSurface (hdc, VL_3D, (LPCOORD) surf, 4, 4, sknot, tknot, 8, 8))
			break;
        Rotate3D (6, 'z');
        Rotate3D (12, 'x');
        Rotate3D (3, 'y');
        UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    EndDoubleBuffer (&hdc, VL_CURRENT);
}

void    RotateDodecahedron (HDC hdc)
{
    short   i;

    SelectViewer (viewer33);
    SetViewerName (VL_CURRENT, "Dodecahedron");
	SelectMaterial (mater2);
    BeginDoubleBuffer (&hdc, VL_CURRENT);
    Scale3D (6, 6, 6);
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		if (!Dodecahedron (hdc, 0.5f))
			break;
        Translate3D (0, 0.1f, 0);
        Rotate3D (6, 'z');
        UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    EndDoubleBuffer (&hdc, VL_CURRENT);
}

void    RotateIcosahedron (HDC hdc)
{
    short   i;

	if (!viewer34)
		return;
    SelectViewer (viewer34);
    SetViewerName (VL_CURRENT, "Icosahedron");
	SelectMaterial (mater1);
    BeginDoubleBuffer (&hdc, VL_CURRENT);
    Scale3D (3, 3, 3);
    for (i = 0; i < 5 * animate_length; i ++) {
        ClearViewer (hdc, VL_CURRENT, VL_GRAY);
		if (!Icosahedron (hdc, 1))
			break;
		Rotate3D (3, 'y');
		Translate3D (0.1f, 0, 0);
		Rotate3D (6, 'z');
		UpdateDoubleBuffer (hdc, VL_CURRENT);
    }
    EndDoubleBuffer (&hdc, VL_CURRENT);
}

void	AnimationDemo (HDC hdc, WORD cmd)
{
    short	depthbuffer, shadingmethod, twosideshade, backfaceremoval;
	BOOL	l0, l1, l2, l3;

	l0 = SwitchLight (light0, FALSE);
	l1 = SwitchLight (light1, FALSE);
	l2 = SwitchLight (light2, FALSE);
	l3 = SwitchLight (light3, FALSE);
	depthbuffer = ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, FALSE);
	shadingmethod = ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, VL_FLATSHADE);
	twosideshade = ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, FALSE);
	backfaceremoval = ShadingOption (VL_CURRENT, VL_BACKFACEREMOVAL, TRUE);
	SwitchLight (light7, TRUE);
	SwitchLight (light8, TRUE);
	PenColor (hdc, VL_NONE);
	switch (cmd) {
		case IDM_ANIMATE_FRAME:
			animate_length = 10;
			RotateFrame (hdc);
			break;
		case IDM_ANIMATE_OBJECT2D:
			animate_length = 10;
			ObjectMotion2D (hdc);
			break;
		case IDM_ANIMATE_SURFACE:
			animate_length = 10;
			RotateSurface (hdc);
			break;
		case IDM_ANIMATE_ICOSAHEDRON:
			animate_length = 10;
			RotateIcosahedron (hdc);
			break;
		case IDM_ANIMATE_OBJECT3D:
			animate_length = 20;
			Object3D (hdc);
			break;
		case IDM_ANIMATE_STAR3D:
			animate_length = 15;
			RotateStar (hdc);
			break;
		case IDM_ANIMATE_DODECAHEDRON:
			animate_length = 15;
			RotateDodecahedron (hdc);
			break;
		case IDM_ANIMATE_VIEWER3D:
			animate_length = 7;
			ViewerMotion3D (hdc);
			break;
		case IDM_ANIMATE_ZOOM3D:
			animate_length = 15;
			ViewerZoom3D (hdc);
			break;
	}
	SwitchLight (light7, FALSE);
	SwitchLight (light8, FALSE);
	ShadingOption (VL_CURRENT, VL_DEPTHBUFFER, depthbuffer);
	ShadingOption (VL_CURRENT, VL_SHADINGMETHOD, shadingmethod);
	ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, twosideshade);
	ShadingOption (VL_CURRENT, VL_BACKFACEREMOVAL, backfaceremoval);
	SwitchLight (light0, l0);
	SwitchLight (light1, l1);
	SwitchLight (light2, l2);
	SwitchLight (light3, l3);
}

void CompositeDemo2D (HDC hdc)
{
    RECT    orgport, newport;

    SelectViewer (viewer22);
	SetViewerName (VL_CURRENT, "Flag");
    GetViewport (VL_CURRENT, &orgport);
    SetRect (&newport, 350, 230, 410, 260);
    SetViewport (VL_CURRENT, newport);
    USFlag (hdc);
	TextColor (hdc, VL_BLUE, VL_BLACK, TRANSPARENT);
    DisplayViewerName (hdc, VL_CURRENT, 0);
    SetViewport (VL_CURRENT, orgport);
    USFlag (hdc);
}

void	Surfaces (HDC hdc, WORD cmd)
{
	short	twosideshade;

    SelectViewer (viewer30);
    ClearDepthBuffer (0xffff);
	twosideshade = ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, TRUE);
	PenColor (hdc, VL_NONE);

	PushTransformation3D (NULL);
	switch (cmd) {
		case IDM_SURFACE_BEZIER:
		{
			POINT3D surf[16] = {
				{0, 6, 3}, {2, 6, 0}, {4, 6, 2}, {6, 6, 0},
				{0, 4, 0}, {2, 4, 5}, {4, 4, 0}, {6, 4, 6},
				{0, 2, 5}, {2, 2, 0}, {4, 2, 6}, {6, 2, 0},
				{0, 0, 0}, {2, 0, 3}, {4, 0, 0}, {6, 0, 3}};

			Scale3D (5, 5, 5);
			BezierSurface (hdc, VL_3D, (LPCOORD) surf, 16, 16);
			PenColor (hdc, VL_GREEN);
			Net3D (hdc, VL_3D, (LPCOORD) surf, 4, 4);
			PolyMark3D (hdc, VL_3D, (LPCOORD) surf, 16, 2, 2, VL_CIRCLEMARK);
			SetViewerName (VL_CURRENT, "Bezier Surface");
			break;
		}
		case IDM_SURFACE_HERMIT:
		{
			POINT3D surf[16] = {
				{0, 0, 0}, {0, 6, 0}, {0, 6, 6}, {0, 6, -2},
				{6, 0, 0}, {6, 6, 0}, {0, 2, 2}, {0, 6, -2},
				{2, 0, 2}, {2, 0, 2}, {0, 0, 0}, {0, 0, 0},
				{2, 0, 2}, {2, 0, 2}, {0, 0, 0}, {0, 0, 0}};

			Scale3D (5, 5, 5);
			HermitSurface (hdc, VL_3D, (LPCOORD) surf, 16, 16);
			SetViewerName (VL_CURRENT, "Hermit Surface");
			break;
		}
		case IDM_SURFACE_BSPLINE:
		{
			POINT3D surf[36] = {
				{0,0,0},{1,0,0},{2,0,0},{3,0,0},{4,0,0},{5,0,0},
				{0,1,0},{1,1,0},{2,1,0},{3,1,0},{4,1,0},{5,1,0},
				{0,2,0},{1,2,0},{2,2,9},{3,2,9},{4,2,0},{5,2,0},
				{0,3,0},{1,3,0},{2,3,9},{3,3,9},{4,3,0},{5,3,0},
				{0,4,0},{1,4,0},{2,4,0},{3,4,0},{4,4,0},{5,4,0},
				{0,5,0},{1,5,0},{2,5,0},{3,5,0},{4,5,0},{5,5,0}};

			Scale3D (3, 3, 3);
			BSplineSurface (hdc, VL_3D, (LPCOORD) surf, 6, 6, 4, 4);
			SetViewerName (VL_CURRENT, "B-Spline Surface");
			break;
		}
		case IDM_SURFACE_NURBS:
		{
			POINT3D surf[36] = {
				{0,0,0},{1,0,0},{2,0,0},{3,0,0},{4,0,0},{5,0,0},
				{0,1,0},{1,1,0},{2,1,0},{3,1,0},{4,1,0},{5,1,0},
				{0,2,0},{1,2,0},{2,2,9},{3,2,9},{4,2,0},{5,2,0},
				{0,3,0},{1,3,0},{2,3,9},{3,3,9},{4,3,0},{5,3,0},
				{0,4,0},{1,4,0},{2,4,0},{3,4,0},{4,4,0},{5,4,0},
				{0,5,0},{1,5,0},{2,5,0},{3,5,0},{4,5,0},{5,5,0}};
			REAL    sknot[20] = {0,0,0,1,2,3,3,3};
			REAL    tknot[20] = {0,0,0,1,2,3,3,3};

			Scale3D (10, 10, 5);
			Translate3D (-3, -2, 0);
			NURBSSurface (hdc, VL_3D, (LPCOORD) surf, 6, 6, sknot, tknot, 4, 4);
			PenColor (hdc, VL_GREEN);
			Net3D (hdc, VL_3D, (LPCOORD) surf, 6, 6);
			PolyMark3D (hdc, VL_3D, (LPCOORD) surf, 36, 2, 2, VL_BOXMARK);
			SetViewerName (VL_CURRENT, "NURBS Surface");
			break;
		}
		case IDM_SURFACE_COONSPATCH:
		{
			POINT3D	point[] = {{0,0,4},{1,-2,3},{2,-2,2},{3,0,1},
							   {4,0,0},{4,1,0},{4,2,0},{4,3,0},
							   {4,4,0},{3,4,0},{2,4,0},{1,4,0},
							   {0,4,0},{0,3,1},{-2,2,2},{-2,1,3}};
			Scale3D (5, 5, 5);
			CoonsPatch (hdc, VL_3D, (LPCOORD) point, 5, 5);
			SetViewerName (VL_CURRENT, "Coons Patch Surface");
			break;
		}
	}
	PopTransformation3D (NULL);
	ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, twosideshade);
}

void	PolyfacetsDemo (HDC hdc)
{
	POLYFACET	polyfacet;
	LPWIRE		wire;
	LPFACET		facet;
	LPINT		vindex, nindex;
	LPVECT3		normal;
	short		i;
	LPPOINT3D	vertex;

	polyfacet.nvert = 8;
	polyfacet.nnorm = 4;
	polyfacet.nwire = 12;
	polyfacet.nfacet = 6;
	polyfacet.vertex = NEWLIST (POINT3D, polyfacet.nvert);
	wire = polyfacet.wire = NEWLIST (WIRE, polyfacet.nwire);
	facet = polyfacet.facet = NEWLIST (FACET, polyfacet.nfacet);
	normal = polyfacet.normal = NEWLIST (VECTOR3, 4);
	VSET3 (normal[0], 0.6f, -0.8f, 0);
	VSET3 (normal[1], 0.6f, 0.8f, 0);
	VSET3 (normal[2], 0, 0.6f, 0.8f);
	VSET3 (normal[3], 0, 0.6f, -0.8f);
	vertex = polyfacet.vertex;
	SetPoint3D (&vertex[0], 0, 0, 20);
	SetPoint3D (&vertex[1], 20, 0, 20);
	SetPoint3D (&vertex[2], 20, 20, 20);
	SetPoint3D (&vertex[3], 0, 20, 20);
	SetPoint3D (&vertex[4], 0, 0, 0);
	SetPoint3D (&vertex[5], 20, 0, 0);
	SetPoint3D (&vertex[6], 20, 20, 0);
	SetPoint3D (&vertex[7], 0, 20, 0);
	wire[3].vert2 = wire[0].vert1 = wire[4].vert1 = 0;
	wire[0].vert2 = wire[1].vert1 = wire[5].vert1 = 1;
	wire[1].vert2 = wire[2].vert1 = wire[6].vert1 = 2;
	wire[2].vert2 = wire[3].vert1 = wire[7].vert1 = 3;
	wire[11].vert2 = wire[4].vert2 = wire[8].vert1 = 4;
	wire[8].vert2 = wire[5].vert2 = wire[9].vert1 = 5;
	wire[9].vert2 = wire[6].vert2 = wire[10].vert1 = 6;
	wire[10].vert2 = wire[7].vert2 = wire[11].vert1 = 7;
	facet[0].npts = facet[1].npts = facet[2].npts = facet[3].npts = 4;
	facet[4].npts = facet[5].npts = 4;
	facet[0].nindex = facet[1].nindex = facet[4].nindex = facet[5].nindex = 0;
	nindex = facet[2].nindex = NEWLIST (int, 4);
	VSET4 (nindex, 0, 0, 1, 1);
	nindex = facet[3].nindex = NEWLIST (int, 4);
	VSET4 (nindex, 2, 3, 3, 2);
	vindex = facet[0].vindex = NEWLIST (int, 4);
	VSET4 (vindex, 0, 1, 2, 3);
	VSET3 (facet[0].normal, 0, 0, 1);
	vindex = facet[1].vindex = NEWLIST (int, 4);
	VSET4 (vindex, 0, 4, 5, 1);
	VSET3 (facet[1].normal, 0, -1, 0);
	vindex = facet[2].vindex = NEWLIST (int, 4);
	VSET4 (vindex, 1, 5, 6, 2);
	VSET3 (facet[2].normal, 1, 0, 0);
	vindex = facet[3].vindex = NEWLIST (int, 4);
	VSET4 (vindex, 2, 6, 7, 3);
	VSET3 (facet[3].normal, 0, 1, 0);
	vindex = facet[4].vindex = NEWLIST (int, 4);
	VSET4 (vindex, 3, 7, 4, 0);
	VSET3 (facet[4].normal, -1, 0, 0);
	vindex = facet[5].vindex = NEWLIST (int, 4);
	VSET4 (vindex, 4, 7, 6, 5);
	VSET3 (facet[5].normal, 0, 0, -1);

	ClearDepthBuffer (0xffff);
	SelectMaterial (mater2);
	SwitchLight (light7, TRUE);
	SwitchLight (light8, TRUE);
	ShadePolyFacet (hdc, &polyfacet);
	for (i = 0; i < polyfacet.nfacet; i++) {
		_ffree (facet[i].vindex);
		if (facet[i].nindex)
			_ffree (facet[i].nindex);
			
	}
	_ffree (polyfacet.vertex);
	_ffree (polyfacet.normal);
	_ffree (polyfacet.wire);
	_ffree (polyfacet.facet);
}

VOIDED	ShowSolidPrimitives (HDC hdc, WORD cmd)
{
	ShadingOption (VL_CURRENT, VL_BACKFACEREMOVAL, TRUE);
	ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, FALSE);
	ClearDepthBuffer (0xffff);
	PenColor (hdc, VL_NONE);
	switch (cmd) {
		case IDM_SOLID_TUBE:
			SetViewerName (VL_CURRENT, "Tube and Ring");
			Tube (hdc, 15, 20, 2, 30);
			SolidRing (hdc, 40, 40, 3, 10, 115, 335, 1);
			break;
        case IDM_SOLID_TORUS:
			SetViewerName (VL_CURRENT, "Torus and Wedged Torus");
			TranslateTo3D (-20, 20, 0);
			if (!Torus (hdc, 15, 5))
				break;
			TranslateTo3D (20, -20, 0);
			WedgedTorus (hdc, 15, 5, 90, 360, 180, 90);
            break;
        case IDM_SOLID_SPHERE:
			SetViewerName (VL_CURRENT, "Sphere and Wedged Sphere");
			WedgedSphere (hdc, 20, 20, 30, 90, 0, 45, 135);
            break;
        case IDM_SOLID_ELLIPSOID:
			SetViewerName (VL_CURRENT, "Ellipsoid");
            Ellipsoid (hdc, 20, 40, 30);
            break;
        case IDM_SOLID_CYLINDER:
			SetViewerName (VL_CURRENT, "Cylinder and Solid Pie");
			if (!WedgedCylinder (hdc, 10, 20, 30, 0.7f, 90, 0))
				break;
            TranslateTo3D (30, -30, 0);
            if (!SolidPie (hdc, 20, 10, 5, 45, 180))
				break;
            TranslateTo3D (-30, 30, 0);
            SolidPie (hdc, 20, 10, 5, 180, 45);
            break;
        case IDM_SOLID_CONE:
			SetViewerName (VL_CURRENT, "Cone and Wedged Cone");
			if (!WedgedCone (hdc, 10, 20, 30, 90, 0))
				break;
            TranslateTo3D (30, -30, 0);
			if (!WedgedCone (hdc, 20, 10, 30, 110, 0))
				break;
			TranslateTo3D (-30, 30, 0);
            WedgedCone (hdc, 20, 10, 30, 180, 45);
            break;
        case IDM_SOLID_TETRAHEDRON:
			SetViewerName (VL_CURRENT, "Tetrahedron (4 facets)");
            Tetrahedron (hdc, 20);
            MarkPosition3D (hdc, 0, 0, 0, 10, VL_CROSSHAIR);
            break;
        case IDM_SOLID_OCTAHEDRON:
			SetViewerName (VL_CURRENT, "Octahedron (8 facets)");
            Octahedron (hdc, 20);
            MarkPosition3D (hdc, 0, 0, 0, 20, VL_ORIGIN);
            break;
        case IDM_SOLID_DODECAHEDRON:
			SetViewerName (VL_CURRENT, "Dodecahedron (12 facets)");
            Dodecahedron (hdc, 20);
            MarkPosition3D (hdc, 0, 0, 0, 10, VL_ORIGIN);
            break;
        case IDM_SOLID_ICOSAHEDRON:
			SetViewerName (VL_CURRENT, "Icosahedron (20 facets)");
            Icosahedron (hdc, 20);
            MarkPosition3D (hdc, 0, 0, 0, 10, VL_ORIGIN);
            break;
        case IDM_SOLID_FRUSTUM:
			SetViewerName (VL_CURRENT, "Frustum");
            Frustum (hdc, 20, 30, 10, 20, 20);
            break;
        case IDM_SOLID_RIDGE:
			SetViewerName (VL_CURRENT, "Ridge");
            Ridge (hdc, 20, 30, 10, 20);
            break;
        case IDM_SOLID_BOX:
			SetViewerName (VL_CURRENT, "Box");
			Cube (hdc, 40, 40, 20);
            break;
        case IDM_SOLID_STAR:
			SetViewerName (VL_CURRENT, "Solid Star");
            SolidStar (hdc, 5, 20, 20, 10);
            break;
        case IDM_SOLID_FLOWER:
			SetViewerName (VL_CURRENT, "Solid Flower");
            SolidFlower (hdc, 8, 0.666f, 30, 30, 10);
            break;
	}
}

void    ShadingSettings (HWND hwnd, WORD cmd)
{
	COLORREF	color;

	switch (cmd) {
		case IDM_OPTION_PREVIEW:
		{
			RECT rect = {50, 50, 100, 100};
			HDC	hdc;

			SelectViewer (viewer30);
			hdc = GetDC (hwnd);
			ShadingPreview (hdc, &rect, 40, 173);
			ReleaseDC (hwnd, hdc);
			break;
		}
        case IDM_GLOBAL_AMBIENT:
            color = ShadingColor (VL_CURRENT, VL_GLOBALAMBIENT, VL_INQUIRE);
			color = SelectColor (color);
			ShadingColor (VL_CURRENT, VL_GLOBALAMBIENT, color);
            break;
		case IDM_OPTION_BACKCOLOR:
		{
			HBRUSH	hbrush;

			backcolor = SelectColor (backcolor);
			hbrush = GetClassWord (hwnd, GCW_HBRBACKGROUND);
			DeleteObject (hbrush);
			hbrush = CreateSolidBrush (backcolor);
			SetClassWord (hwnd, GCW_HBRBACKGROUND, hbrush);
            InvalidateRect (hwnd, NULL, TRUE);
			UpdateWindow (hwnd);
			break;
		}
		case IDM_OPTION_REDRAW:
            InvalidateRect (hwnd, NULL, TRUE);
			UpdateWindow (hwnd);
			break;
		case IDM_OPTION_SHADEMODE:
			DialogBox (hInst, MAKEINTRESOURCE(DLGSHADING), hwnd, DlgShading);
			break;
        case IDM_SELECT_M1:
            SelectMaterial (mater0);
			DialogBox (hInst, MAKEINTRESOURCE(DLGMATERIAL), hwnd, DlgMaterial);
            break;
        case IDM_SELECT_M2:
            SelectMaterial (mater1);
			DialogBox (hInst, MAKEINTRESOURCE(DLGMATERIAL), hwnd, DlgMaterial);
            break;
        case IDM_SELECT_M3:
            SelectMaterial (mater2);
			DialogBox (hInst, MAKEINTRESOURCE(DLGMATERIAL), hwnd, DlgMaterial);
            break;
        case IDM_SELECT_M4:
            SelectMaterial (mater3);
			DialogBox (hInst, MAKEINTRESOURCE(DLGMATERIAL), hwnd, DlgMaterial);
            break;
        case IDM_SELECT_L1:
            SelectLight (light0);
			DialogBox (hInst, MAKEINTRESOURCE(DLGLIGHTSETUP), hwnd, DlgLightSetup);
            break;
        case IDM_SELECT_L2:
            SelectLight (light1);
			DialogBox (hInst, MAKEINTRESOURCE(DLGLIGHTSETUP), hwnd, DlgLightSetup);
            break;
        case IDM_SELECT_L3:
            SelectLight (light2);
			DialogBox (hInst, MAKEINTRESOURCE(DLGLIGHTSETUP), hwnd, DlgLightSetup);
            break;
        case IDM_SELECT_L4:
            SelectLight (light3);
			DialogBox (hInst, MAKEINTRESOURCE(DLGLIGHTSETUP), hwnd, DlgLightSetup);
            break;
        case IDM_OPTION_TEXTURE:
			DialogBox (hInst, MAKEINTRESOURCE(DLGTEXTURE), hwnd, DlgTexture);
            break;
	}
}

WORD	halign = TA_CENTER;
WORD	valign = TA_BASELINE;

VOIDED	ShowTextPrimitives (HDC hdc, int func)
{
	char	str[40];

	ShadingOption (VL_CURRENT, VL_BACKFACEREMOVAL, TRUE);
	ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, FALSE);
	wsprintf (str, "Visualib\nAdvanced\nTechnology");
	switch (func) {
		case IDM_TEXT_2D:
			SelectViewer (viewer20);
			TextParameter (VL_TEXT_HEIGHT, 4);
			BrushColor (hdc, VL_RED);
			PenColor (hdc, VL_GREEN);
			SetTextAlign (hdc, halign | valign);
			Text2D (hdc, 0, 0, 0, str);
			SetViewerName (VL_CURRENT, "2D Horizontal Text");
			break;
		case IDM_TEXT_3D:
			SelectViewer (viewer30);
            MarkPosition3D (hdc, 0, 0, 0, 40, VL_ORIGIN);
			PushTransformation3D (NULL);
			TextParameter (VL_TEXT_HEIGHT, 15);
			BrushColor (hdc, VL_YELLOW);
			PenColor (hdc, VL_BLUE);
			SetTextAlign (hdc, TA_LEFT | TA_BOTTOM);
			Text3D (hdc, 3, 1, 0, str);
			PushTransformation3D (NULL);
			Rotate3D (90, 'y');
			SetTextAlign (hdc, TA_RIGHT | TA_BOTTOM);
			Text3D (hdc, -3, 1, 0, str);
			PopTransformation3D (NULL);
			Rotate3D (-90, 'x');
			SetTextAlign (hdc, TA_TOP | TA_LEFT);
			Text3D (hdc, 3, -1, 0, str);
			PopTransformation3D (NULL);
			SetViewerName (VL_CURRENT, "3D Horizontal Text");
			break;
		case IDM_TEXT_SOLID:
			SelectViewer (viewer30);
			TextParameter (VL_TEXT_HEIGHT, 30);
			ClearDepthBuffer (0xffff);
			TextParameter (VL_TEXT_THICKNESS, 8);
			PushTransformation3D (NULL);
			Rotate3D (135, 'z');
			Rotate3D (30, 'x');
			SetTextAlign (hdc, TA_BASELINE | TA_CENTER);
			SolidText (hdc, str);
			PopTransformation3D (NULL);
			SetViewerName (VL_CURRENT, "Solid Text");
			break;
	}
	SelectObject (hdc, GetStockObject (SYSTEM_FONT));
}

void    ProcessWindowPaint (HWND hwnd)
{
    PAINTSTRUCT ps;
    HDC         hdc;

    hdc = BeginPaint (hwnd, &ps);
	if (hpal) {
		SelectPalette (hdc, hpal, FALSE);
		RealizePalette (hdc);
	}
	FunctionDemos (hdc);
    EndPaint (hwnd, &ps);
}

void	SpotlightDemo (HDC hdc)
{
	SelectViewer (viewer30);
	SetViewerName (VL_CURRENT, "Spot Lights Demo");
	ClearDepthBuffer (0xffff);
	SelectMaterial (mater0);
	SwitchLight (light4, TRUE);
	SwitchLight (light5, TRUE);
	SwitchLight (light6, TRUE);
	SolidFlower (hdc, 8, 0.666f, 30, 30, 10);
}

void	ImageMappingDemo (HDC hdc)
{
	COORD	point[12];
	static BOOL	LoadImage = TRUE;

	if (LoadImage) {
		if (GetDeviceCaps (hdc, BITSPIXEL) >= 8) {
			if (!ReadDIBFile ("deer256.bmp", &hdib1) ||
				!ReadDIBFile ("deer256.bmp", &hdib2))
				return;
		}
		else {
			if (!ReadDIBFile ("bring16.bmp", &hdib1) ||
				!ReadDIBFile ("bring16.bmp", &hdib2))
				return;
		}
		if (!ReadDIBFile ("c:\\windows\\system\\vgalogo.rle", &hdib3))
			return;
		LoadImage = FALSE;
	}

	SelectViewer (viewer30);
	SetViewerName (VL_CURRENT, "Image Mapping");
	Scale3D (20, 20, 30);

	point[0] = -1; point[1] = -1; point[2] = 1;
	point[3] = 1; point[4] = -1; point[5] = 1;
	point[6] = 1; point[7] = 1; point[8] = 1;
	point[9] = -1; point[10] = 1; point[11] = 1;
	if (hdib1) {
		if (!ImageMap3D (hdc, hdib1, VL_3D, point))
			return;
	}

	point[0] = 1; point[1] = 1; point[2] = 1;
	point[3] = 1; point[4] = 1; point[5] = -1;
	point[6] = -1; point[7] = 1; point[8] = -1;
	point[9] = -1; point[10] = 1; point[11] = 1;
	if (hdib2) {
		if (!ImageMap3D (hdc, hdib2, VL_3D, point))
			return;
	}

	point[0] = 1; point[1] = -1; point[2] = -1;
	point[3] = 1; point[4] = 1; point[5] = -1;
	point[6] = 1; point[7] = 1; point[8] = 1;
	point[9] = 1; point[10] = -1; point[11] = 1;
	if (hdib3) {
		ImageMap3D (hdc, hdib3, VL_3D, point);
	}
}

void	TranslateTransf2D (HDC hdc)
{
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	SetViewerName (VL_CURRENT, "2D Translate Transformation");
	BrushColor (hdc, VL_RED);
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	Label2D (hdc, 0, 0, "Original");
	TranslateTo2D (5, 3);
	BrushColor (hdc, VL_GREEN);
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	Label2D (hdc, 0, 0, "Translated To (5,3)");
	PushTransformation2D (NULL);
	Translate2D (0, -6);
	BrushColor (hdc, VL_YELLOW);
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	Label2D (hdc, 0, 0, "Translated (0,-6) from above");
	PopTransformation2D (NULL);
	Translate2D (-10, 0);
	BrushColor (hdc, VL_BLUE);
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	Label2D (hdc, 0, 0, "Translated (-10,0) from right");
	Translate2D (0, -6);
	BrushColor (hdc, VL_WHITE);
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	Label2D (hdc, 0, 0, "Translated (0,-6) from above");
}

void	MirrorTransf2D (HDC hdc)
{
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	SetViewerName (VL_CURRENT, "2D Mirror Transformation");
	BrushColor (hdc, VL_RED);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Original");
	PushTransformation2D (NULL);
	Mirror2D (0, 0, 0);
	BrushColor (hdc, VL_GREEN);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Mirrored along (0,0) with 0 degree");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	Mirror2D (0, 0, 90);
	BrushColor (hdc, VL_YELLOW);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Mirrored along (0,0) with 90 degree");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	Mirror2D (0, 0, (REAL)(atan2 (-5, 3) * RTOD));
	BrushColor (hdc, VL_BLUE);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Mirrored along (0,0) with radian (-5,3)");
	PopTransformation2D (NULL);
}

void	StretchTransf2D (HDC hdc)
{
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	SetViewerName (VL_CURRENT, "2D Stretch Transformation");
	BrushColor (hdc, VL_RED);
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	Label2D (hdc, 0, 0, "Original");
	PushTransformation2D (NULL);
	Stretch2D (5, 3, 0, 1.5f);
	BrushColor (hdc, VL_GREEN);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Stretched along 0 degree");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	Stretch2D (5, -3, 90, 1.5f);
	BrushColor (hdc, VL_YELLOW);
	Star2D (hdc, 5, -3, 0, 2, 2, 5);
	Label2D (hdc, 5, -3, "Stretched along 90 degree");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	Stretch2D (-5, -3, 45, 1.5f);
	BrushColor (hdc, VL_BLUE);
	Star2D (hdc, -5, -3, 0, 2, 2, 5);
	Label2D (hdc, -5, -3, "Stretched along 45 degree");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	Stretch2D (-5, 3, 45, -1.5f);
	BrushColor (hdc, VL_BROWN);
	Star2D (hdc, -5, 3, 0, 2, 2, 5);
	Label2D (hdc, -5, 3, "Stretched and flipped 45 degree");
	PopTransformation2D (NULL);
}

void	ShearTransf2D (HDC hdc)
{
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	SetViewerName (VL_CURRENT, "2D Shear Transformation");
	BrushColor (hdc, VL_RED);
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	Label2D (hdc, 0, 0, "Original");
	PushTransformation2D (NULL);
	Shear2D (5, 3, 0, 0.5f, 0);
	BrushColor (hdc, VL_GREEN);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Horizontal shear");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	Shear2D (5, -3, 0, 0, 0.5f);
	BrushColor (hdc, VL_BLUE);
	Star2D (hdc, 5, -3, 0, 2, 2, 5);
	Label2D (hdc, 5, -3, "Vertical shear");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	Shear2D (-5, -3, 0, 0.5f, 0.5f);
	BrushColor (hdc, VL_YELLOW);
	Star2D (hdc, -5, -3, 0, 2, 2, 5);
	Label2D (hdc, -5, -3, "Horizontal and vertical shear");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	Shear2D (-5, 3, 45, 0.5f, 0);
	BrushColor (hdc, VL_BROWN);
	Star2D (hdc, -5, 3, 0, 2, 2, 5);
	Label2D (hdc, -5, 3, "Horizontal shear along 45 degree");
	PopTransformation2D (NULL);
}

void	PointRotateTransf2D (HDC hdc)
{
	SetTextAlign (hdc, TA_CENTER | TA_BOTTOM);
	Label2D (hdc, 5, 3, "(5,3)");
	SetTextAlign (hdc, TA_RIGHT | TA_BASELINE);
	Label2D (hdc, -5, 3, "(-5,3)");
	SetTextAlign (hdc, TA_CENTER | TA_TOP);
	Label2D (hdc, -5, -3, "(-5,-3)");
	SetTextAlign (hdc, TA_LEFT | TA_BASELINE);
	Label2D (hdc, 5, -3, "(5,-3)");
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	SetViewerName (VL_CURRENT, "2D Point Ratate Transformation");
	PenColor (hdc, VL_WHITE);
	BrushColor (hdc, VL_RED);
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	Label2D (hdc, 0, 0, "Original");
	Line2D (hdc, 5, 3, 0, 0);
	PushTransformation2D (NULL);
	PointRotate2D (5, 3, 90);
	BrushColor (hdc, VL_GREEN);
	Label2D (hdc, 0, 0, "Rotate 90 degree around (5,3)");
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	LineTo2D (hdc, 0, 0);
	LineTo2D (hdc, 5, 3);
 	PopTransformation2D (NULL);
	Line2D (hdc, -5, 3, 0, 0);
	PushTransformation2D (NULL);
	PointRotate2D (-5, 3, 45);
	BrushColor (hdc, VL_YELLOW);
	Label2D (hdc, 0, 0, "Rotate 45 degree around (-5,3)");
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	LineTo2D (hdc, 0, 0);
	LineTo2D (hdc, -5, 3);
	PopTransformation2D (NULL);
	Line2D (hdc, 5, -3, 0, 0);
	PushTransformation2D (NULL);
	PointRotate2D (5, -3, 45);
	BrushColor (hdc, VL_BLUE);
	Label2D (hdc, 0, 0, "Rotate 45 degree around (5,-3)");
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	LineTo2D (hdc, 0, 0);
	LineTo2D (hdc, 5, -3);
	PopTransformation2D (NULL);
	Line2D (hdc, -5, -3, 0, 0);
	PushTransformation2D (NULL);
	PointRotate2D (-5, -3, 90);
	BrushColor (hdc, VL_BROWN);
	Label2D (hdc, 0, 0, "Rotate 90 degree around (-5,-3)");
	Star2D (hdc, 0, 0, 0, 2, 2, 5);
	LineTo2D (hdc, 0, 0);
	LineTo2D (hdc, -5, -3);
	PopTransformation2D (NULL);
}

void	PointScaleTransf2D (HDC hdc)
{
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	BrushColor (hdc, VL_RED);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Original");
	PushTransformation2D (NULL);
	PointScale2D (0, 0, -1, 1);
	BrushColor (hdc, VL_GREEN);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Horizontal flipped");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	PointScale2D (0, 0, 1, -1);
	BrushColor (hdc, VL_BLUE);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Vertical flipped");
	PopTransformation2D (NULL);
	PushTransformation2D (NULL);
	PointScale2D (0, 0, -1, -1);
	BrushColor (hdc, VL_YELLOW);
	Star2D (hdc, 5, 3, 0, 2, 2, 5);
	Label2D (hdc, 5, 3, "Horizontal and vertical flipped");
	PopTransformation2D (NULL);
}
	
void	Transformation2D (HDC hdc, int func)
{
	SetROP2 (hdc, R2_XORPEN);
	TextColor (hdc, VL_WHITE, VL_BLACK, TRANSPARENT);
	PushTransformation2D (NULL);
	switch (func) {
		case IDM_2DTRANSF_TRANSLATE:
			TranslateTransf2D (hdc);
			break;
		case IDM_2DTRANSF_SCALE:
			break;
		case IDM_2DTRANSF_POINTSCALE:
			PointScaleTransf2D (hdc);
			break;
		case IDM_2DTRANSF_ROTATE:
			break;
		case IDM_2DTRANSF_POINTROTATE:
			PointRotateTransf2D (hdc);
			break;
		case IDM_2DTRANSF_STRETCH:
			StretchTransf2D (hdc);
			break;
		case IDM_2DTRANSF_SHEAR:
			ShearTransf2D (hdc);
			break;
		case IDM_2DTRANSF_MIRROR:
			MirrorTransf2D (hdc);
			break;
	}
	PopTransformation2D (NULL);
}

void	AxleRotateTransf3D (HDC hdc)
{
	short	i;
	VECTOR3	ref = {0, 0, 0}, dir;
	char	str[] = "Visualib";

	SetTextAlign(hdc, TA_LEFT | TA_BOTTOM);
	TextParameter (VL_TEXT_HEIGHT, 20);
	MarkPosition3D (hdc, 0, 0, 0, 20, VL_ORIGIN);
	BrushColor (hdc, VL_RED);
	Text3D (hdc, 15, 15, 0, str);
	VSET3 (dir, 1, 0, 0);
	for (i = 1; i < 4; i++) {
		PushTransformation3D (NULL);
		AxleRotate3D (ref, dir, i * 90);
		BrushColor (hdc, i+1);
		Text3D (hdc, 15, 15, 0, str);
		PopTransformation3D (NULL);
	}
	VSET3 (dir, 0, 1, 0);
	for (i = 1; i < 4; i++) {
		PushTransformation3D (NULL);
		AxleRotate3D (ref, dir, i * 90);
		BrushColor (hdc, i+4);
		Text3D (hdc, 15, 15, 0, str);
		PopTransformation3D (NULL);
	}
	VSET3 (dir, 1, -1, 0);
	for (i = 1; i < 4; i++) {
		PushTransformation3D (NULL);
		AxleRotate3D (ref, dir, i * 90);
		BrushColor (hdc, i+7);
		Text3D (hdc, 15, 15, 0, str);
		PopTransformation3D (NULL);
	}
}

void	StretchTransf3D (HDC hdc)
{
	VECTOR3	ref = {0, 0, 0}, dir;

	TextParameter (VL_TEXT_HEIGHT, 30);
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	PushTransformation3D (NULL);
	VSET3 (dir, -1, 1, 1);
	Stretch3D (ref, dir, 1.5f);
	Cube (hdc, 20, 20, 20);
	MarkPosition3D (hdc, 0, 0, 0, 40, VL_ORIGIN);
	PopTransformation3D (NULL);
}

void	ShearTransf3D (HDC hdc)
{
	VECTOR3	origin = {0, 0, 0}, normal = {0, 0, 1};

	TextParameter (VL_TEXT_HEIGHT, 30);
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	PushTransformation3D (NULL);
	Shear3D (origin, normal, -0.5f, 0.5f);
	Cube (hdc, 20, 20, 20);
	MarkPosition3D (hdc, 0, 0, 0, 40, VL_ORIGIN);
	PopTransformation3D (NULL);
}

void	MirrorTransf3D (HDC hdc)
{
	VECTOR3	ref = {0, 0, 0}, dir;
	char	str[] = "Visualib";

	MarkPosition3D (hdc, 0, 0, 0, 40, VL_ORIGIN);
	SetViewerName (VL_CURRENT, "3D Mirror Transformation");
	SetTextAlign (hdc, TA_LEFT | TA_BOTTOM);
	TextParameter (VL_TEXT_HEIGHT, 20);
	BrushColor (hdc, VL_RED);
	Text3D (hdc, 3, 3, 0, str);
	PushTransformation3D (NULL);
	VSET3 (dir, 1, 0, 0);
	Mirror3D (ref, dir);
	BrushColor (hdc, VL_GREEN);
	Text3D (hdc, 3, 3, 0, str);
	PopTransformation3D (NULL);
	PushTransformation3D (NULL);
	VSET3 (dir, 0, 1, 0);
	Mirror3D (ref, dir);
	BrushColor (hdc, VL_YELLOW);
	Text3D (hdc, 3, 3, 0, str);
	PopTransformation3D (NULL);
	PushTransformation3D (NULL);
	VSET3 (dir, -1, -1, 0);
	Mirror3D (ref, dir);
	BrushColor (hdc, VL_BLUE);
	Text3D (hdc, 3, 3, 0, str);
	PopTransformation3D (NULL);
}

void	PointScaleTransf3D (HDC hdc)
{
	char	str[] = "Visualib";

	MarkPosition3D (hdc, 0, 0, 0, 40, VL_ORIGIN);
	SetViewerName (VL_CURRENT, "3D PointScale Transformation");
	SetTextAlign (hdc, TA_LEFT | TA_BOTTOM);
	TextParameter (VL_TEXT_HEIGHT, 20);
	BrushColor (hdc, VL_RED);
	Text3D (hdc, 3, 3, 0, str);
	PushTransformation3D (NULL);
	PointScale3D (0, 0, 0, -1, 1, 1);
	BrushColor (hdc, VL_GREEN);
	Text3D (hdc, 3, 3, 0, str);
	PopTransformation3D (NULL);
	PushTransformation3D (NULL);
	PointScale3D (0, 0, 0, 1, -1, 1);
	BrushColor (hdc, VL_YELLOW);
	Text3D (hdc, 3, 3, 0, str);
	PopTransformation3D (NULL);
	PushTransformation3D (NULL);
	PointScale3D (0, 0, 0, -1, -1, 1);
	BrushColor (hdc, VL_BLUE);
	Text3D (hdc, 3, 3, 0, str);
	PopTransformation3D (NULL);
}

void	Transformation3D (HDC hdc, int func)
{
	TextColor (hdc, VL_WHITE, VL_BLACK, TRANSPARENT);
	ClearDepthBuffer (0xffff);
	switch (func) {
		case IDM_3DTRANSF_TRANSLATE:
			break;
		case IDM_3DTRANSF_SCALE:
			break;
		case IDM_3DTRANSF_POINTSCALE:
			PointScaleTransf3D (hdc);
			break;
		case IDM_3DTRANSF_ROTATE:
			break;
		case IDM_3DTRANSF_AXLEROTATE:
			AxleRotateTransf3D (hdc);
			break;
		case IDM_3DTRANSF_STRETCH:
			StretchTransf3D (hdc);
			break;
		case IDM_3DTRANSF_SHEAR:
			ShearTransf3D (hdc);
			break;
		case IDM_3DTRANSF_MIRROR:
			MirrorTransf3D (hdc);
			break;
	}
}

VOIDED	MaterialPropertyDemo (HDC hdc)
{
	short	i, j, n = 1;
	REAL	ks, kd, orgks, orgkd, orgn;
	RECT	rect;

	SwitchLight (light7, TRUE);
	SwitchLight (light8, TRUE);
	SelectViewer (viewer30);
	SetViewerName (VL_CURRENT, "Material Reflection Property");
	orgks = ShadingFactor (VL_CURRENT, VL_SPECULARREFLECT, VL_INQUIRE);
	orgkd = ShadingFactor (VL_CURRENT, VL_DIFFUSEREFLECT, VL_INQUIRE);
	orgn = ShadingFactor (VL_CURRENT, VL_SHININESS, VL_INQUIRE);
	rect.top = 10;
	ks = 0.1f;
	for (i = 0; i < 6; i++) {
		kd = 0.05f;
		rect.left = 10;
		rect.bottom = rect.top + 40;
		for (j = 0; j < 10; j++) {
			rect.right = rect.left + 40;
			ShadingFactor (VL_CURRENT, VL_SHININESS, n);
			ShadingFactor (VL_CURRENT, VL_SPECULARREFLECT, ks);
			ShadingFactor (VL_CURRENT, VL_DIFFUSEREFLECT, kd);
			if (!ShadingPreview (hdc, &rect, 5, 173))
				goto exit;
			rect.left += 49;
			kd += 0.1f;
		}
		ks += 0.2f;
		rect.top += 53;
		n *= 2;
	}
exit:
	ShadingFactor (VL_CURRENT, VL_DIFFUSEREFLECT, orgkd);
	ShadingFactor (VL_CURRENT, VL_SPECULARREFLECT, orgks);
	ShadingFactor (VL_CURRENT, VL_SHININESS, orgn);
}

void	CompositeDemo3D (HDC hdc)
{
	static REAL	r0, r1, r2, t1, t2, h;
	short	i;
	BOOL	flag;

	SelectViewer (viewer30);
	SetViewerName (VL_CURRENT, "Object Composition");
	ClearDepthBuffer (0xffff);
	SwitchLight (light7, TRUE);
	SwitchLight (light8, TRUE);
	SelectMaterial (mater0);
	PushTransformation3D (NULL);
	r0 = 4; r1 = 30; r2 = 40;
	t1 = 3; t2 = 2; h = 10;

	if (!SolidRing (hdc, r2, r2, t2, h, 115, 335, 1))
		goto exit;

	PushTransformation3D (NULL);
	Translate3D (0, 0, h / 2);
	SelectMaterial (mater1);
	Rotate3D (135, 'z');
	for (i = 0; i < 10; i++) {
		PushTransformation3D (NULL);
		Translate3D (35, 0, 0);
		flag = Sphere (hdc, r0);
		PopTransformation3D (NULL);
		Rotate3D (20, 'z');
		if (!flag)
			goto exit;
	}
	PopTransformation3D (NULL);
	SelectMaterial (mater0);
	if (!Tube (hdc, r1, r1, t1, h))
		goto exit;
	PushTransformation3D (NULL);
	Translate3D (0, 0, h / 2);
	SelectMaterial (mater1);
	Rotate3D (-25, 'z');
	for (i = 0; i < 8; i++) {
		PushTransformation3D (NULL);
		Translate3D (35, 0, 0);
		flag = Sphere (hdc, r0);
		PopTransformation3D (NULL);
		Rotate3D (20, 'z');
		if (!flag)
			break;
	}
	PopTransformation3D (NULL);
exit:
	PopTransformation3D (NULL);
}

void	DepthClippingDemo (HDC hdc)
{
	SelectViewer (viewer30);
	SetPerspective (VL_CURRENT, 45, 1, 141, 200);
	ClearDepthBuffer (0xffff);
	SwitchLight (light7, TRUE);
	SwitchLight (light8, TRUE);
	SelectMaterial (mater1);
	TranslateTo3D (20, 0, 0);
	if (!Sphere (hdc, 20))
		goto exit;
	SelectMaterial (mater2);
	TranslateTo3D (0, 20, 0);
	if (!Sphere (hdc, 20))
		goto exit;
	SelectMaterial (mater3);
	TranslateTo3D (0, 0, 20);
	if (!Sphere (hdc, 20))
		return;
	TranslateTo3D (0, 0, 0);
	SelectMaterial (mater0);
	if (!Cube (hdc, 40, 40, 40))
		goto exit;
 exit:
	SetPerspective (VL_CURRENT, 45, 1, 30, 1000);
	SetViewerName (VL_CURRENT, "Depth Buffer and Clipping");
}

void	MarbleRingDemo (hdc)
{
	short	texture;

	SelectViewer (viewer30);
	SetViewerName (VL_CURRENT, "Marble Ring");
	ClearDepthBuffer (0xffff);
	SelectMaterial (mater3);
	texture = SolidTexture (VL_MARBLE);
	ShadingColor (VL_CURRENT, VL_MATERIALSPECULAR, RGB (255, 255, 255));
	ShadingFactor (VL_CURRENT, VL_SPECULARREFLECT, 1);
	SwitchLight (light7, TRUE);
	SwitchLight (light8, TRUE);
	Torus (hdc, 35, 5);
	SolidTexture (texture);
}

void	WoodSurfaceDemo (HDC hdc)
{
	short	texture;
	
	POINT3D surf[36] = {
		{0,0,0},{1,0,0},{2,0,0},{3,0,0},{4,0,0},{5,0,0},
		{0,1,0},{1,1,0},{2,1,0},{3,1,0},{4,1,0},{5,1,0},
		{0,2,0},{1,2,0},{2,2,9},{3,2,9},{4,2,0},{5,2,0},
		{0,3,0},{1,3,0},{2,3,9},{3,3,9},{4,3,0},{5,3,0},
		{0,4,0},{1,4,0},{2,4,0},{3,4,0},{4,4,0},{5,4,0},
		{0,5,0},{1,5,0},{2,5,0},{3,5,0},{4,5,0},{5,5,0}};
	REAL    sknot[20] = {0,0,0,1,2,3,3,3};
	REAL    tknot[20] = {0,0,0,1,2,3,3,3};

	SelectViewer (viewer30);
	SetViewerName (VL_CURRENT, "Wood Surface");
	ClearDepthBuffer (0xffff);
	texture = SolidTexture (VL_WOODGRAIN);
	SwitchLight (light7, TRUE);
	SwitchLight (light8, TRUE);
	Translate3D (-15, -15, 5);
	Scale3D (10, 10, 5);
	NURBSSurface (hdc, VL_3D, (LPCOORD) surf, 6, 6, sknot, tknot, 4, 4);
	SolidTexture (texture);
}

void	GraniteCubeDemo (HDC hdc)
{
	REAL	l8;
	short	texture;

	SelectViewer (viewer30);
	SetViewerName (VL_CURRENT, "Granite Cube");
	ClearDepthBuffer (0xffff);
	texture = SolidTexture (VL_GRANITE);
	SelectMaterial (mater0);
	l8 = ShadingFactor (light8, VL_LIGHTINTENSITY, 2);
	SwitchLight (light7, TRUE);
	SwitchLight (light8, TRUE);
	Cube (hdc, 30, 30, 30);
	SolidTexture (texture);
	ShadingFactor (light8, VL_LIGHTINTENSITY, l8);
}

void	StereoTextDemo (HDC hdc)
{
	SelectViewer (viewer30);
	SelectMaterial (mater3);
	ClearDepthBuffer (0xffff);
	TextParameter (VL_TEXT_HEIGHT, 40);
	TextParameter (VL_TEXT_THICKNESS, 8);
	SwitchLight (light4, TRUE);
	SwitchLight (light7, TRUE);
	SelectMaterial (mater0);
	PushTransformation3D (NULL);
	Rotate3D (135, 'z');
	Rotate3D (90, 'x');
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	SolidText (hdc, "Visualib");
	PopTransformation3D (NULL);
	SetViewerName (VL_CURRENT, "Stereo Text");
	SelectObject (hdc, GetStockObject (SYSTEM_FONT));
}

void	Welcome (HDC hdc)
{
	char	str[80];

	SelectViewer (viewer20);
	PushTransformation2D (NULL);
	Scale2D (0.1f, 0.1f);
	SetTextAlign (hdc, TA_BASELINE | TA_CENTER);
	TextParameter (VL_TEXT_HEIGHT, 40);
	PenColor (hdc, VL_RED);
	BrushColor (hdc, VL_YELLOW);
	wsprintf (str, "Welcome\nto\nVisuaLib");
	SetFont (NULL);
	Text2D (hdc, 0, 0, 0, str);
	PopTransformation2D (NULL);
}

void	BumpyDonutDemo (HDC hdc)
{
	short	texture;

	SelectViewer (viewer30);
	SetViewerName (VL_CURRENT, "Bumpy Donut");
	SelectMaterial (mater2);
	ClearDepthBuffer (0xffff);
	texture = SolidTexture (VL_BUMPY);
	ShadingColor (VL_CURRENT, VL_MATERIALSPECULAR, RGB (255, 255, 255));
	ShadingFactor (VL_CURRENT, VL_SPECULARREFLECT, 1);
//	SwitchLight (light7, TRUE);
	SwitchLight (light8, TRUE);
	Torus (hdc, 35, 10);
	SolidTexture (texture);
}

void	VlibDemo (HDC hdc, int func)
{
	BOOL	l0, l1, l2, l3;
	BOOL	twosideshade, backfaceoff;

	l0 = SwitchLight (light0, FALSE);
	l1 = SwitchLight (light1, FALSE);
	l2 = SwitchLight (light2, FALSE);
	l3 = SwitchLight (light3, FALSE);
	twosideshade = ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, FALSE);
	backfaceoff = ShadingOption (VL_CURRENT, VL_BACKFACEREMOVAL, TRUE);
	switch (func) {
		case IDM_DEMO_START:
			Welcome (hdc);
			break;
		case IDM_DEMO_SPOTLIGHT:
			SpotlightDemo (hdc);
			break;
		case IDM_DEMO_MATERIALPROPERTY:
			MaterialPropertyDemo (hdc);
			break;
		case IDM_DEMO_IMAGEMAPPING:
			ImageMappingDemo (hdc);
			break;
		case IDM_DEMO_DEPTHCLIPPING:
			DepthClippingDemo (hdc);
			break;
		case IDM_DEMO_MARBLERING:
			MarbleRingDemo (hdc);
			break;
		case IDM_DEMO_BUMPYDONUT:
			BumpyDonutDemo (hdc);
			break;
		case IDM_DEMO_GRANITECUBE:
			GraniteCubeDemo (hdc);
			break;
		case IDM_DEMO_WOODSURFACE:
			WoodSurfaceDemo (hdc);
			break;
		case IDM_DEMO_3DCOMPOSITE:
			CompositeDemo3D (hdc);
			break;
		case IDM_DEMO_STEREOTEXT:
			StereoTextDemo (hdc);
			break;
		case IDM_DEMO_2DCOMPOSITE:
			CompositeDemo2D (hdc);
			break;
		case IDM_DEMO_NURBSCURVE:
			SelectViewer (viewer20);
			Primitives2D (hdc, IDM_2DCURVE_NURBS);
			SelectViewer (viewer30);
			Primitives3D (hdc, IDM_3DCURVE_NURBS);
			break;
		case IDM_DEMO_POLYFACET:
			SelectViewer (viewer30);
			SetViewerName (VL_CURRENT, "Poly Facets");
			PolyfacetsDemo (hdc);
			break;
	}
	ShadingOption (VL_CURRENT, VL_TWOSIDESHADE, twosideshade);
	ShadingOption (VL_CURRENT, VL_BACKFACEREMOVAL, backfaceoff);
	SwitchLight (light0, l0);
	SwitchLight (light1, l1);
	SwitchLight (light2, l2);
	SwitchLight (light3, l3);
	SwitchLight (light4, FALSE);
	SwitchLight (light5, FALSE);
	SwitchLight (light6, FALSE);
	SwitchLight (light7, FALSE);
	SwitchLight (light8, FALSE);
	SelectMaterial (mater3);
}

void    FunctionDemos (HDC hdc)
{
	int		func = demo_function;

	SetROP2 (hdc, R2_COPYPEN);
	if (func > IDM_2DPRIME_START && func < IDM_2DPRIME_END) {
		SelectViewer (viewer20);
		Prime2D (hdc, func);
	}
	else if (func > IDM_3DPRIME_START && func < IDM_3DPRIME_END) {
		SelectViewer (viewer30);
		Prime3D (hdc, func);
	}
	else if (func >= IDM_SURFACE_START && func < IDM_SURFACE_END) {
		SelectViewer (viewer30);
		Surfaces (hdc, func);
	}
	else if (func >= IDM_SOLID_START && func < IDM_SOLID_END) {
		SelectViewer (viewer30);
		ShowSolidPrimitives (hdc, func);
	}
	else if (func > IDM_ANIMATE_START && func < IDM_ANIMATE_END) {
		AnimationDemo (hdc, func);
		ViewerReset ();
		SelectMaterial (mater3);
	}
	else if (func > IDM_TEXT_START && func < IDM_TEXT_END) {
		ShowTextPrimitives (hdc, func);
	}
	else if (func > IDM_2DTRANSF_BEGIN && func < IDM_3DTRANSF_BEGIN) {
		SelectViewer (viewer20);
		Transformation2D (hdc, func);
	}
	else if (func > IDM_3DTRANSF_BEGIN && func < IDM_3DTRANSF_END) {
		SelectViewer (viewer30);
		Transformation3D (hdc, func);
	}
	else if (func > IDM_2DPRIMIT_START && func < IDM_2DPRIMIT_END) {
		SelectViewer (viewer20);
		Primitives2D (hdc, func);
	}
	else if (func > IDM_3DPRIMIT_START && func < IDM_3DPRIMIT_END) {
		SelectViewer (viewer30);
		Primitives3D (hdc, func);
	}
	else if (func > IDM_3DARRAY_BEGIN && func < IDM_3DARRAY_END) {
		SelectViewer (viewer30);
		ObjectArray3D (hdc, func);
	}
	else if (func > IDM_2DARRAY_BEGIN && func < IDM_2DARRAY_END) {
		SelectViewer (viewer20);
		ObjectArray2D (hdc, func);
	}
    else {
		VlibDemo (hdc, func);
    }
	PenColor (hdc, VL_BLUE);
	DisplayViewerFrame (hdc, VL_CURRENT);
	TextColor (hdc, VL_RED, VL_BLACK, TRANSPARENT);
	DisplayViewerName (hdc, VL_CURRENT, FALSE);
}

void    AdjustViewer (HWND hwnd, int viewid)
{
    RECT    rect;

    GetClientRect (hwnd, &rect);
	rect.left += 10;
	rect.right -= 10;
	rect.top += 10;
	rect.bottom -= 20;
    SetViewport (viewid, rect);
}

BINARY	SavePicture (HWND hwnd, BOOL withframe)
{
	RECT	rect;
	HANDLE	hdib;
	BOOL	flag;

	GetScreenRect (hwnd, withframe, &rect);
	hdib = ScreenToDIB (&rect);
	if (!hdib)
		return (FALSE);
	flag = WriteDIBFile (NULL, hdib);
	GlobalUnlock (hdib);
	GlobalFree (hdib);
	return (flag);
}

BINARY	PrintPicture (HWND hwnd, BOOL withframe)
{
	RECT	rect;
	HANDLE	hdib;
	BOOL	flag;

	GetScreenRect (hwnd, withframe, &rect);
	hdib = ScreenToDIB (&rect);
	if (!hdib)
		return (FALSE);
	flag = PrintImage (hdib,
		VL_BESTFIT | VL_VERTCENTER | VL_HORZCENTER | VL_MARKCORNER,
		0, 0, 0, 0);
	GlobalUnlock (hdib);
	GlobalFree (hdib);
	return (flag);
}

void	PrintFlag (void)
{
	SelectViewer (viewer22);
	PrintDrawing (USFlag,
		VL_BESTFIT | VL_HORZCENTER | VL_VERTCENTER | VL_MARKCORNER,
		0, 0, 0, 0);
}

void	ExitVlibDemo (HWND hwnd)
{
	DeleteObject (GetClassWord (hwnd, GCW_HBRBACKGROUND));
	ExitVisualib ();
	if (hdib1) {
		GlobalUnlock (hdib1);
		GlobalFree (hdib1);
	}
	if (hdib2) {
		GlobalUnlock (hdib2);
		GlobalFree (hdib2);
	}
	if (hdib3) {
		GlobalUnlock (hdib3);
		GlobalFree (hdib3);
	}
	PostQuitMessage (0);
}

void	AlterMenuItem (HWND hwnd, WORD entry)
{
	short	flag = MF_BYCOMMAND;

	switch (entry) {
		case IDM_DEMO_WITHFRAME:
			withframe = !withframe;
			flag |= (withframe) ? MF_CHECKED : MF_UNCHECKED;
			break;
	}
	CheckMenuItem (GetMenu (hwnd), entry, flag);
}
						
/****************************************************************************

    FUNCTION: MainWndProc (HWND, WORD, WORD, LONG)

****************************************************************************/

long WINAPI MainWndProc (HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
    switch (msg) {
        case WM_COMMAND:
            switch (wparam) {
                case IDM_DEMO_EXIT:
					PostMessage (hwnd, WM_DESTROY, 0, 0L);
                    break;
                case IDM_HELP_ABOUT:
					AboutVisualib ();
					SendMessage (hwnd, WM_COMMAND, IDM_DEMO_START, 0L);
                    break;
				case IDM_HELP_LICENSE:
					LicenseInfo ();
					break;
                case IDM_HELP_DEMOPROG:
                    WinHelp (hwnd, "vlibdemo.hlp", HELP_INDEX, 0);
                    break;
                case IDM_HELP_VISUALIB:
                    WinHelp (hwnd, "visualib.hlp", HELP_INDEX, 0);
                    break;
				case IDM_DEMO_SAVEPICTURE:
					SavePicture (hwnd, withframe);
					break;
				case IDM_DEMO_PRINTPICTURE:
					PrintPicture (hwnd, withframe);
					break;
				case IDM_DEMO_WITHFRAME:
					AlterMenuItem (hwnd, wparam);
					break;
				case IDM_DEMO_PRINTFLAG:
					PrintFlag ();
					break;
				case IDM_TEXT_SELECTFONT:
					SelectFont ();
					return (NULL);
                default:
					if (wparam > 200 && wparam < 300) {
						ShadingSettings (hwnd, wparam);
						break;
					}
                    demo_function = wparam;
                    InvalidateRect (hwnd, NULL, TRUE);
                    return (DefWindowProc (hwnd, msg, wparam, lparam));
            }
            break;
        case WM_DESTROY:
			ExitVlibDemo (hwnd);
            break;

        case WM_PAINT:
            ProcessWindowPaint (hwnd);
            break;
        
        case WM_SIZE:
            AdjustViewer (hwnd, viewer20);
            AdjustViewer (hwnd, viewer30);
            InvalidateRect (hwnd, NULL, TRUE);
            break;

        default:
            return (DefWindowProc (hwnd, msg, wparam, lparam));
    }
    return (NULL);
}
