#include <windows.h>
#include <stdlib.h>
#include <math.h>
#include "visualib.h"
#include "modellib.h"
#include "vlibdemo.h"
#include "demoproc.h"

VOIDED	LineDemo2D (HDC hdc)
{
	ViewerName (VL_CURRENT, "2D Lines");
	PenColor (hdc, VL_RED);
	MoveTo2D (hdc, 0, 0);
	LineTo2D (hdc, 1, 1);
	RLineTo2D (hdc, -2, 0);
	RLineTo2D (hdc, 0, -2);
	RLineTo2D (hdc, 2, 0);
	RLineTo2D (hdc, 0, 2);
	RMoveTo2D (hdc, 1, 1);
	LineTo2D (hdc, -2, 2);
	PenColor (hdc, VL_BLUE);
	MoveTo2H (hdc, 1, 1, 0.5f);
	LineTo2H (hdc, 0, 1, 0);
	LineTo2H (hdc, 0, 0, 1);
	MoveTo2H (hdc, -1, 1, 0.5f);
	LineTo2H (hdc, -1, 0, 0);
	LineTo2H (hdc, 0, 0, 1);
	MoveTo2H (hdc, -1, -1, 0.5f);
	LineTo2H (hdc, 0, -1, 0);
	LineTo2H (hdc, 0, 0, 1);
	MoveTo2H (hdc, 1, -1, 0.5f);
	LineTo2H (hdc, 1, 0, 0);
	LineTo2H (hdc, 0, 0, 1);
	PenColor (hdc, VL_GREEN);
	Line2D (hdc, -15, 5, 15, 5);
	Line2D (hdc, -15, -5, 15, -5);
	Line2D (hdc, -5, -15, -5, 15);
	Line2D (hdc, 5, -15, 5, 15);
	Line2D (hdc, -15, 0, 0, 15);
	Line2D (hdc, 15, 0, 0, 15);
	Line2D (hdc, 0, -15, 15, 0);
	Line2D (hdc, 0, -15, -15, 0);
	PenColor (hdc, VL_YELLOW);
	Line2H (hdc, -5, 5, 0.75f, 5, 5, 0.75f);
	Line2H (hdc, -5, -5, 0.75f, 5, -5, 0.75f);
	Line2H (hdc, -5, -5, 0.75f, -5, 5, 0.75f);
	Line2H (hdc, 5, -5, 0.75f, 5, 5, 0.75f);
	PenColor (hdc, VL_BROWN);
	RLine2D (hdc, 2, 3, -5, -5);
}

VOIDED	PolylineDemo2D (HDC hdc)
{
	REAL	poly[] = {-1, -1, -1, 1, 1, 1, 1, -1};

	ViewerName (VL_CURRENT, "2D PolyLines");
	PenColor (hdc, VL_RED);
	Polyline2D (hdc, VL_2D, poly, 4);
	PushTransformation2D (NULL);
	TranslateTo2D (3, 3);
	ClosedPolyline2D (hdc, VL_2D, poly, 4);
	TranslateTo2D (10, 0);
	ClosedPolyline2D (hdc, VL_2D, poly, 4);
	TranslateTo2D (10, -6);
	ClosedPolyline2D (hdc, VL_2D, poly, 4);
	TranslateTo2D (-10, -6);
	ClosedPolyline2D (hdc, VL_2D, poly, 4);
	TranslateTo2D (-10, 6);
	ClosedPolyline2D (hdc, VL_2D, poly, 4);
	PopTransformation2D (NULL);
	LineTo2D (hdc, 0, 0);
}

VOIDED	PointerDemo2D (HDC hdc)
{
	REAL	x, y, a;
	UINT	i;

	ViewerName (VL_CURRENT, "2D Pointers");
	PenColor (hdc, VL_YELLOW);
	for (i = 0, a = 0; i < 12; i++, a += 0.5f) {
		x = (REAL) cos (a) * 9;
		y = (REAL) sin (a) * 5;
		Pointer2D (hdc, 0, 0, x, y, 1, 0.5f, VL_CLOSEDARROW);
	}
}

VOIDED	MarkDemo2D (HDC hdc)
{
	UINT	i, j;
	REAL	x, y;

	ViewerName (VL_CURRENT, "2D Marks");
	PenColor (hdc, VL_BLUE);
	for (j = 0, y = -6; j < 7; j++, y += 2)
		for (i = 0, x = -9; i < 10; i++, x += 2)
			Mark2D (hdc, x, y, i+2, i+2, VL_CIRCLEMARK << j);
}

VOIDED	LabelDemo2D (HDC hdc)
{
	ViewerName (VL_CURRENT, "2D Labels");
	TextColor (hdc, VL_RED, VL_NONE);
	PenColor (hdc, VL_GREEN);
	SetTextAlign (hdc, TA_CENTER | TA_BASELINE);
	Label2D (hdc, 0, 0, "Center & BaseLine");
	Mark2D (hdc, 0, 0, 15, 5, VL_CROSSMARK);
	SetTextAlign (hdc, TA_CENTER | TA_TOP);
	Label2D (hdc, 0, 3, "Center & Top");
	Mark2D (hdc, 0, 3, 15, 3, VL_CROSSMARK);
	SetTextAlign (hdc, TA_CENTER | TA_BOTTOM);
	Label2D (hdc, 0, -3, "Center & Bottom");
	Mark2D (hdc, 0, -3, 15, 3, VL_CROSSMARK);

	SetTextAlign (hdc, TA_LEFT | TA_BASELINE);
	Label2D (hdc, 3.5f, 0, "Left & BaseLine");
	Mark2D (hdc, 3.5f, 0, 15, 5, VL_CROSSMARK);
	SetTextAlign (hdc, TA_LEFT | TA_TOP);
	Label2D (hdc, 3.5f, 3, "Left & Top");
	Mark2D (hdc, 3.5f, 3, 15, 3, VL_CROSSMARK);
	SetTextAlign (hdc, TA_LEFT | TA_BOTTOM);
	Label2D (hdc, 3.5f, -3, "Left & Bottom");
	Mark2D (hdc, 3.5f, -3, 15, 3, VL_CROSSMARK);

	SetTextAlign (hdc, TA_RIGHT | TA_BASELINE);
	Label2D (hdc, -3.5f, 0, "Right & BaseLine");
	Mark2D (hdc, -3.5f, 0, 15, 5, VL_CROSSMARK);
	SetTextAlign (hdc, TA_RIGHT | TA_TOP);
	Label2D (hdc, -3.5f, 3, "Right & Top");
	Mark2D (hdc, -3.5f, 3, 15, 3, VL_CROSSMARK);
	SetTextAlign (hdc, TA_RIGHT | TA_BOTTOM);
	Label2D (hdc, -3.5f, -3, "Right & Bottom");
	Mark2D (hdc, -3.5f, -3, 15, 3, VL_CROSSMARK);
}

VOIDED	NetDemo2D (HDC hdc)
{
	REAL	net[140];
	UINT	i, j, index = 0;
	REAL	x, y;

	PenColor (hdc, VL_BLUE);
	;
	for (i = 0, y = -6.5f; i < 7; i++, y += 2) {
		for (j = 0, x = -9.5f; j < 10; j++, x += 2) {
			net[index++] = x + ((REAL) rand () / RAND_MAX);
			net[index++] = y + ((REAL) rand () / RAND_MAX);
		}
	}
	Net2D (hdc, VL_2D, (VECTOR) net, 7, 10);
	ViewerName (VL_CURRENT, "2D Net");
}

VOIDED	Prime2D (HDC hdc, WORD func)
{
	switch (func) {
		case IDM_2DPRIME_LINE:
			LineDemo2D (hdc);
			break;
		case IDM_2DPRIME_POLYLINE:
			PolylineDemo2D (hdc);
			break;
		case IDM_2DPRIME_POINTER:
			PointerDemo2D (hdc);
			break;
		case IDM_2DPRIME_MARK:
			MarkDemo2D (hdc);
			break;
		case IDM_2DPRIME_LABEL:
			LabelDemo2D (hdc);
			break;
		case IDM_2DPRIME_NET:
			NetDemo2D (hdc);
			break;
		case IDM_2DPRIME_SPIRAL:
			PenColor (hdc, VL_YELLOW);
            Spiral2D (hdc, 0, 0, 30, 5, 1, 1);
			ViewerName (VL_CURRENT, "2D Spiral Curve");
			break;
	}
}

VOIDED	LineDemo3D (HDC hdc)
{
	ViewerName (VL_CURRENT, "3D Lines");
	PenColor (hdc, VL_RED);
	MoveTo3D (hdc, 0, 0, 0);
	LineTo3D (hdc, 10, 10, 0);
	RLineTo3D (hdc, 0, -20, 0);
	RLineTo3D (hdc, -20, 0, 0);
	RLineTo3D (hdc, 0, 20, 0);
	RLineTo3D (hdc, 20, 0, 0);
	PenColor (hdc, VL_BLUE);
	MoveTo3H (hdc, 1, 1, 0, 0.5f);
	LineTo3H (hdc, 0, 1, 0, 0);
	LineTo3H (hdc, 0, 0, 0, 1);
	MoveTo3H (hdc, -1, 1, 0, 0.5f);
	LineTo3H (hdc, -1, 0, 0, 0);
	LineTo3H (hdc, 0, 0, 0, 1);
	MoveTo3H (hdc, -1, -1, 0, 0.5f);
	LineTo3H (hdc, 0, -1, 0, 0);
	LineTo3H (hdc, 0, 0, 0, 1);
	MoveTo3H (hdc, 1, -1, 0, 0.5f);
	LineTo3H (hdc, 1, 0, 0, 0);
	LineTo3H (hdc, 0, 0, 0, 1);
	PenColor (hdc, VL_YELLOW);
	MoveTo3D (hdc, 100, 100, 90);
	LineTo3D (hdc, 10, 0, 0);
	MoveTo3D (hdc, 100, 100, 90);
	LineTo3D (hdc, 0, 10, 0);
	MoveTo3D (hdc, 100, 100, 90);
	LineTo3D (hdc, 0, 0, 10);
}

VOIDED	PolylineDemo3D (HDC hdc)
{
	REAL	poly[] = {-1, -1, -1, 1, 1, 1, 1, -1};

	ViewerName (VL_CURRENT, "3D PolyLines");
	PenColor (hdc, VL_RED);
	Polyline3D (hdc, VL_2D, poly, 4);
	PushTransformation3D (NULL);
	Scale3D (5, 5, 5);
	TranslateTo3D (3, 3, 0);
	PenColor (hdc, VL_GREEN);
	ClosedPolyline3D (hdc, VL_2D, poly, 4);
	TranslateTo3D (10, 0, 0);
	PenColor (hdc, VL_BLUE);
	ClosedPolyline3D (hdc, VL_2D, poly, 4);
	TranslateTo3D (10, -6, 0);
	PenColor (hdc, VL_YELLOW);
	ClosedPolyline3D (hdc, VL_2D, poly, 4);
	TranslateTo3D (-10, -6, 0);
	PenColor (hdc, VL_BROWN);
	ClosedPolyline3D (hdc, VL_2D, poly, 4);
	TranslateTo3D (-10, 6, 0);
	PenColor (hdc, VL_WHITE);
	ClosedPolyline3D (hdc, VL_2D, poly, 4);
	PopTransformation3D (NULL);
	LineTo3D (hdc, 0, 0, 0);
}

VOIDED	PointerDemo3D (HDC hdc)
{
	ViewerName (VL_CURRENT, "3D Pointers");
	PenColor (hdc, VL_RED);
	Pointer3D (hdc, 0, 0, 0, 20, 0, 0, 5, 3, VL_OPENARROW);
	PenColor (hdc, VL_GREEN);
	Pointer3D (hdc, 0, 0, 0, 0, 20, 0, 5, 3, VL_CLOSEDARROW);
	PenColor (hdc, VL_BLUE);
	Pointer3D (hdc, 0, 0, 0, 0, 0, 20, 5, 3, VL_CROSSMARK);
	PenColor (hdc, VL_YELLOW);
	Pointer3D (hdc, 0, 0, 0, -20, 0, 0, 5, 3, VL_HEXAGONMARK);
	PenColor (hdc, VL_BROWN);
	Pointer3D (hdc, 0, 0, 0, 0, -20, 0, 5, 3, VL_TRIANGLEMARK);
	PenColor (hdc, VL_WHITE);
	Pointer3D (hdc, 0, 0, 0, 0, 0, -20, 5, 3, VL_BOXMARK);
}

VOIDED	MarkDemo3D (HDC hdc)
{
	ViewerName (VL_CURRENT, "3D Marks");
	PenColor (hdc, VL_RED);
	Mark3D (hdc, 0, 0, 0, 5, 5, VL_CROSSMARK);
	PenColor (hdc, VL_GREEN);
	Mark3D (hdc, 20, 0, 0, 5, 5, VL_HEXAGONMARK);
	PenColor (hdc, VL_BLUE);
	Mark3D (hdc, 0, 20, 0, 5, 5, VL_DIAMONDMARK);
	PenColor (hdc, VL_WHITE);
	Mark3D (hdc, 0, 0, 20, 5, 5, VL_TRIANGLEMARK);
}

VOIDED	LabelDemo3D (HDC hdc)
{
	int	method;

	ViewerName (VL_CURRENT, "3D Labels");
	Scale3D (2, 2, 2);
	method = ShadingMethod (VL_WIREFRAME);
	PenColor (hdc, VL_GREEN);
	Cube (hdc, 20, 20, 20);
	ShadingMethod (method);
	TextColor (hdc, VL_RED, VL_NONE);
	SetTextAlign (hdc, TA_BOTTOM | TA_CENTER);
	Label3D (hdc, -10, -10, 10, "Back Top");
	SetTextAlign (hdc, TA_BASELINE | TA_CENTER);
	Label3D (hdc, 10, 10, 10, "Front Top");
	SetTextAlign (hdc, TA_TOP | TA_CENTER);
	Label3D (hdc, 10, 10, -10, "Front Bottom");
	SetTextAlign (hdc, TA_BASELINE | TA_RIGHT);
	Label3D (hdc, 10, -10, 10, "Left Top");
	Label3D (hdc, 10, -10, -10, "Left Bottom");
	SetTextAlign (hdc, TA_BASELINE | TA_LEFT);
	Label3D (hdc, -10, 10, 10, "Right Top");
	Label3D (hdc, -10, 10, -10, "Right Bottom");
}

VOIDED	NetDemo3D (HDC hdc)
{
	REAL	x, y, net[210];
	UINT	i, j, index = 0;

	PushTransformation3D (NULL);
	Scale3D (5, 5, 5);
	PenColor (hdc, VL_BLUE);
	for (i = 0, y = -6.5f; i < 7; i++, y += 2) {
		for (j = 0, x = -9.5f; j < 10; j++, x += 2) {
			net[index++] = x + ((REAL) rand () / RAND_MAX);
			net[index++] = y + ((REAL) rand () / RAND_MAX);
			net[index++] = (REAL) rand () / RAND_MAX;
		}
	}
	Net3D (hdc, VL_3D, (VECTOR) net, 7, 10);
	PopTransformation3D (NULL);
	ViewerName (VL_CURRENT, "3D Net");
}

VOIDED	Prime3D (HDC hdc, WORD func)
{
	MarkPosition3D (hdc, 0, 0, 0, 10, VL_ORIGIN);
	switch (func) {
		case IDM_3DPRIME_LINE:
			LineDemo3D (hdc);
			break;
		case IDM_3DPRIME_POLYLINE:
			PolylineDemo3D (hdc);
			break;
		case IDM_3DPRIME_POINTER:
			PointerDemo3D (hdc);
			break;
		case IDM_3DPRIME_MARK:
			MarkDemo3D (hdc);
			break;
		case IDM_3DPRIME_LABEL:
			LabelDemo3D (hdc);
			break;
		case IDM_3DPRIME_NET:
			NetDemo3D (hdc);
			break;
		case IDM_3DPRIME_SPIRAL:
			MarkPosition3D (hdc, 0, 0, 0, 20, VL_ORIGIN);
            PenColor (hdc, VL_GREEN);
            Spiral3D (hdc, 0, 10, 0, 0.5f, 40);
			PenColor (hdc, VL_YELLOW);
			Rotate3D (90, 'y');
            Spiral3D (hdc, 0, 10, 0, 0.5f, 40);
			PenColor (hdc, VL_RED);
			Rotate3D (-90, 'x');
            Spiral3D (hdc, 0, 10, 0, 0.5f, 40);
			ViewerName (VL_CURRENT, "3D Spiral");
			break;
		case IDM_3DPRIME_SPRING:
			MarkPosition3D (hdc, 0, 0, 0, 20, VL_ORIGIN);
            PenColor (hdc, VL_BLUE);
            Spring3D (hdc, 30, 10, 10, 40);
			PenColor (hdc, VL_YELLOW);
			Rotate3D (90, 'y');
            Spring3D (hdc, 30, 10, 10, 40);
			PenColor (hdc, VL_GREEN);
			Rotate3D (-90, 'x');
            Spring3D (hdc, 30, 10, 10, 40);
			ViewerName (VL_CURRENT, "3D Springs");
			break;
	}
}

VOIDED	DrawNgon (HDC hdc, WORD type)
{
	REAL	x, y, t, w, h;
	WORD	i, j, n;

	t = 0;
	w = h = 1.75f;
	for (i = 0, y = -5; i < 3; i++, y += 5) {
		for (j = 0, x = -7.5f; j < 4; j++, x += 5) {
			n = i * 4 + j;
			PenColor (hdc, (WORD)(VL_RED + n));
			BrushColor (hdc, (WORD)(VL_RED + j * 3 + i));
			n += 3;
			if (type == VL_THREED)
				Ngon3D (hdc, x, y, t, w, h, n);
			else
				Ngon2D (hdc, x, y, t, w, h, n);
		}
	}
}

VOIDED	DrawStar (HDC hdc, WORD type)
{
	REAL	x, y, t, w, h;
	UINT	i, j, n;

	t = 0; w = h = 1.75f;
	for (i = 0, y = -5; i < 3; i++, y += 5) {
		for (j = 0, x = -7.5f; j < 4; j++, x += 5) {
			n = i * 4 + j;
			PenColor (hdc, (WORD)(VL_RED + n));
			BrushColor (hdc, (WORD)(VL_RED + j * 3 + i));
			n += 3;
			if (type == VL_THREED)
				Star3D (hdc, x, y, t, w, h, n);
			else
				Star2D (hdc, x, y, t, w, h, n);
		}
	}
}

VOIDED	DrawFlower (HDC hdc, WORD type)
{
	REAL	x, y, t, w, h, r;
	UINT	i, j, n;

	t = 0; w = h = 1.75f; r = 0.75f;
	for (i = 0, y = -5; i < 3; i++, y += 5) {
		;
		for (j = 0, x = -7.5f; j < 4; j++, x += 5) {
			n = i * 4 + j;
			PenColor (hdc, (WORD)(VL_RED + n));
			BrushColor (hdc, (WORD)(VL_RED + j * 3 + i));
			n += 3;
			if (type == VL_THREED)
				Flower3D (hdc, x, y, t, w, h, n, r);
			else
				Flower2D (hdc, x, y, t, w, h, n, r);
		}
	}
}

VOIDED	DrawPie (HDC hdc, WORD type)
{
	REAL	x, y, t, w, h, a, b;
	UINT	i, j, n;

	t = 0;
	a = 0; w = h = 1.75f;
	for (i = 0, y = -6; i < 4; i++, y += 4) {
		for (j = 0, x = -7.5f, b = 30; j < 4; j++, x += 5, b += 30) {
			n = i * 4 + j;
			PenColor (hdc, (WORD)(VL_RED + n));
			BrushColor (hdc, (WORD)(VL_RED + j * 3 + i));
			if (type == VL_THREED)
				Pie3D (hdc, x, y, t, w, h, a, b);
			else
				Pie2D (hdc, x, y, t, w, h, a, b);
		}
		t += 90;
	}
}

VOIDED	DrawDisk (HDC hdc, WORD type)
{
	REAL	x, y, t, w, h;
	UINT	i, j, n;

	t = 0;
	w = 2; h = 0.2f;
	for (i = 0, y = -5; i < 3; i++, y += 5) {
		for (j = 0, x = -7.5f; j < 4; j++, x += 5) {
			n = i * 4 + j;
			PenColor (hdc, (WORD)(VL_RED + n));
			BrushColor (hdc, (WORD)(VL_RED + j * 3 + i));
			if (type == VL_THREED)
				Disk3D (hdc, x, y, t, w, h);
			else
				Disk2D (hdc, x, y, t, w, h);
			t += 15;
			w -= 0.15f;
			h += 0.15f;
		}
	}
}

VOIDED	DrawRose (HDC hdc, WORD type)
{
	REAL	x, y, t, r;
	UINT	i, j, m, n;

	t = 0;
	r = 2;
	for (i = 0, y = -4; i < 3; i++, y += 4) {
		n = i + 1;
		for (j = 0, x = -7.5f; j < 4; j++, x += 5) {
			switch (n) {
				case 1:
					m = j + 2;
					break;
				case 2:
					m = j * 2 + 1;
					break;
				case 3:
					m = j + 1 + j / 2;
					break;
			}
			PenColor (hdc, (WORD)(VL_RED + i * 4 + j));
			BrushColor (hdc, (WORD)(VL_RED + j * 3 + i));
			if (type == VL_THREED)
				Rose3D (hdc, x, y, t, r, m, n);
			else
				Rose2D (hdc, x, y, t, r, m, n);
			t += 15;
		}
	}
}

VOIDED	DrawBox (HDC hdc, WORD type)
{
	REAL	x, y, t, w, h;
	UINT	i, j, n;

	t = 0;
	w = 3; h = 0.6f;
	for (i = 0, y = -5; i < 3; i++, y += 5) {
		for (j = 0, x = -7.5f; j < 4; j++, x += 5, w -= 0.2f, h += 0.2f) {
			n = i * 4 + j;
			PenColor (hdc, (WORD)(VL_RED + n));
			BrushColor (hdc, (WORD)(VL_RED + j * 3 + i));
			if (type == VL_THREED)
				Box3D (hdc, x, y, t, w, h);
			else
				Box2D (hdc, x, y, t, w, h);
			t += 15;
		}
	}
}

VOIDED	DrawChord (HDC hdc, WORD type)
{
	REAL	x, y, t, w, h, a, b;
	UINT	i, j, n;

	t = 0;
	a = 0; b = 30; w = h = 1.75f;
	for (i = 0, y = -5; i < 3; i++, y += 5) {
		for (j = 0, x = -7.5f; j < 4; j++, x += 5, b += 30, t += 15) {
			n = i * 4 + j;
			PenColor (hdc, (WORD)(VL_RED + n));
			BrushColor (hdc, (WORD)(VL_RED + j * 3 + i));
			if (type == VL_THREED)
				Chord3D (hdc, x, y, a, w, h, a, b);
			else
				Chord2D (hdc, x, y, a, w, h, a, b);
		}
	}
}

VOIDED	DrawRing (HDC hdc, WORD type)
{
	REAL	x, y, t, w, h, a, b;
	UINT	i, j, n;

	; t = 0;
	a = 0; b = 30; w = h = 1;
	for (i = 0, y = -5; i < 3; i++, y += 5) {
		for (j = 0, x = -7.5f; j < 4; j++, x += 5, b += 30, t += 15) {
			n = i * 4 + j;
			PenColor (hdc, (WORD)(VL_RED + n));
			BrushColor (hdc, (WORD)(VL_RED + j * 3 + i));
			if (type == VL_THREED)
				Ring3D (hdc, x, y, a, w, h, a, b, 0.5f);
			else
				Ring2D (hdc, x, y, a, w, h, a, b, 0.5f);
		}
	}
}

VOIDED	DrawBezierCurve (HDC hdc, WORD type)
{
	REAL	point[40];

	point[0] = -8; point[1] = 3.5f;
	point[2] = -5; point[3] = 6;
	point[4] = -5; point[5] = 1;
	point[6] = -2; point[7] = 3.5f;
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		BezierCurve2D (hdc, VL_2D, point);
	else
		BezierCurve3D (hdc, VL_2D, point);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 4);
	else
		Polyline3D (hdc, VL_2D, point, 4);
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 4, 4, 4, VL_HEXAGONMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 4, 4, 4, VL_HEXAGONMARK);

	point[0] = 2; point[1] = 3.5f;
	point[2] = 5; point[3] = 6;
	point[4] = 8; point[5] = 3.5f;
	point[6] = 5; point[7] = 1;
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		BezierCurve2D (hdc, VL_2D, point);
	else
		BezierCurve3D (hdc, VL_2D, point);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 4);
	else
		Polyline3D (hdc, VL_2D, point, 4);
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 4, 4, 4, VL_CROSSMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 4, 4, 4, VL_CROSSMARK);

	point[0] = -8; point[1] = -3;
	point[2] = -2; point[3] = -6;
	point[4] = -2; point[5] = -1;
	point[6] = -8; point[7] = -5;
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		BezierCurve2D (hdc, VL_2D, point);
	else
		BezierCurve3D (hdc, VL_2D, point);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 4);
	else
		Polyline3D (hdc, VL_2D, point, 4);
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 4, 4, 4, VL_XMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 4, 4, 4, VL_XMARK);

	point[0] = 2; point[1] = -6;
	point[2] = 5; point[3] = -1;
	point[4] = 8; point[5] = -6;
	point[6] = 2; point[7] = -6;
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		BezierCurve2D (hdc, VL_2D, point);
	else
		BezierCurve3D (hdc, VL_2D, point);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 4);
	else
		Polyline3D (hdc, VL_2D, point, 4);
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 4, 4, 4, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 4, 4, 4, VL_DIAMONDMARK);
}

VOIDED	DrawBSplineCurve (HDC hdc, WORD type)
{
	REAL	point[] = {0, 0, 0, 4, 2, 4, 2, 0, 4, 0, 6, 4, 8, 4, 8, 0};
    REAL    knot[20] = {0, 0, 0, 1, 2, 3, 3, 3, 4, 5, 6, 6, 6};

	PenColor (hdc, VL_RED);
	TransfVertex (VL_2D, -9, 1, 0, 1, 1, point, 8);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		BSplineCurve2D (hdc, VL_2D, point, 8);
	else
		BSplineCurve3D (hdc, VL_2D, point, 8);
	TransfVertex (VL_2D, 10, 0, 0, 1, 1, point, 8);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		SplineInterp2D (hdc, VL_2D, point, 8);
	else
		SplineInterp3D (hdc, VL_2D, point, 8);
	TransfVertex (VL_2D, -10, -6, 0, 1, 1, point, 8);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);

	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		BSplineCurveClosed2D (hdc, VL_2D, point, 8);
	else
		BSplineCurveClosed3D (hdc, VL_2D, point, 8);
	TransfVertex (VL_2D, 10, 0, 0, 1, 1, point, 8);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		NURBSCurveClosed2D (hdc, VL_2D, point, 8, knot);
	else
		NURBSCurveClosed3D (hdc, VL_2D, point, 8, knot);
}

VOIDED	DrawCatmullRomCurve (HDC hdc, WORD type)
{
	REAL	point[] = {0, 0, 0, 1, 1, 1, 1, 0, 2, 0, 3, 1, 4, 1, 4, 0};

	TransfVertex (VL_2D, -8, -4, 0, 4, 8, point, 8);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		CatmullRomSpline2D (hdc, VL_2D, point, 8);
	else
		CatmullRomSpline3D (hdc, VL_2D, point, 8);
}

void    heart (HDC hdc, WORD type, BOOL showpnt)
{
    REAL point[] = {0, 0, 0.4f, 0.8f, 2, 1.4f, 2.5f, -1, 1, -2, 0, -3,
                    -1, -2, -2.5f, -1, -2, 1.4f,
                    -0.4f, 0.8f, 0, 0};
    REAL    knot[20] = {0, 0, 0, 1, 2, 3, 3, 3, 4, 5, 6, 6, 6};

	if (type == VL_TWOD) {
		PenColor (hdc, VL_RED);
		PushTransformation2D (NULL);
		Scale2D (2, 2);
		NURBSCurve2D (hdc, VL_2D, point, 11, knot);
	}
	else {
		PenColor (hdc, VL_WHITE);
		PushTransformation3D (NULL);
		Scale3D (3, 3, 3);
		NURBSCurve3D (hdc, VL_2D, point, 11, knot);
	}
	if (showpnt) {
		if (type == VL_TWOD) {
			PenColor (hdc, VL_GREEN);
			ClosedPolyline2D (hdc, VL_2D, point, 10); 
			PolyMark2D (hdc, VL_2D, point, 10, 4, 4, VL_BOXMARK);
		}
		else {
			PenColor (hdc, VL_BLUE);
			ClosedPolyline3D (hdc, VL_2D, point, 10); 
			PolyMark3D (hdc, VL_2D, point, 10, 4, 4, VL_BOXMARK);
		}
	}
	if (type == VL_TWOD)
		PopTransformation2D (NULL);
	else
		PopTransformation3D (NULL);
}

void    circle (HDC hdc, WORD type, BOOL showpnt)
{
    POINT2H p[20] = {
		{0, 1, 1}, {0.707f, 0.707f, 0.707f}, {1, 0, 1},
		{0.707f, -0.707f, 0.707f}, {0, -1, 1}, {-0.707f, -0.707f, 0.707f},
		{-1, 0, 1}, {-0.707f, 0.707f, 0.707f}, {0, 1, 1}};
    REAL    knot[20] = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4};

	if (type == VL_TWOD) {
		PenColor (hdc, VL_RED);
		PushTransformation2D (NULL);
		Scale2D (3, 3);
		QNURBSCurve2D (hdc, VL_2H, (VECTOR) p, 9, knot);
	}
	else {
		PenColor (hdc, VL_WHITE);
		PushTransformation3D (NULL);
		Scale3D (3, 3, 3);
		QNURBSCurve3D (hdc, VL_2H, (VECTOR) p, 9, knot);
	}
	if (showpnt) {
		if (type == VL_TWOD) {
			PenColor (hdc, VL_GREEN);
			ClosedPolyline2D (hdc, VL_2H, (VECTOR) p, 8);
			PolyMark2D (hdc, VL_2H, (VECTOR) p, 8, 4, 4, VL_BOXMARK);
		}
		else {
			PenColor (hdc, VL_BLUE);
			ClosedPolyline3D (hdc, VL_2H, (VECTOR) p, 8);
			PolyMark3D (hdc, VL_2H, (VECTOR) p, 8, 4, 4, VL_BOXMARK);
		}
	}
	if (type == VL_TWOD)
		PopTransformation2D (NULL);
	else
		PopTransformation3D (NULL);
}

VOIDED	DrawNURBSCurve (HDC hdc, WORD type)
{
	circle (hdc, type, TRUE);
	heart (hdc, type, TRUE);
}

VOIDED	DrawHermitCurve (HDC hdc, WORD type)
{
	REAL	point[20];

	point[0] = -6; point[1] = -1; point[2] = 6; point[3] = -1;
	point[4] = -10; point[5] = 0; point[6] = 0; point[7] = -40;
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD)
		HermitCurve2D (hdc, VL_2D, point);
	else
		HermitCurve3D (hdc, VL_2D, point);
	PenColor (hdc, VL_GREEN);	
	if (type == VL_TWOD) {
		Arrow2D (hdc, point[0], point[1], point[4], point[5],
			4, 1, 0.5f, VL_OPENARROW);
		Arrow2D (hdc, point[2], point[3], point[6], point[7],
			4, 1, 0.5f, VL_OPENARROW);
	}
	else {
		Arrow3D (hdc, point[0], point[1], 0, point[4], point[5], 0,
			4, 1, 0.5f, VL_OPENARROW);
		Arrow3D (hdc, point[2], point[3], 0, point[6], point[7], 0,
			4, 1, 0.5f, VL_OPENARROW);
	}
	PenColor (hdc, VL_WHITE);
	if (type == VL_TWOD) {
		Mark2D (hdc, point[0], point[1], 4, 4, VL_DIAMONDMARK);
		Mark2D (hdc, point[2], point[3], 4, 4, VL_DIAMONDMARK);
	}
	else {
		Mark3D (hdc, point[0], point[1], 0, 4, 4, VL_DIAMONDMARK);
		Mark3D (hdc, point[2], point[3], 0, 4, 4, VL_DIAMONDMARK);
	}
}

VOIDED	DrawNURBSCurveKnot (HDC hdc, WORD type)
{
	REAL point[] = {0, 0, 0, 4, 2, 4, 2, 0, 4, 0, 6, 4, 8, 4, 8, 0};
	REAL Knot1[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
	REAL Knot2[] = {0, 0, 0, 1, 1, 1, 4, 5, 5, 5};
	REAL Knot3[] = {0, 0, 0, 1, 1, 1, 1, 2, 3, 4, 5, 6};
	REAL Knot4[] = {0, 0, 0, 1, 3, 5, 7, 9, 10, 15};

	TransfVertex (VL_2D, -9, 1, 0, 1, 1, point, 8);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
		
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		NURBSCurve2D (hdc, VL_2D, point, 8, Knot1);
	else
		NURBSCurve3D (hdc, VL_2D, point, 8, Knot1);

	TransfVertex (VL_2D, 10, 0, 0, 1, 1, point, 8);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		NURBSCurve2D (hdc, VL_2D, point, 8, Knot2);
	else
		NURBSCurve3D (hdc, VL_2D, point, 8, Knot2);

	TransfVertex (VL_2D, -10, -6, 0, 1, 1, point, 8);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		NURBSCurve2D (hdc, VL_2D, point, 8, Knot3);
	else
		NURBSCurve3D (hdc, VL_2D, point, 8, Knot3);

	TransfVertex (VL_2D, 10, 0, 0, 1, 1, point, 8);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		NURBSCurve2D (hdc, VL_2D, point, 8, Knot4);
	else
		NURBSCurve3D (hdc, VL_2D, point, 8, Knot4);
}

VOIDED	DrawQNURBSCurve (HDC hdc, WORD type)
{
	REAL	point[] = {0, 1, 1, 0.707f, 0.707f, 0.707f, 1, 0, 1,
		0.707f, -0.707f, 0.707f, 0, -1, 1, -0.707f, -0.707f, 0.707f,
		-1, 0, 1, -0.707f, 0.707f, 0.707f, 0, 1, 1};
	REAL knot[] = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4};

	PenColor (hdc, VL_RED);
	if (type == VL_TWOD) {
		PushTransformation2D (NULL);
		Translate2D (-5, -3);
		Scale2D (3, 3);
		ClosedPolyline2D (hdc, VL_2H, point, 8);
	}
	else {
		PushTransformation3D (NULL);
		Translate3D (-5, -3, 0);
		Scale3D (3, 3, 3);
		ClosedPolyline3D (hdc, VL_2H, point, 8);
	}
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2H, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2H, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD) {
		QNURBSCurve2D (hdc, VL_2H, point, 9, knot);
		PopTransformation2D (NULL);
	}
	else {
		QNURBSCurve3D (hdc, VL_2H, point, 9, knot);
		PopTransformation3D (NULL);
	}
}

VOIDED	DrawQuadraticCurve (HDC hdc, WORD type)
{
	REAL	point[] = {0, 0, 0, 4, 2, 4, 2, 0, 4, 0, 6, 4, 8, 4, 8, 0, 0, 0};
    REAL    knot[20] = {0, 0, 1, 2, 3, 4, 5, 6, 7, 7, 7};
	UINT	i;

	PenColor (hdc, VL_RED);
	TransfVertex (VL_2D, -9, 1, 0, 1, 1, point, 9);
	if (type == VL_TWOD)
		ClosedPolyline2D (hdc, VL_2D, point, 8);
	else
		ClosedPolyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD) {
		for (i = 0; i < 7; i += 2)
			QBezierCurve2D (hdc, VL_2D, &point[i*2]);
	}
	else {
		for (i = 0; i < 7; i += 2)
			QBezierCurve3D (hdc, VL_2D, &point[i*2]);
	}
	TransfVertex (VL_2D, 10, 0, 0, 1, 1, point, 9);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		ClosedPolyline2D (hdc, VL_2D, point, 8);
	else
		ClosedPolyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		QBSplineCurve2D (hdc, VL_2D, point, 9);
	else
		QBSplineCurve3D (hdc, VL_2D, point, 9);

	TransfVertex (VL_2D, 0, -6, 0, 1, 1, point, 9);
	PenColor (hdc, VL_RED);
	if (type == VL_TWOD)
		Polyline2D (hdc, VL_2D, point, 8);
	else
		Polyline3D (hdc, VL_2D, point, 8);
	PenColor (hdc, VL_BLUE);
	if (type == VL_TWOD)
		PolyMark2D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	else
		PolyMark3D (hdc, VL_2D, point, 8, 3, 3, VL_DIAMONDMARK);
	PenColor (hdc, VL_GREEN);
	if (type == VL_TWOD)
		QNURBSCurve2D (hdc, VL_2D, point, 8, knot);
	else
		QNURBSCurve3D (hdc, VL_2D, point, 8, knot);
	DrawQNURBSCurve (hdc, type);
}

VOIDED	SelectPrimitives (HDC hdc, WORD cmd)
{
	switch (cmd) {
		case IDM_2DCURVE_BEZIER:
			ViewerName (VL_CURRENT, "Bezier Curves in 2D");
			DrawBezierCurve (hdc, VL_TWOD);
			break;
		case IDM_3DCURVE_BEZIER:
			ViewerName (VL_CURRENT, "Bezier Curves in 3D");
			DrawBezierCurve (hdc, VL_THREED);
			break;
		case IDM_2DCURVE_BSPLINE:
			ViewerName (VL_CURRENT, "B-Spline Curves in 2D");
			DrawBSplineCurve (hdc, VL_TWOD);
			break;
		case IDM_3DCURVE_BSPLINE:
			ViewerName (VL_CURRENT, "B-Spline Curves in 3D");
			DrawBSplineCurve (hdc, VL_THREED);
			break;
		case IDM_2DCURVE_HERMIT:
			ViewerName (VL_CURRENT, "2D Hermit Curves");
			DrawHermitCurve (hdc, VL_TWOD);
			break;
		case IDM_3DCURVE_HERMIT:
			ViewerName (VL_CURRENT, "3D Hermit Curves");
			DrawHermitCurve (hdc, VL_THREED);
			break;
		case IDM_2DCURVE_NURBSKNOTS:
			ViewerName (VL_CURRENT, "2D NUBRS Curves w/ Different Knots");
			DrawNURBSCurveKnot (hdc, VL_TWOD);
			break;
		case IDM_3DCURVE_NURBSKNOTS:
			ViewerName (VL_CURRENT, "3D NUBRS Curves w/ Different Knots");
			DrawNURBSCurveKnot (hdc, VL_THREED);
			break;
        case IDM_2DCURVE_CATMULLROM:
			ViewerName (VL_CURRENT, "2D Catmull-Rom Curve");
			DrawCatmullRomCurve (hdc, VL_TWOD);
			break;
        case IDM_3DCURVE_CATMULLROM:
			ViewerName (VL_CURRENT, "3D Catmull-Rom Curve");
			DrawCatmullRomCurve (hdc, VL_THREED);
			break;
		case IDM_2DCURVE_NURBS:
			ViewerName (VL_CURRENT, "2D Cubic and Quadratic NUBRS");
			DrawNURBSCurve (hdc, VL_TWOD);
			break;
		case IDM_3DCURVE_NURBS:
			ViewerName (VL_CURRENT, "3D Cubic and Quadratic NUBRS");
			DrawNURBSCurve (hdc, VL_THREED);
			break;
        case IDM_2DCURVE_QBEZIER:
			ViewerName (VL_CURRENT, "2D Quadratic Bezier Curve");
			DrawQuadraticCurve (hdc, VL_TWOD);
			break;
        case IDM_3DCURVE_QBEZIER:
			ViewerName (VL_CURRENT, "3D Quadratic Bezier Curve");
			DrawQuadraticCurve (hdc, VL_THREED);
			break;
		case IDM_3DSHAPE_ROSE:
			ViewerName (VL_CURRENT, "Roses in 3D");
			DrawRose (hdc, VL_THREED);
			break;
		case IDM_3DSHAPE_BOX:
			ViewerName (VL_CURRENT, "Rectangles in 3D");
			DrawBox (hdc, VL_THREED);
			break;
		case IDM_3DSHAPE_DISK:
			ViewerName (VL_CURRENT, "Disks in 3D");
			DrawDisk (hdc, VL_THREED);
			break;
		case IDM_3DSHAPE_NGON:
			ViewerName (VL_CURRENT, "Nside Polygons in 3D");
			DrawNgon (hdc, VL_THREED);
			break;
		case IDM_3DSHAPE_STAR:
			ViewerName (VL_CURRENT, "Nside Stars in 3D");
			DrawStar (hdc, VL_THREED);
			break;
		case IDM_3DSHAPE_FLOWER:
			DrawFlower (hdc, VL_THREED);
			ViewerName (VL_CURRENT, "Nside Flowers in 3D");
			break;
		case IDM_3DSHAPE_CHORD:
			ViewerName (VL_CURRENT, "Chords in 3D");
			DrawChord (hdc, VL_THREED);
			break;
		case IDM_3DSHAPE_PIE:
			ViewerName (VL_CURRENT, "Pies in 3D");
			DrawPie (hdc, VL_THREED);
			break;
		case IDM_3DSHAPE_RING:
			ViewerName (VL_CURRENT, "Rings in 3D");
			DrawRing (hdc, VL_THREED);
			break;
		case IDM_2DSHAPE_ROSE:
			ViewerName (VL_CURRENT, "Roses in 2D");
			DrawRose (hdc, VL_TWOD);
			break;
		case IDM_2DSHAPE_BOX:
			ViewerName (VL_CURRENT, "Rectangles in 2D");
			DrawBox (hdc, VL_TWOD);
			break;
		case IDM_2DSHAPE_DISK:
			ViewerName (VL_CURRENT, "Disks in 2D");
			DrawDisk (hdc, VL_TWOD);
			break;
		case IDM_2DSHAPE_NGON:
			ViewerName (VL_CURRENT, "Nside Polygons in 2D");
			DrawNgon (hdc, VL_TWOD);
			break;
		case IDM_2DSHAPE_STAR:
			ViewerName (VL_CURRENT, "Nside Stars in 2D");
			DrawStar (hdc, VL_TWOD);
			break;
		case IDM_2DSHAPE_FLOWER:
			ViewerName (VL_CURRENT, "Nside Flowers in 2D");
			DrawFlower (hdc, VL_TWOD);
			break;
		case IDM_2DSHAPE_CHORD:
			ViewerName (VL_CURRENT, "Chords in 2D");
			DrawChord (hdc, VL_TWOD);
			break;
		case IDM_2DSHAPE_PIE:
			ViewerName (VL_CURRENT, "Pies in 2D");
			DrawPie (hdc, VL_TWOD);
			break;
		case IDM_2DSHAPE_RING:
			ViewerName (VL_CURRENT, "Rings in 2D");
			DrawRing (hdc, VL_TWOD);
			break;
	}
}

VOIDED	Primitives2D (HDC hdc, WORD cmd)
{
	SelectPrimitives (hdc, cmd);
}

VOIDED	Primitives3D (HDC hdc, WORD cmd)
{
	PushTransformation3D (NULL);
	Scale3D (3, 3, 3);
	MarkPosition3D (hdc, 0, 0, 0, 10, VL_ORIGIN);

	PushTransformation3D (NULL);
	Translate3D (10, 8, 0);
	SelectPrimitives (hdc, cmd);
	PopTransformation3D (NULL);
	PushTransformation3D (NULL);
	Rotate3D (90, 'x');
	Translate3D (10, 8, 0);
	SelectPrimitives (hdc, cmd);
	PopTransformation3D (NULL);
	PushTransformation3D (NULL);
	Rotate3D (-90, 'y');
	Translate3D (10, 8, 0);
	SelectPrimitives (hdc, cmd);
	PopTransformation3D (NULL);
	PopTransformation3D (NULL);
}

BOOLEAN	BiArrayBox (HDC hdc, UINT row, UINT col)
{
	switch (row % 4) {
		case 0:
			SelectMaterial (VL_DEFAULT);
			break;
		case 1:
			SelectMaterial (mater1);
			break;
		case 2:
			SelectMaterial (mater2);
			break;
		case 3:
			SelectMaterial (mater3);
			break;
	}
	return (Cube (hdc, 2, 3, 4));
}

BOOLEAN	TriArrayBox (HDC hdc, UINT row, UINT col, UINT lev)
{
	switch (lev % 4) {
		case 0:
			SelectMaterial (VL_DEFAULT);
			break;
		case 1:
			SelectMaterial (mater1);
			break;
		case 2:
			SelectMaterial (mater2);
			break;
		case 3:
			SelectMaterial (mater3);
			break;
	}
	return (Cube (hdc, 2, 3, 2));
}

VOIDED	ObjectArray3D (HDC hdc, WORD func)
{
	ClearDepthBuffer (0xffff);
	switch (func) {
		case IDM_3DARRAY_RECTANGLE:
			RectangularArray3D (hdc, 4, 6, 8, 8,
				(BidimArrayProc)MakeProcInstance (BiArrayBox, hinst));
			ViewerName (VL_CURRENT, "4x6 Rectangular Object Array");
			break;
		case IDM_3DARRAY_POLAR:
			PolarArray3D (hdc, 4, 6, 10, 30, 5,
				(BidimArrayProc)MakeProcInstance (BiArrayBox, hinst));
			ViewerName (VL_CURRENT, "4x6 Polar Object Array");
			break;
		case IDM_3DARRAY_CUBIC:
			CubicArray (hdc, 4, 6, 5, 8, 8, 4,
				(TridimArrayProc)MakeProcInstance(TriArrayBox, hinst));
			ViewerName (VL_CURRENT, "4x6x5 Cubic Object Array");
			break;
		case IDM_3DARRAY_CYLINDRIC:
			CylindricArray (hdc, 4, 6, 5, 10, 30, 5, 5,
				(TridimArrayProc)MakeProcInstance (TriArrayBox, hinst));
			ViewerName (VL_CURRENT, "4x6x5 Cylindric Object Array");
			break;
		case IDM_3DARRAY_SPHERIC:
			SphericArray (hdc, 4, 6, 5, 10, 30, 30, 10, 30,
				(TridimArrayProc)MakeProcInstance (TriArrayBox, hinst));
			ViewerName (VL_CURRENT, "4x6x5 Spheric Object Array");
			break;
	}
}

BOOLEAN	RectangularArray2DProc (HDC hdc, UINT row, UINT col)
{
	UINT	index;

	index = (row * 6 + col) % 8;
	BrushColor (hdc, index);
	Ngon2D (hdc, 0, 0, 0, 1, 1, index + 3);
	return (TRUE);
}

BOOLEAN	PolarArray2DProc (HDC hdc, UINT row, UINT col)
{
	BrushColor (hdc, row * 3 + col + 1);
	switch (col % 3) {
		case 0:
			Ngon2D (hdc, 0, 0, 0, 1, 1, row + 3);
			break;
		case 1:
			Star2D (hdc, 0, 0, 0, 1, 1, row + 3);
			break;
		case 2:
			Flower2D (hdc, 0, 0, 0, 1, 1, row + 3, 2);
			break;
	}
	return (TRUE);
}

VOIDED	ObjectArray2D(HDC hdc, WORD func)
{
	switch (func) {
		case IDM_2DARRAY_RECTANGLE:
			ViewerName (VL_CURRENT, "4x6 Rectangular Object Array");
			Translate2D (-8, -5);
			RectangularArray2D (hdc, 4, 6, 3, 3,
				(BidimArrayProc)MakeProcInstance (RectangularArray2DProc, hinst));
			break;
		case IDM_2DARRAY_POLAR:
			PolarArray2D (hdc, 12, 3, 2, 30, 2,
				(BidimArrayProc)MakeProcInstance (PolarArray2DProc, hinst));
			ViewerName (VL_CURRENT, "4x6 Polar Object Array");
			break;
	}
}

BOOLEAN	USFlag (HDC hdc)
{
    UINT	i, j;
    REAL    x1, y1, x2, y2, r, width, height;

    width = 1;
    height = (REAL) 13 / 24;
    x1 = 0;
    x2 = width;
    y1 = 0;
    y2 = height / 13;
    BrushColor (hdc, VL_RED);
    PenColor (hdc, VL_RED);
    for (i = 0; i < 7; i ++) {
        Rectangle2D (hdc, x1, y1, x2, y2);
        y1 += height * 2 / 13;
        y2 += height * 2 / 13;
    }

    BrushColor (hdc, VL_WHITE);
    PenColor (hdc, VL_WHITE);
    y1 = height / 13;
    y2 = height * 2 / 13 - 0.001f;
    for (i = 0; i < 6; i ++) {
        Rectangle2D (hdc, x1, y1, x2, y2);
        y1 += height * 2 / 13;
        y2 += height * 2 / 13;
    }

    BrushColor (hdc, VL_BLUE);
    PenColor (hdc, VL_BLUE);
    x2 = 10 * width / 24;
    y1 = 6 * height / 13;
    y2 = height;
    Rectangle2D (hdc, x1, y1, x2, y2);

    BrushColor (hdc, VL_WHITE);
    PenColor (hdc, VL_WHITE);
    x2 /= 6;
    x1 = x2 / 2;
    y2 = height * 7 / 13 / 5;
	r = 0.01f;
    for (i = 0; i < 6 ; i ++) {
        y1 = height - y2 / 2;
        for (j = 0; j < 5; j ++) {
            Star2D (hdc, x1, y1, 0, r, r, 5);
            y1 -= y2;
        }
        x1 = x1 + x2;
    }
    x1 = x2;
    for (i = 0; i < 5; i ++) {
        y1 = height - y2;
        for (j = 0; j < 4; j ++) {
            Star2D (hdc, x1, y1, 0, r, r, 5);
            y1 -= y2;
        }
        x1 = x1 + x2;
    }
	return (TRUE);
}

VOIDED	ModelPrimitives (HDC hdc, int func)
{
	HBODY	hb;

	switch (func) {
		case IDM_MODEL_BOX:
			hb = NewBox (40, 30, 20);
			ViewerName (VL_CURRENT, "Block Model");
			break;
		case IDM_MODEL_FRUSTUM:
			hb = NewFrustum (30, 20, 20, 10, 10);
			ViewerName (VL_CURRENT, "Frustum Model");
			break;
		case IDM_MODEL_SPHERE:
			hb = NewSphere (20, 24);
			ViewerName (VL_CURRENT, "Sphere Model");
			break;
		case IDM_MODEL_SOCCER:
			hb = NewBall (20);
			ViewerName (VL_CURRENT, "Soccer Ball Model");
			break;
		case IDM_MODEL_PYRAMID:
			hb = NewPyramid (30, 20, 0, 0, 30);
			ViewerName (VL_CURRENT, "Pyramid Model");
			break;
		case IDM_MODEL_CYLINDER:
			hb = NewCylinder (20, 30, 16);
			ViewerName (VL_CURRENT, "Cylinder Model");
			break;
		case IDM_MODEL_CONE:
			hb = NewCone (20, 30, 16);
			ViewerName (VL_CURRENT, "Cone Model");
			break;
		case IDM_MODEL_DOME:
			hb = NewDome (20, 30, 16);
			ViewerName (VL_CURRENT, "Tube Model");
			break;
		case IDM_MODEL_TUBE:
			hb = NewTube (20, 2, 30, 16);
			ViewerName (VL_CURRENT, "Tube Model");
			break;
		case IDM_MODEL_TORUS:
			hb = NewTorus (30, 5, 16, 8);
			ViewerName (VL_CURRENT, "Torus Model");
			break;
		case IDM_MODEL_REDUCER:
			break;
		case IDM_MODEL_REVOLVE:
		{
			POINT3D	profile[10];
			UINT	i;

			StarVertex (VL_3D, 30, 0, 0, 10, 10, 5, (LPREAL)profile);
			for (i = 0; i < 10; i++) {
				profile[i].z = profile[i].y;
				profile[i].y = 0;
			}
			hb = NewRevolution (profile, 10, 12, TWOPI);
			break;
		}
		case IDM_MODEL_SWEEP:
		{
			POINT3D	profile[10], path[4];
			REAL	scale[] = {1, 1, 1, 1};

			StarVertex (VL_3D, 0, 0, 0, 10, 10, 5, (LPREAL)profile);
			
			SetPoint3D (&path[0], 0, 0, 0);
			SetPoint3D (&path[1], 0, 0, 30);
			SetPoint3D (&path[2], 0, 30, 30);
			SetPoint3D (&path[3], 0, 30, 0);
			hb = NewSweep (profile, 10, path, scale, 2, TRUE);
			break;
		}
		case IDM_MODEL_EXTRUDE:
			break;
		case IDM_MODEL_PRISM:
		{
			POINT3D	vertex[10];

			StarVertex (VL_3D, 0, 0, 0, 40, 40, 5, (LPREAL)vertex);
			hb = NewPrismoid (vertex, 10, 0.7, -5, 5, 30);
			break;
		}
	}
	if (hb) {
		BodyShade (hdc, hb);
		FreeBody (hb);
	}
}

VOIDED	BooleanOperator (HDC hdc, int func)
{
	HBODY	b1 = 0, b2 = 0, b3 = 0;

	switch (func) {
		case IDM_BOOL_UNIONBOXES:
			b1 = NewBox (20, 30, 20);
			TranslateBody (b1, 5, -5, 0);
			b2 = NewBox (30, 20, 30);
			TranslateBody (b2, -5, 5, 0);
			b3 = UniteBody (b1, b2);
			ViewerName (VL_CURRENT, "Unionize Boxes");
			break;
		case IDM_BOOL_UNIONSPHERES:
			b1 = NewSphere (30, 24);
			b2 = NewSphere (20, 24);
			TranslateBody (b2, 0, 0, 20);
			b3 = UniteBody (b1, b2);
			ViewerName (VL_CURRENT, "Unionize Spheres");
			break;
		case IDM_BOOL_INTERBOXES:
			b1 = NewBox (20, 30, 20);
			TranslateBody (b1, 5, -5, 0);
			b2 = NewBox (30, 20, 30);
			TranslateBody (b2, -5, 5, 0);
			b3 = IntersectBody (b1, b2);
			ViewerName (VL_CURRENT, "Intersect Boxes");
			break;
		case IDM_BOOL_INTERSPHERES:
			b1 = NewSphere (30, 24);
			b2 = NewSphere (20, 24);
			TranslateBody (b2, 0, 30, 0);
			b3 = IntersectBody (b1, b2);
			ViewerName (VL_CURRENT, "Intersect Spheres");
			break;
		case IDM_BOOL_DIFFBOXES:
			b1 = NewBox (30, 30, 20);
			b2 = NewBox (20, 40, 30);
			b3 = SubtractBody (b1, b2);
			FreeBody (b1);
			FreeBody (b2);
			b1 = b3;
			b2 = NewBox (40, 20, 30);
			b3 = SubtractBody (b1, b2);
			ViewerName (VL_CURRENT, "Subtract A Box From Another");
			break;
		case IDM_BOOL_DIFFSPHERES:
			b1 = NewSphere (30, 24);
			b2 = NewSphere (20, 24);
			TranslateBody (b2, 0, 30, 0);
			b3 = SubtractBody (b1, b2);
			ViewerName (VL_CURRENT, "Subtract A Sphere From Another");
			break;
	}
	BodyShade (hdc, b3);
	FreeBody (b1);
	FreeBody (b2);
	FreeBody (b3);
}

VOIDED	BodyOperation (HDC hdc, int func)
{
	HBODY	b1, b2, b3, body[3];
	POINT3D	p;
	BASE	base;
	LINE	line;
	PLANE	plane;
	UINT	i, nb;

	switch (func) {
		case IDM_TOOL_DRILL:
			b1 = NewBox (30, 30, 40);
			VSET3 (line.v, 1, -1, 0);
			VSET3 (line.p, 0, 20, 10);
			b2 = DrillBody (b1, &line, 2, ALL_WAY);
			FreeBody (b1);
			VSET3 (base.origin, 0, 20, 30);
			VSET3 (base.zvect, 1, -1, 0);
			VSET3 (base.xvect, 0, 0, 1);
			b1 = b2;
			b2 = MortiseBody (b1, &base, 3, 7, THROUGH);
			FreeBody (b1);
			VSET3 (plane.n, 0, 0, 1);
			plane.e = -20;
			nb = SplitBody (b2, &plane, body);
			FreeBody (b2);
			for (i = 0; i < nb; i++) {
				BodyShade (hdc, body[i]);
				FreeBody (body[i]);
				Translate3D (-5, 5, 0);
			}
			break;
		case IDM_TOOL_MORTISE:
			b1 = NewBox (50, 40, 30);
			VSET3 (plane.n, 1, 1, 0);
			plane.e = 0;
			SetPoint3D (&p, 25, 20, 20);
			b2 = CutThroughBody (b1, &plane, &p);
			BodyShade (hdc, b2);
			FreeBody (b1);
			FreeBody (b2);
			break;
		case IDM_TOOL_CUT:
			b1 = NewBox (50, 40, 30);
			VSET3 (line.v, 0, -1, 0);
			VSET3 (line.p, -20, 30, 20);
			b2 = DrillBody (b1, &line, 2, ALL_WAY);
			FreeBody (b1);
			VSET3 (line.p, -10, 30, 15);
			b1 = DrillBody (b2, &line, 5, ALL_WAY);
			FreeBody (b2);
			VSET3 (line.p, 10, 30, 15);
			b2 = DrillBody (b1, &line, 5, ALL_WAY);
			FreeBody (b1);
			VSET3 (line.p, 20, 30, 20);
			b1 = DrillBody (b2, &line, 5, ALL_WAY);
			FreeBody (b2);
			VSET3 (line.v, -1, 0, 0);
			VSET3 (line.p, 30, -10, 15);
			b2 = DrillBody (b1, &line, 5, ALL_WAY);
			FreeBody (b1);
			VSET3 (line.p, 30, 10, 15);
			b1 = DrillBody (b2, &line, 5, ALL_WAY);
			FreeBody (b2);

			VSET3 (plane.n, 0, 0, 1);
			plane.e = -15;

			nb = SplitBody (b1, &plane, body);
			FreeBody (b1);
			b2 = body[0];
			b1 = body[1];
			TranslateBody (b2, 0, 30, 0);
			BodyShade (hdc, b2);
			VSET3 (line.p, 0, -10, 0);
			VSET3 (line.v, 1, 0, 0);
			RotateBody (b1, &line, HALFPI);
			BodyShade (hdc, b1);
			FreeBody (b1);
			FreeBody (b2);

			break;
		case IDM_TOOL_SPLIT:
			b1 = NewBox (30, 30, 40);
			VSET3 (plane.n, 0.707, 0.707, 0);
			plane.e = 0;
			nb = SplitBody (b1, &plane, body);
			for (i = 0; i < nb; i++) {
				BodyShade (hdc, body[i]);
				FreeBody (body[i]);
				Translate3D (-5, 5, 0);
			}
			break;
		case IDM_TOOL_CHAMFER:
			b1 = NewBox (30, 30, 40);

			SetPoint3D (&p, 0, 0, 40);
			b2 = ChamferBodyFace (b1, PickBodyFace (b1, &p), 2);
			FreeBody (b1);

			SetPoint3D (&p, 15, 15, 38);
			b1 = ChamferBodyVert (b2, PickBodyVert (b2, &p), 3);
			FreeBody (b2);

			SetPoint3D (&p, 15, 15, 20);
			b2 = ChamferBodyEdge (b1, PickBodyEdge (b1, &p), 2);
			FreeBody (b1);

			BodyShade (hdc, b2);
			FreeBody (b2);
			break;
		case IDM_TOOL_SLICE:
			b1 = NewBox (50, 40, 30);
			VSET3 (line.v, 0, -1, 0);
			VSET3 (line.p, -20, 30, 20);
			b2 = DrillBody (b1, &line, 2, ALL_WAY);
			FreeBody (b1);
			VSET3 (line.p, -10, 30, 15);
			b1 = DrillBody (b2, &line, 5, ALL_WAY);
			FreeBody (b2);
			VSET3 (line.p, 10, 30, 15);
			b2 = DrillBody (b1, &line, 5, ALL_WAY);
			FreeBody (b1);
			VSET3 (line.p, 20, 30, 20);
			b1 = DrillBody (b2, &line, 5, ALL_WAY);
			FreeBody (b2);
			VSET3 (line.v, -1, 0, 0);
			VSET3 (line.p, 30, -10, 15);
			b2 = DrillBody (b1, &line, 5, ALL_WAY);
			FreeBody (b1);
			VSET3 (line.p, 30, 10, 15);
			b1 = DrillBody (b2, &line, 5, ALL_WAY);
			FreeBody (b2);
			VSET3 (plane.n, 1, 1, 0);
			plane.e = 0;
			b3 = SliceBody (b1, &plane);
			BodyShade (hdc, b3);
			FreeBody (b3);
			FreeBody (b1);

			break;
	}
}

VOIDED	ModellibDemo (HDC hdc, WORD func)
{
	BackFaceRemoval (TRUE);
	TwoSideShading (FALSE);
	ClearDepthBuffer (0xffff);
	if (func < 2020)
		ModelPrimitives (hdc, func);
	else if (func < 2030)
		BooleanOperator (hdc, func);
	else if (func < 2040)
		BodyOperation (hdc, func);
	CleanupMemory ();
}
