/*============================================================================
  Hello - Windows Programmer's Journal Volume 1 Number 6

  File      : Hello.C

  Prototype : 

  Call      : 

  Library   : 

  Example   : 

  24 April 1993 - dlcampbell
  1993 Dave Campbell WynApse
----------------------------------------------------------------------------*/
#define WINVER 0x0300
#include <windows.h>
#include "hello.h"
#include "fileo.h"
#include <string.h>

char       szAppName[] = "Hello";
HANDLE     hInst;
HWND       hWndMain;
HANDLE     hFileo;
HICON      hIcon, hIconMain;
int        InitSettings;
static     HMENU hMainMenu, hAlternateMenu;

static     char szFileName[128];
static     char szFileSpec[16];
static     char szDefExt[5];
static     WORD wFileAttr;
OFSTRUCT   of;
LPOFSTRUCT pof;

/*----------------------------------------------------------------------------
  Function Prototypes
----------------------------------------------------------------------------*/
BOOL FAR PASCAL AboutDlgProc(HWND, WORD, WORD, LONG);

BOOL FAR PASCAL HelloDlgProc(HWND, WORD, WORD, LONG);
long FAR PASCAL WndProc(HWND, unsigned, WORD, LONG);
BOOL            InitInstance(HANDLE);
BOOL FAR PASCAL TimerProc(HWND, WORD, WORD, LONG);

void DoFileOpenDlg(void);
BOOL FAR PASCAL FileOpenDlgProc(HWND, WORD, WORD, LONG);
LPSTR lstrchr (LPSTR str, char ch);

/* The main procedure. This is called by Windows when your program is run. */
/* hInstance is the handle for the current instance of the program         */
/* hPrevInst is the handle for the last instance of the program to run     */
/* CmdLine is a pointer to a string of whatever command line params came in*/
/* nCmd is the specifies the applications appearance.                      */

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInst, LPSTR CmdLine,
                                                                     int nCmd)
{
MSG     msg;								/* Message */
HWND    hWnd;                   	/* Our Window Handle */
HMENU   hMenu;

if (!hPrevInst)                         /* If no instance already exists, */
   {
	if (!InitInstance(hInstance))   	/* try initializing instance */
		return FALSE;                     /* No dice, it failed */
	}

hInst = hInstance;
	
hWndMain = CreateWindow(szAppName,              /* Window Class */
			      			"Hello World Program",  /* Window caption */
						      WS_OVERLAPPEDWINDOW,    /* Overlapped style */
						      CW_USEDEFAULT,          /* Use defaults for the */
						      CW_USEDEFAULT,          /* X & Y Positions and  */
						      CW_USEDEFAULT,          /* X & Y sizes */
						      CW_USEDEFAULT,          
						      NULL,                   /* Parent Window */
						      NULL,
						      hInstance,              /* Instance */
						      NULL);                  /* Creation Params */

if (hWndMain == NULL)
   return 0;

hFileo = LoadLibrary("FILEO.DLL");
if (hFileo < 32)
   {
   FreeLibrary(hFileo);
   MessageBox(GetFocus(),"Dynamic Link Library FILEO.DLL must be present",
                                       szAppName, MB_ICONEXCLAMATION | MB_OK);
   return 0;
   }

SetTimer(hWndMain, ID_TIMER, 500, MakeProcInstance((FARPROC)TimerProc, hInst));

hMenu = GetSystemMenu(hWndMain, FALSE);
hAlternateMenu = LoadMenu(hInstance, "Hello2");

AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);
AppendMenu(hMenu, MF_STRING,    IDM_HELPABOUT, "About...");
AppendMenu(hMenu, MF_STRING,    IDM_SETUP, "Setup...");

ShowWindow(hWndMain, nCmd);
UpdateWindow(hWndMain);
	
while (GetMessage(&msg, NULL, 0, 0))
   {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
   }
	
FreeLibrary(hFileo);
return msg.wParam;
}                                       /* int FAR PASCAL WinMain */

BOOL InitInstance (HANDLE hInstance)
{
WNDCLASS wc;                            /* Window class structure */

wc.lpszMenuName  = szAppName;
wc.lpszClassName = szAppName;
wc.hbrBackground = GetStockObject(WHITE_BRUSH);  /* White bkgrnd */
wc.hInstance     = hInstance;
wc.style         = CS_VREDRAW | CS_HREDRAW;
wc.lpfnWndProc   = (WNDPROC)WndProc;          	/* Name of proc to handle window */
wc.hCursor       = LoadCursor(NULL, IDC_ARROW);  /* Arrow Cursor */
wc.hIcon         = LoadIcon(hInstance, "WPJ");  /* Generic Icon */
wc.cbClsExtra    = 0;            	/* no extras */
wc.cbWndExtra    = 0;            	/* No Extras */

hIconMain = wc.hIcon;

return (RegisterClass(&wc)); /* Let's register that class */
}                                       /* BOOL InitInstance */

/* This is our main windows procedure. It receives messages in message, then,
depending on what the message is, we react accordingly
*/

long FAR PASCAL WndProc(HWND hWnd, unsigned message, WORD wParam, LONG lParam)
{
HDC            hdc;
PAINTSTRUCT    ps;
RECT           rect;
HMENU          hMenu;
static FARPROC lpfnHelloDlgProc, lpfnAboutDlgProc;
char           OutMsg[25];

lstrcpy(OutMsg, "");

switch (message)
   {
   case WM_CREATE :
      hMainMenu = GetMenu(hWnd);
      InitSettings = GetPrivateProfileInt("Hello", "Setup", 1, "Hello.ini");
      InitSettings = InitSettings ? IDM_HELLO : IDM_GOODBYE;
      hdc = GetDC(hWnd);
         InvalidateRect(hWnd, NULL, TRUE);
      ReleaseDC(hWnd, hdc);

/*----------------------------------------------------------------------------
  fall through to WM_PAINT...
----------------------------------------------------------------------------*/
   case WM_PAINT :
      if (IsIconic(hWnd))
         {
         BeginPaint(hWnd, &ps);

/*----------------------------------------------------------------------------
  Erase the background of the window with what's on the desktop. This is so
  the desktop bitmap will show through the transparent areas of the icon. 
----------------------------------------------------------------------------*/
         DefWindowProc(hWnd, WM_ICONERASEBKGND, (WORD)ps.hdc, 0L);

/*----------------------------------------------------------------------------
  Now draw the icon. 
----------------------------------------------------------------------------*/
         DrawIcon(ps.hdc, 0,0, hIcon);
         EndPaint(hWnd, &ps);
         }
      else
         {
         hdc = BeginPaint(hWnd,&ps);        /* returns pointer to hdc */
         GetClientRect(hWnd, &rect);
/*
  -1 tells the DrawText function to calculate length of string based on
  NULL-termination
*/
         DrawText(hdc, (InitSettings == IDM_HELLO) ? "Hello Windows!" : "Goodbye Windows!", -1,
                                   &rect, DT_SINGLELINE|DT_CENTER|DT_VCENTER);
         EndPaint(hWnd,&ps);
         }
      return 0;

   case WM_SYSCOMMAND :
      switch (wParam)
         {
         case IDM_SETUP :
            lpfnHelloDlgProc = MakeProcInstance(HelloDlgProc, hInst);
            DialogBox(hInst, "Hello", hWnd, lpfnHelloDlgProc);
            FreeProcInstance(lpfnHelloDlgProc);
            return 0;

         case IDM_HELPABOUT :
            lpfnAboutDlgProc = MakeProcInstance(AboutDlgProc, hInst);
            DialogBox(hInst, "About", hWnd, lpfnAboutDlgProc);
            FreeProcInstance(lpfnAboutDlgProc);
            return 0;
         }

      break;


   case WM_ERASEBKGND:
      if (IsIconic(hWnd))

/*----------------------------------------------------------------------------
  Don't erase the background now because we will do it at paint time when
  we paint our icon.
----------------------------------------------------------------------------*/
         return(TRUE);
      else
         return(DefWindowProc(hWnd, message, wParam, lParam));

   case WM_QUERYDRAGICON:
      return((LONG)(WORD)hIconMain);

   case WM_COMMAND :
      hMenu = GetMenu(hWnd);
      switch (wParam)
         {
      case IDM_FILENEW :
         lstrcpy(OutMsg, "IDM_FILENEW");
         break;

      case IDM_FILEOPEN :
         DoFileOpenDlg();
         lstrcpy(OutMsg, szFileName);
         break;

      case IDM_FILESAVE :
         lstrcpy(OutMsg, "IDM_FILESAVE");
         break;

      case IDM_FILESAVEAS :
         lstrcpy(OutMsg, "IDM_FILESAVEAS");
         break;

      case IDM_FILEPRINT :
         lstrcpy(OutMsg, "IDM_FILEPRINT");
         break;

      case IDM_FILEPRINTPREV :
         lstrcpy(OutMsg, "IDM_FILEPRINTPREV");
         break;

      case IDM_FILEPRINTSETUP :
         lstrcpy(OutMsg, "IDM_FILEPRINTSETUP");
         break;

      case IDM_FILEEXIT :
         lstrcpy(OutMsg, "IDM_FILEEXIT");
         break;


      case IDM_EDITUNDO :
         lstrcpy(OutMsg, "IDM_EDITUNDO");
         break;

      case IDM_EDITREPEAT :
         lstrcpy(OutMsg, "IDM_EDITREPEAT");
         break;

      case IDM_EDITCUT :
         lstrcpy(OutMsg, "IDM_EDITCUT");
         break;

      case IDM_EDITCOPY :
         lstrcpy(OutMsg, "IDM_EDITCOPY");
         break;

      case IDM_EDITPASTE :
         lstrcpy(OutMsg, "IDM_EDITPASTE");
         break;

      case IDM_EDITCLEAR :
         lstrcpy(OutMsg, "IDM_EDITCLEAR");
         break;

      case IDM_EDITPAST :
         lstrcpy(OutMsg, "IDM_EDITPAST");
         break;


      case IDM_SAMPLEDLG :
         lstrcpy(OutMsg, "IDM_SAMPLEDLG");
         break;


      case IDM_HELPINDX :
         lstrcpy(OutMsg, "IDM_HELPINDX");
         break;

      case IDM_HELPKBD :
         lstrcpy(OutMsg, "IDM_HELPKBD");
         break;

      case IDM_HELPCMDS :
         lstrcpy(OutMsg, "IDM_HELPCMDS");
         break;

      case IDM_HELPPROCS :
         lstrcpy(OutMsg, "IDM_HELPPROCS");
         break;

      case IDM_HELPUSING :
         lstrcpy(OutMsg, "IDM_HELPUSING");
         break;

      case IDM_HELPABOUT :
         lpfnAboutDlgProc = MakeProcInstance(AboutDlgProc, hInst);
         DialogBox(hInst, "About", hWnd, lpfnAboutDlgProc);
         FreeProcInstance(lpfnAboutDlgProc);
         return 0;

      case IDM_ALTERNATE :
         SetMenu(hWnd, hAlternateMenu);
         return 0;

      case IDM_ALTONE : 
         CheckMenuItem(hMenu, IDM_ALTONE, MF_CHECKED);
         CheckMenuItem(hMenu, IDM_ALTTWO, MF_UNCHECKED);
         return 0;

      case IDM_ALTTWO : 
         CheckMenuItem(hMenu, IDM_ALTTWO, MF_CHECKED);
         CheckMenuItem(hMenu, IDM_ALTONE, MF_UNCHECKED);
         return 0;

      case IDM_ALTGRAY : 
         EnableMenuItem(hMenu, IDM_ALTGRAY, MF_GRAYED);
         EnableMenuItem(hMenu, IDM_ALTUNGRAY, MF_ENABLED);
         return 0;

      case IDM_ALTUNGRAY : 
         EnableMenuItem(hMenu, IDM_ALTUNGRAY, MF_GRAYED);
         EnableMenuItem(hMenu, IDM_ALTGRAY, MF_ENABLED);
         return 0;

      case IDM_ALTRESTORE : 
         SetMenu(hWnd, hMainMenu);
         return 0;

      case WM_DESTROY :
          PostQuitMessage(0);
          return 0;
          }

   if (lstrlen(OutMsg) != 0)
      {
      MessageBox(hWnd, OutMsg, szAppName, MB_ICONEXCLAMATION | MB_OK);
      return 0;
      }

   }
return DefWindowProc(hWnd, message, wParam, lParam);
}                                       /* long FAR PASCAL WndProc */

/*============================================================================
  HelloDlgProc -- 

  File      : Hello.C

  Prototype : BOOL FAR PASCAL HelloDlgProc(HWND, WORD, WORD, LONG);

  Call      : HelloDlgProc(hDlg, message, wParam, lParam);

  Library   : 

  24 April 1993 - dlcampbell
  (c) 1993 WynApse
----------------------------------------------------------------------------*/
BOOL FAR PASCAL HelloDlgProc (HWND hDlg, WORD message, WORD wParam,
                                                                  LONG lParam)
{
switch (message)
   {
   case WM_INITDIALOG :
      CheckRadioButton(hDlg, IDM_HELLO, IDM_GOODBYE, InitSettings);
      return TRUE;

   case WM_COMMAND :
      switch (wParam)
         {
         case IDM_HELLO : 
			   WritePrivateProfileString("Hello", "Setup", "1", "Hello.ini");
            InitSettings = wParam;
            break;

         case IDM_GOODBYE : 
			   WritePrivateProfileString("Hello", "Setup", "0", "Hello.ini");
            InitSettings = wParam;
            break;

         case IDOK :
            EndDialog(hDlg, wParam);
            return TRUE;

         }
      break;

   }
return FALSE;
}                                       /* HelloDlgProc */
/*============================================================================
  AboutDlgProc

  File      : ExitWin.C

  Prototype : 

  Call      : 

  Library   : 

  24 April 1993 - dlcampbell
  (c) 1993 WynApse
----------------------------------------------------------------------------*/
BOOL FAR PASCAL AboutDlgProc (HWND hDlg, WORD message, WORD wParam,
                                                                  LONG lParam)
{
char szBuffer[100];

switch (message)
   {
   case WM_INITDIALOG :
      wsprintf(szBuffer, "%s at %s", (LPSTR) __DATE__, (LPSTR) __TIME__);
      SetWindowText(GetDlgItem(hDlg, ID_VERSION), szBuffer);
      return TRUE;

   case WM_COMMAND :
      switch (wParam)
         {
         case IDOK :
         case IDCANCEL :
            if (HIWORD(lParam) == BN_CLICKED)
               EndDialog(hDlg, wParam);
            return TRUE;

         default :
            return TRUE;
         }

   default :
      return FALSE;
   }
}                                       /* AboutDlgProc */

/*============================================================================
  DoFileOpenDlg --

  File      : Hello.C

  Prototype : void DoFileOpenDlg(void);

  Call      : DoFileOpenDlg()

  Library   : 

  24 April 1993 - dlcampbell
  (c) 1993 WynApse
----------------------------------------------------------------------------*/
void DoFileOpenDlg(void)
{
FARPROC lpfnFileOpenDlgProc = GetProcAddress(hFileo,  "FileOpenDlgProc");

(*lpfnFileOpenDlgProc)();
GetPrivateProfileString("FileO", "FileName", "NoName", szFileName, 128,
                                                                 "Hello.ini");
}                                       /* DoFileOpenDlg */

/*============================================================================
  TimerProc

  File      : Hello.C

  Prototype : 

  Call      : 

  Library   : 

  Example   : 

  6 June 1993 - dlcampbell
  (c) 1993 Campbell SoftWare
----------------------------------------------------------------------------*/
BOOL FAR PASCAL TimerProc(HWND hWnd, WORD message, WORD wParam, LONG lParam)
{
static BOOL which = 0;

if (IsIconic(hWnd))
   {
   if (which = !which)
      {
      hIcon = LoadIcon(hInst, "GO");
      InvalidateRect(hWnd, NULL, FALSE);
      SendMessage(hWndMain, WM_PAINT, NULL, NULL);
      }
   else
      {
      hIcon = LoadIcon(hInst, "SUNS");
      InvalidateRect(hWnd, NULL, FALSE);
      SendMessage(hWndMain, WM_PAINT, NULL, NULL);
      }
   }
}                                       /* TimerProc */
