#ifndef __STRCLASS__    // This insures that String class
#define __STRCLASS__    // is not defined more than once
                        // in case this header file is
                        // included by more than one
                        // source  file.
#include <iostream.h>
#include "object.h"  

extern const Class class_String;
////////////////////////////////////////////////////////////
// class String (declaration)
////////////////////////////////////////////////////////////
class String : public Object
{
private:
    char *str;      // A traditional string
    int  iSize;     // Size of str buffer
    int  *refs;     // Number of references to str
public:
                    // constructors, destructors
                    String(const String &s);
                    String(const int length=0);
                    String(const char *s);
                    ~String();

                    // operators
    String          &operator=(const String &s);
    String          &operator=(const char *s);
    friend int      operator==(const String &s1, const String &s2);
    friend int      operator!=(const String &s1, const String &s2);
    friend int      operator<(const String &s1, const String &s2);
    friend String&  operator+(const String &s1, const String &s2);
    friend ostream& operator<<(ostream &os, const String &s);
                    operator char *() const { return str; }  // cast String as char*
                              

    virtual const Class*    isA()                   const;
    virtual void            printOn(ostream& strm) const;

    ////////////////////////////////////////////////////////
    // 4/27/93 -gmv
    // Note that Smalltalk collection classes implement
    // a 'size' method to indicate the number of elements
    // in a collection (including the length of a string).
    // However, none of the classes in the standarded
    // Smalltalk collections implements a 'length' method.
    // Both are provided here as synonyms since C programmers
    // are likely to think in terms of length--from strlen.
    ////////////////////////////////////////////////////////
    unsigned                size()    const  { return iSize; }  // -gmv 4/26/93
    unsigned                length()  const  { return iSize; }
    void                    toUpper() const;                    // -gmv 4/26/93
    void                    toLower() const;                    // -gmv 4/26/93
    virtual unsigned        hash()                  const;      // -gmv 4/19/93
    virtual bool            isEqual(const Object&)  const;      // -gmv 4/19/93
    virtual int             compare(const Object&)  const;      // -gmv 4/19/93
};
#endif

