VERSION 2.00
Begin Form frmMain 
   BackColor       =   &H00FFFFFF&
   Caption         =   "Tek4010 Telnet"
   ClientHeight    =   5760
   ClientLeft      =   1830
   ClientTop       =   2190
   ClientWidth     =   7665
   ForeColor       =   &H00000000&
   Height          =   6450
   Icon            =   FRMMAIN.FRX:0000
   Left            =   1770
   LinkTopic       =   "Form1"
   ScaleHeight     =   5760
   ScaleWidth      =   7665
   Top             =   1560
   Width           =   7785
   Begin PictureBox picVT100 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00808080&
      BorderStyle     =   0  'None
      FillColor       =   &H00FFFFFF&
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Terminal"
      FontSize        =   9
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FFFFFF&
      Height          =   5760
      Left            =   0
      ScaleHeight     =   384
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   512
      TabIndex        =   1
      TabStop         =   0   'False
      Top             =   0
      Width           =   7680
   End
   Begin PictureBox picScrn 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00000000&
      ForeColor       =   &H0000FF00&
      Height          =   5760
      Left            =   0
      ScaleHeight     =   768
      ScaleMode       =   0  'User
      ScaleWidth      =   1024
      TabIndex        =   0
      Top             =   0
      Visible         =   0   'False
      Width           =   7680
   End
   Begin WinSock wskTelnet 
      Client_or_Server=   0  'Client
      Interval        =   0
      IPName          =   "139.222.128.1"
      Left            =   6960
      LicDate         =   -1320938557
      License1        =   "Mike Salmon"
      License2        =   "University of East Anglia"
      Licensed        =   -346978248
      Linger          =   0   'False
      Port            =   23
      RecvBufSize     =   0
      SendBufSize     =   0
      Top             =   5880
   End
   Begin Menu mnuFile 
      Caption         =   "File"
      Begin Menu mnuFileExit 
         Caption         =   "Exit"
      End
   End
   Begin Menu mnuConnect 
      Caption         =   "Connect"
      Begin Menu mnuConnOpen 
         Caption         =   "Open"
      End
      Begin Menu mnuConnClose 
         Caption         =   "Close"
         Enabled         =   0   'False
      End
   End
   Begin Menu mnuMode 
      Caption         =   "Mode"
      Begin Menu mnuModeVT 
         Caption         =   "VT100"
      End
      Begin Menu mnuModeTek 
         Caption         =   "Tektronix T4010"
      End
   End
   Begin Menu mnuHelp 
      Caption         =   "Help"
      Begin Menu mnuHelpAbout 
         Caption         =   "About"
      End
   End
End
Option Explicit
Dim VTx As Integer, VTy As Integer
Dim TerminalMode As Integer


Sub Form_Load ()
  picVT100.FontName = "Small Fonts"
  picVT100.FontSize = 7
  picVT100.FontBold = False
End Sub

Function HandleOOB (t$) As String
  Dim cmd, opt As Integer

  cmd = Asc(Left(t$, 1))
  opt = Asc(Mid$(t$, 2, 1))

  ' provide debug info & handle some cmds
  Select Case cmd
    Case 240
      OOBinfo "SE"
    Case 241
      OOBinfo "NOP"
    Case 242
      OOBinfo "DM"
    Case 243
      OOBinfo "BRK"
    Case 244
      OOBinfo "IP"
    Case 245
      OOBinfo "AO"
    Case 246
      OOBinfo "AYT"
    Case 247
      OOBinfo "EC"
    Case 248
      OOBinfo "EL"
    Case 249
      OOBinfo "GA"
    Case 250
      OOBinfo "SB"
    Case 251
      OOBinfo "WILL " & opt
    Case 252
      OOBinfo "WONT " & opt
    Case 253
      OOBinfo "DO " & opt
      ' always say WONT whatever the other wants
      wskTelnet.Send = Chr$(255) & Chr$(252) & Chr$(opt)
    Case 254
      OOBinfo "DONT " & opt
    Case 255
      OOBinfo "IAC"
      ' doubled up to represent 'real' 255
      TermOut (Chr$(255))
  End Select

  ' strip cmd ( & opt, if any ) for return
  If cmd >= 251 And cmd <= 254 Then
    HandleOOB = Mid$(t$, 3)
  Else
    HandleOOB = Mid$(t$, 2)
  End If
  
End Function

Sub mnuConnClose_Click ()
  wskTelnet.Open = False
'  mnuConnClose.Enabled = False
'  mnuConnOpen.Enabled = True
End Sub

Sub mnuConnOpen_Click ()
'  wskTelnet.Open = True
'  mnuConnOpen.Enabled = False
'  mnuConnClose.Enabled = True
  dlgOpen.Show
End Sub

Sub mnuFileExit_Click ()
  Unload Me
End Sub

Sub mnuHelpAbout_Click ()
  dlgAbout.Left = frmMain.Left + (frmMain.Width - dlgAbout.Width) / 2
  dlgAbout.Top = frmMain.Top + (frmMain.Height - dlgAbout.Height) / 2
  dlgAbout.Show 1
End Sub

Sub mnuModeTek_Click ()
  SwitchToTek
End Sub

Sub mnuModeVT_Click ()
  SwitchToVT100
End Sub

Sub OOBinfo (txt)
  Debug.Print txt
End Sub

Sub picVT100_KeyPress (KeyAscii As Integer)
  If KeyAscii = 13 Then
    wskTelnet.Send = Chr(13) & Chr(10)
  Else
    wskTelnet.Send = Chr$(KeyAscii)
  End If
End Sub

Sub SwitchToTek ()
  If TerminalMode <> 1 Then
    picVT100.Visible = False
    picScrn.Visible = True
    TerminalMode = 1
  End If
End Sub

Sub SwitchToVT100 ()
  If TerminalMode <> 0 Then
    picVT100.Visible = True
    picScrn.Visible = False
    TerminalMode = 0
  End If
End Sub

Sub TermOut (t$)
  ' Armed = TRUE ... just received ESC
  ' TekMode = 0 .... ASCII mode
  ' TekMode = 1 .... awaiting HiY, LoY or LoX
  ' TekMode = 2 .... awaiting LoY or LoX
  ' TekMode = 3 .... awaiting HiX or LoX
  ' TekMode = 4 .... awaiting LoX
  ' TekMode = 5 .... ready to draw vector
  Static TekMode, Armed, DarkVector As Integer
  Static HiY, LoY, HiX, LoX, Recvd As Integer
  Dim out$
  Dim i, c, x, y As Integer

  out$ = ""
  For i = 1 To Len(t$)
    c = Asc(Mid$(t$, i, 1))

    If c = 27 Then
      Armed = True
    Else
      If c < 32 Then
        If Armed Then
          Select Case c
            Case 12 ' FF
              TekClear
          End Select
        Else
          Select Case c
            Case 10 ' LF
              out$ = out$ & Chr$(13)
            Case 13 ' CR
              TekMode = 0
              out$ = out$ & Chr$(13)
            Case 29 ' GS
              TekMode = 1
              DarkVector = True
              SwitchToTek
            Case 31 ' US
              TekMode = 0
          End Select
        End If
      Else ' c>=32
        Select Case TekMode
          Case 0 ' ascii, not tek mode
            out$ = out$ + Chr$(c) ' add to ascii queue
          Case 1 ' awaiting HiY, LoY or LoX
            If c < 64 Then
              HiY = c - 32
              TekMode = 2
            ElseIf c < 96 Then
              LoX = c - 64
              TekMode = 5
            ElseIf c < 128 Then
              LoY = c - 96
              TekMode = 3
            Else
              Debug.Print c & " >= 128"
              TekMode = 1
            End If
          Case 2 ' awaiting LoY or LoX
            If c < 64 Then
              Debug.Print "Expecting LoY or LoX, got " & c
              TekMode = 1
            ElseIf c < 96 Then
              LoX = c - 64
              TekMode = 5
            ElseIf c < 128 Then
              LoY = c - 96
              TekMode = 3
            Else
              Debug.Print c & " >= 128"
              TekMode = 1
            End If
          Case 3 ' awaiting HiX or LoX
            If c < 64 Then
              HiX = c - 32
              TekMode = 4
            ElseIf c < 96 Then
              LoX = c - 64
              TekMode = 5
            ElseIf c < 128 Then
              Debug.Print "Expecting HiX or LoX, got " & c
              TekMode = 1
            Else
              Debug.Print c & " >= 128"
              TekMode = 1
            End If
          Case 4 ' awaiting LoX
            If c >= 64 And c < 96 Then
              LoX = c - 64
              TekMode = 5
            Else
              Debug.Print "Expected LoX, got " & c
              TekMode = 1
            End If
        End Select
        If TekMode = 5 Then
          x = HiX * 32 + LoX
          y = HiY * 32 + LoY
          If DarkVector Then
            MoveTo x, y
            DarkVector = False
          Else
            DrawTo x, y
          End If
          TekMode = 1
        End If
      End If
      Armed = False
    End If
  Next i
'  If out$ <> "" Then AscTermOut (out$)
  If out$ <> "" Then VTout (out$)
End Sub

Sub txtTerm_KeyPress (KeyAscii As Integer)
  If KeyAscii = 13 Then
    wskTelnet.Send = Chr(13) & Chr(10)
  Else
    wskTelnet.Send = Chr$(KeyAscii)
  End If
End Sub

Sub VTchout (ch)
  Dim rc As Integer
  Const xl = 0
  Const yb = 24 * 16 - 1
  Const xr = 80 * 6 - 1
  Const yt = 23 * 16

'  Debug.Print ch; " "; Asc(ch)
  Select Case Asc(ch)
    Case 10
      VTy = VTy + 1
'      picVT100.CurrentY = picVT100.CurrentY + 16
    Case 13
      VTx = 0
      VTy = VTy + 1
    Case Else
'      picVT100.Print ch;
      picVT100.CurrentX = VTx * 6 + 3 - picVT100.TextWidth(ch) / 2
      picVT100.CurrentY = VTy * 16
      picVT100.Print ch;
      VTx = VTx + 1
      If VTx > 79 Then
        VTx = 0
        VTy = VTy + 1
      End If
  End Select

  If VTy > 23 Then
    rc = BitBlt(picVT100.hDC, 0, 0, xr, yt, picVT100.hDC, 0, 16, SRCCOPY)
    picVT100.Line (0, yt)-(xr, yb), QBColor(8), BF
    VTy = 23
End If
End Sub

Sub VTout (strng)
  Dim i As Integer

  For i = 1 To Len(strng)
    VTchout (Mid$(strng, i, 1))
  Next i
End Sub

Sub wskTelnet_Connect (ID As Integer)
  mnuConnOpen.Enabled = False
  mnuConnClose.Enabled = True
End Sub

Sub wskTelnet_Disconnect ()
  mnuConnClose.Enabled = False
  mnuConnOpen.Enabled = True
End Sub

Sub wskTelnet_Recv ()
  Dim i, j, p As Integer
  Dim t$
  
  t$ = wskTelnet.Recv
  
  Do
    p = InStr(t$, Chr$(255))
    If p <> 0 Then
      If p > 1 Then TermOut (Left$(t$, p - 1))
      t$ = HandleOOB(Mid$(t$, p + 1))
    End If
  Loop Until p = 0
  If t$ <> "" Then TermOut (t$)

'  For i = 1 To Len(t$)
'    j = Asc(Mid$(t$, i, 1))
'    If j > 126 Then
'      TermOut ("[" & j & "]")
'    Else
'      TermOut Chr$(j)
'    End If
'  Next i

End Sub

