/***************************************************************************
  Windows Sockets FTP Client Application Support Module

  Written by:
     Santanu Lahiri              Internet: slahiri@magnus.acs.ohio-state.edu

Converted the Create Buttons calls to simulated buttons.  Added necessary
WM_PAINT code to handle displaying the buttons in the appropriate mode

Added the ComboBox "History" feature.

Cleaned up WM_PAINT code that was eating resources - Deselected created
brushes and pens before the hdc was released.

*****************************************************************************/
/*
  MODULE: WS_CHILD.C  (child window functions)
*/

#include "ws_glob.h"
#include "winftp.H"
#include <dos.h>
#include <ctype.h>

#define WS_CHILDSTYLE  WS_CHILD|WS_VISIBLE
#define LBS_STYLE      LBS_STANDARD|WS_VSCROLL|WS_CHILDSTYLE|LBS_NOTIFY|LBS_NOINTEGRALHEIGHT
#define WS_TXTSTYLE    WS_CHILDSTYLE|SS_LEFTNOWORDWRAP
#define WS_RADIOSTYLE  WS_CHILDSTYLE|BS_RADIOBUTTON
#define CBS_STYLE      WS_CHILDSTYLE|WS_VSCROLL|CBS_DROPDOWNLIST|CBS_HASSTRINGS|CBS_SORT
#define SBV_STYLE      WS_CHILDSTYLE|SBS_VERT|WS_VISIBLE
#define EDT_STYLE      WS_CHILDSTYLE|WS_BORDER|ES_AUTOHSCROLL

#define XSIZ(x) (x*nWndx)/4
#define YSIZ(x) (x*nWndy)/8

#ifdef WIN32
   #define MAXLINES 150
#else
   #define MAXLINES 100
#endif

#define STATLEN  151

char *lpStatusLines=NULL;
int nStatusPtr=0;
int nStatusScroll=1;

RECT rcMsg;

BOOL bCanMKD,bCanRMD,bCanREN,bCanDELE,bIsQVT,bIsNCSA,bIs5000,bIsDual;
BOOL bHELP=FALSE;

LPSTR lpListBox = "listbox";
LPSTR lpButton  = "button";
LPSTR lpStatic  = "static";
LPSTR lpEdit    = "edit";
LPSTR lpComboBox= "combobox";
LPSTR lpScroll  = "scrollbar";
LPSTR lpChgDir  = "ChgDir";
LPSTR lpMkDir   = "MkDir";
LPSTR lpRmDir   = "RmDir";
LPSTR lpRefresh = "Refresh";
LPSTR lpDisplay = "Display";
LPSTR lpRename  = "Rename";
LPSTR lpDelete  = "Delete";
LPSTR lpConnect = "Connect";
LPSTR lpClose   = "Close";
LPSTR lpLongDir = "LongDir";
LPSTR lpAbort   = "Abort";
LPSTR lpOptions = "Options";
LPSTR lpAbout   = "About";
LPSTR lpExit    = "Exit";
LPSTR lpToRemote= "-->";
LPSTR lpToLocal = "<--";

typedef struct
{
  LPSTR *lpBtnTxt;
  RECT rcBtn;
  int nBtnID, nStat;
  int nTxtx, nTxty;
  int nSendMsg;
  RECT rcExt;
} BTNPOS;

static RECT rcLEdt, rcREdt, rcLLst, rcRLst, rcLDir, rcLFile, rcRDir, rcRFile;

#define  BUTTONS   23

BOOL bEnabled[BUTTONS];

BTNPOS bpButton[BUTTONS] = 
{  
  &lpChgDir,  {  84,  32, 26, 13}, BTN_LCHANGE,         0, 0, 0, 0, {0, 0, 0, 0},
  &lpMkDir,   {  84,  46, 26, 13}, BTN_LMKDIR,          0, 0, 0, 0, {0, 0, 0, 0},
  &lpRmDir,   {  84,  60, 26, 13}, BTN_LRMDIR,          0, 0, 0, 0, {0, 0, 0, 0},
  &lpRefresh, {  84,  84, 26, 13}, BTN_LREFRESH,        0, 0, 0, 0, {0, 0, 0, 0},
  &lpDisplay, {  84, 107, 26, 13}, BTN_LDISPLAY,        0, 0, 0, 0, {0, 0, 0, 0},
  &lpRename,  {  84, 121, 26, 13}, BTN_LRENAME,         0, 0, 0, 0, {0, 0, 0, 0},
  &lpDelete,  {  84, 135, 26, 13}, BTN_LDELETE,         0, 0, 0, 0, {0, 0, 0, 0},
  &lpChgDir,  { 213,  32, 26, 13}, BTN_RCHANGE,         0, 0, 0, 0, {0, 0, 0, 0},
  &lpMkDir,   { 213,  46, 26, 13}, BTN_RMKDIR,          0, 0, 0, 0, {0, 0, 0, 0},
  &lpRmDir,   { 213,  60, 26, 13}, BTN_RRMDIR,          0, 0, 0, 0, {0, 0, 0, 0},
  &lpRefresh, { 213,  84, 26, 13}, BTN_RREFRESH,        0, 0, 0, 0, {0, 0, 0, 0},
  &lpDisplay, { 213, 107, 26, 13}, BTN_RDISPLAY,        0, 0, 0, 0, {0, 0, 0, 0},
  &lpRename,  { 213, 121, 26, 13}, BTN_RRENAME,         0, 0, 0, 0, {0, 0, 0, 0},
  &lpDelete,  { 213, 135, 26, 13}, BTN_RDELETE,         0, 0, 0, 0, {0, 0, 0, 0},
  &lpToLocal, { 116, 101, 14, 13}, BTN_REMOTE_TO_LOCAL, 0, 0, 0, 0, {0, 0, 0, 0},
  &lpToRemote,{ 116, 118, 14, 13}, BTN_LOCAL_TO_REMOTE, 0, 0, 0, 0, {0, 0, 0, 0},
  &lpConnect, {   4, 185, 32,  9}, BTN_CONNECT,         0, 0, 0, 0, {0, 0, 0, 0},
  &lpClose,   {  38, 185, 32,  9}, BTN_CLOSE,           0, 0, 0, 0, {0, 0, 0, 0},
  &lpLongDir, {  72, 185, 32,  9}, BTN_LONG,            0, 0, 0, 0, {0, 0, 0, 0},
  &lpAbort,   { 106, 185, 34,  9}, BTN_ABORT,           0, 0, 0, 1, {0, 0, 0, 0},
  &lpOptions, { 142, 185, 32,  9}, BTN_OPTION,          0, 0, 0, 0, {0, 0, 0, 0},
  &lpAbout,   { 176, 185, 32,  9}, BTN_ABOUT,           0, 0, 0, 0, {0, 0, 0, 0},
  &lpExit,    { 210, 185, 32,  9}, BTN_EXIT,            0, 0, 0, 0, {0, 0, 0, 0} 
};

//*********************************************************************
//  Create the Button positions array.  Compute the actual screen sizes
//  and the screen text positions based on the initial button position
//  and size.  Use the actual screen size of text to locate it in a button.
//*********************************************************************
void CreateButtonPos (HWND hWnd)
{
  HDC hdc;
  DWORD dwExt;
  RECT rc;
  int nI, cExt, cHt;

#ifdef WIN32
  SIZE sizeStr;
#endif
  
  hdc = GetDC (hWnd);
  SelectObject (hdc, GetStockObject (ANSI_VAR_FONT));   //  This allows actual size calc.

  for (nI=0; nI<sizeof (bpButton)/sizeof (BTNPOS); nI++)
  {
    bEnabled[nI] = TRUE;

#ifdef WIN32
    dwExt = GetTextExtentPoint (hdc, *bpButton[nI].lpBtnTxt, lstrlen (*bpButton[nI].lpBtnTxt), &sizeStr);
    cExt = sizeStr.cx;                 //  Length of screen text
    cHt  = sizeStr.cy;                 //  Height of screen text
#else
    dwExt = GetTextExtent (hdc, *bpButton[nI].lpBtnTxt, lstrlen (*bpButton[nI].lpBtnTxt));
    cExt = LOWORD (dwExt);                 //  Length of screen text
    cHt  = HIWORD (dwExt);                 //  Height of screen text
#endif
    
    rc = bpButton[nI].rcExt = bpButton[nI].rcBtn;  //  Copy button size for later use
    rc.right += rc.left;                   //  Compute screen right bound
    rc.bottom+= rc.top;                    //  Compute screen lower bound
    rc.left   = (rc.left   * nWndx) / 4;   //  Convert to MM_TEXT pixel count
    rc.top    = (rc.top    * nWndy) / 8;
    rc.right  = (rc.right  * nWndx) / 4;
    rc.bottom = (rc.bottom * nWndy) / 8;
    bpButton[nI].rcBtn = rc;               //  Save the computed sizes.
    bpButton[nI].nTxtx = (rc.left+rc.right-cExt)/2;  //  Compute the text position
    bpButton[nI].nTxty = (rc.top+rc.bottom-cHt)/2;   //  horizontal and vertical both.
  }
  
  rcMsg.top    = YSIZ (164);
  rcMsg.bottom = YSIZ (179);
  rcMsg.left   = XSIZ (8);
  rcMsg.right  = XSIZ (228);
  
  ReleaseDC (hWnd, hdc);    //  Done here, release resources.
}

//*********************************************************************
//*********************************************************************
void CreateListRectPos (LPRECT rcLDir, int nX, int nY, int nExt, int nH)
{
  rcLDir->left  = nX;
  rcLDir->top   = nY;
  rcLDir->right = nX+nExt-1;
  rcLDir->bottom= nY+nH-1;
}

//*********************************************************************
//*********************************************************************
int GetChildWindowID (LPARAM lParam)
{
  POINT pt;
  BOOL bFlag = (pt.y > rcLLst.bottom);

  pt.y = HIWORD (lParam);
  pt.x = LOWORD (lParam);
  if (PtInRect (&rcLFile, pt)) return LST_LFILES;
  if (PtInRect (&rcRFile, pt)) return LST_RFILES;
  if (PtInRect (&rcLDir, pt)) return LST_LDIRS;
  if (PtInRect (&rcRDir, pt)) return LST_RDIRS;
  if (PtInRect (&rcLLst, pt)) return LST_LDIRLST;
  if (PtInRect (&rcRLst, pt)) return LST_RDIRLST;
  if (PtInRect (&rcLEdt, pt)) return EDT_LFILETYPE;
  if (PtInRect (&rcREdt, pt)) return EDT_RFILETYPE;
  
  return 0;
}

//*********************************************************************
//*********************************************************************
int CreateSubWindows(HWND hParent,HWND hInst)
{
  HFONT hFont = GetStockObject (ANSI_VAR_FONT);
  int nX1, nX2, nY1, nY2, nH1, nH2, nExt;

  CreateButtonPos (hParent);  //  Create the button screen positions.
  
  nExt= XSIZ ( 28);           //  Editbox Extent
  nX1 = XSIZ ( 81);           //  Local File Type position
  nX2 = XSIZ (210);           //  Remote File Type position
  nY1 = YSIZ (  6);           //  EditBox Y position
  nH1 = YSIZ ( 10);           //  EditBox height

  CreateWindow (lpEdit, NULL, EDT_STYLE,
    nX1, nY1, nExt, nH1, hParent, (HMENU) EDT_LFILETYPE, hInst,  NULL);
  
  CreateWindow (lpEdit, NULL, EDT_STYLE,
    nX2, nY1, nExt, nH1, hParent, (HMENU) EDT_RFILETYPE, hInst,  NULL);

  CreateListRectPos (&rcLEdt,  nX1, nY1, nExt, nH1);
  CreateListRectPos (&rcREdt,  nX2, nY1, nExt, nH1);

  nExt= XSIZ (74);            //  Combo box Extent
  nX1 = XSIZ ( 7);            //  Local Dir List position
  nX2 = XSIZ (136);           //  Remote Dir List position
  nY1 = YSIZ (32);            //  Combo Box Y position
  nH1 = YSIZ (82);            //  Combo Box height when opened

  hLbxLDirLst = CreateWindow (lpComboBox, NULL, CBS_STYLE,
    nX1, nY1, nExt, nH1, hParent, (HMENU) LST_LDIRLST, hInst,  NULL);
  
  hLbxRDirLst = CreateWindow (lpComboBox, NULL, CBS_STYLE,
    nX2, nY1, nExt, nH1, hParent, (HMENU) LST_RDIRLST, hInst,  NULL);
    
  CreateListRectPos (&rcLLst,  nX1, nY1, nExt, nH1);
  CreateListRectPos (&rcRLst,  nX2, nY1, nExt, nH1);

  nY1 = YSIZ (44);            //  Directory List Y position
  nH1 = YSIZ (38);            //  Directory List Box height
  nY2 = YSIZ (84);            //  Files List Y position
  nH2 = YSIZ (65);            //  Files List Box height
  
  hLbxLDir = CreateWindow (lpListBox, NULL, LBS_STYLE,          // Local Dir list
    nX1, nY1, nExt, nH1, hParent, (HMENU) LST_LDIRS, hInst,  NULL);

  hLbxLFiles = CreateWindow (lpListBox, NULL, LBS_STYLE| LBS_EXTENDEDSEL,
    nX1, nY2, nExt, nH2, hParent, (HMENU) LST_LFILES, hInst,  NULL);    // Local Files List

  hLbxRDir = CreateWindow(lpListBox, NULL, LBS_STYLE,           // Remote Dir List
    nX2, nY1, nExt, nH1, hParent, (HMENU) LST_RDIRS, hInst,  NULL);

  hLbxRFiles = CreateWindow(lpListBox, NULL, LBS_STYLE| LBS_EXTENDEDSEL,
    nX2, nY2, nExt, nH2, hParent, (HMENU) LST_RFILES, hInst,  NULL);    //  Remote Files List

  CreateListRectPos (&rcLDir,  nX1, nY1, nExt, nH1);
  CreateListRectPos (&rcRDir,  nX2, nY1, nExt, nH1);
  CreateListRectPos (&rcLFile, nX1, nY2, nExt, nH2);
  CreateListRectPos (&rcRFile, nX2, nY2, nExt, nH2);

  CreateWindow (lpListBox, NULL, LBS_STANDARD|WS_CHILD,         // Temporary Files list
    0, 0, nExt, nH1, hParent, (HMENU) LST_DELFILES, hInst,  NULL);

  SendDlgItemMessage (hParent, EDT_LFILETYPE, WM_SETFONT, (WPARAM) hFont, (LPARAM) MAKELONG (TRUE, 0));
  SendDlgItemMessage (hParent, EDT_RFILETYPE, WM_SETFONT, (WPARAM) hFont, (LPARAM) MAKELONG (TRUE, 0));
  SendDlgItemMessage (hParent, LST_LDIRLST,   WM_SETFONT, (WPARAM) hFont, (LPARAM) MAKELONG (TRUE, 0));
  SendDlgItemMessage (hParent, LST_RDIRLST,   WM_SETFONT, (WPARAM) hFont, (LPARAM) MAKELONG (TRUE, 0));
  SendDlgItemMessage (hParent, LST_LDIRS,     WM_SETFONT, (WPARAM) hFont, (LPARAM) MAKELONG (TRUE, 0));
  SendDlgItemMessage (hParent, LST_RDIRS,     WM_SETFONT, (WPARAM) hFont, (LPARAM) MAKELONG (TRUE, 0));
  SendDlgItemMessage (hParent, LST_LFILES,    WM_SETFONT, (WPARAM) hFont, (LPARAM) MAKELONG (TRUE, 0));
  SendDlgItemMessage (hParent, LST_RFILES,    WM_SETFONT, (WPARAM) hFont, (LPARAM) MAKELONG (TRUE, 0));

  SendDlgItemMessage (hParent, LST_DELFILES,  WM_SETFONT, (WPARAM) hFont, (LPARAM) MAKELONG (TRUE, 0));

  SendDlgItemMessage (hParent, EDT_LFILETYPE, WM_SETTEXT, (WPARAM) 0, (LPARAM)(LPCSTR) szLFileType);
  SendDlgItemMessage (hParent, EDT_RFILETYPE, WM_SETTEXT, (WPARAM) 0, (LPARAM)(LPCSTR) szRFileType);

  hTxtLDir   = CreateWindow (lpStatic, NULL, WS_TXTSTYLE, XSIZ (  9), YSIZ (21), XSIZ (100), YSIZ (8), hParent, (HMENU) TXT_LDIRECTORY, hInst,  NULL);
  hTxtRDir   = CreateWindow (lpStatic, NULL, WS_TXTSTYLE, XSIZ (138), YSIZ (21), XSIZ (100), YSIZ (8), hParent, (HMENU) TXT_RDIRECTORY, hInst,  NULL);
  hScroll    = CreateWindow (lpScroll, NULL, SBV_STYLE, XSIZ(230), YSIZ(164), XSIZ(8), YSIZ(15), hParent, (HMENU) SCRLWND, hInst, NULL);
  
#define WC_TEXT(style,x)   CreateWindow (lpStatic, NULL, WS_CHILDSTYLE | style, x, YSIZ(155), XSIZ(40), YSIZ(8), hParent, (HMENU) TXT_STATUS, hInst, NULL)

  hTxtLBytes = WC_TEXT (SS_RIGHT, (XSIZ(10)));
  hTxtRBytes = WC_TEXT (SS_RIGHT, (XSIZ(198)));

#define WC_RADIO(Txt,x,ID) CreateWindow (lpButton, Txt, WS_RADIOSTYLE, x, YSIZ(154), XSIZ(39), YSIZ(9), hParent, (HMENU) ID, hInst, NULL)

  hRBascii = WC_RADIO ("ASCII",  (XSIZ ( 60)), RB_ASCII);
  hRBbinary= WC_RADIO ("Binary", (XSIZ (115)), RB_BINARY);
  hRBl8    = WC_RADIO ("L 8",    (XSIZ (160)), RB_L8);

  return(TRUE);
}

HPEN hPenDark;
HPEN hPenLight;

//*********************************************************************
//  Draw a box to give the chiseled metal appearance
//*********************************************************************
void BoxIt (HDC hDC, int left, int top, int width, int height, BOOL flag)
{
  POINT Pt;
  HPEN hPenOld;
  
  hPenOld = SelectObject (hDC, flag? hPenDark : hPenLight);
  MoveToEx (hDC, (left*nWndx)/4, ((top+height)*nWndy)/8, &Pt);
  LineTo (hDC, (left*nWndx)/4, (top*nWndy)/8);
  LineTo (hDC, ((left+width)*nWndx)/4, (top*nWndy)/8);
  if (flag) SelectObject (hDC,hPenLight); 
  else SelectObject (hDC,hPenDark);
  LineTo (hDC, ((left+width)*nWndx)/4, ((top+height)*nWndy)/8);
  LineTo (hDC, (left*nWndx)/4, ((top+height)*nWndy)/8);
  SelectObject (hDC, hPenOld);
}

//*********************************************************************
//*********************************************************************
void BoxButton (HDC hDC, int left, int top, int width, int height, BOOL bFlag, BOOL bEnable)
{
  if (!bEnable)
  {
    HBRUSH hBr = GetStockObject (DKGRAY_BRUSH);
    RECT rc;
    
    rc.top = YSIZ (top); rc.bottom = YSIZ (top+height);
    rc.left = XSIZ (left); rc.right = XSIZ (left+width);
    FillRect (hDC, &rc, hBr);
  }
  BoxIt (hDC, left, top, width, height, bFlag);
}

//*********************************************************************
//  Return the Button ID, given its index position
//  Used for sending the WM_COMMAND message
//*********************************************************************
int GetButtonID (int nBtn)
{
  return bpButton[nBtn].nBtnID;
}

//*********************************************************************
//  Return the Button ID, given its index position
//  Used for sending the WM_COMMAND message
//*********************************************************************
int GetButtonIndex (int nBtnID)
{
  int nI;
  
  for (nI=0; nI<sizeof (bpButton)/sizeof (BTNPOS); nI++)
  {
    if (bpButton[nI].nBtnID==nBtnID) return nI;
  }
  return -1;
}

//*********************************************************************
//  Return the Button SendMsg type - 0=>Post Message, 1=> SendMessage
//*********************************************************************
int GetButtonMsgStatus (int nBtn)
{
  return bpButton[nBtn].nSendMsg;
}

//*********************************************************************
//  Return the Button Status - 0=>Button is up, 1=> depressed
//*********************************************************************
int GetButtonStatus (int nBtn)
{
  return bpButton[nBtn].nStat;
}

//*********************************************************************
//  Set new button status, return the old one.
//*********************************************************************
int SetButtonStatus (int nBtn, int nStat)
{
  int nOld = bpButton[nBtn].nStat;
  
  bpButton[nBtn].nStat=nStat;  
  return nOld;
}

//*********************************************************************
//  Return the Button Status - 0=>Button is up, 1=> depressed
//*********************************************************************
BOOL GetButtonEnabledStatus (int nBtn)
{
  return bEnabled[nBtn];
}

//*********************************************************************
//  Set Btn Enabled Status, Return Prev Status - True => Was Enabled
//*********************************************************************
BOOL SetButtonEnabledStatus (int nBtnID, BOOL bFlag)
{
  BOOL bFlagOld;
  
  nBtnID = GetButtonIndex (nBtnID);
  if (nBtnID==-1) return FALSE;
  bFlagOld = bEnabled[nBtnID];
  bEnabled[nBtnID] = bFlag;
  if (bFlag!=bFlagOld) InvalidateRect (hWndMain, &bpButton[nBtnID].rcBtn, TRUE);
  return bFlagOld;
}

//*********************************************************************
//  Given x & y coords of a point, find which button it belongs to.
//  Return index if found, else return -1
//*********************************************************************
int FindButtonClicked (int nXpos, int nYpos)
{
  int nI;
  POINT pt;

  pt.x = nXpos;
  pt.y = nYpos;
  for (nI=0; nI<sizeof (bpButton)/sizeof (BTNPOS); nI++)
  {
    if (PtInRect (&bpButton[nI].rcBtn, pt)) return nI;
  }
  return -1;
}

//*********************************************************************
//  Enable all buttons
//*********************************************************************
void SetButtonsEnabled()
{
  int nI;

  for (nI=0; nI<BUTTONS; nI++) if (bEnabled[nI]!=TRUE) InvalidateRect (hWndMain, &bpButton[nI].rcBtn, TRUE);
  for (nI=0; nI<BUTTONS; nI++) bEnabled[nI] = TRUE;
}

//*********************************************************************
//  Reduce the RECT size by n Pixels along all dimensions
//*********************************************************************
RECT ReduceRect (RECT rc, int nPix)
{
  nPix >>= 1;
  rc.left   += nPix;
  rc.right  -= nPix;
  rc.top    += nPix;
  rc.bottom -= nPix;
  return rc;
}

//*********************************************************************
//*********************************************************************
void CreateButtonPens()
{
  hPenDark  = CreatePen (PS_SOLID, 1, RGB (128,128,128));
  hPenLight = CreatePen (PS_SOLID, 1, RGB (224,224,224));
}

//*********************************************************************
//*********************************************************************
void DeleteButtonPens()
{
  DeleteObject (hPenDark);
  DeleteObject (hPenLight);
}

//*********************************************************************
//  Paint a single button, with the status supplied - up/down.  Button
//  specified by its index number.
//*********************************************************************
int DoPaintButton (HWND hWnd, int nBtn, int nStat)
{
  RECT  rc   = bpButton[nBtn].rcExt;
  LPSTR lpsz = *bpButton[nBtn].lpBtnTxt;
  int   nX   = bpButton[nBtn].nTxtx + nStat;
  int   nY   = bpButton[nBtn].nTxty + nStat;
  
  HBRUSH hBrushOld;
  HBRUSH hBrush=CreateSolidBrush (RGB(192,192,192));
  HDC hDC = GetDC (hWnd);

  //*************************************************
  // Create two temporary pens to do the 3-D effect
  //*************************************************
  CreateButtonPens();

  //*************************************************
  //  Prepare the hdc for drawing the button
  //*************************************************
  hBrushOld = SelectObject (hDC, hBrush);
  SelectObject (hDC, GetStockObject (ANSI_VAR_FONT));
  SetBkColor (hDC, RGB (192, 192, 192));

  //*************************************************
  //  Draw the bounding box as 3-D, then fill inside
  //  with Gray brush, lastly draw the text
  //*************************************************
  BoxIt (hDC, rc.left, rc.top, rc.right, rc.bottom, nStat?TRUE:FALSE);
  rc = ReduceRect (bpButton[nBtn].rcBtn, 6);
  FillRect (hDC, &rc, bEnabled[nBtn]? hBrush : GetStockObject (DKGRAY_BRUSH));
  if (bEnabled[nBtn]) TextOut (hDC, nX, nY, (LPSTR) lpsz, lstrlen (lpsz));
  
  //*************************************************
  // Release the pens and brushes created this run.
  //*************************************************
  SelectObject (hDC, GetStockObject (BLACK_PEN));
  DeleteObject (SelectObject (hDC, hBrushOld));
  DeleteButtonPens();
  
  //*************************************************
  //  Final cleanup
  //*************************************************
  ReleaseDC (hWnd, hDC);
  return 0;
}

//*********************************************************************
//*********************************************************************
DoMainPaint(HWND hWnd)
{
  HDC         hDC;   // handle for the display device
  PAINTSTRUCT ps;    // holds PAINT information
  HBRUSH      hBrush, hBrushOld, hDkBrush;
  int         nI;

  memset (&ps, 0x00, sizeof(PAINTSTRUCT));
  hDC = BeginPaint (hWnd, &ps);

  hBrush = CreateSolidBrush (RGB(192,192,192));
  hPenDark = CreatePen (PS_SOLID,1,RGB(128,128,128));
  hPenLight = CreatePen (PS_SOLID,1,RGB(224,224,224));

  hBrushOld = SelectObject (hDC, hBrush);            // Save original handle
  SelectObject (hDC, GetStockObject (ANSI_VAR_FONT));   // Prepare Device Context
  SetBkColor (hDC, RGB (192,192,192));

  BoxIt (hDC,   4,2,109,149,TRUE);            //  Locals 3-D box
  BoxIt (hDC, 133,2,109,149,TRUE);            //  Remotes 3-D box

  BoxIt (hDC,   7,5,103,12,TRUE);             //  "Local" window 
  BoxIt (hDC, 136,5,103,12,TRUE);             //  "Remote" window

  BoxIt (hDC,  4,153,238,29,TRUE);            //  Outer 3-D Grouping Box
  BoxIt (hDC,  7,163,232,17,FALSE);           //  Inner 3-D FTP Message box
  
  BoxIt (hDC,  7,19,103,10,FALSE);            //  Local 3-D Current Dir box
  BoxIt (hDC,136,19,103,10,FALSE);            //  Remote 3-D Current Dir box

  TextOut (hDC, XSIZ (  9), YSIZ (8),"Local PC info",13);
  TextOut (hDC, XSIZ (138), YSIZ (8),"Remote host info",16);

  //*************************************************
  //  Now draw the 3-D effects for all the buttons
  //  and print the text for each button.
  //*************************************************
  
  FillRect (hDC, &rcMsg, hBrush);
  if (lpStatusLines!=NULL)
  {
    char *lp;
    HRGN hRgn;
    
    hRgn = CreateRectRgn (rcMsg.left, rcMsg.top, rcMsg.right, rcMsg.bottom);
    SelectClipRgn (hDC, hRgn);
    lp = lpStatusLines+(nStatusScroll*STATLEN);
    TextOut (hDC, XSIZ(9), YSIZ(172), lp, lstrlen (lp));
    if (nStatusScroll>0)
    {
      lp = lpStatusLines+((nStatusScroll-1)*STATLEN);
      TextOut (hDC, XSIZ(9), YSIZ(165), lp, lstrlen (lp));
    }
    SelectClipRgn (hDC, (HRGN) NULL);
    DeleteObject (hRgn);
  }

  hDkBrush = GetStockObject (DKGRAY_BRUSH);
  SetBkMode (hDC, TRANSPARENT);
  for (nI=0; nI<sizeof (bpButton)/sizeof (BTNPOS); nI++)
  {
    LPSTR lpsz = *bpButton[nI].lpBtnTxt;
    RECT  rc   =  bpButton[nI].rcExt;
    int   nX   =  bpButton[nI].nTxtx + bpButton[nI].nStat;
    int   nY   =  bpButton[nI].nTxty + bpButton[nI].nStat;

    BoxIt (hDC, rc.left, rc.top, rc.right, rc.bottom, bpButton[nI].nStat?TRUE:FALSE);
    rc = ReduceRect (bpButton[nI].rcBtn, 6);
    FillRect (hDC, &rc, bEnabled[nI]? hBrush : hDkBrush);
    if (bEnabled[nI]) TextOut (hDC, nX, nY, (LPSTR) lpsz, lstrlen (lpsz));
  }

  SelectObject (hDC, hBrushOld);         //  Deselect any created resources
  SelectObject (hDC, GetStockObject (BLACK_PEN));
  
// Inform Windows painting is complete
  EndPaint (hWnd, &ps);
  DeleteObject (hBrush);              //  Release all resources created
  DeleteObject (hPenLight);
  DeleteObject (hPenDark);  
  return 0;
}

//*********************************************************************
//*********************************************************************

#ifdef WIN32

int GetLocalDirForWnd(HWND hWnd)
{
  WIN32_FIND_DATA ffblk;
  HANDLE hFile;

  // get the local directory name
  // DLG_LDIRECTORY (directory name)
  getcwd (szString,180);
  SendMessage (hTxtLDir,WM_SETTEXT,0,(LPARAM)(LPCSTR) szString);
  SendDlgItemMessage (hWnd, LST_LDIRLST, CB_SELECTSTRING, (WPARAM) 0, (LPARAM)(LPCSTR) szString);

  // DLG_LDIRS      (directory list box)
  SendMessage (hLbxLDir,LB_RESETCONTENT,0,0);

  if ((hFile = FindFirstFile ("*.*", &ffblk))!=INVALID_HANDLE_VALUE)
  {
    do 
    {
      if ((ffblk.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) &&
          (lstrcmp (ffblk.cFileName, ".")!=0))
             SendMessage (hLbxLDir,LB_ADDSTRING,0,(LPARAM)(LPCSTR) ffblk.cFileName);
    }
    while (FindNextFile (hFile, &ffblk));
    FindClose (hFile);
  }

  // add drives to the list box
  SendMessage(hLbxLDir, LB_DIR, 0x4000 | 0x8000, (LPARAM) ((LPSTR) "*"));

  // DLG_LFILES     (file list box)
  SendMessage (hLbxLFiles, LB_RESETCONTENT, 0, 0);

  SendDlgItemMessage (hWndMain, EDT_LFILETYPE, WM_GETTEXT, (WPARAM) sizeof (szLFileType), (LPARAM)(LPCSTR) szLFileType);
  if (lstrlen (szLFileType)==0) 
  {
    lstrcpy (szLFileType, "*.*");
    SendDlgItemMessage (hWndMain, EDT_LFILETYPE, WM_SETTEXT, (WPARAM) 0, (LPARAM)(LPCSTR) szLFileType);
  }
  
  if ((hFile = FindFirstFile (szLFileType, &ffblk))!=INVALID_HANDLE_VALUE)
  {
    do 
    {
      if (!(ffblk.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
             SendMessage (hLbxLFiles, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) ffblk.cFileName);
    }
    while (FindNextFile (hFile, &ffblk));
    FindClose (hFile);
  }
  
  return 0;
}

#else

int GetLocalDirForWnd(HWND hWnd)
{

#ifdef _BORLANDC_
  struct ffblk ffblk;
#else
  #define ff_attrib attrib
  #define ff_name name
  #define findnext(a) _dos_findnext(a)
  struct _find_t ffblk;
#endif  
  
  int nDone;

  // get the local directory name
  // DLG_LDIRECTORY (directory name)
  getcwd (szString,180);
  SendMessage (hTxtLDir,WM_SETTEXT,0,(LPARAM)(LPCSTR) szString);
  SendDlgItemMessage (hWnd, LST_LDIRLST, CB_SELECTSTRING, (WPARAM) 0, (LPARAM)(LPCSTR) szString);
  // DLG_LDIRS      (directory list box)
  SendMessage (hLbxLDir,LB_RESETCONTENT,0,0);

#ifdef _BORLANDC_
  nDone = findfirst("*.*",&ffblk,FA_DIREC);
#else
  nDone=_dos_findfirst("*.*",_A_SUBDIR,&ffblk);
#endif  

  while (!nDone)
  {
    if (ffblk.ff_attrib & 0x10 && lstrcmp(ffblk.ff_name,".")!=0)
      SendMessage (hLbxLDir, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) ffblk.ff_name);
    nDone = findnext (&ffblk);
  }
  // add drives to the list box
  SendMessage (hLbxLDir, LB_DIR, 0x4000 | 0x8000, (LPARAM) ((LPSTR) "*"));

  // DLG_LFILES     (file list box)
  SendMessage (hLbxLFiles, LB_RESETCONTENT, 0, 0);

  SendDlgItemMessage (hWndMain, EDT_LFILETYPE, WM_GETTEXT, (WPARAM) sizeof (szLFileType), (LPARAM)(LPCSTR) szLFileType);
  if (lstrlen (szLFileType)==0) 
  {
    lstrcpy (szLFileType, "*.*");
    SendDlgItemMessage (hWndMain, EDT_LFILETYPE, WM_SETTEXT, (WPARAM) 0, (LPARAM)(LPCSTR) szLFileType);
  }
  
#ifdef _BORLANDC_
  nDone = findfirst (szLFileType, &ffblk, 0);
#else
  nDone=_dos_findfirst (szLFileType, _A_NORMAL, &ffblk);
#endif
  
  while (!nDone)  
  {
    if (!(ffblk.ff_attrib & 0x10)) 
    {
      lstrcpy (szString,ffblk.ff_name);
      strlwr (szString);
      SendMessage (hLbxLFiles, LB_ADDSTRING, 0, (LPARAM)(LPCSTR) szString);
    }
    nDone = findnext (&ffblk);
  }
  return 0;
}

#endif

//*********************************************************************
// Return a Status Line Pointer
//*********************************************************************
LPSTR GetStatusLine (int nLine)
{
  if (lpStatusLines==NULL) return NULL;
  return (LPSTR) (lpStatusLines + nLine*STATLEN);
}

//*********************************************************************
//*********************************************************************
int GetMaxStatusLines()
{
  return __min (nStatusPtr, MAXLINES);
}

//*********************************************************************
//  Display the Scroll Message
//*********************************************************************
ScrollStatus (HWND hWnd, int value) 
{
  int nNew=nStatusScroll+value;
  
  nNew = __min (__max (nNew, 1), nStatusPtr);
  if (nNew!=nStatusScroll)
  {
    nStatusScroll = nNew;
    InvalidateRect (hWnd, &rcMsg, FALSE);
  }
  return 0;
}

//*********************************************************************
//*********************************************************************
SetStatus (HWND hWnd, LPSTR lpString) 
{
  if (lpStatusLines==NULL)
  {
    (char *) lpStatusLines = (char *) GlobalAllocPtr (GHND, (MAXLINES+1) * STATLEN);
    nStatusPtr = 0;
    if (lpStatusLines==NULL) return 0;
  }
  
  if (nStatusPtr>(MAXLINES-1))
    memmove (lpStatusLines, lpStatusLines+STATLEN, (MAXLINES*STATLEN));

  if (lstrlen (lpString) > (STATLEN-1)) lpString[STATLEN-1] = '\0';
  lstrcpy (lpStatusLines+nStatusPtr*STATLEN, lpString);
  nStatusScroll = nStatusPtr;
  if (nStatusPtr<MAXLINES) nStatusPtr++;
  InvalidateRect (hWnd, &rcMsg, FALSE);
  return 0;
}

//*********************************************************************
//*********************************************************************
UnsetStatusLines()
{
  if (lpStatusLines!=NULL) GlobalFreePtr (lpStatusLines), lpStatusLines=NULL;  
  return 0;
}


