/*
  MODULE: WinFTP.C

  Based on code published in UNIX Network Programming by W. Richard Stevens

  These are common routines that will be needed by many different programs
  and should not be modified for a specific instance.
*/

#include "ws_glob.h"
#include "winftp.h"
#include <stdlib.h>

SOCKET connectTCP(char *host,char *service)
{
  return connectsock(host,service,"tcp");
}

SOCKET connectUDP(char *host,char *service)
{
  return connectsock(host,service,"udp");
}

//*********************************************************************
//*********************************************************************
GetDefaultService (LPSTR lpServ)
{
  if (lstrcmpi (lpServ, "ftp")==0) return 21;
  return -1;
}

//*********************************************************************
//*********************************************************************
GetDefaultProtocol (LPSTR lpProto)
{
  if (lstrcmpi (lpProto, "tcp")==0) return 6;
  return -1;
}

//*********************************************************************
//*********************************************************************
SOCKET connectsock (LPSTR host, LPSTR service, LPSTR protocol)
{
  struct hostent *pHostEntry;      // pointer to host entry
  struct servent *pServiceEntry;   // pointer to service entry
  struct protoent *pProtoEntry;    // pointer to protocol entry
  SOCKET sSocket;                  // socket
  int nSocketType;                 // socket type
  short nProtocol;                 // protocol value

  // initialize socket address structure
  // get service port number from name
  memset((char *)&saSockAddr,0,sizeof(saSockAddr));
  saSockAddr.sin_family=AF_INET;
  if (pServiceEntry=getservbyname(service,protocol))
    saSockAddr.sin_port=pServiceEntry->s_port;
  else if ((saSockAddr.sin_port=htons((u_short)atoi(service)))==0) 
  {
    DoPrintf ("can't get \"%s\" service entry, will use default",service);
    saSockAddr.sin_port = htons ((u_short) GetDefaultService (service));
  }
  // map host to ip, allow ip
  if (pHostEntry=gethostbyname(host))
  {
    memcpy((char *)&saSockAddr.sin_addr,pHostEntry->h_addr,pHostEntry->h_length);
  }
  else if((saSockAddr.sin_addr.s_addr=inet_addr(host))==INADDR_NONE) 
  {
    DoPrintf("can't get \"%s\" host entry",host);
    return INVALID_SOCKET;
  }
  // map protocol name to protocol number
  // use protocol to choose socket type
  if ((pProtoEntry=getprotobyname(protocol))==0) 
  {
    DoPrintf("can't get \"%s\" protocol entry, will use default", protocol);
    nProtocol = GetDefaultProtocol (protocol);
    if (nProtocol==-1)  return INVALID_SOCKET;
  }
  else 
  {
  	nProtocol = pProtoEntry->p_proto;
  }
  // DoPrintf ("Protocol is %s, value %d", protocol, pProtoEntry->p_proto);
  if (strcmp (protocol,"udp")==0)
    nSocketType = SOCK_DGRAM;
  else
    nSocketType = SOCK_STREAM;
  // allocate a socket
  sSocket = socket (AF_INET, nSocketType, nProtocol);
  if (sSocket==INVALID_SOCKET) 
  {
    ReportWSError("create socket",WSAGetLastError());
    return INVALID_SOCKET;
  }

  memcpy ((LPSTR)&saSockAddr1, (LPSTR)&saSockAddr, sizeof (saSockAddr));
  saSockAddr1.sin_port=htons(20);

  // connect the socket
  if (connect(sSocket, (struct sockaddr *)&saSockAddr, sizeof(saSockAddr))
      ==SOCKET_ERROR) {
    DoPrintf("Can't connect to %s %s service.", host, service);
    ReportWSError (NULL,WSAGetLastError());
    return INVALID_SOCKET;
  }

  DoPrintf ("Connected to %s port %u",
    inet_ntoa (saSockAddr.sin_addr), ntohs (saSockAddr.sin_port));

  return sSocket;
}

//*********************************************************************
//*********************************************************************
int sendstr (SOCKET sSocket, LPSTR pBuf, int nBytesToWrite, int *lpnRetCode)
{
  int nBytesLeft, nBytesWritten, nError;

  nBytesLeft = nBytesToWrite;
  
  // while we haven't written enough or transfer has not been aborted
  // send out the data 
  while (nBytesLeft > 0)
  {                   
    nBytesWritten = send (sSocket, pBuf, nBytesLeft,0); // write what we can
    if (nBytesWritten==SOCKET_ERROR) 
    {
      ReportWSError ("Send", nError = WSAGetLastError());
      *lpnRetCode = (bAborted) ? FTP_ABORT : FTP_ERROR;
      return nBytesWritten;  // error occured
    }
    nBytesLeft -= nBytesWritten;                 // count what we wrote
    pBuf   += nBytesWritten;                     // adjust buffer pointer
    if (bAborted)
    {
       break;
    }
  }
  if (bAborted) *lpnRetCode = FTP_ABORT;
  else *lpnRetCode = FTP_COMPLETE;
  return (nBytesToWrite - nBytesLeft);       // return count of bytes written
}

