Unit DrumMIDI;

{$F+}

(*----------------------------------------------------
   Drum.pas written by Peter Horn, July 1992 based on
   DRUM.C -- MIDI Drum Machine for Multimedia Windows
             (c) Charles Petzold, 1992
             {$R DRUMMIDI.RES}
  ----------------------------------------------------*)
Interface

USES
  WinTypes, WinProcs, Objects, OMemory, OWindows, ODialogs,
  Strings, OStdDlgs, OStdWnds,  BWCC, MidInterface, Drumfile,
  MIDIDrum, MIDIConst, MIDIIds;





CONST
  WINDOWTITLE : Pchar = 'MIDI Drum Machine [Vers. 1.00 24th December 1994] : ';
  szUntitled : PChar = '(Untitled)';
  szTitleName : PChar = '';


  TYPE


  PDRUMWindow =  ^TDRUMWindow;
  TDRUMWindow = Object (TWindow)

                    {DatenFelder}
                    Vertical, Horizontal : PScrollbar;

                    {Methods}
                    CONSTRUCTOR Init (AParent: PWindowsObject;
                    zTitel: PChar);

                    PROCEDURE   SetupWindow; VIRTUAL;
                    PROCEDURE Paint (hPaintDC: HDC; VAR PaintInfo: TPaintStruct);
                         VIRTUAL;

                    PROCEDURE NewDrum(VAR Msg: TMESSAGE);
    			virtual cm_First + cm_newdrum;
                    Procedure DrumOpen(VAR Msg: TMESSAGE);
          		virtual cm_First + cm_OPENDrum;
                    Procedure DrumSave(VAR Msg: TMESSAGE);
                        virtual cm_First + cm_SaveDrum;
                    Procedure DrumSaveASMIDI(VAR Msg: TMESSAGE);
                        virtual cm_First + cm_SaveAsMIDI;
                    Procedure WMLButtonDown (VAR Msg: TMESSAGE);
                        virtual wm_First + WM_LBUTTONDOWN;
                    Procedure WMRButtonDown (var Msg : TMessage);
                        virtual wm_First + WM_RBUTTONDOWN;
                    Procedure DoCaption (szTitleName : Pchar);
                    Function    CanClose: Boolean ;
                    Virtual;

                    {Selfdefined Methods}

                    PROCEDURE   CMShowDrum (var Msg :TMessage);
                    virtual cm_First + cm_DRUM;

                    PROCEDURE CMShowPiano (var Msg :TMessage);
                    virtual cm_First + cm_Piano;

                    PROCEDURE CMShowNotes (var Msg :TMessage);
                    virtual cm_First +  cm_Notation;

                    PROCEDURE  CMShowMIDI (var Msg :TMessage);
                    virtual cm_First +  cm_MIDITrack;

                    PROCEDURE  CMExitMIDI (var Msg :TMessage);
                    virtual cm_First +  cm_ExitMIDIMusic;

                    Procedure Running (var Msg : TMessage);
                    VIRTUAL CM_FIRST + cm_Running;
                    PROCEDURE Stopped (VAR Msg: TMESSAGE);
                    VIRTUAL CM_FIRST + cm_STOPPED;
                    PROCEDURE HScroll (VAR Msg: TMESSAGE);
          		virtual id_First + id_horizontal;
                    PROCEDURE VScroll (VAR Msg: TMESSAGE);
          		virtual id_First + id_vertical;
                    PROCEDURE WmUsernotify (VAR Msg: TMESSAGE);
                    VIRTUAL WM_FIRST +  WM_USER_NOTIFY;
                    Procedure WMUserfinished (Var Msg : TMessage);
                    VIRTUAL WM_FIRST +  WM_USER_FINISHED;
                    PROCEDURE wmusererror (VAR Msg: TMESSAGE);
               	    VIRTUAL WM_FIRST +  WM_USER_ERROR;


                    procedure CMHelp(var Message: TMessage);
                    virtual cm_First + cm_Help;
                    procedure CMHelpPiano (var Message: TMessage);
                    virtual cm_First + cm_Help_Piano;
                    procedure CMHelpDrum (var Message: TMessage);
                    virtual cm_First + cm_Help_Drum;
                    procedure CMHelpList (var Message: TMessage);
                    virtual cm_First + cm_Help_List;
                    procedure CMHelpNotes (var Message: TMessage);
                    virtual cm_First + cm_Help_Notes;
                    procedure CMHelpPianoRoll (var Message: TMessage);
                    virtual cm_First + cm_Help_PianoRoll;
                    procedure CMHelpListEdit (var Message: TMessage);
                    virtual cm_First + cm_Help_ListEdit;

                    procedure CMHelpHelp(var Message: TMessage);
                    virtual cm_First + cm_HelpHelp;
                    procedure CMQuickHelp(var Message: TMessage);
                    virtual cm_First + cm_quickHelp;
                    procedure CMIndexHelp(var Message: TMessage);
                    virtual cm_First + cm_indexHelp;
                    procedure CMKeyboardHelp(var Message: TMessage);
                    virtual cm_First + cm_KeyboardHelp;
                    procedure CMMIDIHelp(var Message: TMessage);
                    virtual cm_First + cm_midiHelp;
                    procedure CMDrumHelp(var Message: TMessage);
                    virtual cm_First + cm_drum_fileHelp;
                    procedure CMInstallHelp(var Message: TMessage);
                    virtual cm_First + cm_Install_Board;

                    PROCEDURE HelpAboutList (VAR Msg: TMESSAGE);
                    VIRTUAL cM_FIRST + cm_AboutList;
                    PROCEDURE HelpAboutDrum (VAR Msg: TMESSAGE);
                    VIRTUAL cM_FIRST + cm_AboutDrum;
                    PROCEDURE HelpAboutPiano (VAR Msg: TMESSAGE);
                    VIRTUAL cM_FIRST + cm_AboutPiano;
                    PROCEDURE HelpAboutNotes (VAR Msg: TMESSAGE);
                    VIRTUAL cM_FIRST + cm_AboutNotes;
                    PROCEDURE HelpAbout (VAR Msg: TMESSAGE);
                    VIRTUAL cM_FIRST + cm_About;

                    PROCEDURE   DummyMeldung (STR : STRING; zText1 : PChar);

  (* Destructor Done (VAR Msg: TMESSAGE); virtual; *)

  END; {TDRUMWindow}

  Implementation

  const


  szPerc : ARRAY [0..NUM_PERC] OF Pchar =
  (
  ('Acoustic Bass Drum'), ('Bass Drum 1'),     ('Side Stick'),
  ('Acoustic Snare'),     ('Hand Clap'),       ('Electric Snare'),
  ('Low Floor Tom'),      ('Closed High-Hat'), ('High Floor Tom'),
  ('Pedal High Hat'),     ('Low Tom'),         ('Open High Hat'),
  ('Low-Mid Tom'),        ('High-Mid Tom'),    ('Crash Cymbal 1'),
  ('High Tom'),           ('Ride Cymbal 1'),   ('Chinese Cymbal'),
  ('Ride Bell'),          ('Tambourine'),      ('Splash Cymbal'),
  ('Cowbell'),            ('Crash Cymbal 2'),  ('Vibraslap'),
  ('Ride Cymbal 2'),      ('High Bongo'),      ('Low Bongo'),
  ('Mute High Conga'),    ('Open High Conga'), ('Low Conga'),
  ('High Timbale'),       ('Low Timbale'),     ('High Agogo'),
  ('Low Agogo'),          ('Cabasa'),          ('Maracas'),
  ('Short Whistle'),      ('Long Whistle'),    ('Short Guiro'),
  ('Long Guiro'),         ('Claves'),          ('High Wood Block'),
  ('Low Wood Block'),     ('Mute Cuica'),      ('Open Cuica'),
  ('Mute Triangle'),      ('Open Triangle'),   ('')
  ) ;

  _MAX_FNAME = 128;
  _MAX_EXT   = 3;
  running_now : boolean = false;

VAR

        szBuffer : ARRAY [0..80 + _MAX_FNAME + _MAX_EXT] OF CHAR;
        hInst : THANDLE ;
        cxChar, cyChar : INTEGER;
        dwCurrPos : LONGINT ;
        iTempo, iIndexLast : INTEGER;
        bNeedSave : boolean;
        hwndNotify : HWND  ;


        VAR
          IndexCount, CurrentCount: INTEGER;
          newrecord : BOOLEAN;
          AboutProc: TFARPROC;

    {---------------------------------------------------------}
    { About Function                                          }
    {---------------------------------------------------------}



        FUNCTION About (Dialog: HWND; Message, WParam: WORD;
                  LParam: LONGINT): BOOL; export;
        BEGIN
          About := TRUE;
          CASE Message OF
            wm_InitDialog:
                            EXIT;
            wm_Command:
                         IF (WParam = ID_OK) OR (WParam = ID_CANCEL) THEN
                         BEGIN
                           EndDialog (Dialog, 1);
                           EXIT;
                         END;
          END;
          About := FALSE;
        END;

    PROCEDURE ErrorMessage (HWindow : hwnd; szError : Pchar; szTitleName : PChar);
     begin
     	wvsprintf (szBuffer, szError, szTitleName) ;

     	MessageBeep (MB_ICONEXCLAMATION) ;
     	MessageBox (hwindow, szBuffer, szAppName, MB_OK or MB_ICONEXCLAMATION) ;
     end;


function min(a,b: integer):integer;
begin
  if (a) < (b)
    then min := a else min  := b;
end;

function max(a,b: integer):integer;
begin
  if  b < a
    then max := a else max  := b;
end;

function minmax(a,x,b: integer):integer;
begin
  minmax := (min (max (x, a), b));
end;

    {---------------------------------------------------------}
    { DrawRectangle                                           }
    {---------------------------------------------------------}

     PROCEDURE DrawRectangle (PaintDC: HDC; X, Y : INTEGER);
     CONST L : DWORD = 1;
     VAR
        iBrush: INTEGER ;

     BEGIN

       if (drums^.dwSeqBas[y] and drums^.dwSeqExt[y] and (L shl x) <> 0)
       then iBrush := BLACK_BRUSH

       else if (drums^.dwSeqBas [y] and (L shl x) <> 0)
       then iBrush := LTGRAY_BRUSH

       else if (drums^.dwSeqExt [y] and (L shl x)  <> 0)
       then iBrush := DKGRAY_BRUSH

       else
       iBrush := WHITE_BRUSH;
       SelectObject (Paintdc, GetStockObject (iBrush) ) ;

       RECTANGLE (Paintdc, (X + 40) * cxChar, (2 * Y + 4) * cyChar DIV 4,
       		  (X + 41) * cxChar + 1, (2 * Y + 6) * cyChar DIV 4 + 1) ;



     END;     (* DrawRectangle*)


     PROCEDURE DrawNewRect (HWindow: Hwnd);
     var NewDC : HDC; x,y : Integer; NewPen : HPEN;

     begin
     NewDC := GetDC (hwindow) ;

     (*Draw rectangular grid, repeat mark, and beat marks*)


         FOR X := 0 TO  31 DO BEGIN
          FOR Y := 0 TO NUM_PERC - 1 DO BEGIN
           DrawRectangle (NewDC, X, Y) ;
           IF (X = drums^. iNumBeats - 1) THEN
             SetTextColor (newDC, RGB (0, 0, 0) )
           ELSE     SetTextColor (NewDC, RGB (255, 255, 255) ) ;

           TextOut (NewDC, (41 + X) * cxChar, 0, ':|', 2) ;

           SetTextColor (NewDC, RGB (0, 0, 0) ) ;

           IF (X MOD 4 = 0) THEN
             TextOut (NewDC, (40 + X) * cxChar, 0, '.', 1) ;
         END;
       END;

       ReleaseDC (hwindow, Newdc) ;
    end;




    {---------------------------------------------------------}
    {  TDRUMWindow Methods                                       }
    {---------------------------------------------------------}

    CONSTRUCTOR TDRUMWindow. Init (AParent: PWindowsObject;
                 zTitel: PChar);
    var i : integer;


     BEGIN
       Inherited Init (AParent, zTitel);
       With Attr do begin
         Style := Style or ws_Tiled or ws_Sysmenu or ws_visible;
         Menu := LoadMenu (HInstance, 'DRUMMENU');
         x := 0;
         y := 0;
         H := 480;
         W := 640;
       end;
       new (szTitleName);
       NEW (drums);
       drums^. iMsecPerBeat  := 100 ;
       drums^. iVelocity     :=  64 ;
       drums^. iNumBeats     :=  32 ;

       for i := 0 to NUM_PERC -1 do begin
             drums^.dwSeqBas [i] := 0 ;
             drums^.dwSeqExt [i] := 0 ;
       end;

       DrumSetParams (drums) ;

       iTempo := 50;

       Horizontal := NEW (PScrollbar, Init
          (@self, id_horizontal, 0, 418, 618, 0, TRUE) );
       Horizontal^.SetupWindow;
       Horizontal^.SetRange (1, 127);
       Horizontal^.SetPosition (drums^.iVelocity);

       Vertical := NEW (PScrollbar, Init (@self, id_vertical, 618, 0, 0, 418, FALSE) );
       Vertical^.SetupWindow;

       Vertical^.SetRange (10, 240);
       Vertical^.SetPosition (iTempo);

       cxChar := LoWord (GetDialogBaseUnits ) ;
       cyChar := HiWord (GetDialogBaseUnits ) ;

     END; {Init}

    PROCEDURE TDRUMWindow. SetupWindow;
     BEGIN
       (*
       DoCaption (szTitleName);

        *)

       Inherited SetupWindow;

     END; {SetupWindow}

    Procedure TDRUMWindow. DoCaption (szTitleName : Pchar);
    var title :Pchar;FileChars : array [0..256] of char;
    begin
     title := @FileChars;
     if StrLen(szTitleName) = 0 then StrLCat (szTitleName, szUntitled, StrLen(szUntitled)+1);
     StrLCopy (Title, WINDOWTITLE,  StrLen (WINDOWTITLE));
     StrLCat (WINDOWTITLE, szTitleName,  StrLen (WINDOWTITLE)+ StrLen (szTitleName));
     Twindow.SetCaption (Title);
    end;

     PROCEDURE TDRUMWindow. CMShowDrum (var Msg :TMessage);
     begin
       PostMessage (ParentNotify, WM_USER_SWITCHDRUM, 0, 0) ;
     end;

     PROCEDURE TDRUMWindow. CMShowPiano (var Msg :TMessage);
     begin
        PostMessage (ParentNotify, WM_USER_SWITCHPIANO, 0, 0) ;
     end;

     PROCEDURE TDRUMWindow. CMShowNotes (var Msg :TMessage);
     begin
       PostMessage (ParentNotify, WM_USER_SWITCHNOTES, 0, 0) ;
     end;

     PROCEDURE TDRUMWindow. CMShowMIDI (var Msg :TMessage);
     begin
       PostMessage (ParentNotify, WM_USER_SWITCHMIDI, 0, 0) ;
     end;

     PROCEDURE TDRUMWindow. CMExitMIDI (var Msg :TMessage);
     begin
       PostMessage (ParentNotify, WM_USER_EXIT, 0, 0) ;
     end;

     PROCEDURE TDRUMWindow. Paint (hPaintDC: HDC; VAR PaintInfo: TPaintStruct);
     	VAR i : INTEGER; X, Y : WORD; NewPen : HPEN;

         MyTExtstring : ARRAY [0..20] OF CHAR;

     BEGIN    (* TDRUMWindow.Paint *)
       SetTextAlign (hPaintDC, TA_UPDATECP) ;
       SetBkMode (hPaintDC, TRANSPARENT) ;

       (* Draw the text strings and horizontal lines   *)

       FOR i := 0 TO NUM_PERC - 1 DO BEGIN
         IF i IN  [17..18,20,22..24,39..39,41..47] THEN
           SetTextColor (hPaintDC, RGB ($A0, $90, $90) )
         ELSE
           SetTextColor (hPaintDC, RGB (0, 0 , 0) );

         MOVETO (hPaintDC, (i MOD 2) * 20 * cxChar  ,
         (2 * i + 3) * cyChar DIV 4) ;

         TextOut (hPaintDC, 0, 0, szPerc [i], StrLen (szPerc [i] ) ) ;

         dwCurrPos  := GetCurrentPosition (hPaintDC) ;

         X := LoWord (dwCurrPos) ;
         Y := HiWord (dwCurrPos) ;

         MOVETO (hPaintDC,  X + cxChar, Y + cyChar DIV 2) ;
         LINETO (hPaintDC, 39 * cxChar, Y + cyChar DIV 2) ;

       END;

       SetTextAlign (hPaintDC, 0) ;

       (* Draw rectangular grid, repeat mark, and beat marks *)

       FOR X := 0 TO  31 DO BEGIN
         FOR Y := 0 TO NUM_PERC - 1 DO BEGIN
           DrawRectangle (hPaintDC, X, Y) ;
           IF (X = drums^. iNumBeats - 1) THEN
             SetTextColor (hPaintDC, RGB (0, 0, 0) )
           ELSE     SetTextColor (hPaintDC, RGB (255, 255, 255) ) ;

           TextOut (hPaintDC, (41 + X) * cxChar, 0, ':|', 2) ;

           SetTextColor (hPaintDC, RGB (0, 0, 0) ) ;

           IF (X MOD 4 = 0) THEN
             TextOut (hPaintDC, (40 + X) * cxChar, 0, '.', 1) ;
         END;
       END;

     END;

     PROCEDURE TDRUMWindow.NewDrum (VAR Msg: TMESSAGE);
     var i : integer;
     begin
         If running_now  then DrumEndSequence (lphMidiOut, False) ;

         for i := 0 to NUM_PERC -1 do begin

             drums^.dwSeqBas [i] := 0 ;
             drums^.dwSeqExt [i] := 0 ;

         end;
         DrumSetParams (drums) ;

         DrawNewRect (HWindow);
         bNeedSave := FALSE ;
     end;

     Procedure TDRUMWindow.DrumSave(VAR Msg: TMESSAGE);

     var Dialog: PFileDialog;
         szFileName : Pchar ; FileChars : array [0..128] of char;

     begin
       If running_now then DrumEndSequence (lphMidiOut, False) ;
       new (szFileName); szFileName := @FileChars;
       StrCopy (szFileName, '*.DRM');
       Dialog := New (PFileDialog, Init
	 (@Self, PChar (sd_FileSave), szFileName));

       If (Application^.ExecDialog (Dialog) = id_Ok)
       Then
       Begin
         DrumFileWrite (drums, szFileName) ;
         if bNeedSave then (* AskAboutSave (hwnd, szTitleName)) *);
       end;

     end;

     Procedure TDRUMWindow.DrumSaveASMIDI(VAR Msg: TMESSAGE);
     var Dialog: PFileDialog; nKontrolle : integer;
         szFileName : Pchar ; FileChars : array [0..128] of char;

     begin
       If running_now  then DrumEndSequence (lphMidiOut, False) ;
       new (szFileName); szFileName := @FileChars;
       StrCopy (szFileName, '*.MID');
       Dialog := New (PFileDialog, Init
	 (@Self, PChar (sd_FileSave), szFileName));
       If (Application^.ExecDialog (Dialog) = id_Ok)
       Then
       Begin
         if bNeedSave then ;
         MIDIFileWrite   (drums, szFileName)  ;
         InvalidateRect (Hwindow, NIL, False) ;
       end;
     end;

     Procedure TDRUMWindow.DrumOpen (VAR Msg: TMESSAGE);

     var Dialog: PFileDialog;

     Var
         szErrorString : PChar; (* Opendrums : Pdrum; *) j : integer;
         szFileName : Pchar ; FileChars : array [0..128] of char;
     begin
       If running_now  then DrumEndSequence (lphMidiOut, False) ;
       new (szFileName); szFileName := @FileChars;
       StrCopy (szFileName, '*.DRM');
       Dialog := New (PFileDialog, Init
	 (@Self, PChar (sd_FileOpen), szFileName));
       If (Application^.ExecDialog (Dialog) = id_Ok)
       Then
       Begin
         if bNeedSave then ;

         new (szErrorString);
         szErrorString := DrumFileRead (Hwindow,szFileName) ;

         if drums^. iNumBeats > 32 then drums^. iNumBeats := 32;
         InvalidateRect (Hwindow, NIL, False) ;
         bNeedSave := FALSE ;
       end;
     end;

     Procedure TDRUMWindow.WMLButtonDown (var Msg : TMessage);
     CONST L : DWORD = 1;
     var NewDC : hdc;  x, y : Integer;
     begin
               NewDC := GetDC (hwindow) ;

               (* Convert mouse coordinates to grid coordinates *)

               x :=     LOWORD (Msg.lParam) div cxChar - 40 ;
               y := 	2 * HIWORD (Msg.lParam) div cyChar -  2 ;

               (* Set a new number of beats of sequence *)

               if (x > 0) and (x <= 32) and (y < 0) then

                 begin

                    SetTextColor (Newdc, RGB (255, 255, 255)) ;
                    TextOut (Newdc, (40 + drums^.iNumBeats) * cxChar, 0, ':|', 2);
                    SetTextColor (Newdc, RGB (0, 0, 0)) ;

                    if (drums^.iNumBeats mod 4 = 0) then
                         TextOut (Newdc, (40 + drums^.iNumBeats) * cxChar, 0,
                                       '.', 1) ;

                    drums^.iNumBeats := x ;

                    TextOut (Newdc, (40 + drums^.iNumBeats) * cxChar, 0, ':|', 2) ;

                    bNeedSave := TRUE ;

               end
               else
               (* Set or reset a percussion instrument beat *)

               if (x >= 0) and (x < 32) and (y >= 0) and (y < NUM_PERC) then
                 begin
                    drums^.dwSeqExt[y] := drums^.dwSeqExt[y] xor (L shl x) ;
                    DrawRectangle (Newdc, x, y) ;
                    bNeedSave := TRUE ;

                  end;
               ReleaseDC (hwindow, Newdc) ;
               DrumSetParams (drums) ;
     end;

     Procedure TDRUMWindow.WMrButtonDown (var Msg : TMessage);
     CONST L : DWORD = 1;
     var NewDC : hdc;  x, y : Integer;
     begin
          Twindow.WMLButtonDown (Msg);
          NewDC := GetDC (hwindow) ;

               (* Convert mouse coordinates to grid coordinates *)

               x :=     LOWORD (Msg.lParam) div cxChar - 40 ;
               y := 	2 * HIWORD (Msg.lParam) div cyChar -  2 ;

               (* Set a new number of beats of sequence *)

               if (x > 0) and (x <= 32) and (y < 0) then

                 begin

                    SetTextColor (Newdc, RGB (255, 255, 255)) ;
                    TextOut (Newdc, (40 + drums^.iNumBeats) * cxChar, 0, ':|', 2);
                    SetTextColor (Newdc, RGB (0, 0, 0)) ;

                    if (drums^.iNumBeats mod 4 = 0) then
                         TextOut (Newdc, (40 + drums^.iNumBeats) * cxChar, 0,
                                       '.', 1) ;

                    drums^.iNumBeats := x ;

                    TextOut (Newdc, (40 + drums^.iNumBeats) * cxChar, 0, ':|', 2) ;
                    bNeedSave := TRUE ;
                    
               end
               else
               (* Set or reset a melody instrument beat *)

               if (x >= 0) and (x < 32) and (y >= 0) and (y < NUM_PERC) then
                 begin
                    drums^.dwSeqBas[y] := drums^.dwSeqBas[y] xor (L shl x) ;

                    DrawRectangle (Newdc, x, y) ;

                    bNeedSave := TRUE ;

                  end;
               ReleaseDC (hwindow, Newdc) ;
               DrumSetParams (drums) ;
     end;

     Procedure TDRUMWindow.Running (var Msg : TMessage);

     begin


        if (not DrumBeginSequence (lphMidiOut, hWindow))
          Then
            ErrorMessage (hwindow,
              'Could not start MIDI sequence -- ',
              'MIDI Mapper device is unavailable!')
          else begin

       	       CheckMenuItem (Attr.Menu, cm_RUNNING,   MF_CHECKED);
               CheckMenuItem (Attr.Menu, cm_STOPPED, MF_UNCHECKED);
               running_now := true;
          end;
     end;

     PROCEDURE TDRUMWindow.Stopped (VAR Msg: TMESSAGE);
     var yes : Boolean;

     begin
          (*Finish at end of sequence  *)
          DrumEndSequence (lphMidiOut, False) ;
          CheckMenuItem (Attr.Menu, cm_RUNNING, MF_UNCHECKED);
          CheckMenuItem (Attr.Menu, cm_STOPPED, MF_CHECKED);
          running_now := false;
     end;

     PROCEDURE TDRUMWindow.HScroll (VAR Msg: TMESSAGE);
     var NewDC : HDC; VelocityTxt : PChar; Intxt : array [0..128] of char;
     (* Horizontal Scroll: Change the note velocity *)
     begin
         VelocityTxt := @Intxt;
          case Msg.wParam of
              SB_LINEUP:         drums^.iVelocity := drums^.iVelocity - 1 ;
              SB_LINEDOWN:       drums^.iVelocity := drums^.iVelocity + 1 ;
              SB_PAGEUP:         drums^.iVelocity := drums^.iVelocity - 8 ;
              SB_PAGEDOWN:       drums^.iVelocity := drums^.iVelocity + 8 ;
              SB_THUMBPOSITION:  drums^.iVelocity := LOWORD (Msg.lParam) ;
         end;
         drums^.iVelocity := max (1, min (drums^.iVelocity, 127)) ;
         SetScrollPos (hwindow, id_horizontal, drums^.iVelocity, TRUE) ;
         DrumSetParams (drums) ;
         NewDC := GetDC (HWindow);
         wvsprintf (VelocityTxt,'Velocity = %3d  ' ,drums^.iVelocity);
         SetTextColor (NewDC, RGB (0, 0, $FF));
         Textout (NewDC,5,400,VelocityTxt,strLen (VelocityTxt));
         ReleaseDC (HWindow, NewDC);
         bNeedSave := TRUE ;
     end;

     PROCEDURE TDRUMWindow.VScroll (VAR Msg: TMESSAGE);
     var NewDC : HDC; VelocityTxt : PChar; Intxt : array [0..128] of char;
     (* Vertical Scroll: Change the speed *)
     begin
         VelocityTxt := @Intxt;
          case Msg.wParam of
              SB_LINEUP:         drums^. iMsecPerBeat := drums^. iMsecPerBeat - 1 ;
              SB_LINEDOWN:       drums^. iMsecPerBeat := drums^. iMsecPerBeat  + 1 ;
              SB_PAGEUP:         drums^. iMsecPerBeat := drums^. iMsecPerBeat  - 8 ;
              SB_PAGEDOWN:       drums^. iMsecPerBeat := drums^. iMsecPerBeat + 8 ;
              SB_THUMBPOSITION:  drums^. iMsecPerBeat :=    LOWORD (Msg.lParam) ;
         end;
         drums^. iMsecPerBeat :=   max (10, min (drums^. iMsecPerBeat , 240)) ;
         SetScrollPos (hwindow, id_vertical, drums^. iMsecPerBeat , false) ;
         DrumSetParams (drums) ;
         NewDC := GetDC (HWindow);
         wvsprintf (VelocityTxt,'Speed (MilliSeconds/Beat) = %3d  ' ,drums^. iMsecPerBeat);
         SetTextColor (NewDC, RGB (0, 0, $FF));
         Textout (NewDC,350,400,VelocityTxt,strLen (VelocityTxt));
         ReleaseDC (HWindow, NewDC);
         bNeedSave := TRUE ;
     end;

     Procedure TDRUMWindow.WMUserfinished (Var Msg : TMessage);
     begin
               DrumEndSequence (lphMidiOut, TRUE) ;
               CheckMenuItem (Attr.Menu, cm_RUNNING,   MF_UNCHECKED) ;
               CheckMenuItem (Attr.Menu, cm_STOPPED, MF_CHECKED) ;
     end;

     PROCEDURE TDRUMWindow.wmUsernotify (VAR Msg: TMESSAGE);
     var NewDC : HDC; i, x, y: Integer;
     begin
               (* Draw the "bouncing ball" *)

               Newdc := GetDC (hwindow) ;

               SelectObject (Newdc, GetStockObject (NULL_PEN)) ;
               SelectObject (Newdc, GetStockObject (WHITE_BRUSH)) ;

               for i := 0 to 1 do begin

                    x := iIndexLast ;
                    y := NUM_PERC + 1 ;

                    Ellipse (Newdc, (x + 40) * cxChar, (2 * y + 3) * cyChar div 4,
                                  (x + 41) * cxChar, (2 * y + 5) * cyChar div 4);

                    iIndexLast := Msg.wParam ;
                    SelectObject (Newdc, GetStockObject (BLACK_BRUSH)) ;
               end;

               ReleaseDC (hwindow, Newdc) ;
     end;

     PROCEDURE TDRUMWindow. wmusererror (VAR Msg: TMESSAGE);
     const szTitlename : Pchar = 'Drum Machine';
     begin
        ErrorMessage (hWindow, 'Can''t set timer event for tempo',
                                   szTitleName) ;
     end;

     Function TDRUMWindow. CanClose;
     var reply : integer;
     begin
        show (sw_Hide);
        CanClose := false;
        if bNeedSave then begin
           Reply := MessageBox (Hwindow, 'Do you want to save?',
                 'Drum File has changed', mb_YesNO or mb_IconQuestion);
                 If reply = id_Yes
                 then canclose := false
        end
        else begin
          DrumEndSequence (lphMidiOut, TRUE) ;
          (*FreeLibrary(Lib);*)
        end;

     end;

     procedure TDRUMWindow.CMHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Index')));
     end;


     procedure TDRUMWindow.CMHelpPiano (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Piano')));
     end;


     procedure TDRUMWindow.CMHelpDrum (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Drum')));
     end;

     procedure TDRUMWindow.CMHelpNotes (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Staff')));
     end;


     procedure TDRUMWindow.CMHelpPianoRoll (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Index')));
     end;


     procedure TDRUMWindow.CMHelpListEdit (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Index')));
     end;


     procedure TDRUMWindow.CMHelpList (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Lister')));
     end;


     procedure TDRUMWindow.CMHelpHelp(var Message: TMessage);
     begin
         WinHelp(HWindow, 'WINHELP.HLP', Help_Index, 0);
     end;
     procedure TDRUMWindow.CMQuickHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Quick')));
     end;

     procedure TDRUMWindow.CMIndexHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Index')));
     end;

     procedure TDRUMWindow.CMKeyboardHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Keyboard')));
     end;

     procedure TDRUMWindow.CMMIDIHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('midi_file')));
     end;

     procedure TDRUMWindow.CMDrumHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Drum_file')));
     end;
     procedure TDRUMWindow.CMInstallHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Install')));
     end;

     PROCEDURE TDRUMWindow.HelpAboutList (VAR Msg: TMESSAGE);
        BEGIN
          AboutProc := MakeProcInstance (@About, HINSTANCE);
          DialogBox (HINSTANCE, 'AboutList', HWindow, AboutProc);
          FREEPROCINSTANCE (AboutProc);
          EXIT;
        END;
     PROCEDURE TDRUMWindow.HelpAboutDrum (VAR Msg: TMESSAGE);
     BEGIN
          AboutProc := MakeProcInstance (@About, HINSTANCE);
          DialogBox (HINSTANCE, 'AboutDrum', HWindow, AboutProc);
          FREEPROCINSTANCE (AboutProc);
          EXIT;
     END;

     PROCEDURE TDRUMWindow.HelpAboutPiano (VAR Msg: TMESSAGE);
        BEGIN
          AboutProc := MakeProcInstance (@About, HINSTANCE);
          DialogBox (HINSTANCE, 'AboutPiano', HWindow, AboutProc);
          FREEPROCINSTANCE (AboutProc);
          EXIT;
        END;

     PROCEDURE TDRUMWindow.HelpAboutNotes (VAR Msg: TMESSAGE);
        BEGIN
          AboutProc := MakeProcInstance (@About, HINSTANCE);
          DialogBox (HINSTANCE, 'AboutNotes', HWindow, AboutProc);
          FREEPROCINSTANCE (AboutProc);
          EXIT;
        END;

     PROCEDURE TDRUMWindow.HelpAbout (VAR Msg: TMESSAGE);
        BEGIN
          AboutProc := MakeProcInstance (@About, HINSTANCE);
          DialogBox (HINSTANCE, 'AboutBox', HWindow, AboutProc);
          FREEPROCINSTANCE (AboutProc);
          EXIT;
        END;

     PROCEDURE TDRUMWindow. DummyMeldung (STR : STRING; zText1: PChar);
     VAR zText2 : Pchar; S4 : ARRAY [0..20] OF CHAR;
     BEGIN
       NEW (zText2);
       StrPCopy (zText2, STR);
       MessageBox (hWindow, zText1,
       zText2, MB_OK OR MB_ICONINFORMATION);

     END; {DummyMeldung}





     BEGIN


     END. {DRUM}

