Library MIDIDLL;

{$F+}

uses WinTypes, WinProcs, Strings, MMSystem, MIDIconst;

Const
     TIMER_RES  =  5;


type

    PDRUM  = ^DRUM;
    DRUM = Record
     iMsecPerBeat : integer   ;
     iVelocity    : integer   ;
     iNumBeats    : integer   ;
     dwSeqBas     : array [0..NUM_PERC-1] of DWORD     ;
     dwSeqExt     : array [0..NUM_PERC-1] of DWORD     ;
   end;

var
    MIDI_Id : Integer;
    mydrums : pdrum;
    bSequenceGoing, bEndSequence : Bool;
    hwndNotify : HWND  ;
    iIndex : integer;
    wTimerRes, wTimerID : WORD;
    vMidiOut: PHMIDIOUT;

function min(a,b: integer):integer;
begin
  if (a) < (b)
    then min := a else min  := b;
end;

function max(a,b: integer):integer;
begin
  if  b < a
    then max := a else max  := b;
end;

function minmax(a,x,b: integer):integer;
begin
  minmax := (min (max (x, a), b));
end;

function MidiOutMessage (lphMidiOut : PHMIDIOUT; iStatus, iChannel,
                         iData1, iData2 :  integer) : DWORD; export;
var dwMessage : DWORD; idata2long : DWORD ;
begin
   idata2long := iData2;
   dwMessage  := iStatus or iChannel or (iData1 shl 8) or (iData2long shl 16) ;

   MidiOutMessage :=  midiOutShortMsg (lphMidiOut, dwMessage) ;
end;


function MidiNoteOff (lphMidiOut: PHMIDIOUT; iChannel, iOct, iNote,
                      iVel : Integer) : DWORD ; export;
begin
  MidiNoteOff := MidiOutMessage (lphMidiOut, $80, iChannel, 12 * iOct + iNote, iVel) ;
end;


function MidiNoteOn (lphMidiOut: PHMIDIOUT; iChannel, iOct, iNote,
                     iVel : Integer) : DWORD ; export;
begin
  MidiNoteOn := MidiOutMessage (lphMidiOut, $90, iChannel,
                                 12 * iOct + iNote, iVel);
end;

function MidiSetPatch (lphMidiOut: PHMIDIOUT;  iChannel,
                       iVoice : integer) : DWORD; export;
begin
  MidiSetPatch := MidiOutMessage (lphMidiOut, $C0, iChannel, iVoice, 0);
end;

function MidiPitchBend (lphMidiOut: PHMIDIOUT; iChannel,
                        iBend: Integer) : DWORD; export;

begin
  MidiPitchBend := MidiOutMessage (lphMidiOut, $E0, iChannel, iBend and $7F, iBend shr 7) ;
end;


Procedure DrumTimerFunc (wID, wMsg : WORD ; dwUser,
                                        dw1,  dw2 : DWORD); export;
  const
     L : DWORD = 1;
  var
     dwSeqExtLast, dwSeqBasLast : array [0..NUM_PERC] of DWORD;
     i : integer; PostIt : Boolean;

               (* Note Off messages for channels 9 and 15 *)
  begin
     if (iIndex <> -1) then begin

          for i := 0 to NUM_PERC-1 do begin

               if (dwSeqExtLast[i] and (L shl iIndex)<>0) then
                    MidiNoteOff (vMidiOut,9 , 2, i+11, 0);

               if (dwSeqBasLast[i] and (L shl iIndex)<>0) then
                    MidiNoteOff (vMidiOut,15 , 2, i+11, 0);
          end;
     end;

     (* Increment index and notify window to advance bouncing ball *)

     iIndex := (iIndex + 1) mod mydrums^.iNumBeats ;

     PostMessage (hwndNotify, WM_USER_NOTIFY, iIndex, timeGetTime) ;

     (*Check if ending the sequence*)

     if bEndSequence and (iIndex = 0)
        then

          PostMessage (hwndNotify, WM_USER_FINISHED, 0, 0) ;

     (*  Note On messages for channels 9 and 15 *)

     for i := 0 to NUM_PERC-1 do begin

          if (mydrums^.dwSeqExt[i] and (L shl iIndex)<>0 ) then
               MidiNoteOn (vMidiOut,9 , 2, i+11,mydrums^.iVelocity);

          if (mydrums^.dwSeqBas[i] and (L shl iIndex)<>0) then
               MidiNoteOn (vMidiOut,15 , 2, i+11,mydrums^.iVelocity);


          dwSeqExtLast[i] := mydrums^.dwSeqExt[i] ;
          dwSeqBasLast[i] := mydrums^.dwSeqBas[i] ;
     end;
          (*    // Set a new timer event  *)

     wTimerID := timeSetEvent (max (integer (wTimerRes), mydrums^.iMsecPerBeat),
                              wTimerRes, DrumTimerFunc, 0, TIME_ONESHOT) ;

     if (wTimerID = 0)  then

          PostMessage (hwndNotify, WM_USER_ERROR, 0, 0) ;

     end;


Procedure DrumEndSequence (lphMidiOut: PHMIDIOUT; bRightAway: boolean);export;

     begin

        if (bRightAway) then begin
          
          if (bSequenceGoing) then  begin

               (* stop the timer  *)
               if (wTimerID <> 0) then
                    timeKillEvent (wTimerID) ;
               timeEndPeriod (wTimerRes) ;
                                                 (* turn off all notes *)

               MidiOutMessage (lphMidiOut, $B0,  9, 123, 0) ;
               MidiOutMessage (lphMidiOut, $B0, 15, 123, 0) ;

                                                  (* close the MIDI port *)
               bSequenceGoing := FALSE ;
          end;
        end
     else
          bEndSequence := TRUE ;
  end;

Function DrumBeginSequence (lphMidiOut: PHMIDIOUT; Mywindow : HWND) : boolean; export;
var
     tc : PTIMECAPS;

  begin
     hwndNotify := Mywindow ;   (* Save window handle for notification *)
     vMidiOut:= lphMidiOut;
     DrumEndSequence (lphMidiOut, TRUE) ;   (* Stop current sequence if running    *)

     new (tc);

     {  Send Program Change messages for channels 9 and 15 }

     MidiSetPatch (lphMidiOut, 9, 0);
     MidiSetPatch (lphMidiOut, 15, 0);

     (* Begin sequence by setting a timer event *)

     timeGetDevCaps (tc, sizeof (PTIMECAPS)) ;
     wTimerRes := minmax (tc^.wPeriodMin, TIMER_RES, tc^.wPeriodMax) ;
     timeBeginPeriod (wTimerRes) ;
     bEndSequence := FALSE ;
     wTimerID := timeSetEvent (max (integer(wTimerRes), mydrums^.iMsecPerBeat),
                              wTimerRes, DrumTimerFunc, 0, TIME_ONESHOT) ;

     if (wTimerID = 0)
       then begin
          timeEndPeriod (wTimerRes) ;
          DrumBeginSequence := false;
          exit;
       end;

     iIndex := -1 ;

     bSequenceGoing := TRUE ;
     DrumBeginSequence := true
end;

Procedure  DrumSetParams     (xdrums : PDRUM) ; export;
var i : Integer;
begin
   for i := 0 to NUM_PERC-1 do begin
         mydrums^.dwSeqExt[i] := xdrums^.dwSeqExt[i];
         mydrums^.dwSeqBas[i] := xdrums^.dwSeqBas[i];
     end;
   mydrums^. iMsecPerBeat  := xdrums^. iMsecPerBeat ;
   mydrums^. iVelocity     := xdrums^. iVelocity;
   mydrums^. iNumBeats     := xdrums^. iNumBeats;

end;

Procedure Devices (Devicenumber : Word; var MyDevice: PMidiOutCaps); export;

var iNumDevs : word;

begin
    MIDI_ID := Devicenumber;
    iNumDevs := midiOutGetDevCaps(Midi_ID, MyDevice, sizeOf (MyDevice^));
end;

Procedure  StartMIDI (Hwindow :Hwnd; var lphMidiOut: PHMIDIOUT); export;

var ErrorNo, iNumDevs : word; ErrorM: PChar; MessArray : array [0..128] of char;

    hWaveOut: PHWaveOut;

    lpdwVolume: PLongint;

begin


       Midi_ID := 0;

       {MIDI_ID = -1  = Microsword (MIDIMAPPER);
                =  0  = SB Pro 2 Synth
                =  1  = SB MIDI Out }

       lphMIDIOut^ := mm_MOM_Open;
       ErrorNo := midiOutOpen (@lphMidiOut, MIDI_ID, 0, 0, 0);
       If (ErrorNo <> 0) then begin
         New (ErrorM);
         case Error of
            mmsyserr_Error  : StrCopy (ErrorM, 'Unspecified Error');
            mmsyserr_BadDeviceID : StrCopy (ErrorM, 'Device ID out of range');
            mmsyserr_NotEnabled : StrCopy (ErrorM, 'Driver failed enable');
            mmsyserr_Allocated  : StrCopy (ErrorM, 'MIDI already allocated');
            mmsyserr_InvalHandle : StrCopy (ErrorM, 'Device handle is invalid');
            mmsyserr_NoDriver   : StrCopy (ErrorM, 'No device driver present');
            mmsyserr_NoMem  : StrCopy (ErrorM, 'Memory allocation error');
            mmsyserr_NotSupported : StrCopy (ErrorM, 'Function isn''t supported');
            mmsyserr_BadErrNum   : StrCopy (ErrorM, 'Error value out of range');
            mmsyserr_InvalFlag : StrCopy (ErrorM, 'Invalid flag passed');
            mmsyserr_InvalParam : StrCopy (ErrorM, 'Invalid parameter passed');
          else  StrCopy (ErrorM, 'Unspecified Error and out of range');
          end;
          MessageBox(HWindow, ErrorM,
             'MIDI Error', MB_OK or MB_IconHand);

      end;

      MidiSetPatch (lphMidiOut,1,0);
     end;

     Procedure  EndMIDI (lphMIDIOut: PHMIDIOUT) ; export;
     var i : Integer;
     begin
        {Turn off all notes in Channel 1 }

        for i := 0 to 15 do
            MidiOutMessage (lphMidiOut, $B0, i, 123, 0) ;
        midiOutClose (lphMidiOut) ;


     end;

exports
     MidiOutMessage index 1,
     MidiNoteOff index 2,
     MidiNoteOn index 3,
     MidiSetPatch index 4,
     MidiPitchBend index 5,
     StartMIDI index 6,
     EndMIDI index 7,
     DrumTimerFunc index 8,
     DrumEndSequence index 9,
     DrumBeginSequence index 10,
     DrumSetParams index 11,
     Devices index 12;

begin
  bSequenceGoing := false;
  bEndSequence   := true;
  new (mydrums);
end.

     
