UNIT MIDInterface;

{$F+}

interface

uses WinTypes, WinProcs, Strings, MMSystem, midiids, MIDIConst;

type
   DWORD = Longint;

    PDRUM  = ^DRUM;
    DRUM = Record 
     iMsecPerBeat : integer   ;
     iVelocity 	  : integer   ;
     iNumBeats 	  : integer   ;
     dwSeqBas     : array [0..NUM_PERC-1] of DWORD     ;
     dwSeqExt 	  : array [0..NUM_PERC-1] of DWORD     ;
   end;  

var drums : pdrum;


function MidiOutMessage (lphMidiOut : PHMIDIOUT; iStatus, iChannel,
                        iData1, iData2 :  integer) : DWORD;far;

function MidiNoteOff (lphMidiOut: PHMIDIOUT; iChannel, iOct, iNote, iVel : Integer) : DWORD ;
function MidiNoteOn (lphMidiOut: PHMIDIOUT; iChannel, iOct, iNote, iVel : Integer) : DWORD ;
function MidiSetPatch (lphMidiOut: PHMIDIOUT;  iChannel, iVoice : integer) : DWORD;
function MidiPitchBend (lphMidiOut: PHMIDIOUT; iChannel, iBend: Integer) : DWORD;
Procedure  StartMIDI(Hwindow :Hwnd;var lphMidiOut: PHMIDIOUT);far;
Procedure  EndMIDI (lphMidiOut: PHMIDIOUT);far;
Procedure DrumTimerFunc (wID, wMsg : WORD ; dwUser,
                           dw1,  dw2 : DWORD);
Procedure  DrumSetParams     (drums : PDRUM) ;
Function   DrumBeginSequence (lphMidiOut: PHMIDIOUT; Mywindow : HWND) : Boolean  ;
Procedure  DrumEndSequence   (lphMidiOut: PHMIDIOUT; Yes : BOOLean)  ;
Procedure Devices (Devicenumber : Word; var MyDevice: PMidiOutCaps);

implementation

function MidiOutMessage         ; external 'MIDIDLL' index 1;
function MidiNoteOff            ; external 'MIDIDLL' index 2;
function MidiNoteOn             ; external 'MIDIDLL' index 3;
function MidiSetPatch           ; external 'MIDIDLL' index 4;
function MidiPitchBend          ; external 'MIDIDLL' index 5;
procedure StartMIDI             ; external 'MIDIDLL' index 6;
procedure EndMIDI               ; external 'MIDIDLL' index 7;
Procedure  DrumSetParams        ; EXTERNAL 'MIDIDLL' index 11;
FUNCTION   DrumBeginSequence    ; EXTERNAL 'MIDIDLL' index 10;
Procedure  DrumEndSequence      ; EXTERNAL 'MIDIDLL' index  9;
Procedure DrumTimerFunc         ; EXTERNAL 'MIDIDLL' index  8;
Procedure Devices               ; EXTERNAL 'MIDIDLL' index 12;
end.

