Unit MIDIPiano;

{$F+}

INTERFACE

USES WinTypes, WinProcs,  Strings, OStdDlgs,
     Objects, OMemory, OWindows, ODialogs, vk_codes,
     MMSystem, MIDIConst, MIDIIds, MIDInterface, Validate (*, MMTypes*);

const
    id_Scroll1 = 417;
    id_Scroll2 = 418;
Type

   { Data Record Structures }

   PPitchRec = ^TPitchRec;
   TPitchRec  = Record
     Pitch : array [0..12] of Word;
     {Octave : array [-3..5] of Word;}
   end;

   PDataRec = ^TDataRec;
   TDataRec = Record
     POctave    : array [0..6] of char;
   end;

   POctaveRec = ^TOctaveRec;
   TOctaveRec  = Record
     POctave : array [0..5] of Word;
   end;

   PLoudRec   = ^TLoudRec;
   TLoudRec   =  Record

     PLoud    : array [0..6] of char;
     Position : array [0..2] of Integer;
   end;

   PvolumeRec = ^TvolumeRec;
   TVolumeRec= Record
     PLeft : array [0..6] of char;
     PRight :array [0..6] of char;
     Position : array [0..5] of Integer;
     Lock : Word;
   end;

   PPlayRec = ^TPlayRec;
   TPlayRec = Record
     PlayChannel : array [0..15] of Word;
   end;

   PPlayRecordRec = ^TPlayRecordRec;
   TPlayRecordRec = Record
     PlayChannel : array [0..15] of Word;
     RecordChannel : array [0..15] of Word;
   end;

   PMetronomeRec = ^TMetronomeRec;
   TMetronomeRec = Record
     Port, ONote, Note, Ochannel, Channel,
     OVelocity, Velocity : array [0..6] of char;
     MOnOffAcc : array [1..3] of Word;
     MCheck : Word;
   end;

   PLoudDialog = ^TLoudDialog;
   TLoudDialog = object (TDialog)
      LoudEdit    : PEdit;
      LoudScroll : PScrollbar;

      constructor Init (AParent: PWindowsObject; AName : PChar);
      procedure ScrollVolume (var Msg :TMessage);
                virtual id_First + id_Scroll1;
      procedure Helpbutton (var Msg :TMessage);
                virtual id_First + id_Helpbutton;
   end;

   PVolumeDialog = ^TVolumeDialog;
   TVolumeDialog = object (TDialog)
      LeftEdit, RightEdit : PEdit;
      Left, Right : PScrollbar;
      Lock : PCheckbox;
      constructor Init (AParent: PWindowsObject; AName : PChar);
      procedure Scroll1Volume (var Msg :TMessage);
                virtual id_First + id_Scroll1;
      procedure Scroll2Volume (var Msg :TMessage);
                virtual id_First + id_Scroll2;
      procedure Helpbutton (var Msg :TMessage);
                virtual id_First + id_Helpbutton;
   end;

   POctaveDialog = ^TOctaveDialog;
   TOctaveDialog = object (TDialog)
      constructor Init (AParent: PWindowsObject; AName : PChar);
      procedure Helpbutton (var Msg :TMessage);
                virtual id_First + id_Helpbutton;
   end;

   PPlayDialog = ^TPlayDialog;
   TPlayDialog = object (TDialog)
      constructor Init (AParent: PWindowsObject; AName : PChar);
      procedure Helpbutton (var Msg :TMessage);
                virtual id_First + id_Helpbutton;
   end;

   PPitchDialog = ^TPitchDialog;
   TPitchDialog = object (TDialog)
      constructor Init (AParent: PWindowsObject; AName : PChar);
      procedure Helpbutton (var Msg :TMessage);
                virtual id_First + id_Helpbutton;
   end;

   PRecordDialog = ^TRecordDialog;
   TRecordDialog = object (TDialog)
      constructor Init (AParent: PWindowsObject; AName : PChar);
      procedure Helpbutton (var Msg :TMessage);
                virtual id_First + id_Helpbutton;
   end;

   PPlayRecordDialog = ^TPlayRecordDialog;
   TPlayRecordDialog = object (TDialog)
      constructor Init (AParent: PWindowsObject; AName : PChar);
      procedure Helpbutton (var Msg :TMessage);
                virtual id_First + id_Helpbutton;
   end;


   PMetDialog = ^TMetDialog;
   TMetDialog = object (TDialog)
      constructor Init (AParent: PWindowsObject; AName : PChar);
      procedure Helpbutton (var Msg :TMessage);
                virtual id_First + id_Helpbutton;
  end;


  PEditDialog = ^TEditDialog;
  TEditDialog = object (TDialog)
      constructor Init (AParent: PWindowsObject; AName : PChar);
  end;


  PPianoWindow =  ^TPianoWindow;
  TPianowindow = Object (TWindow)
         Dialog :PDialog;

         CONSTRUCTOR Init (AParent: PWindowsObject;
                    zTitel: PChar);
         PROCEDURE   SetupWindow; VIRTUAL;
         PROCEDURE Paint (hPaintDC: HDC; VAR PaintInfo: TPaintStruct);
                         VIRTUAL;

         function   CanClose : Boolean; virtual;
         procedure GetWindowClass(var AWndClass: TWndClass); virtual;
         function GetClassName: PChar; virtual;

         PROCEDURE   CMShowDrum (var Msg :TMessage);
                    virtual cm_First + cm_DRUM;

         PROCEDURE CMShowPiano (var Msg :TMessage);
                    virtual cm_First + cm_Piano;

         PROCEDURE CMShowNotes (var Msg :TMessage);
                    virtual cm_First +  cm_Notation;

         PROCEDURE  CMShowMIDI (var Msg :TMessage);
                    virtual cm_First +  cm_MIDITrack;
         PROCEDURE  Mixer (var Msg :TMessage);
                    virtual cm_First +  cm_mixer;
         PROCEDURE  CMExitMIDI (var Msg :TMessage);
                    virtual cm_First +  cm_ExitMIDIMusic;
         Procedure  CMNewMidi  (var Msg :TMessage);
                    virtual cm_First +  cm_NewMIDI;
         Procedure  CMOpenMidiFile  (var Msg :TMessage);
                    virtual cm_First + cm_OpenMIDIFile;
         Procedure  CMSaveMidi  (var Msg :TMessage);
                    virtual cm_First + cm_SaveMIDI;
         Procedure  CMSaveAsMidiFile  (var Msg :TMessage);
                    virtual cm_First + cm_Save_As;
         Procedure  CMMerge  (var Msg :TMessage);
                    virtual cm_First + cm_Merge;
         Procedure  CMImport  (var Msg :TMessage);
                    virtual cm_First + cm_Import;
         Procedure  CMImportSysEx  (var Msg :TMessage);
                    virtual cm_First + cm_ImportSysEx;
         PROCEDURE  MetronomeBeeps  (var Msg :TMessage);
                    virtual cm_First +  cm_MetronomeBeeps ;
         PROCEDURE  PianoPlay (var Msg :TMessage);
                    virtual cm_First +  cm_PianoPlay;
         PROCEDURE  PianoRecord (var Msg :TMessage);
                    virtual cm_First +  cm_PianoRecord;
         PROCEDURE  PianoPlayRecord (var Msg :TMessage);
                    virtual cm_First +  cm_PianoPlayRecord;
         PROCEDURE  PianoBacking (var Msg :TMessage);
                    virtual cm_First + cm_Backing;
         PROCEDURE  TimeSignature (var Msg :TMessage);
                    virtual cm_First +  cm_TimeSignature;
         PROCEDURE  Volume (var Msg :TMessage);
                    virtual cm_First +  cm_Volume;
         PROCEDURE  Octave (var Msg :TMessage);
                    virtual cm_First +  cm_Octave;
         PROCEDURE  Velocity (var Msg :TMessage);
                    virtual cm_First +  cm_Velocity;
         PROCEDURE  Channel (var Msg :TMessage);
                    virtual cm_First +  cm_Channel;
         PROCEDURE  Pitch (var Msg :TMessage);
                    virtual cm_First +  cm_Pitch;

         Procedure WMKeyDown (var Msg :TMessage);
                    virtual wm_First + wm_KeyDown;
         Procedure WMKeyUp (var Msg :TMessage);
                    virtual wm_First + wm_KeyUp;
         Procedure WMLButtonDown (VAR Msg: TMESSAGE);
                    virtual wm_First + WM_LBUTTONDOWN;
         Procedure WMLButtonUp (VAR Msg: TMESSAGE);
                    virtual wm_First + WM_LBUTTONUP;

         Procedure  AcousticGrandPiano (var Msg :TMessage);
                    virtual cm_First + cm_AcousticGrandPiano;
         Procedure  BrightAcousticPiano (var Msg :TMessage);
                    virtual cm_First + cm_BrightAcousticPiano;
         Procedure  ElectricGrandPiano (var Msg :TMessage);
                    virtual cm_First + cm_ElectricGrandPiano;
         Procedure  HonkytonkPiano (var Msg :TMessage);
                    virtual cm_First + cm_HonkytonkPiano;
         Procedure  RhodesPiano (var Msg :TMessage);
                    virtual cm_First + cm_RhodesPiano;
         Procedure  ChorusedPiano (var Msg :TMessage);
                    virtual cm_First + cm_ChorusedPiano;
         Procedure  Harpsichord(var Msg :TMessage);
                    virtual cm_First + cm_Harpsichord;
         Procedure  Clavinet (var Msg :TMessage);
                    virtual cm_First + cm_Clavinet;
         Procedure  Celesta (var Msg :TMessage);
                    virtual cm_First + cm_Celesta;
         Procedure  Glockenspiel(var Msg :TMessage);
                    virtual cm_First + cm_Glockenspiel;
         Procedure  Musicbox (var Msg :TMessage);
                    virtual cm_First + cm_Musicbox;
         Procedure  Vibraphone (var Msg :TMessage);
                    virtual cm_First + cm_Vibraphone;
         Procedure  Marimba (var Msg :TMessage);
                    virtual cm_First + cm_Marimba;
         Procedure  Xylophone (var Msg :TMessage);
                    virtual cm_First + cm_Xylophone;
         Procedure  TubularBells (var Msg :TMessage);
                    virtual cm_First + cm_TubularBells;
         Procedure  Dulcimer(var Msg :TMessage);
                    virtual cm_First + cm_Dulcimer;
         Procedure  HammondOrgan (var Msg :TMessage);
                    virtual cm_First + cm_HammondOrgan;
         Procedure  PercussiveOrgan(var Msg :TMessage);
                    virtual cm_First + cm_PercussiveOrgan;
         Procedure  RockOrgan(var Msg :TMessage);
                    virtual cm_First + cm_RockOrgan;
         Procedure  ChurchOrgan (var Msg :TMessage);
                    virtual cm_First + cm_ChurchOrgan;
         Procedure  ReedOrgan (var Msg :TMessage);
                    virtual cm_First + cm_ReedOrgan;
         Procedure  Accordion (var Msg :TMessage);
                    virtual cm_First + cm_Accordion;
         Procedure  Harmonica (var Msg :TMessage);
                    virtual cm_First + cm_Harmonica;
         Procedure  TangoAccordian (var Msg :TMessage);
                    virtual cm_First + cm_TangoAccordian;
         Procedure  NylonAcousticGuitar (var Msg :TMessage);
                    virtual cm_First + cm_NylonAcousticGuitar;
         Procedure  SteelAcousticGuitar (var Msg :TMessage);
                    virtual cm_First + cm_SteelAcousticGuitar;
         Procedure  JazzElectricGuitar (var Msg :TMessage);
                    virtual cm_First + cm_JazzElectricGuitar;
         Procedure  CleanElectricGuitar (var Msg :TMessage);
                    virtual cm_First + cm_CleanElectricGuitar;
         Procedure  MutedElectricGuitar (var Msg :TMessage);
                    virtual cm_First + cm_MutedElectricGuitar;
         Procedure  OverdrivenGuitar (var Msg :TMessage);
                    virtual cm_First + cm_OverdrivenGuitar;
         Procedure  DistortionGuitar (var Msg :TMessage);
                    virtual cm_First + cm_DistortionGuitar;
         Procedure  GuitarHarmonics (var Msg :TMessage);
                    virtual cm_First + cm_GuitarHarmonics;
         Procedure  AcousticBass (var Msg :TMessage);
                    virtual cm_First + cm_AcousticBass;
         Procedure  ElectricBass (var Msg :TMessage);
                    virtual cm_First + cm_ElectricBass;
         Procedure  ElectricPickBass (var Msg :TMessage);
                    virtual cm_First + cm_ElectricPickBass;
         Procedure  FretlessBass (var Msg :TMessage);
                    virtual cm_First + cm_FretlessBass;
         Procedure  SlapBass1 (var Msg :TMessage);
                    virtual cm_First + cm_SlapBass1;
         Procedure  SlapBass2 (var Msg :TMessage);
                    virtual cm_First + cm_SlapBass2;
         Procedure  SynthBass1 (var Msg :TMessage);
                    virtual cm_First + cm_SynthBass1;
         Procedure  SynthBass2 (var Msg :TMessage);
                    virtual cm_First + cm_SynthBass2;
         Procedure  Violin (var Msg :TMessage);
                    virtual cm_First + cm_Violin;
         Procedure  Viola (var Msg :TMessage);
                    virtual cm_First + cm_Viola;
         Procedure  Cello (var Msg :TMessage);
                    virtual cm_First + cm_Cello;
         Procedure  Contrabass (var Msg :TMessage);
                    virtual cm_First + cm_Contrabass;
         Procedure  TremoloStrings  (var Msg :TMessage);
                    virtual cm_First + cm_TremoloStrings ;
         Procedure  PizzicatoStrings (var Msg :TMessage);
                    virtual cm_First + cm_PizzicatoStrings;
         Procedure  OrchestralHarp (var Msg :TMessage);
                    virtual cm_First + cm_OrchestralHarp;
         Procedure  Timpani (var Msg :TMessage);
                    virtual cm_First + cm_Timpani;
         Procedure  StringEns1 (var Msg :TMessage);
                    virtual cm_First + cm_StringEns1;
         Procedure  StringEns2 (var Msg :TMessage);
                    virtual cm_First + cm_StringEns2;
         Procedure  SynthStr1 (var Msg :TMessage);
                    virtual cm_First + cm_SynthStr1;
         Procedure  SynthStr2 (var Msg :TMessage);
                    virtual cm_First + cm_SynthStr2;
         Procedure  ChoirAahs (var Msg :TMessage);
                    virtual cm_First + cm_ChoirAahs;
         Procedure  VoiceOohs (var Msg :TMessage);
                    virtual cm_First + cm_VoiceOohs;
         Procedure  SynthVoice (var Msg :TMessage);
                    virtual cm_First + cm_SynthVoice;
         Procedure  OrchestraHit (var Msg :TMessage);
                    virtual cm_First + cm_OrchestraHit;
         Procedure  Trumpet (var Msg :TMessage);
                    virtual cm_First + cm_Trumpet;
         Procedure  Trombone (var Msg :TMessage);
                    virtual cm_First + cm_Trombone;
         Procedure  Tuba (var Msg :TMessage);
                    virtual cm_First + cm_Tuba;
         Procedure  MutedTrumpet (var Msg :TMessage);
                    virtual cm_First + cm_MutedTrumpet;
         Procedure  FrenchHorn (var Msg :TMessage);
                    virtual cm_First + cm_FrenchHorn;
         Procedure  BrassSection (var Msg :TMessage);
                    virtual cm_First + cm_BrassSection;
         Procedure  SynthBrass1 (var Msg :TMessage);
                    virtual cm_First + cm_SynthBrass1;
         Procedure  SynthBrass2 (var Msg :TMessage);
                    virtual cm_First + cm_SynthBrass2;
         Procedure  SopranoSax (var Msg :TMessage);
                    virtual cm_First + cm_SopranoSax;
         Procedure  AltoSax (var Msg :TMessage);
                    virtual cm_First + cm_AltoSax;
         Procedure  TenorSax (var Msg :TMessage);
                    virtual cm_First + cm_TenorSax;
         Procedure  BaritoneSax (var Msg :TMessage);
                    virtual cm_First + cm_BaritoneSax;
         Procedure  Oboe (var Msg :TMessage);
                    virtual cm_First + cm_Oboe;
         Procedure  EnglishHorn (var Msg :TMessage);
                    virtual cm_First + cm_EnglishHorn;
         Procedure  Bassoon (var Msg :TMessage);
                    virtual cm_First + cm_Bassoon;
         Procedure  Clarinet (var Msg :TMessage);
                    virtual cm_First + cm_Clarinet;
         Procedure  Piccolo (var Msg :TMessage);
                    virtual cm_First + cm_Piccolo;
         Procedure  Flute (var Msg :TMessage);
                    virtual cm_First + cm_Flute;
         Procedure  Recorder (var Msg :TMessage);
                    virtual cm_First + cm_Recorder;
         Procedure  PanFlute (var Msg :TMessage);
                    virtual cm_First + cm_PanFlute;
         Procedure  BottleBlow (var Msg :TMessage);
                    virtual cm_First + cm_BottleBlow;
         Procedure  Shakuhachi (var Msg :TMessage);
                    virtual cm_First + cm_Shakuhachi;
         Procedure  Whistle  (var Msg :TMessage);
                    virtual cm_First + cm_Whistle ;
         Procedure  Ocarina  (var Msg :TMessage);
                    virtual cm_First + cm_Ocarina ;
         Procedure  Leadsquare (var Msg :TMessage);
                    virtual cm_First + cm_Leadsquare;
         Procedure  Leadsawtooth (var Msg :TMessage);
                    virtual cm_First + cm_Leadsawtooth;
         Procedure  Leadcaliope (var Msg :TMessage);
                    virtual cm_First + cm_Leadcaliope;
         Procedure  Leadchiff (var Msg :TMessage);
                    virtual cm_First + cm_Leadchiff;
         Procedure  Leadcharang (var Msg :TMessage);
                    virtual cm_First + cm_Leadcharang;
         Procedure  Leadvoice (var Msg :TMessage);
                    virtual cm_First + cm_Leadvoice;
         Procedure  Leadfifths (var Msg :TMessage);
                    virtual cm_First + cm_Leadfifths;
         Procedure  Leadbrass (var Msg :TMessage);
                    virtual cm_First + cm_Leadbrass;
         Procedure  Pad1 (var Msg :TMessage);
                    virtual cm_First + cm_Pad1;
         Procedure  Pad2 (var Msg :TMessage);
                    virtual cm_First + cm_Pad2;
         Procedure  Pad3 (var Msg :TMessage);
                    virtual cm_First + cm_Pad3;
         Procedure  Pad4 (var Msg :TMessage);
                    virtual cm_First + cm_Pad4;
         Procedure  Pad5 (var Msg :TMessage);
                    virtual cm_First + cm_Pad5;
         Procedure  Pad6 (var Msg :TMessage);
                    virtual cm_First + cm_Pad6;
         Procedure  Pad7 (var Msg :TMessage);
                    virtual cm_First + cm_Pad7;
         Procedure  Pad8 (var Msg :TMessage);
                    virtual cm_First + cm_Pad8;
         Procedure  FX1(var Msg :TMessage);
                    virtual cm_First + cm_FX1;
         Procedure  FX2 (var Msg :TMessage);
                    virtual cm_First + cm_FX2 ;
         Procedure  FX3(var Msg :TMessage);
                    virtual cm_First + cm_FX3;
         Procedure  FX4(var Msg :TMessage);
                    virtual cm_First + cm_FX4;
         Procedure  FX5(var Msg :TMessage);
                    virtual cm_First + cm_FX5;
         Procedure  FX6(var Msg :TMessage);
                    virtual cm_First + cm_FX6;
         Procedure  FX7 (var Msg :TMessage);
                    virtual cm_First + cm_FX7 ;
         Procedure  FX8(var Msg :TMessage);
                    virtual cm_First + cm_FX8;
         Procedure  Sitar(var Msg :TMessage);
                    virtual cm_First + cm_Sitar;
         Procedure  Banjo(var Msg :TMessage);
                    virtual cm_First + cm_Banjo;
         Procedure  Shamisen(var Msg :TMessage);
                    virtual cm_First + cm_Shamisen;
         Procedure  Koto(var Msg :TMessage);
                    virtual cm_First + cm_Koto;
         Procedure  Kalimba(var Msg :TMessage);
                    virtual cm_First + cm_Kalimba;
         Procedure  Bagpipe(var Msg :TMessage);
                    virtual cm_First + cm_Bagpipe;
         Procedure  Fiddle (var Msg :TMessage);
                    virtual cm_First + cm_Fiddle ;
         Procedure  Shanai(var Msg :TMessage);
                    virtual cm_First + cm_Shanai;
         Procedure  TinkleBell(var Msg :TMessage);
                    virtual cm_First + cm_TinkleBell;
         Procedure  Agogo(var Msg :TMessage);
                    virtual cm_First + cm_Agogo;
         Procedure  SteelDrums(var Msg :TMessage);
                    virtual cm_First + cm_SteelDrums;
         Procedure  Woodblock(var Msg :TMessage);
                    virtual cm_First + cm_Woodblock;
         Procedure  TaikoDrum (var Msg :TMessage);
                    virtual cm_First + cm_TaikoDrum ;
         Procedure  MelodicTom(var Msg :TMessage);
                    virtual cm_First + cm_MelodicTom;
         Procedure  SynthDrum(var Msg :TMessage);
                    virtual cm_First + cm_SynthDrum;
         Procedure  ReverseCymbal(var Msg :TMessage);
                    virtual cm_First + cm_ReverseCymbal;
         Procedure  GuitarFretNoise(var Msg :TMessage);
                    virtual cm_First + cm_GuitarFretNoise;
         Procedure  BreathNoise(var Msg :TMessage);
                    virtual cm_First + cm_BreathNoise;
         Procedure  Seashore(var Msg :TMessage);
                    virtual cm_First + cm_Seashore;
         Procedure  BirdTweet(var Msg :TMessage);
                    virtual cm_First + cm_BirdTweet;
         Procedure  TelephoneRing(var Msg :TMessage);
                    virtual cm_First + cm_TelephoneRing;
         Procedure  Helicopter(var Msg :TMessage);
                    virtual cm_First + cm_Helicopter;
         Procedure  Applause(var Msg :TMessage);
                    virtual cm_First + cm_Applause;
         Procedure  Gunshot(var Msg :TMessage);
                    virtual cm_First + cm_Gunshot;

         procedure CMHelp(var Message: TMessage);
                    virtual cm_First + cm_Help;
         procedure CMHelpPiano (var Message: TMessage);
                    virtual cm_First + cm_Help_Piano;
         procedure CMHelpDrum (var Message: TMessage);
                    virtual cm_First + cm_Help_Drum;
         procedure CMHelpList (var Message: TMessage);
                    virtual cm_First + cm_Help_List;
         procedure CMHelpNotes (var Message: TMessage);
                    virtual cm_First + cm_Help_Notes;
         procedure CMHelpPianoRoll (var Message: TMessage);
                    virtual cm_First + cm_Help_PianoRoll;
         procedure CMHelpListEdit (var Message: TMessage);
                    virtual cm_First + cm_Help_ListEdit;

         procedure CMHelpHelp(var Message: TMessage);
                    virtual cm_First + cm_HelpHelp;
         procedure CMQuickHelp(var Message: TMessage);
                    virtual cm_First + cm_quickHelp;
         procedure CMIndexHelp(var Message: TMessage);
                    virtual cm_First + cm_indexHelp;
         procedure CMKeyboardHelp(var Message: TMessage);
                    virtual cm_First + cm_KeyboardHelp;
         procedure CMMIDIHelp(var Message: TMessage);
                    virtual cm_First + cm_midiHelp;
         procedure CMDRUMHelp(var Message: TMessage);
                    virtual cm_First + cm_drum_fileHelp;
         procedure CMInstallHelp(var Message: TMessage);
                    virtual cm_First + cm_Install_Board;
         PROCEDURE HelpAboutList (VAR Msg: TMESSAGE);
                    VIRTUAL cM_FIRST + cm_AboutList;
         PROCEDURE HelpAboutDrum (VAR Msg: TMESSAGE);
                    VIRTUAL cM_FIRST + cm_AboutDrum;
         PROCEDURE HelpAboutPiano (VAR Msg: TMESSAGE);
                    VIRTUAL cM_FIRST + cm_AboutPiano;
         PROCEDURE HelpAboutNotes (VAR Msg: TMESSAGE);
                    VIRTUAL cM_FIRST + cm_AboutNotes;
         PROCEDURE HelpAbout (VAR Msg: TMESSAGE);
                    VIRTUAL cM_FIRST + cm_About;


  end;



  implementation


    {---------------------------------------------------------}
    {  Change Instruments and Channel                         }
    {---------------------------------------------------------}

    Procedure ChangeInstrument (Hwindow : Hwnd; Inst : Integer);

    var i : integer;
        InstrumentTxt :Pchar; Intxt : array [0..128] of char;
    begin
       InstrumentTxt := @InTxt; CurrentInst := Inst;
       StrCopy (InstrumentTxt,Instrumentation [Inst]);
       for i := StrLen (Instrumentation [Inst]) to 40 do
           StrCat (InstrumentTxt,' ');
       GiveInformation  (Hwindow, 3 ,3 , 180 , 28 , InstrumentTxt) ;
       MidiSetPatch (lphMidiOut, CurrentChannel, CurrentInst);
       ChannelInstruments[CurrentChannel] := CurrentInst;
    end;

    Procedure ChangeChannel (HWindow: HWnd; CurrentChannel: Integer);
    var i : integer;
        ChannelTxt :Pchar; Intxt : array [0..128] of char;
    begin
       ChannelTxt := @InTxt;
       wvsprintf (ChannelTxt,'Channel = %d' ,CurrentChannel);
       CurrentInst := ChannelInstruments[CurrentChannel];
       ChangeInstrument (Hwindow, CurrentInst );
       GiveInformation  (Hwindow, 3 ,28 , 180 , 56 , ChannelTxt) ;
       MidiSetPatch (lphMidiOut, CurrentChannel , CurrentInst);
    end;



    {---------------------------------------------------------}
    {  TDialog Methods                                       }
    {---------------------------------------------------------}


     constructor  TEditDialog. Init (AParent: PWindowsObject; AName : PChar);
     var AnEdit : PEdit;
     begin
        inherited Init (AParent, AName);
        AnEdit := New (PEdit, InitResource (@Self,1404,7));
     end;

     constructor  TMetDialog. Init (AParent: PWindowsObject; AName : PChar);
     var AnEdit, NoteEdit : PEdit; MOnOffAcc : PRadioButton; Check: PCheckbox;
         i : integer;
     begin
        inherited Init (AParent, AName);
        AnEdit := New (PEdit, InitResource (@Self,1032,7));
        NoteEdit := New (PEdit, InitResource (@Self,1064,7));

        AnEdit := New (PEdit, InitResource (@Self,1065,7));
        AnEdit := New (PEdit, InitResource (@Self,1066,7));
        AnEdit := New (PEdit, InitResource (@Self,1067,7));
        AnEdit := New (PEdit, InitResource (@Self,1068,7));
        AnEdit := New (PEdit, InitResource (@Self,1069,7));
        for i := 1 to 3 do
           MOnOffAcc := New (PRadioButton, InitResource (@Self,1040+i));
        Check := New (PCheckbox, InitResource (@Self,1037));
     end;


     constructor TLoudDialog. Init (AParent: PWindowsObject; AName : PChar);
     begin
        inherited Init (AParent, AName);
        LoudEdit := New (PEdit, InitResource (@Self,1404,7));
        LoudScroll := New (PScrollBar, InitResource (@Self,417));
     end;

     procedure TLoudDialog. ScrollVolume (var Msg :TMessage);
     var nPosition : Integer; sPosition : String [15];
         cPosition : array [0..7] of char;
     begin
        nPosition := LoudScroll^.Getposition;
        Str (nPosition:3,sPosition);
        StrPCopy (@cPosition,sPosition);
        LoudEdit^.Settext (cPosition);
     end;

     constructor  TVolumeDialog. Init (AParent: PWindowsObject; AName : PChar);

     begin
        inherited Init (AParent, AName);
        LeftEdit := New (PEdit, InitResource (@Self,1404,7));
        RightEdit := New (PEdit, InitResource (@Self,1405,7));
        Left := New (PScrollBar, InitResource (@Self,417));
        Right:= New (PScrollBar, InitResource (@Self,418));
        Lock := New (PCheckbox, InitResource (@Self,419));
     end;

     procedure TVolumeDialog. Scroll1Volume (var Msg :TMessage);
     var nPosition : Integer; sPosition : String [15];
         cPosition : array [0..7] of char;
     begin
        nPosition := Left^.Getposition;
        Str (nPosition:3,sPosition);
        StrPCopy (@cPosition,sPosition);
        LeftEdit^.Settext (cPosition);
        if Lock^.GetCheck = bf_Checked
        then begin
          RightEdit^.Settext (cPosition);
          Right^.SetPosition (nPosition);
        end;
     end;

     procedure TVolumeDialog. Scroll2Volume (var Msg :TMessage);
     var nPosition : Integer; sPosition : String [15];
         cPosition : array [0..7] of char;
     begin
        nPosition := Right^.Getposition;
        Str (nPosition:3,sPosition);
        StrPCopy (@cPosition,sPosition);
        RightEdit^.Settext (cPosition);
        if Lock^.GetCheck = bf_Checked
        then begin
          LeftEdit^.Settext (cPosition);
          Left^.SetPosition (nPosition);
        end;
     end;

     constructor TPlayDialog.Init (AParent: PWindowsObject; AName : PChar);
     var i : integer;
         Check : PCheckbox;
     begin
       inherited Init (AParent, AName);
       for i := 0 to 15 do
           Check := New (PCheckbox, InitResource (@Self,120+i));
     end;

     constructor TRecordDialog.Init (AParent: PWindowsObject; AName : PChar);
     var i : integer;
         Check : PRadioButton;
     begin
       inherited Init (AParent, AName);
       for i := 0 to 15 do
           Check := New (PRadioButton, InitResource (@Self,100+i));
     end;

     constructor TOctaveDialog.Init (AParent: PWindowsObject; AName : PChar);
     var i : integer;
         Check : PRadioButton;
     begin
       inherited Init (AParent, AName);
       for i := 0 to 5 do
           Check := New (PRadioButton, InitResource (@Self,1406+i));
     end;

     constructor TPitchDialog.Init (AParent: PWindowsObject; AName : PChar);
     var i : integer;
         Check : PRadioButton;
     begin
       inherited Init (AParent, AName);
       for i := 0 to 12 do
           Check := New (PRadioButton, InitResource (@Self,500+i));
       {for i := 0 to 5 do
           Check := New (PRadioButton, InitResource (@Self,520+i));}
     end;

     constructor TPlayRecordDialog.Init (AParent: PWindowsObject; AName : PChar);
     var i : integer;
         Check : PCheckbox; Button: PRadioButton;
     begin
       inherited Init (AParent, AName);
       for i := 0 to 15 do
           Check := New (PCheckbox, InitResource (@Self,120+i));
       for i := 0 to 15 do
           Button := New (PRadioButton, InitResource (@Self,100+i));
     end;

     {constructor TVolumeScroll.InitResource (AParent: PWindowsObject;AnID: Integer);
     begin

     end;}

    {---------------------------------------------------------}
    {  Dialog Help Button Methods                                       }
    {---------------------------------------------------------}

     procedure TVolumeDialog.Helpbutton (var Msg :TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Volume')));
     end;

     procedure TPlayDialog.Helpbutton (var Msg :TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Playback')));
     end;

     procedure TRecordDialog.Helpbutton (var Msg :TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Channel')));
     end;

     procedure TMetDialog.Helpbutton (var Msg :TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Metronome')));
     end;

     procedure TPlayRecordDialog.Helpbutton (var Msg :TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('PlayRecord')));
     end;

     procedure TOctaveDialog.Helpbutton (var Msg :TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Octave')));
     end;

     procedure TLoudDialog. Helpbutton (var Msg :TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Velocity')));
     end;

     procedure TPitchDialog. Helpbutton (var Msg :TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Pitch')));
     end;

    {---------------------------------------------------------}
    {  TPiano Methods                                         }
    {---------------------------------------------------------}

    CONSTRUCTOR TPianoWindow. Init (AParent: PWindowsObject;
                 zTitel: PChar);

     BEGIN
       inherited Init (AParent, zTitel);
       Attr.x := 0;
       Attr.y := 0;
       Attr.H := 480;
       Attr.W := 640;
       Attr.Menu := LoadMenu (HInstance,'PIANO');
       Attr.Style := Attr.Style or ws_Sysmenu;
       EnableKBHandler;
     end;

     procedure TPianoWindow. GetWindowClass(var AWndClass: TWndClass);
     begin
        TWindow.GetWindowClass(AWndClass);
        AWndClass.hbrBackground := GetStockObject(Gray_Brush);
        AWndClass.hCursor       := LoadCursor (HInstance,'CUR_Hand');
        Showcursor (boolean(1));
     end;

     function TPianoWindow. GetClassName: PChar;
     begin
        GetClassName := 'PianoWindow';
     end;

     PROCEDURE TPianowindow. SetupWindow;

     BEGIN
       TWindow. SetupWindow;

     END; {SetupWindow}

     PROCEDURE TPianowindow.Paint (hPaintDC: HDC; VAR PaintInfo: TPaintStruct);
     const iBrush: INTEGER = DKGRAY_BRUSH;
     var x,y : integer;
     begin
       SelectObject (hPaintDC, GetStockObject (iBrush) ) ;
       RECTANGLE (hPaintDC, 0,0,640,100 ) ;
       ChangeInstrument (Hwindow, CurrentInst);
       ChangeVelocity (HWindow, CurrentVelocity);
       Currentvolume := midiOutGetVolume(MIDI_ID, lpdwVolume);
       ChangeVolume (HWindow,lpdwVolume );
       ChangeOctave (HWindow,CurrentOctave);
       ChangeChannel (HWindow, CurrentChannel);
       { }

       y := 5;
       for x := 0 to 20 do
       DrawWhiteRectangle (hPaintDC, X, Y );
       for x := 0 to 20 do
       DrawBlackRectangle (hPaintDC,X,Y);
       SetTextColor (hPaintDC, RGB ($0, $0, $0) );
     end;

  function TPianowindow. CanClose : Boolean;
   begin
     show (sw_Hide);
     CanClose := false;
   end;

   PROCEDURE TPianowindow. CMShowDrum (var Msg :TMessage);
     begin
       PostMessage (ParentNotify, WM_USER_SWITCHDRUM, 0, 0) ;
     end;

   PROCEDURE TPianowindow. CMShowPiano (var Msg :TMessage);
     begin
        PostMessage (ParentNotify, WM_USER_SWITCHPIANO, 0, 0) ;
     end;

   PROCEDURE TPianowindow. CMShowNotes (var Msg :TMessage);
     begin
       PostMessage (ParentNotify, WM_USER_SWITCHNOTES, 0, 0) ;
     end;

   PROCEDURE TPianowindow. CMShowMIDI (var Msg :TMessage);
     begin
       PostMessage (ParentNotify, WM_USER_SWITCHMIDI, 0, 0) ;
     end;

     PROCEDURE TPianowindow. CMExitMIDI (var Msg :TMessage);
     begin
       PostMessage (ParentNotify, WM_USER_EXIT, 0, 0) ;
     end;

     Procedure  TPianowindow. CMNewMidi  (var Msg :TMessage);
     begin
        DummyMeldung (HWindow, 'MIDI Music', 'New MIDI File is not yet available');
     end;

     Procedure  TPianowindow. CMOpenMidiFile  (var Msg :TMessage);
     Var
         szErrorString : PChar;
         szFileName : Pchar ; FileChars : array [0..128] of char;

     begin
       szFileName := @FileChars;
       StrCopy (szFileName, '*.MID');
       Dialog := New (PFileDialog, Init
	 (@Self, PChar (sd_FileOpen), szFileName));
       If (Application^.ExecDialog (Dialog) = id_Ok)
       Then
       Begin
          DummyMeldung (HWindow, 'MIDI Music', 'Open MIDI File is not yet available');
       end;
     end;

     Procedure  TPianowindow. CMMerge  (var Msg :TMessage);
     Var
         szErrorString : PChar;
         szFileName : Pchar ; FileChars : array [0..128] of char;
     begin
       szFileName := @FileChars;
       StrCopy (szFileName, '*.MID');
       Dialog := New (PFileDialog, Init
	 (@Self, PChar (sd_FileOpen), szFileName));
       If (Application^.ExecDialog (Dialog) = id_Ok)
       Then
       Begin
         DummyMeldung (HWindow, 'MIDI Music', 'Merge is not yet available');
       end;
     end;

     Procedure  TPianowindow. CMImport  (var Msg :TMessage);
     Var
         szErrorString : PChar;
         szFileName : Pchar ; FileChars : array [0..128] of char;
     begin
       szFileName := @FileChars;
       StrCopy (szFileName, '*.ROL');
       Dialog := New (PFileDialog, Init
	 (@Self, PChar (sd_FileOpen), szFileName));
       If (Application^.ExecDialog (Dialog) = id_Ok)
       Then
       Begin
         DummyMeldung (HWindow, 'MIDI Music', 'Import is not yet available');
       end;
     end;

     Procedure  TPianowindow. CMImportSysEx  (var Msg :TMessage);
     Var
         szErrorString : PChar;
         szFileName : Pchar ; FileChars : array [0..128] of char;
     begin
       szFileName := @FileChars;
       StrCopy (szFileName, '*.SYS');
       Dialog := New (PFileDialog, Init
	 (@Self, PChar (sd_FileOpen), szFileName));
       If (Application^.ExecDialog (Dialog) = id_Ok)
       Then
       Begin
         DummyMeldung (HWindow, 'MIDI Music', 'System Exclusive Import is not yet available');
       end;
     end;


     Procedure  TPianowindow. CMSaveMidi  (var Msg :TMessage);
       Var
         szErrorString : PChar;
         szFileName : Pchar ; FileChars : array [0..128] of char;
     begin
       new (szFileName); szFileName := @FileChars;
       StrCopy (szFileName, '*.MID');
       Dialog := New (PFileDialog, Init
	 (@Self, PChar (sd_FileSave), szFileName));

       If (Application^.ExecDialog (Dialog) = id_Ok)
       Then
       Begin
          DummyMeldung (HWindow, 'MIDI Music', 'Save MIDI File is not yet available');
       end;
     end;


     Procedure  TPianowindow. CMSaveAsMidiFile  (var Msg :TMessage);
     Var
         szErrorString : PChar;
         szFileName : Pchar ; FileChars : array [0..128] of char;
     begin
       new (szFileName); szFileName := @FileChars;
       StrCopy (szFileName, '*.MID');
       Dialog := New (PFileDialog, Init
	 (@Self, PChar (sd_FileSave), szFileName));

       If (Application^.ExecDialog (Dialog) = id_Ok)
       Then
       Begin
          DummyMeldung (HWindow, 'MIDI Music', 'Save As File is not yet available');
       end;

     end;


     Procedure getnote (var Notestring : PChar; var Octave : Integer;
                        CurrentNote : Integer);
     var Note : Integer;
     begin
        note := Currentnote mod 12;
        Octave := Currentnote div 12;

        case note of
         0 : StrCopy (Notestring, 'C ');
         1 : StrCopy (Notestring, 'C#');
         2 : Strcopy (Notestring, 'D ');
         3 : Strcopy (Notestring, 'D#');
         4 : Strcopy (Notestring, 'E ');
         5 : Strcopy (Notestring, 'F ');
         6 : Strcopy (Notestring, 'F#');
         7 : Strcopy (Notestring, 'G ');
         8 : Strcopy (Notestring, 'G#');
         9 : Strcopy (Notestring, 'A ');
         10: Strcopy (Notestring, 'A#');
         11: Strcopy (Notestring, 'B ');
        end;

     end;

     procedure setnote (var Currentnote: integer; NoteString: Pchar);
     var i, NOctave, Errorpos : Integer;
     begin
       case upcase(NoteString[0]) of
         'C' : Currentnote := 0;
         'D' : Currentnote := 2;
         'E' : Currentnote := 4;
         'F' : Currentnote := 5;
         'G' : Currentnote := 7;
         'A' : Currentnote := 9;
         'B' : Currentnote := 11;
       else Currentnote := 0;
       end;
       if NoteString[1] = '#' then Currentnote := Currentnote + 1;
       NOctave := 0;
       for i := 1 to StrLen (NoteString) do
       begin
         if NoteString[i] in ['0'..'9'] then
         val (NoteString[i], NOctave, Errorpos);
       end;
       Currentnote := Currentnote + 12*NOctave;
     end;

     procedure SetDataRec (var ARec : PMetronomeRec; Rec : Boolean; AStyle : integer);
     var i : integer;
     begin
       for i := 1 to 3 do
         if i = AStyle then ARec^.MOnOffAcc[i] := bf_Checked
         else ARec^.MOnOffAcc[i] := bf_unChecked;
       if Rec then ARec^.MCheck := bf_Checked
         else ARec^.MCheck := bf_unChecked;
     end;

     procedure GetDataRec (var Rec : boolean; var AStyle : Integer;ARec : PMetronomeRec);
     var i : integer;
     begin
        for i := 1 to 3 do
         if ARec^.MOnOffAcc[i] = bf_Checked then  AStyle := i;
        if ARec^.MCheck = bf_Checked then Rec := true
         else Rec := false;
     end;

     PROCEDURE  TPianowindow.MetronomeBeeps  (var Msg :TMessage);
     const
          CurrentPort : integer = 1;
          CurrentNote1: integer = 36;
          CurrentNote2: integer = 56;
          CurrentM1Velocity : integer = 45;
          CurrentM2Velocity : integer = 35;
          CurrentM1Channel : integer = 10;
          CurrentM2Channel : integer = 10;
          RecordingOnly : boolean = true;
          OnOffAccented : integer = 2;
     var
          MetData : PMetronomeRec;
          ErrorPos : Integer;EDialog: PEditDialog;
          Notestring, This : PChar; Notearray: array [0..6] of char;
          MOctave : Integer;
     begin
       New (MetData); Notestring := @Notearray;
       SetDataRec (MetData,RecordingOnly, OnOffAccented);
       wvsprintf (MetData^.Port,'%d',CurrentPort);
       getnote (Notestring, MOctave, CurrentNote1);
       wvsprintf (MetData^.Note, StrCat(Notestring,' %d'), MOctave);
       getnote (Notestring, MOctave,CurrentNote2);
       wvsprintf (MetData^.ONote,StrCat(Notestring,' %d'),MOctave);
       wvsprintf (MetData^.Channel,'%d',CurrentM1Channel);
       wvsprintf (MetData^.OChannel,'%d',CurrentM2Channel);
       wvsprintf (MetData^.Velocity,'%d',CurrentM1Velocity);
       wvsprintf (MetData^.OVelocity,'%d',CurrentM2Velocity);

       Dialog := New (PMetDialog, Init (@Self,'METRONOME'));
       Dialog^.Transferbuffer := MetData;
       If (Application^.ExecDialog (Dialog) = id_Ok)
       Then
       begin
          Val (MetData^.Channel,CurrentM1Channel, ErrorPos);
          Val (MetData^.OChannel,CurrentM2Channel, ErrorPos);
          Val (MetData^.Velocity,CurrentM1Velocity, ErrorPos);
          Val (MetData^.OVelocity,CurrentM2Velocity, ErrorPos);
          Val (MetData^.Port,CurrentPort, ErrorPos);
          setnote (Currentnote1,MetData^.Note);
          setnote (Currentnote2,MetData^.ONote);
          GetDataRec (RecordingOnly, OnOffAccented ,MetData);
       end;
     end;

     procedure SetPitchRec (var ARec : PPitchRec; AOctave: Integer; AStyle : Integer);

     var i : integer;
     begin
       for i := 0 to 12 do
         if i = AStyle then ARec^.Pitch[i] := bf_Checked
         else ARec^.Pitch[i] := bf_unChecked;
       {for i := 0 to 5 do
         if i = AOctave then ARec^.Octave[i] := bf_Checked
         else ARec^.Octave [i] := bf_unChecked; }
     end;

     procedure GetPitchRec (var AStyle : Integer; var AOctave: Integer; ARec : PPitchRec);

     var i : integer;
     begin
        AStyle := 0;
        for i := 0 to 12 do
         if ARec^.Pitch[i] = bf_Checked then  AStyle := i;
        {for i := 0 to 5 do
         if ARec^.Octave [i] = bf_Checked then  AOctave := i;}
     end;

     PROCEDURE  TPianowindow.Pitch  (var Msg :TMessage);
     var PitchDialog : PPitchDialog; ARec : PPitchRec;AStyle, AOctave: Integer;
     begin
       New (AREc);
       if semitones = 0 then begin AStyle := 0; AOctave := 0; end
       else begin
       AStyle := semitones mod 12; AOctave := Semitones div 12;
       end;
       SetPitchRec (ARec,AOctave, AStyle);
       PitchDialog := New (PPitchDialog, Init (@Self,'ADJPITCH'));
       PitchDialog^.Transferbuffer := AREc;
       If (Application^.ExecDialog (PitchDialog) = id_Ok)
       Then
       begin
         GetPitchRec (AStyle , AOctave, ARec );
         Semitones := AStyle + AOctave*12;
       end;
     end;


     PROCEDURE  TPianowindow.TimeSignature (var Msg :TMessage);
     begin
       Dialog := New (PDialog, Init (@Self,'ENTERTIMESIG'));
       If (Application^.ExecDialog (Dialog) = id_Ok)
       Then
       DummyMeldung (HWindow, 'MIDI Music', 'Time Signature is not yet available');
     end;

     PROCEDURE  TPianowindow.Mixer (var Msg :TMessage);
     Begin
          WinExec('C:\SBPRO\WIN31\SBPMIXER.EXE', sw_show);
     end;

     PROCEDURE  TPianowindow.PianoBacking (var Msg :TMessage);
     begin
       Dialog := New (PDialog, Init (@Self,'BACKING'));
       If (Application^.ExecDialog (Dialog) = id_Ok)
       Then
       DummyMeldung (HWindow, 'MIDI Music', 'Backing is not yet available');
     end;

     procedure SetPlayRecordRec (var ARec : PPlayRecordRec; AStyle : integer; Playing: Word);
     const L : word = 1;
     var i : integer;
     begin
       for i := 0 to 15 do
         if (Playing and (L shl i)) <> 0
         then ARec^.PlayChannel[i] := bf_Checked
         else ARec^.PlayChannel[i] := bf_unChecked;
       for i := 0 to 15 do
         if i = AStyle then ARec^.RecordChannel[i] := bf_Checked
         else ARec^.RecordChannel[i] := bf_unChecked;
     end;

     procedure GetPlayRecordRec (var AStyle : Integer; var Playing: Word; ARec : PPlayRecordRec);
     const L : word = 1;
     var i : integer;
     begin
        Playing := 0;
        for i := 0 to 15 do
         if ARec^.PlayChannel[i] = bf_Checked
         then Playing := (Playing or (L shl i));
       for i := 0 to 15 do
         if ARec^.RecordChannel[i] = bf_Checked then  AStyle := i;
     end;

     procedure SetRecordRec (var ARec : PPlayRec; AStyle : Integer);
     const L : word = 1;
     var i : integer;
     begin
       for i := 0 to 15 do
         if i = AStyle then ARec^.PlayChannel[i] := bf_Checked
         else ARec^.PlayChannel[i] := bf_unChecked;
     end;

     procedure GetRecordRec (var AStyle : Integer; ARec : PPlayRec);
     const L : word = 1;
     var i : integer;
     begin
        for i := 0 to 15 do
         if ARec^.PlayChannel[i] = bf_Checked then  AStyle := i;
     end;

     procedure SetPlayRec (var ARec : PPlayRec; Playing: Word);
     const L : word = 1;
     var i : integer;
     begin
       for i := 0 to 15 do
         if (Playing and (L shl i)) <> 0
         then ARec^.PlayChannel[i] := bf_Checked
         else ARec^.PlayChannel[i] := bf_unChecked;
     end;

     procedure GetPlayRec (var Playing: Word; ARec : PPlayRec);
     const L : word = 1;
     var i : integer;
     begin
        Playing := 0;
        for i := 0 to 15 do
         if ARec^.PlayChannel[i] = bf_Checked
         then Playing := (Playing or (L shl i));
     end;


     PROCEDURE   TPianowindow.PianoPlay (var Msg :TMessage);
      var PlayDialog: PPlayDialog; ChannelData : PPlayRec ;
          Playing : Word;
      begin
       New (ChannelData);
       SetPlayRec (ChannelData, $202);
       PlayDialog := New (PPlayDialog, Init (@Self,'PIANOPLAY'));
       PlayDialog^.Transferbuffer := ChannelData;
       If (Application^.ExecDialog (PlayDialog) = id_Ok)
       Then
       GetPlayRec (Playing, ChannelData);
       DummyMeldung (HWindow, 'MIDI Music', 'Play Back is not yet available');
     end;

     PROCEDURE   TPianowindow.PianoRecord (var Msg :TMessage);
      var PlayDialog: PRecordDialog;  ChannelData : PPlayRec ;
          AStyle : Integer;
      begin
       New (ChannelData);
       SetrecordRec (ChannelData, CurrentChannel);
       PlayDialog := New (PRecordDialog, Init (@Self,'PIANOREC'));
       PlayDialog^.Transferbuffer := ChannelData;
       If (Application^.ExecDialog (PlayDialog) = id_Ok)
       Then
       GetRecordRec (CurrentChannel, ChannelData);
       DummyMeldung (HWindow, 'MIDI Music', 'Recording is not yet available');
     end;

     PROCEDURE   TPianowindow.PianoPlayRecord (var Msg :TMessage);
      var PlayDialog: PPlayRecordDialog; ChannelData : PPlayRecordRec ;
          Playing: Word; AStyle : Integer;
      begin
       New (ChannelData);
       SetPlayRecordRec (ChannelData, CurrentChannel, $202);
       PlayDialog := New (PPlayRecordDialog, Init (@Self,'PLAYRECORD'));
       PlayDialog^.Transferbuffer := ChannelData;
       If (Application^.ExecDialog (PlayDialog) = id_Ok)
       Then
       GetPlayRecordRec (CurrentChannel, Playing, ChannelData);
       DummyMeldung (HWindow, 'MIDI Music', 'Play and Record is not yet available');
     end;

     PROCEDURE  TPianowindow.Volume (var Msg :TMessage);

     var
          VolumeData : PVolumeRec ; LeftVol, RightVol : Word;
          EDialog: PVolumeDialog; ErrorPos : Integer;
     begin
        {new (lpdwVolume); }
       midiOutGetVolume(Midi_ID, lpdwVolume);
       ChangeVolume (HWindow,lpdwVolume );
       New (VolumeData);
       Leftvol := (HiWord (lpdwvolume^) div $100);
       Rightvol := (LoWord (lpdwvolume^) div $100);

       wvsprintf (VolumeData^.PLeft,'%d',LeftVol);
       wvsprintf (VolumeData^.PRight,'%d',RightVol);
       VolumeData^.Position[0] := 0;
       VolumeData^.Position[1] := 255;
       VolumeData^.Position[2] := LeftVol;
       VolumeData^.Position[3] := 0;
       VolumeData^.Position[4] := 255;
       VolumeData^.Position[5] := RightVol;
       VolumeData^.Lock := bf_Checked;
       EDialog := New (PVolumeDialog, Init (@Self,'ADJVOLUME'));

       EDialog^.Transferbuffer := VolumeData;
       If (Application^.ExecDialog (EDialog) = id_Ok)
       Then
       begin
            Val (VolumeData^.PLeft,LeftVol, ErrorPos);
            Val (VolumeData^.PRight,RightVol, ErrorPos);
            lpdwVolume^ := LeftVol*$100*$10000 + Rightvol * $100;
            midiOutSetVolume(Midi_ID ,lpdwVolume^);
            ChangeVolume (HWindow,lpdwVolume );
       end;
     end;

     procedure SetOctaveRec (var ARec : POctaveRec; AStyle : Integer);

     var i : integer;
     begin
       for i := 0 to 5 do
         if i = AStyle then ARec^.POctave[i] := bf_Checked
         else ARec^.POctave[i] := bf_unChecked;
     end;

     procedure GetOctaveRec (var AStyle : Integer; ARec : POctaveRec);

     var i : integer;
     begin
        for i := 0 to 5 do
         if ARec^.POctave[i] = bf_Checked then  AStyle := i;
     end;

     PROCEDURE  TPianowindow.Octave (var Msg :TMessage);
     var
          OctaveData : POctaveRec ;
          EDialog: POctaveDialog;
     begin
       New (OctaveData);
       SetOctaveRec (OctaveData, CurrentOctave-1);
       EDialog := New (POctaveDialog, Init (@Self,'ADJOCTAVE'));

       EDialog^.Transferbuffer := OctaveData;

       If (Application^.ExecDialog (EDialog) = id_Ok)
       Then begin
            GetOctaveRec (CurrentOctave, OctaveData);
            CurrentOctave := CurrentOctave +1;
            ChangeOctave (HWindow,CurrentOctave);
       end;
     end;

     PROCEDURE  TPianowindow.Velocity (var Msg :TMessage);
     var
          OctaveData : PLoudRec ;
          ErrorPos : Integer;EDialog: PLoudDialog;
     begin
       New (OctaveData);
       wvsprintf (OctaveData^.PLoud,'%d',CurrentVelocity);
       Octavedata^.Position[0] := 0;
       Octavedata^.Position[1] := 127;
       Octavedata^.Position[2] := CurrentVelocity;
       EDialog := New (PLoudDialog, Init (@Self,'ADJLOUD'));

       EDialog^.Transferbuffer := OctaveData;

       If (Application^.ExecDialog (EDialog) = id_Ok)
       Then begin
            Val (OctaveData^.PLoud, CurrentVelocity, ErrorPos);
            ChangeVelocity (HWindow, CurrentVelocity);
       end;
     end;

     PROCEDURE  TPianowindow.Channel (var Msg :TMessage);
      var PlayDialog: PRecordDialog;  ChannelData : PPlayRec ;
          AStyle : Integer;
      begin
       New (ChannelData);
       SetrecordRec (ChannelData, CurrentChannel);
       PlayDialog := New (PRecordDialog, Init (@Self,'ADCHANNEL'));
       PlayDialog^.Transferbuffer := ChannelData;
       If (Application^.ExecDialog (PlayDialog) = id_Ok)
       Then begin
          GetRecordRec (CurrentChannel, ChannelData);
          ChangeChannel (HWindow, CurrentChannel);
       end;

     end;



     function getkey (HWindow: hwnd; key : word; down : boolean) : word;
     var temp: word; sharp : boolean; x,y:integer; PaintDC: HDC; b:bool;
     begin
        case key of
         VK_Tab : begin temp := $FFFF; end;{Vk_Tab hangs application}
         vk_F1  : if down then WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Piano')));
         vk_F2  : if down then PostMessage (ParentNotify, WM_USER_SWITCHNOTES, 0, 0) ;
         vk_F3  : if down then PostMessage (ParentNotify, WM_USER_SWITCHPIANO, 0, 0) ;
         vk_F4  : if down then PostMessage (ParentNotify, WM_USER_SWITCHMIDI, 0, 0) ;
         vk_F5  : if down then PostMessage (ParentNotify, WM_USER_SWITCHDRUM, 0, 0) ;
         vk_F11 : if down then b := PostMessage (HWindow, cm_First + cm_NewMIDI, 0, 0) ;
         {F11 does not work, why?}
         vk_Add : if (down and (CurrentOctave < 7)) then
                     begin
                        CurrentOctave := CurrentOctave + 1;
                        ChangeOctave (HWindow,CurrentOctave);
                        temp := $FFFF;
                     end;
         vk_Subtract: if (down and (CurrentOctave > 0)) then
                      begin
                        CurrentOctave := CurrentOctave - 1;
                        ChangeOctave (HWindow,CurrentOctave);
                        temp := $FFFF;
                      end;

         VK_Z : begin temp := 0; x := 0; sharp := false  end;{C}
         vk_X : begin temp := 2; x := 1; sharp := false  end;{D}
         vk_C : begin temp := 4; x := 2; sharp := false  end;{E}
         vk_V : begin temp := 5; x := 3; sharp := false  end;{F}
         vk_B : begin temp := 7; x := 4; sharp := false  end;{G}
         vk_N : begin temp := 9; x := 5; sharp := false  end;{A}
         vk_M : begin temp := 11; x := 6; sharp := false  end;{B}
         $BC  : begin temp := 12; x := 7; sharp := false  end;{< $3C : C}
         $BE  : begin temp := 14; x := 8; sharp := false  end;{> $3E : D}
         $BF  : begin temp := 16; x := 9; sharp := false  end;{? $3F : E}
         vk_Q : begin temp := 17; x := 10; sharp := false  end;
         vk_W : begin temp := 19; x := 11; sharp := false  end;
         vk_E : begin temp := 21; x := 12; sharp := false  end;
         vk_R : begin temp := 23; x := 13; sharp := false  end;
         vk_T : begin temp := 24; x := 14; sharp := false  end;
         vk_Y : begin temp := 26; x := 15; sharp := false  end;
         vk_U : begin temp := 28; x := 16; sharp := false  end;
         vk_I : begin temp := 29; x := 17; sharp := false  end;
         vk_O : begin temp := 31; x := 18; sharp := false  end;
         vk_P : begin temp := 33; x := 19; sharp := false  end;
         $DB  : begin temp := 35; x := 20; sharp := false  end;
         $DD  : begin temp := 36; x := 21; sharp := false  end;

         vk_S : begin temp := 1; x:= 0;    sharp := true  end;
         vk_D : begin temp := 3; x:= 1;    sharp := true  end;
         vk_G : begin temp := 6; x:= 3;    sharp := true  end;
         vk_H : begin temp := 8; x:= 4;    sharp := true  end;
         vk_J : begin temp := 10;x:= 5;    sharp := true  end;
         vk_L : begin temp := 13;x:= 7;    sharp := true  end;
         $BA  : begin temp := 15; x := 8;  sharp := true  end;
         vk_2 : begin temp := 18; x := 10; sharp := true  end;
         vk_3 : begin temp := 20; x := 11; sharp := true  end;
         vk_4 : begin temp := 22; x := 12; sharp := true  end;
         vk_6 : begin temp := 25; x := 14; sharp := true  end;
         vk_7 : begin temp := 27; x := 15; sharp := true  end;
         vk_9 : begin temp := 30; x := 17; sharp := true  end;
         vk_0 : begin temp := 32; x := 18; sharp := true  end;
         $BD  : begin temp := 34; x := 19; sharp := true  end;

         { If you use a German keyboard the correct key codes are as follows,
         if you use another keyboard you will have to figure it out
         youself or change to US keyboard:
         VK_Y : begin temp := 0; x := 0; sharp := false  end;
         vk_X : begin temp := 2; x := 1; sharp := false  end;
         vk_C : begin temp := 4; x := 2; sharp := false  end;
         vk_V : begin temp := 5; x := 3; sharp := false  end;
         vk_B : begin temp := 7; x := 4; sharp := false  end;
         vk_N : begin temp := 9; x := 5; sharp := false  end;
         vk_M : begin temp := 11; x := 6; sharp := false  end;
         $BC  : begin temp := 12; x := 7; sharp := false  end;
         $BE  : begin temp := 14; x := 8; sharp := false  end;
         $BD  : begin temp := 16; x := 9; sharp := false  end;
         vk_Q : begin temp := 17; x := 10; sharp := false  end;
         vk_W : begin temp := 19; x := 11; sharp := false  end;
         vk_E : begin temp := 21; x := 12; sharp := false  end;
         vk_R : begin temp := 23; x := 13; sharp := false  end;
         vk_T : begin temp := 24; x := 14; sharp := false  end;
         vk_Z : begin temp := 26; x := 15; sharp := false  end;
         vk_U : begin temp := 28; x := 16; sharp := false  end;
         vk_I : begin temp := 29; x := 17; sharp := false  end;
         vk_O : begin temp := 31; x := 18; sharp := false  end;
         vk_P : begin temp := 33; x := 19; sharp := false  end;
         $BA  : begin temp := 35; x := 20; sharp := false  end;

         vk_S : begin temp := 1; x:= 0;    sharp := true  end;
         vk_D : begin temp := 3; x:= 1;    sharp := true  end;
         vk_G : begin temp := 6; x:= 3;    sharp := true  end;
         vk_H : begin temp := 8; x:= 4;    sharp := true  end;
         vk_J : begin temp := 10;x:= 5;    sharp := true  end;
         vk_L : begin temp := 13;x:= 7;    sharp := true  end;
         $C0  : begin temp := 15; x := 8;  sharp := true  end;
         vk_2 : begin temp := 18; x := 10; sharp := true  end;
         vk_3 : begin temp := 20; x := 11; sharp := true  end;
         vk_4 : begin temp := 22; x := 12; sharp := true  end;
         vk_6 : begin temp := 25; x := 14; sharp := true  end;
         vk_7 : begin temp := 27; x := 15; sharp := true  end;
         vk_9 : begin temp := 30; x := 17; sharp := true  end;
         vk_0 : begin temp := 32; x := 18; sharp := true  end;
         $DB  : begin temp := 34; x := 19; sharp := true  end;
         }
        else  begin temp := $FFFF; sharp := true  end;
      end;
      {Show key being depressed}
      {}
      y := 5;
      if temp <> $FFFF then begin
         PaintDC:= GetDC (hwindow) ;
         if down then begin
            if sharp then begin

               DrawGray1Rectangle (PaintDC, X, Y );
            end
            else begin

              DrawGray2Rectangle (PaintDC, X, Y );
            end
         end
         else begin
            if sharp then begin

              DrawBlackRectangle (PaintDC, X, Y );
            end
            else begin

              DrawWhite2Rectangle (PaintDC, X, Y );
            end;
         end;
         ReleaseDC (hwindow, PaintDC) ;

       end;{}
       getkey := temp;
     end;

     Procedure TPianowindow. WMKeyDown (var Msg :TMessage);
     var y:integer; PaintDC: HDC; x, key, typematics : WORD; lpdwVolume: PLongint;
     begin

        key := Msg.wParam;
        typematics := Msg.lParamHi and $4000;
        if (key <> vk_LButton) and (key <> vk_Tab) and (Typematics = 0)
        then begin
             x:= getkey (Hwindow, key, true);
             if x <> $FFFF then begin
             x := x + semitones;
             MidiNoteOn (lphMidiOut, CurrentChannel, currentOctave, x, CurrentVelocity) ;
             end;
        end;
        {Volume is always C000C000}

     end;

     Procedure TPianowindow. WMKeyUp (var Msg :TMessage);
     var y:integer; PaintDC: HDC; x, key : WORD;
     begin

        key := Msg.wParam;
        if key <> vk_LButton then begin
        x:= getkey (Hwindow, key, false);
        if x <> $FFFF then begin
           x := x + semitones;
           MidiNoteOff (lphMidiOut, CurrentChannel, CurrentOctave, x, 0) ;
           end;
        end;

     end;
     Procedure TPianowindow. WMLButtonDown (VAR Msg: TMESSAGE);
     var y, Note, newnote:integer; PaintDC: HDC; x, key, typematics : WORD; lpdwVolume: PLongint;
     begin
          Twindow.WMLButtonDown (Msg);
          PaintDC := GetDC (hwindow) ;

          (* Convert mouse coordinates to grid coordinates *)

          x :=   LOWORD (Msg.lParam);
          y := 	 HIWORD (Msg.lParam);

          if (x > 0) and (x <= 630) and (y < 5*60 ) and (y > 5*40 )then
          begin
              Note := x div 30;
              case note of
                 0: newnote := Note;
                 1: newnote := Note +1;
                 2,3 : newnote := Note +2;
                 4: newnote := Note +3;
                 5: newnote := Note +4;
                 6,7: newnote := Note +5;
                 8: newnote := Note +6;
                 9,10 : newnote := Note +7;
                 11: newnote := Note +8;
                 12: newnote := Note +9;
                 13,14: newnote := Note +10;
                 15: newnote := Note +11;
                 16,17 : newnote := Note +12;
                 18: newnote := Note +13;
                 19: newnote := Note +14;
                 20,21: newnote := Note +15;

              end;
              GlobalNote := Note;  NewNote := NewNote + Semitones; GlobalNewNote := NewNote;
              MidiNoteOn (lphMidiOut, CurrentChannel, CurrentOctave, NewNote, CurrentVelocity) ;
              y:= 5;
              DrawGray2Rectangle (PaintDC, Note, Y );
          end
          else if(x > 0) and (x <= 630) and (y < 5*40 ) and (y > 5*20 )then
          begin
             x := x -21;
             if (x > 0) and (x mod 30 < 18) then begin
                note := x div 30;
                If note in [0,1,3,4,5,7,8,10,11,12,14,15, 17,18,19]
                  then begin
                     case note of
                     0: newnote := Note+1;
                     1: newnote := Note +2;
                     3: newnote := Note +3;
                     4: newnote := Note +4;
                     5: newnote := Note +5;
                     7: newnote := Note +6;
                     8: newnote := Note +7;
                     10 : newnote := Note +8;
                     11: newnote := Note +9;
                     12: newnote := Note +10;
                     14: newnote := Note +11;
                     15: newnote := Note +12;
                     17 : newnote := Note+13;
                     18: newnote := Note +14;
                     19: newnote := Note +15;
                     end;
                  GlobalNote := Note;  NewNote := NewNote + Semitones;
                  GlobalNewNote := NewNote;
                  MidiNoteOn (lphMidiOut, CurrentChannel, CurrentOctave, NewNote, CurrentVelocity) ;
                  y:= 5;
                  DrawGray1Rectangle (PaintDC, Note, Y );
                end; {If note in [0,1,3....]}
            end  {if (x > 0) or (x mod 30 < 18) then begin}
            else if (x < 0) or (x mod 30 > 18) then begin
               x := x + 21;
               note := x div 30;
               case note of
                 0: newnote := Note;
                 1: newnote := Note +1;
                 2,3 : newnote := Note +2;
                 4: newnote := Note +3;
                 5: newnote := Note +4;
                 6,7: newnote := Note +5;
                 8: newnote := Note +6;
                 9,10 : newnote := Note +7;
                 11: newnote := Note +8;
                 12: newnote := Note +9;
                 13,14: newnote := Note +10;
                 15: newnote := Note +11;
                 16,17 : newnote := Note +12;
                 18: newnote := Note +13;
                 19: newnote := Note +14;
                 20,21: newnote := Note +15;

              end;
              GlobalNote := Note;  NewNote := NewNote + Semitones;
              GlobalNewNote := NewNote;
              MidiNoteOn (lphMidiOut, CurrentChannel, CurrentOctave, NewNote, CurrentVelocity) ;
              y:= 5;
              DrawGray2Rectangle (PaintDC, Note, Y );
            end;
          end; {if... (y < 5*40 ) and (y > 5*20 )}
          ReleaseDC (hwindow, PaintDc) ;



     end;

     Procedure TPianowindow. WMLButtonUp (VAR Msg: TMESSAGE);
     var y : Integer; PaintDC: HDC;
     begin

        PaintDC := GetDC (hwindow) ;
        MidiNoteOff (lphMidiOut, CurrentChannel, CurrentOctave, GlobalNewNote, 0) ;
        y := 5;
        GlobalNewNote := GlobalNewnote - Semitones;
        If GlobalNewNote in [1,3,6,8,10,13,15,18,20,22,25,27,30,32,34]
        then
        DrawBlackRectangle (PaintDC, GlobalNote, Y )
        else
        DrawWhite2Rectangle (PaintDC, GlobalNote, Y );
        ReleaseDC (hwindow, PaintDc) ;
     end;



   Procedure  TPianowindow. AcousticGrandPiano (var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  0);
   end;

   Procedure  TPianowindow. BrightAcousticPiano (var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  1);
   end;

   Procedure  TPianowindow. ElectricGrandPiano (var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  2);
   end;

   Procedure  TPianowindow. HonkytonkPiano (var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  3);
   end;

   Procedure  TPianowindow. RhodesPiano (var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  4);
   end;

   Procedure  TPianowindow. ChorusedPiano (var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  5);
   end;

   Procedure  TPianowindow. Harpsichord(var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  6);
   end;

   Procedure  TPianowindow. Clavinet (var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  7);
   end;

   Procedure  TPianowindow. Celesta (var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  8);
   end;

   Procedure  TPianowindow. Glockenspiel(var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  9);
   end;

   Procedure  TPianowindow. Musicbox (var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  10);
   end;

   Procedure  TPianowindow. Vibraphone (var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  11);
   end;

   Procedure  TPianowindow. Marimba (var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  12);
   end;

   Procedure  TPianowindow. Xylophone (var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  13);
   end;

   Procedure  TPianowindow. TubularBells (var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  14);
   end;

   Procedure  TPianowindow. Dulcimer(var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  15);
   end;

   Procedure  TPianowindow. HammondOrgan (var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  16);
   end;

   Procedure  TPianowindow. PercussiveOrgan(var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  17);
   end;

   Procedure  TPianowindow. RockOrgan(var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  18);
   end;

   Procedure  TPianowindow. ChurchOrgan (var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  19);
   end;

   Procedure  TPianowindow. ReedOrgan (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  20);
   end;

   Procedure  TPianowindow. Accordion (var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  21);
   end;

   Procedure  TPianowindow. Harmonica (var Msg :TMessage);
   begin
      ChangeInstrument (Hwindow,  22);
   end;

   Procedure  TPianowindow. TangoAccordian (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  23);
   end;

   Procedure  TPianowindow. NylonAcousticGuitar (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  24);
   end;

   Procedure  TPianowindow. SteelAcousticGuitar (var Msg :TMessage);
    begin
     ChangeInstrument (Hwindow,  25);
   end;

   Procedure  TPianowindow. JazzElectricGuitar (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  26);
   end;

   Procedure  TPianowindow. CleanElectricGuitar (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  27);
   end;

   Procedure  TPianowindow. MutedElectricGuitar (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  28);
   end;

   Procedure  TPianowindow. OverdrivenGuitar (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  29);
   end;

   Procedure  TPianowindow. DistortionGuitar (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  30);
   end;

   Procedure  TPianowindow. GuitarHarmonics (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  31);
   end;

   Procedure  TPianowindow. AcousticBass (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  32);
   end;

   Procedure  TPianowindow. ElectricBass (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  33);
   end;

   Procedure  TPianowindow. ElectricPickBass (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  34);
   end;

   Procedure  TPianowindow. FretlessBass (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  35);
   end;

   Procedure  TPianowindow. SlapBass1 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  36);
   end;

   Procedure  TPianowindow. SlapBass2 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  37);
   end;

   Procedure  TPianowindow. SynthBass1 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  38);
   end;

   Procedure  TPianowindow. SynthBass2 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  39);
   end;

   Procedure  TPianowindow. Violin (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  40);
   end;

   Procedure  TPianowindow. Viola (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  41);
   end;

   Procedure  TPianowindow. Cello (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  42);
   end;

   Procedure  TPianowindow. Contrabass (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  43);
   end;

   Procedure  TPianowindow. TremoloStrings  (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  44);
   end;

   Procedure  TPianowindow. PizzicatoStrings (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  45);
   end;

   Procedure  TPianowindow. OrchestralHarp (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  46);
   end;

   Procedure  TPianowindow. Timpani (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  47);
   end;

   Procedure  TPianowindow.StringEns1 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  48);
   end;

   Procedure  TPianowindow.StringEns2 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  49);
   end;

   Procedure  TPianowindow.SynthStr1 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  50);
   end;

   Procedure  TPianowindow.SynthStr2 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  51);
   end;

   Procedure  TPianowindow.ChoirAahs (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  52);
   end;

   Procedure  TPianowindow.VoiceOohs (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  53);
   end;

   Procedure  TPianowindow.SynthVoice (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  54);
   end;

   Procedure  TPianowindow.OrchestraHit (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  55);
   end;

   Procedure  TPianowindow.Trumpet (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  56);
   end;

   Procedure  TPianowindow.Trombone (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  57);
   end;

   Procedure  TPianowindow.Tuba (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  58);
   end;

   Procedure  TPianowindow.MutedTrumpet (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  59);
   end;

   Procedure  TPianowindow.FrenchHorn (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  60);
   end;

   Procedure  TPianowindow.BrassSection (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  61);
   end;

   Procedure  TPianowindow.SynthBrass1 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  62);
   end;

   Procedure  TPianowindow.SynthBrass2 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  63);
   end;

   Procedure  TPianowindow.SopranoSax (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  64);
   end;

   Procedure  TPianowindow.AltoSax (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  65);
   end;

   Procedure  TPianowindow.TenorSax (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  66);
   end;

   Procedure  TPianowindow.BaritoneSax (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  67);
   end;

   Procedure  TPianowindow.Oboe (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  68);
   end;

   Procedure  TPianowindow.EnglishHorn (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  69);
   end;

   Procedure  TPianowindow.Bassoon (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  70);
   end;

   Procedure  TPianowindow.Clarinet (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  71);
   end;

   Procedure  TPianowindow.Piccolo (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  72);
   end;

   Procedure  TPianowindow.Flute (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  73);
   end;

   Procedure  TPianowindow.Recorder (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  74);
   end;

   Procedure  TPianowindow.PanFlute (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  75);
   end;

   Procedure  TPianowindow.BottleBlow (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  76);
   end;

   Procedure  TPianowindow.Shakuhachi (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  77);
   end;

   Procedure  TPianowindow.Whistle  (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  78);
   end;

   Procedure  TPianowindow.Ocarina  (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  79);
   end;

   Procedure  TPianowindow.Leadsquare (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  80);
   end;

   Procedure  TPianowindow.Leadsawtooth (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  81);
   end;

   Procedure  TPianowindow.Leadcaliope (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  82);
   end;

   Procedure  TPianowindow.Leadchiff (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  83);
   end;

   Procedure  TPianowindow.Leadcharang (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  84);
   end;

   Procedure  TPianowindow.Leadvoice (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  85);
   end;

   Procedure  TPianowindow.Leadfifths (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  86);
   end;

   Procedure  TPianowindow.Leadbrass (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  87);
   end;

   Procedure  TPianowindow.Pad1 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  88);
   end;

   Procedure  TPianowindow.Pad2 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  89);
   end;

   Procedure  TPianowindow.Pad3 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  90);
   end;

   Procedure  TPianowindow.Pad4 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  91);
   end;

   Procedure  TPianowindow.Pad5 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  92);
   end;

   Procedure  TPianowindow.Pad6 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  93);
   end;

   Procedure  TPianowindow.Pad7 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  94);
   end;

   Procedure  TPianowindow.Pad8 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  95);
   end;

   Procedure  TPianowindow.FX1(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  96);
   end;

   Procedure  TPianowindow.FX2 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  97);
   end;

   Procedure  TPianowindow.FX3(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  98);
   end;

   Procedure  TPianowindow.FX4(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  99);
   end;

   Procedure  TPianowindow.FX5(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  100);
   end;

   Procedure  TPianowindow.FX6(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  101);
   end;

   Procedure  TPianowindow.FX7 (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  102);
   end;

   Procedure  TPianowindow.FX8(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  103);
   end;

   Procedure  TPianowindow.Sitar(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  104);
   end;

   Procedure  TPianowindow.Banjo(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  105);
   end;

   Procedure  TPianowindow.Shamisen(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  106);
   end;

   Procedure  TPianowindow.Koto(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  107);
   end;

   Procedure  TPianowindow.Kalimba(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  108);
   end;

   Procedure  TPianowindow.Bagpipe(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  109);
   end;

   Procedure  TPianowindow.Fiddle (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  110);
   end;

   Procedure  TPianowindow.Shanai(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  111);
   end;

   Procedure  TPianowindow.TinkleBell(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  112);
   end;

   Procedure  TPianowindow.Agogo(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  113);
   end;

   Procedure  TPianowindow.SteelDrums(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  114);
   end;

   Procedure  TPianowindow.Woodblock(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  115);
   end;

   Procedure  TPianowindow.TaikoDrum (var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  116);
   end;

   Procedure  TPianowindow.MelodicTom(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  117);
   end;

   Procedure  TPianowindow.SynthDrum(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  118);
   end;

   Procedure  TPianowindow.ReverseCymbal(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  119);
   end;

   Procedure  TPianowindow.GuitarFretNoise(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  120);
   end;

   Procedure  TPianowindow.BreathNoise(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  121);
   end;

   Procedure  TPianowindow.Seashore(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  122);
   end;

   Procedure  TPianowindow.BirdTweet(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  123);
   end;

   Procedure  TPianowindow.TelephoneRing(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  124);
   end;

   Procedure  TPianowindow.Helicopter(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  125);
   end;

   Procedure  TPianowindow.Applause(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  126);
   end;

   Procedure  TPianowindow.Gunshot(var Msg :TMessage);
   begin
     ChangeInstrument (Hwindow,  127);
   end;

   procedure TPianoWindow.CMHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Instructions')));
     end;


     procedure TPianoWindow.CMHelpPiano (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Piano')));
     end;


     procedure TPianoWindow.CMHelpDrum (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Drum')));
     end;

     procedure TPianoWindow.CMHelpNotes (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Staff')));
     end;


     procedure TPianoWindow.CMHelpPianoRoll (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Index')));
     end;


     procedure TPianoWindow.CMHelpListEdit (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Index')));
     end;


     procedure TPianoWindow.CMHelpList (var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Lister')));
     end;


     procedure TPianoWindow.CMHelpHelp(var Message: TMessage);
     begin
         WinHelp(HWindow, 'WINHELP.HLP', Help_Index, 0);
     end;

     procedure TPianoWindow.CMQuickHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Quick')));
     end;

     procedure TPianoWindow.CMIndexHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Index')));
     end;

     procedure TPianoWindow.CMKeyboardHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Keyboard')));
     end;

     procedure TPianoWindow.CMMIDIHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('midi_file')));
     end;

     procedure TPianoWindow.CMDrumHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Drum_file')));
     end;
     procedure TPianoWindow.CMInstallHelp(var Message: TMessage);
     Begin
        WinHelp(HWindow, 'MIDI.HLP', Help_Key, LongInt(PChar('Install')));
     end;

     PROCEDURE TPianoWindow.HelpAboutList (VAR Msg: TMESSAGE);
        BEGIN
          AboutProc := MakeProcInstance (@About, HINSTANCE);
          DialogBox (HINSTANCE, 'AboutList', HWindow, AboutProc);
          FREEPROCINSTANCE (AboutProc);
          EXIT;
        END;
     PROCEDURE TPianoWindow.HelpAboutDrum (VAR Msg: TMESSAGE);
     BEGIN
          AboutProc := MakeProcInstance (@About, HINSTANCE);
          DialogBox (HINSTANCE, 'AboutDrum', HWindow, AboutProc);
          FREEPROCINSTANCE (AboutProc);
          EXIT;
     END;

     PROCEDURE TPianoWindow.HelpAboutPiano (VAR Msg: TMESSAGE);
        BEGIN
          AboutProc := MakeProcInstance (@About, HINSTANCE);
          DialogBox (HINSTANCE, 'AboutPiano', HWindow, AboutProc);
          FREEPROCINSTANCE (AboutProc);
          EXIT;
        END;

     PROCEDURE TPianoWindow.HelpAboutNotes (VAR Msg: TMESSAGE);
        BEGIN
          AboutProc := MakeProcInstance (@About, HINSTANCE);
          DialogBox (HINSTANCE, 'AboutNotes', HWindow, AboutProc);
          FREEPROCINSTANCE (AboutProc);
          EXIT;
        END;

     PROCEDURE TPianoWindow.HelpAbout (VAR Msg: TMESSAGE);
        BEGIN
          AboutProc := MakeProcInstance (@About, HINSTANCE);
          DialogBox (HINSTANCE, 'AboutBox', HWindow, AboutProc);
          FREEPROCINSTANCE (AboutProc);
          EXIT;
        END;



end.

