//  C Header file for barcodes.dll
//
//
// (c) Copyright 1994. All rights reserved.
// HEX TECHNOLOGY, NEW ZEALAND,
// FAX:  (64) (3) 3772255   
// Last Modified: 5 Nov 94
//
//
// BARCODE STYLES
//                                                    
// Use for iStyle parameter
// 
#define BARCODE_2of5				1  
#define BARCODE_2of5_Interleaved	2
#define BARCODE_3of9				3
#define BARCODE_Codabar				4
#define BARCODE_Code39				5
#define BARCODE_Code93				6
#define BARCODE_Code128				7
#define BARCODE_EAN128				9    
#define BARCODE_EAN13				10   
#define BARCODE_EAN8				11   
#define BARCODE_MSI					12
#define BARCODE_ITF					13  
#define BARCODE_Code11				14  
#define BARCODE_CodeB				15  
#define BARCODE_Telepen				16
#define BARCODE_UPC_A				17
#define BARCODE_UPC_E				22 
#define BARCODE_Code128_A			23
#define BARCODE_Code128_B			24
#define BARCODE_Code128_C			25
  


// FLAG VALUES
// 
// Use for iDisplayFlags parameter
// Add together to make a single value
#define FLAG_ShowData 				1
#define FLAG_WBearerBar				2		
#define FLAG_HBearerBar				4
#define FLAG_CheckDigit				8
#define FLAG_ShowSpacer				16
#define FLAG_SwitchText				32	
                            

// FONT FLAGS
//
// Use for iFontFlags parameter
// Add together to make a single value
#define FONT_BOLD 1
#define FONT_ITALIC 2    

#ifdef __cplusplus
extern "C" {
#endif    
HMETAFILE FAR PASCAL _export DrawBarcode(
								 HDC hdc,    		// Used for information only
 								 int iStyle,        // one of BARCODE_XX
								 LPSTR szData,  	// Data string to encode
								 LPSTR szText,      // Optional text to display
								 int iDisplayFlags, // Combination of FLAG_ values 
						 		 int iRatio,        // 0 = default 1 = 1.75 2 = 2.00 .... 7 = 3.0
 								 LPSTR sFontFace,	// Eg: Arial or OCR-A etc TT Fonts only
								 int iFontFlags, 	// Combination of FONT_ values
								 int iFontAdjustment,  // -200 to 200 to adjust default font size
								 long clrFront, 	 // 32Bit color value for barcode bars and text
							     long clrBack, 		 // 32Bit color value for barcode background
 								 int far *iEntireWidth,  // set by dll, holds entire width of barcode
								 int far *iEntireHeight, // set by dll, holds entire height of barcode
								 int far *iBarcodeWidth,  // set by dll, holds just the width of the barcode itself
								 int far *iBarcodeHeight  // set by dll, holds just the height of the barcode itself
								 );

#ifdef __cplusplus
}
#endif

// NOTE !!!
// The iEntireWidth/Height and iBarcodeWidth/Height parameters are set when the
// call to DrawBarcode/CreatePlacableBarcode returns.  You use these values
// to scale the barcode image (HMETAFILE) to the desired size on your device context (HDC).
// See the sample C++ source code file name barvw.cpp for an example of this.
// Or see the Microsoft Word 6.0 macro that is also included with this archive.



// CreatePlacableBarcode is the same as DrawBarcode.. but instead of
// returning a handle to the barcode metafile (HMETAFILE) it saves
// the barcode to .WMF file on disk.  This file is compatible with
// normal WMF graphic filters.

#ifdef __cplusplus
extern "C" {
#endif    
BOOL FAR PASCAL _export CreatePlaceableBarcode( 
								 LPSTR fileName,  	// Name of the disk file to create. eg: soup.wmf
								 HDC hdc,    		// Used for information only
 								 int iStyle,        // one of BARCODE_XX
								 LPSTR szData,  	// Data string to encode
								 LPSTR szText,      // Optional text to display
								 int iDisplayFlags, // Combination of FLAG_ values 
						 		 int iRatio,        // 0 = default 1 = 1.75 2 = 2.00 .... 7 = 3.0
 								 LPSTR sFontFace,	// Eg: Arial or OCR-A etc TT Fonts only
								 int iFontFlags, 	// Combination of FONT_ values
								 int iFontAdjustment,  // -200 to 200 to adjust default font size
								 long clrFront, 	 // 32Bit color value for barcode bars and text
							     long clrBack, 		 // 32Bit color value for barcode background
 								 int far *iEntireWidth,  // set by dll, holds entire width of barcode
								 int far *iEntireHeight, // set by dll, holds entire height of barcode
								 int far *iBarcodeWidth,  // set by dll, holds just the width of the barcode itself
								 int far *iBarcodeHeight);  // set by dll, holds just the height of the barcode itself

#ifdef __cplusplus
}
#endif
				

			