//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code creates a registry key that only the account
// "Guest" can access.
//***************************************************************

// regsec.cpp

#include <windows.h>
#include <iostream.h>

SECURITY_ATTRIBUTES sa;
SECURITY_DESCRIPTOR sd;
BYTE aclBuffer[1024];
PACL pacl=(PACL)&aclBuffer;
BYTE sidBuffer[100];
PSID psid=(PSID) &sidBuffer;
DWORD sidBufferSize = 100;
char domainBuffer[80];
DWORD domainBufferSize = 80;
SID_NAME_USE snu;
LONG result;
HKEY regKey;
DWORD disposition;

void main(void)
{
  InitializeSecurityDescriptor(&sd,
    SECURITY_DESCRIPTOR_REVISION);
  InitializeAcl(pacl, 1024, ACL_REVISION);
  LookupAccountName(0, "guest", psid,
    &sidBufferSize, domainBuffer,
    &domainBufferSize, &snu);
  AddAccessAllowedAce(pacl, ACL_REVISION,
    GENERIC_READ, psid);
  SetSecurityDescriptorDacl(&sd, TRUE, pacl,
    FALSE);

  sa.nLength= sizeof(SECURITY_ATTRIBUTES);
  sa.bInheritHandle = FALSE;
  sa.lpSecurityDescriptor = &sd;

  result = RegCreateKeyEx(HKEY_CURRENT_USER,
    "junk", 0, 0, REG_OPTION_VOLATILE,
    KEY_ALL_ACCESS, &sa, &regKey, 
    &disposition);
  cout << result << endl;
  RegCloseKey(regKey);
}
