//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates how to use a DLL with run-time
// linking.
//***************************************************************

// honker2.cpp

#include <windows.h>
#include <stdlib.h>
#include <iostream.h>

#include "sndrt.h"

VOID main(VOID)
{
  DWORD iterations;
  CHAR iterStr[100];
  CHAR modName[MAX_PATH];
  HINSTANCE sndHandle;

  cout << "Enter the number of beeps to produce: ";
  cin.getline(iterStr, 100);

  iterations=atoi(iterStr);

  // map snd.dll into process
  sndHandle=LoadLibraryEx("snd", NULL,
    0);

  if (sndHandle == NULL)
  {
    cerr << "Sorry, unable to use DLL." << endl;
    return;
  }
  else
  {
    // load function name with address mapped from
    // snd.dll
    MultiHonk=(void (*)(DWORD))GetProcAddress(
      sndHandle, "MultiHonk");

    if (MultiHonk == NULL)
    {
      cerr 
        << "Sorry, MultiHonk function not in DLL."
        << endl;
      // release the DLL
      FreeLibrary(sndHandle);
      return;
    }
    else
    {
      GetModuleFileName(sndHandle, modName,
        MAX_PATH);
      cout << "Using DLL: " << modName
        << endl;

      // make the beeps
      MultiHonk(iterations);
      // release the DLL
      FreeLibrary(sndHandle);
    }
  }
}
