//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code shows how to traverse the registry tree.
//***************************************************************

// showgrps.cpp

#include <windows.h>
#include <iostream.h>

VOID main(VOID)
{
  LONG ret;
  HKEY keyHandle;
  CHAR subKeyName[80];
  DWORD subKeyNameSize;
  CHAR valueName[80];
  DWORD valueNameSize;
  BYTE value[80];
  DWORD valueSize;
  DWORD n;
  FILETIME lastUpdate;

  // open the key to enumerate
  ret=RegOpenKeyEx(HKEY_CURRENT_USER,
    "Program Groups", 0,
    KEY_ENUMERATE_SUB_KEYS,
    &keyHandle);
  if (ret != ERROR_SUCCESS)
  {
    cerr << "Unable to open subkey"
      << endl;
    return;
  }

  cout << "As subkeys:" << endl << endl;

  // show all the subkeys
  n=0;
  do
  {
    subKeyNameSize=80;
    ret=RegEnumKeyEx(keyHandle, n,
      subKeyName, &subKeyNameSize,
      NULL, NULL, NULL, &lastUpdate);
    if (ret == ERROR_SUCCESS)
    {
      cout << subKeyName << endl;
      n++;
    }
  } while (ret == ERROR_SUCCESS);

  cout << endl << "There are " << n
    << " groups listed." << endl << endl;

  // close the key
  ret=RegCloseKey(keyHandle);
  if (ret != ERROR_SUCCESS)
  {
    cerr << "Unable to close subkey"
      << endl;
    return;
  }

  // open the key to enumerate
  ret=RegOpenKeyEx(HKEY_CURRENT_USER,
    "Software\\Microsoft\\Windows NT\\\
CurrentVersion\\Program Manager\\Groups",
    0, KEY_QUERY_VALUE,
    &keyHandle);
  if (ret != ERROR_SUCCESS)
  {
    cerr << "Unable to open subkey"
      << endl;
    return;
  }

  cout << "As values:" << endl << endl;

  // show all the values
  n=0;
  do
  {
    valueNameSize=80;
    valueSize=80;
    ret=RegEnumValue(keyHandle, n,
      valueName, &valueNameSize,
      NULL, NULL, value, &valueSize);
    if (ret == ERROR_SUCCESS)
    {
      cout << valueName << " is "
        << value << endl;
      n++;
    }
  } while (ret == ERROR_SUCCESS);

  cout << endl << "There are " << n
    << " groups listed." << endl;

  // close the key
  ret=RegCloseKey(keyHandle);
  if (ret != ERROR_SUCCESS)
  {
    cerr << "Unable to close subkey"
      << endl;
    return;
  }
}
