//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code searches for the specified file on all logical
// drives. Wildcards are acceptable.
//***************************************************************

// dir3.cpp

#include <iostream.h> 
#include <windows.h>

// prints information about a file
void PrintFindData(WIN32_FIND_DATA *findData,
	char *dirName)
{	
	cout << "\t";
	cout << dirName << '\\' 
		<< findData->cFileName;
	cout << endl;
}

// Recursively lists directories
void ListDirectoryContents(char *dirName, 
	char *fileMask)
{
	char curDir[ 256 ];
	HANDLE fileHandle;
	WIN32_FIND_DATA findData;

	// save current dir so it can restore it
	if( !GetCurrentDirectory( 256, curDir) ) 
		return;
	
	// if the directory name is neither . or .. then
	// change to it, otherwise ignore it
	if( strcmp( dirName, "." ) && 
		strcmp( dirName, ".." ) )
	{
		if( !SetCurrentDirectory( dirName ) ) 
			return;
	}
	else 
		return;

	// Loop through all files in the looking for 
	// the file name of interest.
	fileHandle = FindFirstFile( fileMask, 
		&findData );
	while ( fileHandle != INVALID_HANDLE_VALUE )
	{
		PrintFindData( &findData, curDir );

  		// loop thru remaining entries in the dir
		if (!FindNextFile( fileHandle, &findData ))
			break;
 	}
	FindClose( fileHandle );

	// Loop through all files in the directory
	// looking for other directories
	fileHandle = FindFirstFile( "*.*", 
		&findData );
	while ( fileHandle != INVALID_HANDLE_VALUE )
	{
		// If the name is a directory,
		// recursively walk it. 
		if( findData.dwFileAttributes &
			FILE_ATTRIBUTE_DIRECTORY )
		{
			ListDirectoryContents( findData.cFileName,
				fileMask );
		}
  		// loop thru remaining entries in the dir
		if (!FindNextFile( fileHandle, &findData ))
			break;
 	}
	
	// clean up and restore directory
	FindClose( fileHandle );
	SetCurrentDirectory( curDir );
}

int main(int argc, char *argv[])
{
	char	curDir[ 256 ];
	char	findName[ 256 ];
        DWORD drives;
        int x;

	cout << "Enter name to find: ";
	cin >> findName;

        drives = GetLogicalDrives();
	// Eliminate drives A and B
	drives = drives >> 2;

	for (x=0; x<24; x++)
	{
		if (drives & 1!=0)
		{
			cout << (char) ('C'+x) << endl;
			curDir[0] = (char) ('C'+x);
			curDir[1] = ':';
			curDir[2] = '\\';
			curDir[3] = '\0';
			ListDirectoryContents(curDir, 
				findName);
		}
		drives = drives >> 1;
	}
	cout << endl;

	return( 0 );
}
