//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code shows how to create multiple instances of a single
// thread function.
//***************************************************************

// thread3.cpp

#include <windows.h>
#include <stdlib.h>
#include <iostream.h>

typedef struct
{
  DWORD frequency;
  DWORD duration;
  DWORD iterations;
} honkParams;

void HonkThread(honkParams *params)
{
  DWORD i;

  for (i=0; i<params->iterations; i++)
  {
    Beep(params->frequency, params->duration);
    Sleep(1000);
  }

  GlobalFree(params);
}

void main(void)
{
  HANDLE honkHandles[3];
  DWORD threadID;
  honkParams *params;
  DWORD count;
  CHAR freqStr[100];
  CHAR durStr[100];
  CHAR iterStr[100];

  for (count=0; count<3; count++)
  {
    // allocate memory for a "params" structure
    params=(honkParams *) GlobalAlloc(GPTR, 
      sizeof(honkParams));

    cout << "Enter the beep frequency: ";
    cin.getline(freqStr, 100);
    params->frequency=atoi(freqStr);

    cout << "Enter the beep duration: ";
    cin.getline(durStr, 100);
    params->duration=atoi(durStr);

    cout << "Enter the number of beeps: ";
    cin.getline(iterStr, 100);
    params->iterations=atoi(iterStr);

    // create a thread and pass it the pointer 
    // to its "params" struct
    honkHandles[count]=CreateThread(0, 0,
      (LPTHREAD_START_ROUTINE) HonkThread, 
      params, 0, &threadID);
  }

  // wait for all threads to finish execution
  WaitForMultipleObjects(3, honkHandles, 
    TRUE, INFINITE);  
}
