//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates the use of asynchronous change
// functions.
//***************************************************************

//filefind.cpp

#include <iostream.h> 
#include <windows.h>

int main(int argc, char *argv[])
{
	HANDLE changeHandle;

	// Wait for a file name change in the 
	// current directory
	changeHandle = FindFirstChangeNotification(".", 
		FALSE, FILE_NOTIFY_CHANGE_FILE_NAME);
	cout << "Waiting for a change ..." 
		<< endl;
	WaitForSingleObject(changeHandle, INFINITE);
	cout << "A file name changed." << endl;

	// Wait for a second change
	FindNextChangeNotification(changeHandle);
	cout << "Waiting for a 2nd change ..." 
		<< endl;
	WaitForSingleObject(changeHandle, INFINITE); 
	cout << "A file name changed." << endl;

	// quit
	FindCloseChangeNotification(changeHandle);
	return( 0 );
}
