//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code implements a multi-threaded client.
//***************************************************************

// mtnpclnt.cpp

#include <windows.h>
#include <iostream.h>
#include <stddef.h>
#include <process.h>

#define BUFSIZE 128

// The thread receives all messages from
// from the server
void mtnpServerThread(HANDLE mtnpPipeDup)
{
  CHAR textBuffer[BUFSIZE];
  DWORD numBytesRead;
  OVERLAPPED overlappedRead;

  // Init the overlapped structure
  overlappedRead.Offset = 
    overlappedRead.OffsetHigh = 0;
  overlappedRead.hEvent = 
    CreateEvent(0, TRUE, FALSE, 0);

  while (1)
  {
    // Read a message from the server
    if (!ReadFile(mtnpPipeDup,
      textBuffer, BUFSIZE,
      &numBytesRead, &overlappedRead))
    {
      if (GetLastError() != ERROR_IO_PENDING)
      {
        cerr << 
          "ERROR: Unable to read from named pipe"
          << endl;
        break;
      }
    }
    GetOverlappedResult(mtnpPipeDup,
      &overlappedRead, &numBytesRead,
      TRUE); 
    overlappedRead.Offset += numBytesRead;

    // send the message to the screen
    cout << textBuffer << endl;
  } /* while */

  // clean up the pipe
  FlushFileBuffers(mtnpPipeDup);
  DisconnectNamedPipe(mtnpPipeDup);
  CloseHandle(mtnpPipeDup);
}

// The main function opens a handle
// to the pipe and then writes to it
INT main(VOID)
{
  CHAR textToSend[BUFSIZE];
  HANDLE mtnpPipe;
  DWORD mtnpThread;
  DWORD numBytesWritten;
  BOOL success;
  OVERLAPPED overlappedWrite;
  char machineName[80];
  char pipeName[80];

  cout << "Enter name of server machine: ";
  cin.getline(machineName,80);
  wsprintf(pipeName, "\\\\%s\\pipe\\mtnp", 
    machineName);

  // init overlapped structure
  overlappedWrite.Offset =
    overlappedWrite.OffsetHigh = 0;
  overlappedWrite.hEvent = 
    CreateEvent(0, TRUE, FALSE, 0);

  // Create the named pipe file handle for
  // sending messages 
  mtnpPipe=CreateFile(pipeName,
    GENERIC_WRITE | GENERIC_READ,
    0, 
    (LPSECURITY_ATTRIBUTES) NULL,
    OPEN_EXISTING, 
    FILE_ATTRIBUTE_NORMAL|FILE_FLAG_OVERLAPPED,
    (HANDLE) NULL);
  // Check and see if the named pipe file was
  // opened, if not terminate program 
  if (mtnpPipe == INVALID_HANDLE_VALUE)
  {
    cerr << "ERROR: Unable to create a named pipe "
      << GetLastError()
      << endl;
    return (1);
  }

  // Set the pipe into message mode
  DWORD mode = PIPE_READMODE_MESSAGE | PIPE_WAIT;
  success = SetNamedPipeHandleState(mtnpPipe,
    &mode, 0, 0);
  if (!success)
  {
    cerr << "ERROR: Unable to set pipe mode"
      << endl;
    return (1);
  }

  // Begin a separate thread to read from
  // the pipe
  mtnpThread = _beginthread(mtnpServerThread,
    0, (HANDLE) mtnpPipe);
  if (mtnpThread == -1)
  {
    cerr << "ERROR: Unable to create thread"
      << endl;
    CloseHandle(mtnpPipe);
  }

  // Repeatedly send messages to the pipe
  // until program is terminated 
  while(1)
  {
    cout << "Type text to send: ";
    cin.getline(textToSend, BUFSIZE);

    // Write message to named pipe
    if (!WriteFile(mtnpPipe,
      textToSend, strlen(textToSend) + 1,
      &numBytesWritten, &overlappedWrite))
    {
      if (GetLastError() != ERROR_IO_PENDING)
      {
        cerr 
          << "ERROR: Unable to write to pipe "
          << GetLastError() << endl;
        CloseHandle(mtnpPipe);
        return (1);
      }
    }
    GetOverlappedResult(mtnpPipe,
      &overlappedWrite, &numBytesWritten,
      TRUE); 
    overlappedWrite.Offset += numBytesWritten;

  } // while
  return (0);
}
