//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code implements the monitor portion of ranmon.
//***************************************************************

// ranmon.cpp

// Usage: ranmon

#include <windows.h>
#include <string.h>
#include "ran.h"

#define TITLE_NAME "Run And Notify MONitor"
#define MAX_USERNAME 15

int WINAPI WinMain(HANDLE ghInstance, 
  HANDLE hPrevInstance, LPSTR lpCmdLine,
  int nCmdShow)
{
  HANDLE RANSlot;
  DWORD NumBytesRead;
  DWORD length;
  RANData randata;
  char slotPath[MAX_PATH];
  char msgString[255];
  char tmp[85];
  char userName[MAX_USERNAME + 1];

  strcpy(slotPath, "\\\\.\\mailslot\\ran\\");
  length=sizeof(userName);
  GetUserName(userName, &length);
  strcat(slotPath, userName);

  /* Create a mailslot for receiving messages */
  RANSlot=CreateMailslot(slotPath, sizeof(RANData),
    MAILSLOT_WAIT_FOREVER, 
    (LPSECURITY_ATTRIBUTES) NULL);

  /* Check and see if the mailslot was created */
  if (RANSlot == INVALID_HANDLE_VALUE)
  {
    MessageBox(NULL, 
      "ERROR: Unable to create mailslot.",
      TITLE_NAME, MB_OK | MB_ICONHAND);
    return(1);
  }

  /* Repeatedly check for messages until 
     the program terminates */
  while(1)
  {
    /* Read a message and check to see if 
       read was successful */
    if (!ReadFile(RANSlot, &randata,
      sizeof(RANData),
      &NumBytesRead, (LPOVERLAPPED) NULL))
    {
      MessageBox(NULL, 
        "ERROR: Unable to read from mailslot.",
        TITLE_NAME, MB_OK | MB_ICONHAND);
      CloseHandle(RANSlot);
      return(1);
    }

    if (randata.stopMonitors == 1) return(0);

    strcpy(msgString, "The application \"");
    strcat(msgString, randata.AppName);
    strcat(msgString, "\" executing on ");
    strcat(msgString, randata.WkstnName);
    strcat(msgString, " has finished.\n\n");
    wsprintf(tmp, "It executed for: %ld hours, \
%ld minutes, and %ld seconds.",
      randata.RunHrs, randata.RunMin, 
      randata.RunSec);
    strcat(msgString, tmp);
    MessageBox(NULL, msgString,
      TITLE_NAME, MB_SETFOREGROUND | MB_OK
      | MB_ICONINFORMATION);
  } /* while */
}
