//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code implements the RPC server.
//***************************************************************

// mandels2.cpp

#include <windows.h>
#include <iostream.h>
#include <rpc.h>
#include "ccrpc2.h"
#include "memstub"

INT main(VOID)
{
  // use the protocols specified in 
  // the IDL file for this interface
  if (RpcServerUseAllProtseqsIf(1, 
    calcline_ServerIfHandle,
    NULL))
  {
    cerr 
      << "ERROR: Could not specify protocols" 
      << endl;
    return(1);
  }

  // register the interface
  if (RpcServerRegisterIf(calcline_ServerIfHandle,
    NULL, NULL))
  {
    cerr << 
      "ERROR: Could not register interface handle"
      << endl;
    return(1);
  }

  // listen for and service RPC requests
  if (RpcServerListen(1, 5, FALSE))
  {
    cerr << 
      "ERROR: Unable to listen for RPC requests" 
      << endl;
    return(1);
  }

  return(0);
}
