//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code shows how to set a service's configuration 
// information, in this case by changing a service to auto-start.
//***************************************************************

// setcon.cpp

#include <windows.h>
#include <iostream.h>

void ErrorHandler(char *s, DWORD err)
{
	cout << s << endl;
	cout << "Error number: " << err << endl;
	ExitProcess(err);
}

void main(int argc, char *argv[])
{
	SC_HANDLE service, scm;
	BOOL success;
	SC_LOCK lock;

	if (argc != 2)
	{
		cout << "Usage:\n";
		cout << "   setcon service_name\n";
		return;
	}
	
	// Open a connection to the SCM
	scm = OpenSCManager(0, 0, 
		SC_MANAGER_ALL_ACCESS | GENERIC_WRITE);
	if (!scm)
		ErrorHandler("In OpenScManager",
			GetLastError());

	lock = LockServiceDatabase(scm);
	if (lock == 0)
		ErrorHandler("In LockServiceDatabase", 
			GetLastError());

	// Get the service's handle
	service = OpenService(
		scm, argv[1],
		SERVICE_ALL_ACCESS);
	if (!service)
	{
		DWORD err = GetLastError();
		UnlockServiceDatabase(lock);
		ErrorHandler("In ChangeServiceConfig", err);
	}

	// Change the service to automatic start mode 
	success = ChangeServiceConfig(
		service,
		SERVICE_NO_CHANGE,
		SERVICE_AUTO_START,
		SERVICE_NO_CHANGE,
		0, 0, 0, 0, 0, 0, 0);
	if (!success)
	{
		DWORD err = GetLastError();
		UnlockServiceDatabase(lock);
		ErrorHandler("In ChangeServiceConfig", err);
	}
	
	// unlock the database
	success = UnlockServiceDatabase(lock);
	if (!success)
		ErrorHandler("In UnlockServiceDatabase", 
			GetLastError());

	// Clean up
	CloseServiceHandle(service);
	CloseServiceHandle(scm);
}
