// File referred to (not printed) on page 141 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT01.ZIP 2/21/95
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: STKTEST.CPP -- Test of nested linked list
#include "..\2\stack.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

main(int argc, char** argv) {
  stack textlines;
  FILE* file;
  #define BUFSIZE 100
  char buf[BUFSIZE];
  assert(argc == 2); // File name is argument
  textlines.initialize();
  file = fopen(argv[1], "r");
  assert(file);
  // Read file and store lines in the stack:
  while(fgets(buf, BUFSIZE, file)) {
    char* string =
      (char*)malloc(strlen(buf) + 1);
    assert(string);
    strcpy(string, buf);
    textlines.push(string);
  }
  // Pop lines from the stack and print them:
  char* s;
  while((s = (char*)textlines.pop()) != 0)
    printf("%s", s);
}
