// File from page 292 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT01.ZIP 2/21/95
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: SSTACK.CPP -- Enums inside classes
#include <string.h>
#include <iostream.h>

class StringStack {
  enum { size = 100 };
  const char* stack[size];
  int index;
public:
   StringStack();
   void push(const char* s);
   const char* pop();
};

StringStack::StringStack() : index(0) {
  memset(stack, 0, size * sizeof(char*));
}

void StringStack::push(const char* s) {
  if(index < size)
    stack[index++] = s;
}

const char* StringStack::pop() {
  if(index > 0) {
    const char* rv = stack[--index];
    stack[index] = 0;
    return rv;
  }
  return 0;
}

const char* iceCream[] = {
  "pralines & cream",
  "fudge ripple",
  "jamocha almond fudge",
  "wild mountain blackberry",
  "raspberry sorbet",
  "lemon swirl",
  "rocky road",
  "deep chocolate fudge"
};

const ICsz = sizeof iceCream/sizeof *iceCream;

main() {
  StringStack SS;
  for(int i = 0; i < ICsz; i++)
    SS.push(iceCream[i]);
  const char* cp;
  while((cp = SS.pop()) != 0)
    cout << cp << endl;
}
