// File from page 315 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT01.ZIP 2/21/95
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: CPPTIME.H -- A simple time class
#ifndef CPPTIME_H_
#define CPPTIME_H_
#include <time.h>
#include <string.h>

class Time {
  time_t T;
  tm local;
  char Ascii[26];
  unsigned char lflag, aflag;
  void updateLocal() {
    if(!lflag) {
      local = *localtime(&T);
      lflag++;
    }
  }
  void updateAscii() {
    if(!aflag) {
      updateLocal();
      strcpy(Ascii, asctime(&local));
      aflag++;
    }
  }
public:
  Time() { mark(); }
  void mark() {
    lflag = aflag = 0;
    time(&T);
  }
  const char* ascii() {
    updateAscii();
    return Ascii;
  }
  // Difference in seconds:
  int delta(Time* dt) const {
    return difftime(T, dt->T);
  }
  int DaylightSavings() {
    updateLocal();
    return local.tm_isdst;
  }
  int DayOfYear() { // Since January 1
    updateLocal();
    return local.tm_yday;
  }
  int DayOfWeek() { // Since Sunday
    updateLocal();
    return local.tm_wday;
  }
  int Since1900() { // Years since 1900
    updateLocal();
    return local.tm_year;
  }
  int Month() { // Since January
    updateLocal();
    return local.tm_mon;
  }
  int DayOfMonth() {
    updateLocal();
    return local.tm_mday;
  }
  int Hour() { // Since midight, 24-hour clock
    updateLocal();
    return local.tm_hour;
  }
  int Minute() {
    updateLocal();
    return local.tm_min;
  }
  int Second() {
    updateLocal();
    return local.tm_sec;
  }
};
#endif // CPPTIME_H_
