#include "windows.h"
#include "resource.h"
#include <stdio.h>
#include <stdlib.h>
#include "fastwave.h"
#include "commdlg.h"
#include "string.h"

BOOL __export CALLBACK MainDlgProc( HWND, UINT, WPARAM, LPARAM );
int GetFileName( char *szOpenName, char *Title, int type );

// +--------------------------------------------------------------------------+
// |           Application starts here...just start a dialog box              |
// +--------------------------------------------------------------------------+

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmd,
                        int nShow )
{
	DialogBox( hInstance, MAKEINTRESOURCE( DLG_TEST ), NULL, MainDlgProc );
	UnLoadFastWave();
	return( FALSE );
}

// +--------------------------------------------------------------------------+
// |                  Main window function (dialog box)                       |
// +--------------------------------------------------------------------------+

BOOL __export CALLBACK MainDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )

{
	char buf1[256], buf2[256];
	int	 i, wnum;
	
	switch( msg )
		{
		case WM_INITDIALOG:
			return( TRUE );
		
		case WM_COMMAND:
			{
			if( wParam == IDCANCEL )
				{
				EndDialog( hDlg, TRUE );
				return( TRUE );
				}
			if( wParam == ID_OPEN )                   
				{
				GetFileName( buf1, "Select a Vault File", 1 );
                SetDlgItemText( hDlg, IDC_EDIT3, buf1 );
				i=LoadFastWave( buf1 );
				}
			if( wParam == ID_CREATE )                   
				{
				GetFileName( buf1, "Enter the name for a new Vault File", 1 );
                SetDlgItemText( hDlg, IDC_EDIT3, buf1 );
				i=CreateFastWave( buf1 );
				}
			if( wParam == ID_ADD )                   
				{
				GetDlgItemText( hDlg, IDC_EDIT3, buf2, 255 );
				GetDlgItemText( hDlg, IDC_EDIT2, buf1, 255 );
				i=AddFastWave( buf1, buf2, "Wave name" );
				}
			if( wParam == ID_PLAY )
				{
				GetDlgItemText( hDlg, IDC_EDIT1, buf1, 255 );
				wnum = atoi( buf1 );
				i=PlayFastWave( wnum, 1 );
				}
			break;
			}
   		}
	return( FALSE );
}

//-------------------------------------------------------------------------

int GetFileName( char *szOpenName, char *Title, int type )

{
	OPENFILENAME    ofn;
	BOOL	result;	
	
	memset( &ofn, 0, sizeof(OPENFILENAME) );

	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = NULL;
	if( !type )
		ofn.lpstrFilter = "Wave Files  (*.WAV)\0*.WAV\0";
	else
		ofn.lpstrFilter = "Vault Files  (*.VLT)\0*.VLT\0";
	ofn.lpstrCustomFilter = NULL;
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = (LPSTR)szOpenName;
	ofn.nMaxFile = 128;
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrTitle = (LPSTR)Title;
	ofn.lpstrFileTitle = NULL;
	ofn.lpstrDefExt = NULL;
	ofn.Flags = 0;

	result = GetOpenFileName( (LPOPENFILENAME)&ofn );
	return result;
}

//-------------------------------------------------------------------------
