/*************************************************/
/* GraphZ.DLL demo program.                      */
/* Copyright  1995, ZSoft. All rights reserved. */
/*************************************************/

#include <windows.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include "graphZ.h"

#include "resource.h"

#define ID_GRAPHWINDOW 1

GZPOINT stat[100][1];
GZPOINT dynamic;
double x = 0;
int i;
HWND hWndGraph;
BOOL bDynamic = TRUE;



LONG FAR PASCAL _export DemoProc(HWND hWnd, WORD iMessage, WPARAM wParam, LPARAM lParam)
	{
	switch(iMessage)
		{
		case WM_CREATE:
			/* Initialize the random generator */
			randomize();

			/* Create the GraphZ window */
			hWndGraph = CreateWindow("GraphZ", "", WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE,
				0, 0, 0, 0, hWnd, ID_GRAPHWINDOW, GetWindowWord(hWnd, GWW_HINSTANCE), NULL);

			/* Load the settings */
			GZSetIni(hWndGraph, ".\\demo.grz");
			GZLoadIni(hWndGraph);
			break;

		case WM_DESTROY:
			/* Kill the timer */
			KillTimer(hWnd, 1);

			/* Exit the main message loop */
			PostQuitMessage(0);
			break;

		case WM_SYSCOMMAND:
			/* "Close" menu item in the system menu (the one on the top left corner) */
			if (wParam == SC_CLOSE)
				{
				DestroyWindow(hWnd);
				break;
				}
			else
				goto Def;

		case WM_TIMER:
			/* Generate random data (if desired) */
			if (bDynamic)
				{
				dynamic.x = (x += random(10) / 5.0);
				dynamic.y = random(101);
				dynamic.curve = 0;
				GZAddPoints(hWndGraph, &dynamic, 1);
				}
			break;

		case WM_COMMAND:
			/* Menu commands... */
			switch (wParam)
				{
				case ID_GRAPHWINDOW:
					/* GraphZ asks for validation before user action. */
					/* We don't check it in this demo. Always validate. */
					return TRUE;


				case CM_HELPTHIS_DEMO:
					MessageBox(hWnd, "This is a very simple demo (look at gzdemo.c) to demonstrate some of the GraphZ features.",
								"GraphZ Demo", MB_OK);
					break;

				case CM_USERSGUIDE:
					WinHelp(hWnd, "graphz.hlp", HELP_CONTENTS, NULL);
					break;

				case CM_MAINFEATURES:
					WinHelp(hWnd, "gz_api.hlp", HELP_KEY, (DWORD)(LPSTR)"Features");
					break;

				case ID_FILE_PRINT:
					GZPrint(hWndGraph, TRUE);
					break;

				case ID_FILE_EXIT:
					DestroyWindow(hWnd);
					break;

				case ID_FILE_LOAD:
					GZLoadIni(hWndGraph);
					break;

				case ID_FILE_SAVE:
					GZWriteIni(hWndGraph);
					break;

				case CM_INTERACTSETTINGS:
					GZShowSettingsDialog(hWndGraph);
					break;

				case CM_INTERACTPRINT:
					GZPrint(hWndGraph, FALSE);
					break;

				case CM_INTERACTEXTENDED_LAYOUT:
					GZShowAllObjects(hWndGraph, TRUE);
					break;

				case CM_INTERACTMINIMUM_LAYOUT:
					GZShowAllObjects(hWndGraph, FALSE);
					break;

				case CM_INTERACTREFRESH:
					GZRefresh(hWndGraph);
					break;

				case CM_CLEAR:
					GZClearBuffers(hWndGraph);
					break;

				case CM_GENERATE_STATICSINE:
					for (i =0; i < 100; i++)
						{
						stat[i][0].x = ++x;
						stat[i][0].y = 50 + 50 * sin(i * 0.2);
						stat[i][0].curve = 0;
						}
					GZAddPointsSeries(hWndGraph, (GZPOINT huge **)stat, 1, 100);
					break;

				case CM_GENERATE_STATICTRIANGLE:
					for (i =0; i < 100; i++)
						{
						stat[i][0].x = ++x;
						stat[i][0].y = 10 * abs(i % 20 - 10);
						stat[i][0].curve = 0;
						}
					GZAddPointsSeries(hWndGraph, (GZPOINT huge **)stat, 1, 100);
					break;

				case CM_GENERATE_STATICRANDOM:
					for (i =0; i < 100; i++)
						{
						stat[i][0].x = (x += random(10) / 5.0);
						stat[i][0].y = random(101);
						stat[i][0].curve = 0;
						}
					GZAddPointsSeries(hWndGraph, (GZPOINT huge **)stat, 1, 100);
					break;

				case CM_GENERATE_DYNAMICSTART:
					bDynamic = TRUE;
					break;

				case CM_GENERATE_DYNAMICSTOP:
					bDynamic = FALSE;
					break;

				default:
					goto Def;
				}
			break;

		case WM_SIZE:
			/* Tell the GraphZ window to always occupy the entire client area */
			MoveWindow(hWndGraph, 0, 0, LOWORD(lParam), HIWORD(lParam), TRUE);
			break;

		default:
			Def:
			return DefWindowProc(hWnd, iMessage, wParam, lParam);
		}
	return 0L;
	}




int PASCAL WinMain (HINSTANCE hInst, HINSTANCE hPrev, LPSTR lpszCmdLine, int nCmdShow)
	{
	WNDCLASS wndclass;
	MSG msg;
	HWND hWnd;
	HDC hDC;

	/* Test the video card */
	hDC = GetDC(NULL);
	if (GetDeviceCaps(hDC, COLORRES) < 8)
		{
		MessageBox(NULL, "You would need at least a 256 color display for this software to work correctly.",
			"GraphZ Demo", MB_OK | MB_ICONEXCLAMATION);
		}
	ReleaseDC(NULL, hDC);

	/* Set the logo for all the GraphZ windows from now on */
	GZSetWMFLogo("genlogo.wmf");

	/* Declare the demo window class */
	wndclass.style = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc = (WNDPROC)DemoProc;
	wndclass.cbClsExtra = 0;
	wndclass.cbWndExtra = 0;
	wndclass.hInstance = hInst;
	wndclass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground = GetStockObject(LTGRAY_BRUSH);
	wndclass.lpszMenuName = "DemoMenu";
	wndclass.lpszClassName = "DemoClass";
	if (!RegisterClass(&wndclass))
		return 0;

	/* Create the demo window */
	hWnd = CreateWindow("DemoClass", "GraphZ Demo",
		WS_OVERLAPPEDWINDOW | WS_VISIBLE, CW_USEDEFAULT, CW_USEDEFAULT,
		CW_USEDEFAULT, CW_USEDEFAULT, NULL, 0, hInst, NULL);

	/* Create a time for dynamic data generation */
	SetTimer(hWnd, 1, 10, NULL);

	/* Main message loop */
	while (GetMessage(&msg, NULL, 0, 0))
		{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
		}

	return(msg.wParam);
	}
