If(0)

    DATA STORED IN UNIV FILE FOR CLIENTS

    code is the client code

    clnt^[code]^attn    = The attention to string
    clnt^[code]^add1    = Client address line 1
    clnt^[code]^add2    = Client address line 2
    clnt^[code]^add3    = Client address line 3
    clnt^[code]^add4    = Client address line 4

    clnt_code^[code]    = The Clients name

    DATA STORED IN UNIV FILE FOR CLIENT BRANCHES

    client is the client code that the branch belongs to
    code is the branch code

    clbr^[client]^[code]^attn   = The attention to string
    clbr^[client]^[code]^add1   = Client branch address line 1
    clbr^[client]^[code]^add2   = Client branch address line 2
    clbr^[client]^[code]^add3   = Client branch address line 3
    clbr^[client]^[code]^add4   = Client branch address line 4

    clbr_code^[client]^[code]   = Client branch name

Endif
Define ClientSearchCode(key, type) {
    Explode(key, "^", &code);
    if (type != "s")
        return code;
    return StrCat(code, "\t", univ^clnt_code^[code]);
}
Define ClientMaintScr() {
    scr = SdCreate(, -1, -1, 18, 72, "Client Maintenance");

    SdPrompt(scr, 1,  1, "Client Code     :");
    SdCombo(scr, "code",  0,  1, 19, 12, 10, , 
                    "univ^clnt_code^", 133, "ClientSearchCode", 62, , 134);
    SdFieldCols(scr, "code", 10);
    SdPrompt(scr, 3,  1, "Client Name     :");
    SdString(scr, "desc", 0,  3, 19, 50);
    SdPrompt(scr, 5,  1, "Attention       :");
    SdString(scr, "attn", 0,  5, 19, 50);
    SdPrompt(scr, 7,  1, "Address         :");
    SdString(scr,"add1", 0,  7, 19, 50);
    SdString(scr,"add2", 0,  8, 19, 50);
    SdString(scr,"add3", 0,  9, 19, 50);
    SdString(scr,"add4", 0, 10, 19, 50);

    SdButton(scr, "ok",   0, 16, 16, 10, "Maint", "m", 1);
    SdButton(scr, "bra",  0, 16, 29, 10, "Branches", "b", 112);
    SdButton(scr, "del",  0, 16, 42, 10, "Delete", "d", 114);
    SdButton(scr, "can",  1, 16, 55, 10, "Cancel", "", 2);
    return scr;
}
Define ClientDeleteBranches(code) {
    while (1) {
        Explode(next(univ^clbr_code^[code]^[branch]),"^", &p1, &p2, &branch);
        if (p2 != code || p1 != "clbr_code")
            break;
        ClientBranchDelete(code, branch);
    }
}
Define ClientDelete(code) {
    while(field = NextField("univ", "clnt", code, field))
        univ^clnt^[code]^[field] = "";
    univ^clnt_code^[code] = "";
}
Define ClientMaint() {
    scr = ClientMaintScr();
    mode = 1;
    cursor = "";
    while (1) {
        if (!cursor) {
            if (mode) {
                SdModeSet(scr, 0);
                SdModeSet(scr, 1, "code", "bra", "del", "can");
                SdButton(scr, "ok",   1, 16, 16, 10, "Maint", "m", 1);
            }
            else {
                SdModeSet(scr, 1);
                SdModeSet(scr, 0, "code", "bra", "del");
                if (univ^clnt_code^[code])
                    SdButton(scr, "ok",   1, 16, 16, 10, "Modify", "m", 1);
                else
                    SdButton(scr, "ok",   1, 16, 16, 10, "Add", "a", 1);
            }
            SdFieldVar(scr, "code",     code,
                            "desc",     &univ^clnt_code^[code],
                            "attn",     &univ^clnt^[code]^attn,
                            "add1",     &univ^clnt^[code]^add1,
                            "add2",     &univ^clnt^[code]^add2,
                            "add3",     &univ^clnt^[code]^add3,
                            "add4",     &univ^clnt^[code]^add4);
        }
        cmd = SdEdit(scr, cursor);
        if (mode) {
            Explode(SdFieldGet(scr, "code"), "^", &code);
            if (cmd == 133)             /* action on the combo box */
                continue;
            else if (cmd == 2 || cmd == 3)
                break;
            else if (cmd != 1 && cmd != 134) {
                if (!univ^clnt_code^[code]) {
                    MsgWait("", "Client Code does not exist.");
                    continue;
                }
                if (cmd == 114) {       /* delete */
                    if ((cmd = MsgYesNoCancel("", 
                                "Delete " . code . ", are you sure ?")) 
                                && cmd == 2) {      /* yes hit ? */
                        ClientDeleteBranches(code);
                        ClientDelete(code);
                    }
                }
                else if (cmd == 112)    /* branches */
                    ClientBranchMaint(code);
                continue;
            }
            mode = 0;                   /* means change details */
        }
        else {
            if (cmd == 1) {
                if (!SdFieldGet(scr, "desc")) {
                    MsgWait("", "Client Name must be entered.");
                    cursor = "desc";
                    continue;
                }
                SdUpdate(scr);
            }
            else if (cmd == 3) 
                break;
            mode = 1;                   /* means do next selection */
        }
        cursor = "";
    }
    SdDestroy(scr);
}
Define ClientBranchSearchCode(key, type, prefix) {
    Explode(key, "^", &code);
    if (type != "s")
        return code;
    return StrCat(code, "\t", univ^[prefix][code]);
}
Define ClientBranchMaintScr(client) {
    scr = SdCreate(, -1, -1, 18, 72, 
                   StrCat("Client Branch Maintenance - ", client));

    SdPrompt(scr, 1,  1, "Branch Code     :");
    SdCombo(scr, "code",  0,  1, 19, 12, 10, "", 
                            StrCat("univ^clbr_code^", client, "^"), 
                            133, "ClientBranchSearchCode", 62);
    SdFieldCols(scr, "code", 10);
    SdPrompt(scr, 3,  1, "Branch Name     :");
    SdString(scr, "desc", 0,  3, 19, 50);
    SdPrompt(scr, 5,  1, "Attention       :");
    SdString(scr, "attn", 0,  5, 19, 50);
    SdPrompt(scr, 7,  1, "Address         :");
    SdString(scr,"add1", 0,  7, 19, 50);
    SdString(scr,"add2", 0,  8, 19, 50);
    SdString(scr,"add3", 0,  9, 19, 50);
    SdString(scr,"add4", 0, 10, 19, 50);

    SdButton(scr, "ok",   0, 16, 29, 10, "Maint", "m", 1);
    SdButton(scr, "del",  0, 16, 42, 10, "Delete", "d", 114);
    SdButton(scr, "can",  1, 16, 55, 10, "Cancel", "", 2);
    return scr;
}
Define ClientBranchDelete(client, code) {
    while(1) {
        Explode(next(univ^clbr^[client]^[code]^[field]), "^",
                            &p1, &p2, &p3, &field);
        if (p3 != code || p2 != client || p1 != "clbr")
            break;
        univ^clbr^[client]^[code]^[field] = "";
    }
    univ^clbr_code^[client]^[code] = "";
}
Define ClientBranchMaint(client) {
    scr = ClientBranchMaintScr(client);
    mode = 1;
    cursor = "";
    while (1) {
        if (!cursor) {
            if (mode) {
                SdModeSet(scr, 0);
                SdModeSet(scr, 1, "code", "del", "can");
                SdButton(scr, "ok",   1, 16, 29, 10, "Maint", "m", 1);
            }
            else {
                SdModeSet(scr, 1);
                SdModeSet(scr, 0, "code", "del");
                if (univ^clbr_code^[client]^[code])
                    SdButton(scr, "ok",   1, 16, 29, 10, "Modify", "m", 1);
                else
                    SdButton(scr, "ok",   1, 16, 29, 10, "Add", "a", 1);
            }
            SdFieldVar(scr, "code",     code,
                            "desc",     &univ^clbr_code^[client]^[code],
                            "attn",     &univ^clbr^[client]^[code]^attn,
                            "add1",     &univ^clbr^[client]^[code]^add1,
                            "add2",     &univ^clbr^[client]^[code]^add2,
                            "add3",     &univ^clbr^[client]^[code]^add3,
                            "add4",     &univ^clbr^[client]^[code]^add4);
        }
        cmd = SdEdit(scr, cursor);
        if (mode) {
            Explode(SdFieldGet(scr, "code"), "^", &code);
            if (cmd == 133)             /* action on the combo box */
                continue;
            else if (cmd == 2 || cmd == 3)
                break;
            else if (cmd != 1) {
                if (!univ^clbr_code^[client]^[code]) {
                    MsgWait("", "Client Code does not exist.");
                    continue;
                }
                if (cmd == 114) {       /* delete */
                    if ((cmd = MsgYesNoCancel("", 
                                "Delete " . code . ", are you sure ?")) 
                        && cmd == 2)        /* yes hit ? */
                        ClientBranchDelete(client, code);
                }
                continue;
            }
            mode = 0;                   /* means change details */
        }
        else {
            if (cmd == 1) {
                if (!SdFieldGet(scr, "desc")) {
                    MsgWait("", "A description must be entered.");
                    cursor = "desc";
                    continue;
                }
                SdUpdate(scr);
            }
            else if (cmd == 3)
                break;
            mode = 1;                   /* means do next selection */
        }
        cursor = "";
    }
    SdDestroy(scr);
}

