If(0)

    DATA STORED IN INVOICE FILE

    code is invoice number

    inv^[code]^date = invoice date
    ..........^job  = job number
    ..........^clnt = client code
    ..........^brch = branch code
    ..........^vamt = valuation amount
    ..........^vtyp = valuation type
    ..........^ptyp = property type
    ..........^appl = applicant name
    ..........^loan = loan account number
    ..........^add1 = address text
    ..........^add2
    ..........^add3
    ..........^add4
    ..........^aiv  = scheduled fee (aust inst valuers)
    ..........^base = base valuation amount
    ..........^extr = extras amount
    ..........^feet = fee text

    invnum^new      = The next invoice number to automatically allocate.

    The keys that are defined. Code assumes all keys start with inv_

    inv_clbr^[clnt]^[brch]^[date]^[code]            = "y"

    inv_mecb^[MonthEnd(date)]^[clnt]^[brch]^[code]  = "y"

    inv_mecl^[MonthEnd(date)]^[clnt]^[code]         = "y"

    inv_date^[date]^[code]                          = "y"

    inv_job^[job]^[code]                            = "y"

    inv_ptyp^[ptyp]^[clnt]^[code]                   = "y"

    inv_vtyp^[vtyp]^[clnt]^[code]                   = "y"

Endif
If(0)
    Following Eval will setup default valuation and property types and 
    invoice printer definitions in univ
Endif
Eval {
    univ^vtyp_code^mv  = "Mortgage Valuation";
    univ^vtyp_code^nmv = "Non Mortgage Valuation";
    univ^vtyp_code^pi  = "Progress Inspections";

    univ^ptyp_code^d   = "Domestic Premises";
    univ^ptyp_code^ft  = "Flats and Townhouses";
    univ^ptyp_code^cp1 = "Commercial Premises to $5,000,000";
    univ^ptyp_code^cp2 = "Commercial Premises above $5,000,000";
    univ^ptyp_code^gvt = "Government and Semi Govt Properties";
    univ^ptyp_code^ip1 = "Industrial Premises to $5,000,000";
    univ^ptyp_code^ip2 = "Industrial Premises above $5,000,000";
    univ^ptyp_code^lp  = "Licenced Premises";
    univ^ptyp_code^m   = "Motels";
    univ^ptyp_code^hr  = "Holiday Resorts over $2,000,000";
    univ^ptyp_code^ca  = "Caravan Parks (under $2,000,000)";
    univ^ptyp_code^sr  = "Semi-rural";
    univ^ptyp_code^ra  = "Rental Assessment";
    univ^ptyp_code^or  = "Other";

    parm^prt^inv^name   = "";
    parm^prt^inv^copies = 1;
    parm^prt^inv^append = "";
    parm^prt^inv^browse = "b";
    parm^page^inv^height = 66;
    parm^page^inv^width  = 80;
    parm^page^inv^margin^top    = 3;
    parm^page^inv^margin^bottom = 3;
    parm^page^inv^margin^left   = 0;
    parm^page^inv^margin^right  = 0;
}
Define InvSearchCode(key, type) {
    Explode(key, "^", &code);
    if (type != "s")
        return code;
    return code. "\t". data^inv_code^[code];
}
Define InvSearchClient(key, type)   {
    Explode(key, "^", &code);
    if (type != "s")
        return code;
    return code. "\t". univ^clnt_code^[code];
}
Define InvSearchBranch(key, type)   {
    Explode(key, "^", &code);
    if (type != "s")
        return code;
    return code. "\t". univ^clbr_code^[code];
}
Define InvSearchPtyp(key, type) {
    Explode(key, "^", &code);
    if (type != "s")
        return code;
    return code. "\t". univ^ptyp_code^[code];
}
Define InvSearchVtyp(key, type) {
    Explode(key, "^", &code);
    if (type != "s")
        return code;
    return code. "\t". univ^vtyp_code^[code];
}
Define InvSearchAlt(key, type) {
    Explode(key, "^", &alt, &code);
    if (type != "s")
        return alt;
    return alt. "\t". code. "\t". data^inv_code^[code];
}
Define InvSearchAltClbr(key, type) {
    Explode(key, "^", &client, &branch, &date, &code);
    alt = client. "^". branch;
    if (type != "s")
        return alt;
    return alt. "\t". code. "\t". data^inv_code^[code];
}
Define InvSearch(invCode) {
    code = invCode;
    scr = SdCreate(, -2, -2, 12, 68, "Invoice Search");

    SdPrompt(scr, 1,  3, "Invoice No      :");
    SdCombo(scr, "code",  1,  1, 21, 10, 10, "", "data^inv_code^", 133, 
                                           "InvSearchCode", 70, , 139);
    SdFieldCols(scr, "code", 8);
    SdPrompt(scr, 3,  3, "Client^Branch   :");
    SdCombo(scr, "clbr",  1,  3, 21, 21, 10, "", "data^inv_clbr^", 134, 
                                            "InvSearchAltClbr", 70, , 139);
    SdFieldCols(scr, "clbr", 18, 8);
    SdPrompt(scr, 4,  3, "Date            :");
    SdCombo(scr, "date",  1,  4, 21, 14, 10, "", "data^inv_date^",  135, 
                                            "InvSearchAlt", 70, , 139);
    SdFieldCols(scr, "date", 12, 8);
    SdPrompt(scr, 5,  3, "Job No          :");
    SdCombo(scr, "job",   1,  5, 21, 10, 10, "", "data^inv_job^",  136, 
                                           "InvSearchAlt", 70, , 139);
    SdFieldCols(scr, "job", 8, 8);
    SdPrompt(scr, 6,  3, "Valuation Type  :");
    SdCombo(scr, "vtyp",  1,  6, 21, 12, 10, "", "data^inv_vtyp^", 137, 
                                           "InvSearchAlt", 70, , 139);
    SdFieldCols(scr, "vtyp", 8, 8);
    SdPrompt(scr, 7,  3, "Property Type   :");
    SdCombo(scr, "ptyp",  1,  7, 21, 12, 10, "", "data^inv_ptyp^", 138, 
                                           "InvSearchAlt", 70, , 139);
    SdFieldCols(scr, "ptyp", 8, 8);
    SdPrompt(scr, 9,  3, "Applicant       :");
    SdString(scr,"appl",  0,  9, 21, 40);

    SdButton(scr, "ok",   1, 11, 39, 10, "OK", "", 1);
    SdButton(scr, "can",  1, 11, 52, 10, "Cancel", "", 2);

    setFields = "y";

    while (1) {
        if (setFields) {
            setFields = "";

            SdFieldSet(scr, "code",     code);
            data^inv_code^[code] ?
                SdFieldSet(scr, "clbr", data^inv^[code]^clnt . "^" .
                                        data^inv^[code]^brch . "^" .
                                        data^inv^[code]^date . "^" . code,
                                "date", data^inv^[code]^date . "^" . code,
                                "job",  data^inv^[code]^job . "^" . code,
                                "vtyp", data^inv^[code]^vtyp . "^" . code,
                                "ptyp", data^inv^[code]^ptyp . "^" . code,
                                "appl", data^inv^[code]^appl)
            :
                SdFieldSet(scr, "clbr", "",
                                "date", "",
                                "job",  "",
                                "vtyp", "",
                                "ptyp", "",
                                "appl", "");
        }
        cmd = SdEdit(scr, cursor);
        code = SdFieldGet(scr, "code");
        switch (cmd) {
        case 133:                   /* code combo box */
            cursor = "code";
            setFields = "y";
            continue;

        case 134:                   /* client branch combo */
            cursor = "clbr";
            Explode(SdFieldGet(scr, cursor), "^", "", "", "", &code);
            setFields = "y";
            continue;

        case 135:                   /* data combo */
            cursor = "date";
            goto GETCODE;
        case 136:
            cursor = "job";
            goto GETCODE;
        case 137:
            cursor = "vtyp";
            goto GETCODE;
        case 138:
            cursor = "ptyp";
        GETCODE:
            Explode(SdFieldGet(scr, cursor), "^", "", &code);
            setFields = "y";
            continue;

        case 1:                         /* Enter button or key */
        case 139:                       /* Double clicked any combo */
            if (SdFieldMod(scr) > 0 &&
                !(SdFieldMod(scr) == 1 && SdFieldMod(scr, "code"))) {
                /*
                    the text of a field was modified, and it wasnt just
                    the code field
                */
                MsgWait(, "You must select using a Combo Box");
                if (SdFieldMod(scr, "clbr"))
                    cursor = "clbr";
                else if (SdFieldMod(scr, "date"))
                    cursor = "date";
                else if (SdFieldMod(scr, "job"))
                    cursor = "job";
                else if (SdFieldMod(scr, "ptyp"))
                    cursor = "ptyp";
                else if (SdFieldMod(scr, "vtyp"))
                    cursor = "vtyp";
                else
                    cursor = "code";
                continue;
            }
            if (!data^inv_code^[code]) {
                MsgWait(, "Invalid Invoice No");
                cursor = "code";
                continue;
            }
            invCode = code;         /* set invoice no we are returning */
        }
        break;
    }
    SdDestroy(scr);

    return cmd;
}
Define InvPrepScr() {
    scr = SdCreate(, -1, -1, 22, 76, "Invoice Preparation");

    SdPrompt(scr, 1,  2, "Invoice No      :");
    SdCombo (scr, "code",  0,  1, 20, 10, 10, "", "data^inv_code^", 
                                            133, "InvSearchCode", 70, , 136);
    SdFieldCols(scr, "code", 8);
    SdButton(scr, "srch", 0,  1, 33, 10, "Search", "s", 134);
    SdPrompt(scr, 3,  2, "Date            :");
    SdDate  (scr,  "date",  0,  3, 20, 10);
    SdPrompt(scr, 3, 46, "Job No        :");
    SdInt   (scr,  "job",   0,  3, 62,  6);
    SdPrompt(scr, 4,  2, "Client          :");
    SdCombo (scr, "clnt",  0,  4, 20, 12, 10, "", "univ^clnt_code^", 135);
    SdPrompt(scr, 4, 46, "Branch        :");
    SdCombo (scr, "brch",  0,  4, 62, 12, 10, "", "univ^clbr_code^^");

    SdPrompt(scr, 5,  2, "Valuation Type  :");
    SdCombo (scr, "vtyp",  0,  5, 20, 12, 10, "", "univ^vtyp_code^", 0, 
                                            "InvSearchVtyp", 50);
    SdFieldCols(scr, "vtyp", 8);
    SdPrompt(scr, 5, 46, "Property Type :");
    SdCombo (scr, "ptyp",  0,  5, 62, 12, 10, "", "univ^ptyp_code^", 0, 
                                            "InvSearchPtyp", 50);
    SdFieldCols(scr, "ptyp", 8);

    SdPrompt(scr, 7,  2, "Applicant       :");
    SdString(scr,"appl",  0,  7, 20, 40);

    SdPrompt(scr, 8,  2, "Loan Account No :");
    SdString(scr,"loan",  0,  8, 20, 20);

    SdPrompt(scr,10,  2, "Property Addr   :");
    SdString(scr,"add1", 0, 10, 20, 40);
    SdString(scr,"add2", 0, 11, 20, 40);
    SdString(scr,"add3", 0, 12, 20, 40);
    SdString(scr,"add4", 0, 13, 20, 40);

    SdPrompt(scr,15,  2, "Fees -");
    SdPrompt(scr,15,  9, "AIV      :");
    SdFloat (scr,"aiv",   0, 15, 20,  9, "", 2);
    SdPrompt(scr,15, 46, "Valuation Amt :");
    SdInt   (scr,"vamt",  0, 15, 62,  9);

    SdPrompt(scr,16,  9, "Base     :");
    SdFloat (scr,"base",  0, 16, 20,  9, "", 2);
    SdPrompt(scr,17,  9, "Extras   :");
    SdFloat (scr,"extr",  0, 17, 20,  9, "", 2);
    SdPrompt(scr,18,  9, "Text     :");
    SdString(scr,"feet",  0, 18, 20, 40);

    SdButton(scr, "add",  0, 20,  9, 10, "Add", "a", 1);
    SdButton(scr, "mod",  0, 20, 22, 10, "Modify", "m", 112);
    SdButton(scr, "del",  0, 20, 35, 10, "Delete", "d", 114);
    SdButton(scr, "prt",  0, 20, 48, 10, "Print", "p", 115);
    SdButton(scr, "can",  1, 20, 61, 10, "Cancel", "", 2);
    return scr;
}
Define InvNumCancel(num)
/*
    called if we cancel adding num
*/
{
    if (num + 1 == data^invnum^new)
        data^invnum^new = num;
}
Define InvAdd(code) {
    Explode(prev(data^inv_code^[999999999]), "^", "", &auto);
    auto = auto + 1;                    /* auto is the next invoice number */
    if (auto < data^invnum^new)         /* automatically chosen */
        auto = data^invnum^new;
    data^invnum^new = auto + 1;
    num = auto;

    scr = SdCreate(, -2, -2,  5, 33, "New Invoice");
    SdPrompt(scr, 1,  4, "Next Invoice No :");
    SdInt   (scr, "code",  1,  1, 22,  6, num);
    SdButton(scr, "ok",   1,  3,  5, 10, "OK", "", 1);
    SdButton(scr, "can",  1,  3, 18, 10, "Cancel", "", 2);

    while ((cmd = SdEdit(scr)) == 1) {
        code = SdFieldGet(scr, "code");
        if (code < 0 || code > 999999) {
            MsgWait("", "Invalid Invoice No out of range.");
            continue;
        }
        if (data^inv_code^[code]) {
            MsgWait("", "Invoice No exists already.");
            continue;
        }
        else
            break;
    }
    if (cmd == 2 || cmd == 3 || num != auto)
        InvNumCancel(auto);

    SdDestroy(scr);
    return cmd;
}
Define InvKeysSet(code, value) {
/*
    set or delete the keys for invoice with number of code.
    if value is null, keys are deleted, else if "y", keys are set
*/
    date = data^inv^[code]^date;
    clnt = data^inv^[code]^clnt;
    brch = data^inv^[code]^brch;
    data^inv_job^[data^inv^[code]^job]^[code] = value;
    data^inv_date^[date]^[code] = value;
    data^inv_clbr^[clnt]^[brch]^[date]^[code] = value;
    data^inv_mecl^[DateMonthEnd(date)]^[clnt]^[date]^[code] = value;
    data^inv_mecb^[DateMonthEnd(date)]^[clnt]^[brch]^[date]^[code] = value;
    data^inv_vtyp^[data^inv^[code]^vtyp]^[code] = value;
    data^inv_ptyp^[data^inv^[code]^ptyp]^[code] = value;
}
Define InvDelete(code) {
    InvKeysSet(code, "");
    while (field = NextField("data", "inv", code, field))
        data^inv^[code]^[field] = "";
    data^inv_code^[code] = "";
}
Define InvPrep() {
    scr = InvPrepScr();
    mode = 1;
    cursor = "";
    while (1) {
        if (!cursor || cursor == "n") {
            if (mode) {
                SdModeSet(scr, 0);
                SdModeSet(scr, 1, "code", "srch", "add", "del", "prt", "can");
                SdButton(scr, "mod",  1, 20, 22, 10, "Modify", "m", 112);
            }
            else {
                SdModeSet(scr, 1);
                SdModeSet(scr, 0, "code", "srch", "del", "prt");
                if (data^inv_code^[code]) {
                    SdModeSet(scr, 0, "add");
                    SdButton(scr, "mod",  1, 20, 22, 10, "Modify", "m", 1);
                    SdCombo(scr, "brch",  1,  4, 62, 12, 10, "", 
                            "univ^clbr_code^". data^inv^[code]^clnt. "^");
                }
                else
                    SdModeSet(scr, 0, "mod");
            }
            SdFieldVar(scr, "code",     code,
                            "clnt",     &data^inv^[code]^clnt,
                            "brch",     &data^inv^[code]^brch,
                            "job",      &data^inv^[code]^job,
                            "date",     &data^inv^[code]^date,
                            "vamt",     &data^inv^[code]^vamt,
                            "vtyp",     &data^inv^[code]^vtyp,
                            "ptyp",     &data^inv^[code]^ptyp,
                            "appl",     &data^inv^[code]^appl,
                            "loan",     &data^inv^[code]^loan,
                            "add1",     &data^inv^[code]^add1,
                            "add2",     &data^inv^[code]^add2,
                            "add3",     &data^inv^[code]^add3,
                            "add4",     &data^inv^[code]^add4,
                            "aiv",      &data^inv^[code]^aiv,
                            "base",     &data^inv^[code]^base,
                            "extr",     &data^inv^[code]^extr,
                            "feet",     &data^inv^[code]^feet);
            if (!mode) {
                if (!SdFieldGet(scr, "date"))
                    SdFieldSet(scr, "date", DateToday());
            }
        }
        cmd = SdEdit(scr, cursor);
        cursor = "";
        if (mode) {
            Explode(SdFieldGet(scr, "code"), "^", &code);
            if (cmd == 133) {           /* action on the combo box */
                cursor = "n";           /* will reload fields and continue */
                continue;
            }
            else if (cmd == 134) {
                InvSearch(&code);
                continue;
            }
            else if (cmd == 1) {        /* enter or add */
                if (InvAdd(&code) != 1)
                    continue;
            }
            else if (cmd == 2 || cmd == 3) {    /* cancel or close */
                break;
            }
            else {
                if (!data^inv_code^[code]) {
                    MsgWait("", "Invoice No does not exist.");
                    continue;
                }
                if (cmd == 114) {   /* delete */
                    if ((cmd = MsgYesNoCancel("", 
                               "Delete " . code . ", are you sure ?")) 
                        && cmd == 2)        /* yes hit ? */
                        InvDelete(code);
                    continue;
                }
                else if (cmd == 115) {  /* print */
                    InvPrint(code);
                    continue;
                }                       /* else its modify and action 136 */
            }
            mode = 0;                   /* means change details */
        }
        else {
            if (cmd == 135) {
                brch = SdFieldGet(scr, "brch");
                SdCombo(scr, "brch",  1,  4, 62, 12, 10, 
                        &data^inv^[code]^brch, 
                        "univ^clbr_code^". SdFieldGet(scr, "clnt"). "^");
                SdFieldSet(scr, "brch", brch);
                cursor = "next";
                continue;
            }
            else if (cmd == 1) {
                if (!(clnt = SdFieldGet(scr, "clnt")) || !univ^clnt_code^[clnt]) {
                    MsgWait("", "Client must be specified and must exist.");
                    cursor = "clnt";
                    continue;
                }
                if ((brch = SdFieldGet(scr, "brch")) && !univ^clbr_code^[clnt]^[brch]) {
                    MsgWait("", "Specified Branch does not exist.");
                    cursor = "brch";
                    continue;
                }
                if ((ptyp = SdFieldGet(scr, "ptyp")) && !univ^ptyp_code^[ptyp]) {
                    MsgWait("", "Property Type specified does not exist.");
                    cursor = "ptyp";
                    continue;
                }
                if ((vtyp = SdFieldGet(scr, "vtyp")) && !univ^vtyp_code^[vtyp]) {
                    MsgWait("", "Valuation Type specified does not exist.");
                    cursor = "vtyp";
                    continue;
                }
                InvKeysSet(code, "");
                SdUpdate(scr);
                InvKeysSet(code, "y");
                data^inv_code^[code] = SdFieldGet(scr, "date"). "  ".
                                       SdFieldGet(scr, "clnt"). "  ".
                                       SdFieldGet(scr, "brch"). "  ".
                                       SdFieldGet(scr, "appl");
            }
            else if (cmd == 2 || cmd == 3 || num != auto) {
                InvNumCancel(code);
                if (cmd == 3)
                    break;
            }
            mode = 1;                   /* means do next selection */
        }
        cursor = "";
    }
    SdDestroy(scr);
}
Define InvKeyRebuild() {

    scr = MsgCreate("Invoice Key Rebuild");

    invCode = "inv_";
    while (1) {                         /* remove them all */
        Explode((invCode = next(data^[invCode])), "^", &pre);
        Explode(pre, "_", &p1, &p2);
        if (p1 != "inv")
            break;
        if (p2 == "code")
            continue;
        if (abort = MsgShow(scr, "Deleting " . invCode))
            break;
        data^[invCode] = "";
    }
    if (!abort) {
        code = "";
        while (1) {
            Explode(next(data^inv_code^[code]), "^", &pre, &code);
            if (pre != "inv_code")
                break;
            if (abort = MsgShow(scr, "Rebuild " . code))
                break;

            InvKeysSet(code, "y");
        }
    }
    MsgDestroy(scr);

}
Define InvRemove() {
    if (PeriodStartEndGet("Invoice Removal", &fromDate, &toDate) != 1)
        return;
    if (MsgYesNo("Invoice Removal", "Removing invoices from " .
                                    fromDate . " to " . toDate .
                                    "\n\nAre you sure ?") != 1)
        return;
                                
    scr = MsgCreate("Invoice Removal");
    date = fromDate;
    code = "";
    while (1) {
        Explode(next(data^inv_date^[date]^[code]), "^", &p1, &date, &code);
        if (p1 != "inv_date" || date > toDate)
            break;
        if (abort = MsgShow(scr, date . " Invoice " . code))
            break;
        InvDelete(code);
    }
    MsgDestroy(scr);
}
