Define PeriodStartEndGet(title, ps, pe) {
    scr = SdCreate(, -2, -2, 7, 40, title);
    fromDate = DateMonthStart(DateToday());
    toDate   = DateMonthEnd(DateToday());
    while (1) {
        SdPrompt(scr, 1,  9, "From Date  :");
        SdDate  (scr, "from",  1,  1, 22, 10, &fromDate);
        SdPrompt(scr, 3,  9, "To Date    :");
        SdDate  (scr, "to",    1,  3, 22, 10, &toDate);
        SdButton(scr, "ok",    1,  5,  9, 10, "OK", "", 1);
        SdButton(scr, "can",   1,  5, 22, 10, "Cancel", "", 2);

        if ((cmd = SdEdit(scr)) == 1) {
            SdUpdate(scr);
            if (fromDate > toDate) {
                MsgWait("", "From Date must not be after To Date.");
                continue;
            }
            ps = fromDate;
            pe = toDate;
        }
        break;
    }
    SdDestroy(scr);
    return cmd;
}
Define PeriodEndGet(title, pe) {
    scr = SdCreate(, -2, -2, 5, 40, title);
    month = DateMonth(DateToday());
    year  = DateYear(DateToday());

    SdPrompt(scr, 1,  3, "Period - Month :");
    SdInt   (scr, "mth",  1,  1, 21, 2, &month);
    SdPrompt(scr, 1, 26, "Year :");
    SdInt   (scr, "year", 1,  1, 33, 4, &year);
    SdButton(scr, "ok",   1,  3,  9, 10, "OK", "", 1);
    SdButton(scr, "can",  1,  3, 22, 10, "Cancel", "", 2);

    while ((cmd = SdEdit(scr, cursor)) == 1) {
        SdUpdate(scr);
        if (month < 0 || month > 12) {
            MsgWait("", "Invalid month name");
            cursor = "mth";
            continue;
        }
        if (year < 1900) {
            MsgWait("", "Invalid year number");
            cursor = "mth";
            continue;
        }
        pe = DateMonthEnd(StrCat("1/", month, "/", year));
        break;
    }
    SdDestroy(scr);
    return cmd;
}
Define InvSummPage(page, line, linesperpage, doc, fmtH1, fmtH2, client, periodName, periodYear) {
    if (page)
        PdPageFeed(doc);
    line = linesperpage;
    PdWrite(doc, PfFormat(fmtH1, "", page = page + 1));
    attnPrompt = attn = "";
    if (page == 1) {
        PdLineFeed(doc, 14);
        line = line - 14;
        if (attn = univ^clnt^[client]^attn)
            attnPrompt = "ATTENTION:";
    }
    PdWrite(doc, PfFormat(fmtH2, "", 
                        attnPrompt, attn,
                        univ^clnt_code^[client],
                        StrCat("Fees Due for Month of ", 
                               periodName, ", ", periodYear)));
}
Define InvSummParams(pe, clientStart, clientEnd, orderBranch) {
    scr = SdCreate(, -2, -2,  9, 55, "Monthly Invoice Summary");
    month = DateMonth(DateToday());
    year  = DateYear(DateToday());

    SdPrompt(scr, 1,  3, "Period - Month :");
    SdInt   (scr, "mth",  1,  1, 21, 2, &month);
    SdPrompt(scr, 1, 26, "Year :");
    SdInt   (scr, "year", 1,  1, 33, 4, &year);
    SdCheck (scr, "sgle", 1,  3,  3, 17, &sgle, "Single Client", "s", 31);
    SdPrompt(scr, 3, 25, "Client Code :");
    SdCombo (scr, "clnt", 0,  3, 39, 12, 10, &clnt, "univ^clnt_code^");
    SdCheck (scr, "ordr", 1,  5,  3, 28, &ordr, "Order Invoices by Branch", "b");
    SdButton(scr, "ok",   1,  7, 16, 10, "OK", "", 1);
    SdButton(scr, "can",  1,  7, 29, 10, "Cancel", "", 2);

    while (1) {
        cmd = SdEdit(scr, cursor);
        SdUpdate(scr);
        if (cmd == 31) {                // single client checkbox
            SdModeSet(scr, sgle, "clnt");
            if (sgle)
                cursor = "clnt";
            else
                cursor = "n";           // next field
            continue;
        }
        else if (cmd == 1) {
            if (month < 0 || month > 12) {
                MsgWait("", "Invalid month name");
                cursor = "mth";
                continue;
            }
            if (year < 1900) {
                MsgWait("", "Invalid year number");
                cursor = "mth";
                continue;
            }
            if (sgle && !univ^clnt_code^[clnt]) {
                MsgWait("", "Client Code selected does not exist");
                cursor = "clnt";
                continue;
            }
            pe = DateMonthEnd(StrCat("1/", month, "/", year));
            if (sgle)
                clientStart = clientEnd = clnt;
            orderBranch = ordr;
        }
        break;
    }
    SdDestroy(scr);
    return cmd;
}
Define InvSummary(argPe) {
    if (InvSummParams(&periodEnd, &clientStart, &clientEnd, &orderBranch) != 1)
        return;

    periodName  = DateMonthName(periodEnd);
    periodYear  = DateYear(periodEnd);

    scr = MsgCreate("Invoice Summary Progress");

    fmtH1 = PfCreate();
    PfInt   (fmtH1, 0, 55, 3);
    PfPrompt(fmtH1, 0, 59, "of");

    fmtH2 = PfCreate();
    PfString(fmtH2, 0,  0, 10);         /* attention */
    PfString(fmtH2, 0, 12, 40);
    PfString(fmtH2, 2,  0, 63, "c");
    PfString(fmtH2, 3,  0, 63, "c");
    PfPrompt(fmtH2, 5,  0, "   DATE");
    PfPrompt(fmtH2, 5, 13, "CLIENTS NAMES");
    PfPrompt(fmtH2, 5, 57, "AMOUNT"); 

    fmtD = PfCreate();
    PfDate  (fmtD,  0,  0, 10);
    PfString(fmtD,  0, 13, 40);
    PfFloat (fmtD,  0, 53, 10, 2);

    fmtL = PfCreate();
    PfString(fmtL,  0, 13, 40);

    fmtB = PfCreate();
    PfString(fmtB,  0,  0,  50);

    fmtT = PfCreate();
    PfString(fmtT,  1,  0, 40);
    PfFloat (fmtT,  1, 53, 10, 2);

    fmtF = PfCreate();
    PfPrompt(fmtF,  4,  0, univ^spar^invs1);
    PfPrompt(fmtF,  5,  0, univ^spar^invs2);
    PfPrompt(fmtF,  6,  0, univ^spar^invs3);
    PfPrompt(fmtF,  7,  0, univ^spar^invs4);

    linesperpage = line = parm^page^def^height -
                          parm^page^def^margin^top -
                          parm^page^def^margin^bottom -
                          7;
    append = parm^prt^def^append; 
    client = clientStart;
    branch = date = code = "";
    while (1) {
        if (orderBranch) {
            Explode(next(data^inv_mecb^[periodEnd]^[client]^[branch]^[date]^[code]), 
                    "^", 
                    &p1, &p2, &clientN, &branchN, &date, &code);

            end = p1 != "inv_mecb" || p2 != periodEnd 
                                   || (clientEnd && clientN  > clientEnd);
        }
        else {
            Explode(next(data^inv_mecl^[periodEnd]^[client]^[date]^[code]), 
                    "^", 
                    &p1, &p2,
                    &clientN, &date, &code);
                    branchN = "";           // these branch vars could go

            end = p1 != "inv_mecl" || p2 != periodEnd 
                                   || (clientEnd && clientN > clientEnd);
        }
        if (abort = MsgShow(scr, clientN . "  " . branchN .  
                                 ",  Invoice " . code)) {
            if (doc)
                PdClose(doc, abort);
            break;
        }
        if (end || clientN != client) {
            if (doc) {
                if (line < 11)
                    InvSummPage(&page, &line, linesperpage, doc, fmtH1, fmtH2, 
                                client, periodName, periodYear);
                PdWrite(doc, PfFormat(fmtT, "", 
                    StrCat(periodName, ", ", periodYear, " Total"), total));
                PdWrite(doc, PfFormat(fmtF, ""));

                PdClose(doc, 0);
                doc = 0;
            }
            if (end)
                break;
        }
        if (!doc) {
            doc = PdCreate(parm^prt^def^name, "InvSumm", append,
                        parm^prt^def^copies, parm^prt^def^browse, 
                        0, 62, 0, "",
                        parm^prt^def^start, parm^prt^def^end);
            append = "y";
            PdPageSize(doc, parm^page^def^height, parm^page^def^width,
                            parm^page^def^margin^top, parm^page^def^margin^bottom,
                            parm^page^def^margin^left, parm^page^def^margin^right);
            page =
            line = 0;
            total = 0.00;
            branch = "";
        }
        if (branchN != branch) {
            if (line < 2)
                InvSummPage(&page, &line, linesperpage, doc, fmtH1, fmtH2, 
                            clientN, periodName, periodYear);
            PdWrite(doc, PfFormat(fmtB, "", branchN));
            line = line - 1;
        }
        if (line < 2)
            InvSummPage(&page, &line, linesperpage, doc, fmtH1, fmtH2,
                        clientN, periodName, periodYear);
        PdWrite(doc, PfFormat(fmtD, "",
                              data^inv^[code]^date,
                              data^inv^[code]^appl,
                              amt = data^inv^[code]^base +
                                    data^inv^[code]^extr));
        PdWrite(doc, PfFormat(fmtL, "", data^inv^[code]^loan));
        line = line - 2;

        total = total + amt;

        client = clientN;
        branch = branchN;
    }
    PfDestroy(fmtF);
    PfDestroy(fmtT);
    PfDestroy(fmtB);
    PfDestroy(fmtL);
    PfDestroy(fmtD);
    PfDestroy(fmtH1);
    PfDestroy(fmtH2);
    MsgDestroy(scr);
}
Define InvRepMonth() {
    if (PeriodEndGet("Monthly Invoice Report", &periodEnd) != 1)
        return;
    periodName  = DateMonthName(periodEnd);
    periodYear  = DateYear(periodEnd);
    title = StrCat("Monthly Invoice Report for ", periodName, ", ", periodYear);

    doc = PdCreate(parm^prt^def^name, "InvRepMth", parm^prt^def^append, 
                   parm^prt^def^copies, parm^prt^def^browse, 
                   0, 120, 0, "",
                   parm^prt^def^start, parm^prt^def^end);
    PdPageSize(doc, parm^page^def^height, parm^page^def^width,
                    parm^page^def^margin^top, parm^page^def^margin^bottom,
                    parm^page^def^margin^left, parm^page^def^margin^right);
    scr = MsgCreate("Monthly Invoice Report");

    head = PfCreate();
    PfPrompt(head, 0,  0, univ^spar^coname);
    PfPrompt(head, 0, 85, DateToday());
    PfPrompt(head, 0, 97, TimeNow());
    PfString(head, 0,106, 10, "R");
    PfPrompt(head, 0,117, "of");
    PfString(head, 2,  0, 124, "C");
    PfPrompt(head, 4,  0, "Date");
    PfPrompt(head, 4, 12, "Applicant and Property Address");
    PfPrompt(head, 4, 68, "Base   Extra  Client   Branch   Valuation  Inv No  Job No");
    PfPrompt(head, 5,  0, " ");

    dtl = PfCreate();
    PfDate  (dtl,  0,  0, 10);
    PfString(dtl,  0, 12, 50);
    PfFloat (dtl,  0, 62, 10, 2);
    PfFloat (dtl,  0, 72,  8, 2);
    PfString(dtl,  0, 82,  8);
    PfString(dtl,  0, 91,  8);
    PfInt   (dtl,  0,100,  9);
    PfInt   (dtl,  0,111,  6);
    PfInt   (dtl,  0,119,  6);
    PfString(dtl,  1, 12, 100);

    tot = PfCreate();
    PfPrompt(tot,  1,  0, "Totals");
    PfPrompt(tot,  0, 62, " _________");
    PfPrompt(tot,  0, 72, " _______");
    PfFloat (tot,  1, 62, 10, 2);
    PfFloat (tot,  1, 72,  8, 2);

    PdWrite(doc, PfFormat(head, "", StrCat("page ", page = page + 1), title));
    line = linesperpage = parm^page^def^height -
                          parm^page^def^margin^top - parm^page^def^margin^bottom - 4;
    date = DateMonthStart(periodEnd);
    code = "";
    while (1) {
        Explode(next(data^inv_date^[date]^[code]), "^", &p1, &date, &code);

        if (p1 != "inv_date" || date > periodEnd)
            break;

        if (abort = MsgShow(scr, "Invoice " . code))
            break;
        if (line <= 2) {
            if (page)
                PdPageFeed(doc);
            PdWrite(doc, PfFormat(head, "", 
                                  StrCat("page ", page = page + 1), title));
            line = linesperpage;
        }
        totBase = totBase + (base = data^inv^[code]^base);
        totExtr = totExtr + (extr = data^inv^[code]^extr);
        PdWrite(doc, PfFormat(dtl, "", 
                              data^inv^[code]^date, 
                              data^inv^[code]^appl, 
                              base, 
                              extr, 
                              data^inv^[code]^clnt, 
                              data^inv^[code]^brch, 
                              data^inv^[code]^vamt, 
                              code,
                              data^inv^[code]^job, 
                              StrCat(data^inv^[code]^add1, "  ",
                                     data^inv^[code]^add2)));

        line = line - 3;
    }
    PdWrite(doc, PfFormat(tot, "", totBase, totExtr));
    PfDestroy(head);
    PfDestroy(dtl);
    PfDestroy(tot);
    MsgDestroy(scr);
    PdClose(doc, abort);
}

