Define PhoneLoad()
//  use this with n -ePhoneLoad -Uphone.dat <text filename listing>
//  macro reads the text phone list and inserts into the univ file
{
    SymRemove("univ");
    SymCreate("univ",,,2048,24);
    while (!LineGet(&buff)) {
        name = StrTrim(StrSubs(buff, 0, 60));
        phoneNo = StrTrim(StrSubs(buff, 60));
        Explode(name, ",", &nameLast, &nameFirst);

//  ph^[code]^phn                   = the phone number
//  ph^[code]^naf                   = name first
//  ph^[code]^nal                   = name last
//  ph_naf^[nameFirst]^[code]       = "y"       (list by name first)
//  ph_nal^[nameLast]^[code]        = "y"       (list by name last)

        code += 1;
        if (nameFirst)
            univ^ph^[code]^naf = nameFirst;
        univ^ph^[code]^nal = nameLast;
        univ^ph^[code]^phn = phoneNo;
    }
    PhoneKeyRebuild();
}
Define PhoneFmtNal(key) {
    Explode(key, "^", , &code);
    return univ^ph^[code]^nal. "\t". univ^ph^[code]^naf. "\t". univ^ph^[code]^phn;
}
Define PhoneFmtNaf(key) {
    Explode(key, "^", , &code);
    return univ^ph^[code]^naf. "\t". univ^ph^[code]^nal. "\t". univ^ph^[code]^phn;
}
Define PhoneSelCreate(scr)
{
    if (parm^phone^ord == "f") {
        SdSelect(scr, "sel",  1, 0, 1, 53, 10, ,
                    "univ^ph_naf^", , "PhoneFmtNaf", 130);
        SdFieldCols(scr, "sel", 15, 20, 15);
    }
    else {
        SdSelect(scr, "sel",  1, 0, 1, 53, 10, , 
                    "univ^ph_nal^", , "PhoneFmtNal", 130);
        SdFieldCols(scr, "sel", 20, 15, 15);
    }
}
Define PhoneSelCode(scr)
{
// returns the code of the currently selected person 
    Explode(SdFieldGet(scr, "sel"), "^", &name, &code);
    return code;
}
Define PhoneSelFieldSet(scr, code)
{
    SdFieldSet(scr, "sel", 
               parm^phone^ord == "f" 
                    ? StrToLower(univ^ph^[code]^naf) . "^" . code
                    : StrToLower(univ^ph^[code]^nal) . "^" . code);
}
Define PhoneSelNext(code)
{
    if (parm^phone^ord == "f") {
        pre = "ph_naf";
        val = StrToLower(univ^ph^[code]^naf);
    }
    else {
        pre = "ph_nal";
        val = StrToLower(univ^ph^[code]^nal);
    }
    Explode(next(univ^[pre]^[val]^[code]), "^", &npre, , &ncode);
    if (npre == pre)
        return ncode;
    Explode(prev(univ^[pre]^[val]^[code]), "^", &npre, , &ncode);
    if (npre == pre)
        return ncode;
    return "";
}
Define PhoneList()
{
    scr = SdCreate("", -1, -1, 10, 55, "Phone List");
    SdMenu(scr, "main", 1, "Entry",      "e", 121, 
                        1, "Options",    "o", 120,
                        1, "Utilities",  "u", 125);
    SdPopup(scr, "mtce", 121, 1, "Modify",     "m", 122,
                              1, "Add",        "a", 123,
                              1, "Remove",     "r", 124);
    SdPopup(scr, "util", 125, 1, "Key Rebuild","k", 126);
    PhoneSelCreate(scr);

    while (action != 2 && action != 3) {
        switch(action = SdEdit(scr)) {
        case 120:
            code = PhoneSelCode(scr);
            if (PhoneOpt() == 1)
                PhoneSelCreate(scr);
                PhoneSelFieldSet(scr, code);
            break;
        case 130:                       // double click select box
        case 122:
            if (PhoneMod(code = PhoneSelCode(scr)) == 1)
                PhoneSelFieldSet(scr, code);
            break;
        case 123:
            if (PhoneAdd(&code) == 1)
                PhoneSelFieldSet(scr, code);
            break;
        case 124:
            code = PhoneSelCode(scr);
            if (MsgYesNo("", 
                           "Delete " . univ^ph^[code]^naf . " "
                                     . univ^ph^[code]^nal 
                                     . ", are you sure ?") == 1) {
                nextCode = PhoneSelNext(code);
                PhoneDel(code);
                PhoneSelFieldSet(scr, nextCode);
            }
            break;
        case 126:
            code = PhoneSelCode(scr);
            PhoneKeyRebuild();
            PhoneSelFieldSet(scr, code);
            break; 
        }
    }
    SdDestroy(scr);    
}
Define PhoneOpt()
{
    scr = SdCreate("", -2, -2, 6, 32, "Options");
    SdPrompt(scr,            1,  2, "Order By:");
    SdRadio (scr, "r0",   1, 1, 12, 20, &parm^phone^ord, "Last Name", "l");
    SdRadio (scr, "r1",   1, 2, 12, 20, &parm^phone^ord, "First Name", "f");
    SdButton(scr, "ok",   1, 4, 4, 10, "OK", "", 1);
    SdButton(scr, "can",  1, 4, 18, 10, "Cancel", "", 2);
    if ((action = SdEdit(scr)) == 1) {
        SdUpdate(scr);
    }
    SdDestroy(scr);    
    return action;
}
Define PhoneNalMandatory(hand, value, name) {
    if (!value) {
        MsgWait("", "Last Name must be entered");
        return 1;
    }
}
Define PhonePhnMandatory(hand, value, name) {
    if (!value) {
        MsgWait("", "Phone Number must be entered");
        return 1;
    }
}
Define PhoneKeysSet(code, value) {
/*
    set or delete the keys for code.
    if value is null, keys are deleted, else if "y", keys are set
*/
    naf = univ^ph^[code]^naf;
    nal = univ^ph^[code]^nal;
    univ^ph_naf^[StrToLower(naf)]^[code]    = naf ? value : "";
    univ^ph_nal^[StrToLower(nal)]^[code]    = value;
}
Define PhoneModScrCreate(title)
{
    scr = SdCreate("", -2, -2, 7, 36, title);
    SdPrompt(scr,            1,  2, "First Name:");
    SdString(scr, "naf", 1, 1,  14, 20);
    SdPrompt(scr,            2,  2, "Last Name:");
    SdString(scr, "nal", 1, 2,  14, 20, , "PhoneNalMandatory");
    SdPrompt(scr,            3,  2, "Phone No:");
    SdString(scr, "phn", 1, 3,  14, 20, , "PhonePhnMandatory");
    SdButton(scr, "ok",   1, 5, 6, 10, "OK", "", 1);
    SdButton(scr, "can",  1, 5, 20, 10, "Cancel", "", 2);
    return scr;
}
Define PhoneModField(name, scr, code)
/*
    name is either Var or VarChg
*/
{
    ["SdField" . name](scr, "naf", &univ^ph^[code]^naf, 
                    "nal", &univ^ph^[code]^nal,
                    "phn", &univ^ph^[code]^phn);
}
Define PhoneMod(code)
{
    scr = PhoneModScrCreate("Modify Entry");
    PhoneModField("Var", scr, code);
    if ((action = SdEdit(scr)) == 1) {
        PhoneKeysSet(code);
        SdUpdate(scr);
        PhoneKeysSet(code, "y");
    }
    SdDestroy(scr);    
    return action;
}
Define PhoneAdd(code)
{
    scr = PhoneModScrCreate("Add Entry");
    if ((action = SdEdit(scr)) == 1) {
        Explode(prev(univ^ph^[999999999]), "^", &type, &code);
        code = type != "ph" ? 1 : code + 1;
        PhoneModField("VarChg", scr, code);
        SdUpdate(scr);
        PhoneKeysSet(code, "y");
    }
    SdDestroy(scr);    
    return action;
}
Define PhoneDel(code) {
    PhoneKeysSet(code, "");
    while (field = NextField("univ", "ph", code, field))
        univ^ph^[code]^[field] = "";
}
Define PhoneKeyRebuild() {
    scr = MsgCreate("Phone List Key Rebuild");
    cnt = 0;
    key = "";
    while (key = SymNext("univ", key, "ph_")) {     /* remove them all */
        if (!((cnt += 1) % 50) && (abort = MsgShow(scr, "Deleting " . key)))
            break;
        univ^ph_[key] = "";
    }
    cnt = 0;
    if (!abort) {
        code = "";
        while (code = SymNext("univ", code, "ph^")) {
            Explode(code, "^", &code);
            if (!((cnt += 1) % 50) && (abort = MsgShow(scr, "Rebuild " . code)))
                break;
            PhoneKeysSet(code, "y");
            code += 1;
        }
    }
    MsgDestroy(scr);
}

