#define __OTCTRL_H


#include "stdafx.h"


class CFont;

class CRect;

class COptNode;


class COptNodeList
{
   int n;
   COptNode *head;
   COptNode *tail;

   public:

   COptNodeList()
   {
      head = 0;
   }

   int getno();
   int append(COptNode *p);
   void setempty();
   void freeallnodes();
   COptNode *operator[](int i);
   COptNode *gethead();
   COptNode *gettail();
   COptNode *getlast(COptNode *p);
   COptNode *getnext(COptNode *p);
};


class COptNode
{
   public:

   int i;                                   /* sequential index in the control */
   int isxcl;                                  /* is exclusive among siblings? */
   int isexp;                          /* is it expanded? meaningless for leaf */
   int chkstr;                /* real check state. calc from kids for a branch */
   int chksti;                /* ideal check state, equal to chkstr for a leaf */
   int enable;                     /* 0 -- disabled  1 -- enabled  2 -- hidden */
   int ischkchg;                           /* is the real check state changed? */
   char txt[40];                               /* maximum 40 char for the name */
   COptNode *dad;                                                  /* dad node */
   COptNode *last;                                             /* last sibling */
   COptNode *next;                                             /* next sibling */
   COptNodeList kids;                                             /* kid nodes */

   /* for leaf node */
   COptNode(char txt[], int isxcl, int chksti, int enable)
   {
      initl(txt, isxcl, chksti, enable);
   }

   /* for branch node */
   COptNode(char txt[], int isxcl, int isexp)
   {
      initb(txt, isxcl, isexp);
   }

   virtual ~COptNode()               /* we need to delete instance of COptNode */
   {
      kids.setempty();
   }

   int getnokids()
   {
      return kids.getno();
   }
   COptNode *getkid(int i)
   {
      return kids[i];
   }

   /* for leaf node */
   void initl(char txt[], int isxcl = 0, int chksti = 1, int enable = 1);

   /* for branch node */
   int appendkid(COptNode *p);
   int calcchkstr();
   int calcenable();
   void freeallnodes();
   void begappendkid();
   void endappendkid();
   void initb(char txt[], int isxcl = 0, int isexp = 1);

   int getlevel();
};


class COptTree;


class COptTree:public CWnd
{
   typedef void (COptTree::*eccproc)(COptNode *p);

   enum
   {
      gap1 = 3, gap2 = 25
   };

   int h;                                           /* the height of each item */
   int tidx;                                                      /* top index */
   int hoff;        /* when listbox is horizontally scrolled, it is the offset */
   int hext;                                                    /* horz extent */
   int noshown;                                     /* total no of nodes shown */
   int isindinv;          /* invalidate individual nodes when triggering check */
   int isshowdot;                 /* show a dot as a leaf node's expand button */
   CWnd *parent;                                           /* parent wnd (dlg) */
   CFont *fo;                                                        /* helv 9 */
   COptNode *tp;                                                   /* top node */
   COptNode *sel;                                 /* the selected node, if any */
   COptNodeList roots;              /* every root starts a tree in the control */
   struct                                            /* w and h of the control */
   {
      int W;
      int H;
   } Attr;

   public:

   COptTree(CWnd *parent, int isshowdot = 1, int isindinv = 0);

  ~COptTree();

   int chksel(COptNode *p);
   int appendroot(COptNode *p);
   void create(int id, int posid);
   void freeallnodes();
   void begappendroot();
   void endappendroot();
   void trychk(COptNode *p, int chksti, int isback = 1);
   void trigsel(COptNode *p);
   void trigchk(COptNode *p);
   void trigexp(COptNode *p);
   void invalidate(COptNode *p);
   COptNode *i2n(int i);
   COptNode *getsel();
   COptNode *getfrst();
   COptNode *getlast(COptNode *p);
   COptNode *getnext(COptNode *p);
   COptNode *getlastsibling(COptNode *p);
   COptNode *getnextsibling(COptNode *p);

   protected:

   void notifyforgetchkchg(COptNode *p)      
   {
      notifychkchg(p);              /* notify that p has changed its chk state */

      p->ischkchg = 0;               /* clear the chk change flag of this node */
   }
   void freeallnodes(COptNode *p)                  /* delete all nodes under p */
   {
      freeallnodes(p->kids);
   }

   /* three notification functions */

   virtual void notifyselchg(COptNode *p)                /* p is just selected */
   {

   }
   virtual void notifychkchg(COptNode *p)        /* chk state of p has changed */
   {

   }
   virtual void notifychkchgend()      /* chk state of some nodes have changed */
   {

   }
   int getloc(int x, int y, COptNode **p);
   int gethext(COptNode *p);
   void freeallnodes(COptNodeList &ns);
   void tryclrsiblings(COptNode *p);
   void sethext();
   void setalli();
   void setnoshown();
   void setscrbars();
   void getwhlrect(COptNode *p, CRect *r);
   void getchkrect(COptNode *p, CRect *r);
   void getexprect(COptNode *p, CRect *r);
   void gettxtrect(COptNode *p, CRect *r);
   void enumchkchg(eccproc f);
   void drawnode(CDC &dc, COptNode *q);
   void Paint(CDC &dc, BOOL erase, CRect &r);
   void OnPaint();
   void OnLButtonDown(UINT modkeys, CPoint pt);
   void OnHScroll(UINT scrollCode, UINT thumbPos, CScrollBar *sb);
   void OnVScroll(UINT scrollCode, UINT thumbPos, CScrollBar *sb);

   DECLARE_MESSAGE_MAP()
};

