#define __OTCTRL_H


#include "classlib\arrays.h"

#include "owl\eventhan.h"


class TFont;

class TRect;

class TOptNode;


class TOptNodeList
{
   int n;
   TOptNode *head;
   TOptNode *tail;

   public:

   TOptNodeList()
   {
      head = 0;
   }

   int getno();
   int append(TOptNode *p);
   void setempty();
   void freeallnodes();
   TOptNode *operator[](int i);
   TOptNode *gethead();
   TOptNode *gettail();
   TOptNode *getlast(TOptNode *p);
   TOptNode *getnext(TOptNode *p);
};


class TOptNode
{
   public:

   int i;                                   /* sequential index in the control */
   int isxcl;                                  /* is exclusive among siblings? */
   int isexp;                          /* is it expanded? meaningless for leaf */
   int chkstr;                /* real check state. calc from kids for a branch */
   int chksti;                /* ideal check state, equal to chkstr for a leaf */
   int enable;                     /* 0 -- disabled  1 -- enabled  2 -- hidden */
   int ischkchg;                           /* is the real check state changed? */
   char txt[40];                               /* maximum 40 char for the name */
   TOptNode *dad;                                                  /* dad node */
   TOptNode *last;                                             /* last sibling */
   TOptNode *next;                                             /* next sibling */
   TOptNodeList kids;                                             /* kid nodes */

   /* for leaf node */
   TOptNode(char txt[], int isxcl, int chksti, int enable)
   {
      initl(txt, isxcl, chksti, enable);
   }

   /* for branch node */
   TOptNode(char txt[], int isxcl, int isexp)
   {
      initb(txt, isxcl, isexp);
   }

   virtual ~TOptNode()               /* we need to delete instance of TOptNode */
   {
      kids.setempty();
   }

   int getnokids()
   {
      return kids.getno();
   }
   TOptNode *getkid(int i)
   {
      return kids[i];
   }

   /* for leaf node */
   void initl(char txt[], int isxcl = 0, int chksti = 1, int enable = 1);

   /* for branch node */
   int appendkid(TOptNode *p);
   int calcchkstr();
   int calcenable();
   void freeallnodes();
   void begappendkid();
   void endappendkid();
   void initb(char txt[], int isxcl = 0, int isexp = 1);

   int getlevel();
};


class TOptTree;


typedef void (TOptTree::*eccproc)(TOptNode *p);


class TOptTree:public TWindow
{
   enum
   {
      gap1 = 3, gap2 = 25
   };

   int h;                                           /* the height of each item */
   int tidx;                                                      /* top index */
   int hoff;        /* when listbox is horizontally scrolled, it is the offset */
   int hext;                                                    /* horz extent */
   int noshown;                                     /* total no of nodes shown */
   int isindinv;          /* invalidate individual nodes when triggering check */
   int isshowdot;                 /* show a dot as a leaf node's expand button */
   TFont *fo;                                                        /* helv 9 */
   TOptNode *tp;                                                   /* top node */
   TOptNode *sel;                                 /* the selected node, if any */
   TOptNodeList roots;              /* every root starts a tree in the control */

   public:

   TOptTree(TWindow *parent, int isshowdot = 1, int isindinv = 0);

  ~TOptTree();

   int chksel(TOptNode *p);
   int appendroot(TOptNode *p);
   void create(int id, int posid);
   void freeallnodes();
   void begappendroot();
   void endappendroot();
   void trychk(TOptNode *p, int chksti, int isback = 1);
   void trigsel(TOptNode *p);
   void trigchk(TOptNode *p);
   void trigexp(TOptNode *p);
   void invalidate(TOptNode *p);
   TOptNode *i2n(int i);
   TOptNode *getsel();
   TOptNode *getfrst();
   TOptNode *getlast(TOptNode *p);
   TOptNode *getnext(TOptNode *p);
   TOptNode *getlastsibling(TOptNode *p);
   TOptNode *getnextsibling(TOptNode *p);

   protected:

   void notifyforgetchkchg(TOptNode *p)      
   {
      notifychkchg(p);              /* notify that p has changed its chk state */

      p->ischkchg = 0;               /* clear the chk change flag of this node */
   }
   void freeallnodes(TOptNode *p)                  /* delete all nodes under p */
   {
      freeallnodes(p->kids);
   }

   /* three notification functions */

   virtual void notifyselchg(TOptNode *p)                /* p is just selected */
   {

   }
   virtual void notifychkchg(TOptNode *p)        /* chk state of p has changed */
   {

   }
   virtual void notifychkchgend()      /* chk state of some nodes have changed */
   {

   }
   int getloc(int x, int y, TOptNode **p);
   int gethext(TOptNode *p);
   void freeallnodes(TOptNodeList &ns);
   void tryclrsiblings(TOptNode *p);
   void sethext();
   void setalli();
   void setnoshown();
   void setscrbars();
   void getwhlrect(TOptNode *p, TRect *r);
   void getchkrect(TOptNode *p, TRect *r);
   void getexprect(TOptNode *p, TRect *r);
   void gettxtrect(TOptNode *p, TRect *r);
   void enumchkchg(eccproc f);
   void drawnode(TDC &dc, TOptNode *q);
   void Paint(TDC &dc, BOOL erase, TRect &r);
   void EvLButtonDown(UINT modkeys, TPoint& pt);
   void EvHScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl);
   void EvVScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl);

   DECLARE_RESPONSE_TABLE(TOptTree);
};

