{**********************************************************}
{*                        QCARD.PAS                       *}
{*            Compile this unit to interface              *}
{*	 QCARD.DLL Version 2.0 with Borland Pascal 7      *}
{*	      or Turbo Pascal for Windows 1.5             *}
{**********************************************************}

UNIT QCARD;

INTERFACE

USES WinTypes;

CONST
  CARDWIDTH    = 71;
  CARDHEIGHT   = 96;
  FACEUP       =  1;
  FACEDOWN     =  0;
  CARDOFFSET   = 16;

 {*** Procedures *************************************************}

  Procedure DrawCard(hWindow : HWnd; nCard, nxLoc, nyLoc : Integer);
  Procedure DealCard(hWindow : HWnd; nCard, nx, ny: Integer);
  Procedure DrawSymbol(hWindow : HWnd; nValue, nx, ny : Integer);
  Procedure DrawBack(hWindow : HWnd; nValue, nx, ny : Integer);
  Procedure RemoveCard(hWindow : HWnd; nCard: Integer);

  Procedure SetCardStatus(nCard : Integer; bStatus : Bool);
  Procedure SetDefaultValues;
  Procedure SetCurrentBack(nIndex : Integer);

  Procedure SetCardX(nCard, nx : Integer);
  Procedure SetCardY(nCard, ny : Integer);
  Procedure SetOffSet(nValue : Integer);

  Procedure SetUser1(nCard : Integer; nValue : Bool);
  Procedure SetUser2(nCard, nValue : Integer);
  Procedure SetUser3(nCard, nValue : Integer);
  Procedure SetUser4(nCard, nValue : Integer);

  Procedure AdjustCardBlocked(nCard : Integer; bBlockFlag : Bool);
  Procedure SetCardDisabled(nCard : Integer; bDisabledFlag : Bool);

  Procedure AbortDrag;
  Procedure DoDrag(hWindow : HWnd; nx, ny : Integer);
  Procedure ReturnDrag(hWindow : HWnd; nCard, nxLoc, nyLoc : Integer);
  Procedure BlockDrag(hWindow : HWnd; CardList : Pointer;
		      nNumCards, nxLoc, nyLoc : Integer);
  Procedure ReturnBlockDrag(hWindow : HWnd; CardList : Pointer;
                            nNumCards, nxLoc, nyLoc : Integer);


  {*** Functions *************************************************}

  Function  InitializeDeck(hWindow : HWnd) : Bool;

  Function  GetCardColor(nCard : Integer) : Integer;
  Function  GetCardSuit(nCard : Integer) : Integer;
  Function  GetCardValue(nCard : Integer) : Integer;

  Function  GetCardStatus(nCard : Integer) : Bool;

  Function  GetCardX(nCard : Integer) : Integer;
  Function  GetCardY(nCard : Integer) : Integer;

  Function  GetUser1(nCard : Integer) : Bool;
  Function  GetUser2(nCard : Integer) : Integer;
  Function  GetUser3(nCard : Integer) : Integer;
  Function  GetUser4(nCard : Integer) : Integer;

  Function  GetCardBlocked(nCard : Integer) : Bool;
  Function  IsCardDisabled(nCard : Integer) : Bool;
  
  Function  InitDrag(hWindow : HWnd; nx, ny : Integer) : Integer;
  Function  EndDrag(hWindow : HWnd; nx, ny : Integer) : Integer;
  Function  EndBlockDrag(hWindow : HWnd; CardList : Pointer;
			 nNumCards, nxLoc, nyLoc : Integer) : Integer;

  Function  GetFreeDestination(nCard : Integer) : Integer;

{******************************************************}
{*     Undocumented functions, generally not used     *}
{******************************************************}

  { Manually sets the active drag card for}
  { subsequent DoDrag or BlockDrag call.  }
  Procedure SetActiveCard(nCard : Integer);

  { Returns the number of any unblocked card}
  { which lies beneath the point nx, ny.    }
  Function PointInFreeCard(nx, ny : Integer) : Integer;

  { returns the number of any card whose top 16 (or Offset)}
  {  pixels lie beneath the point nx, ny.                  }
  Function PointInCardTop(nx, ny : Integer) : Integer;

IMPLEMENTATION

  Procedure DrawCard;           external 'QCARD' index  2;
  Procedure DrawBack;           external 'QCARD' index  3;
  Procedure DrawSymbol;         external 'QCARD' index  4;
  Procedure RemoveCard;	     	external 'QCARD' index  5;
  Function  InitializeDeck;  	external 'QCARD' index  6;
  Procedure DealCard;	     	external 'QCARD' index  7;
  Function  GetCardColor;     	external 'QCARD' index  8;
  Function  GetCardSuit;     	external 'QCARD' index  9;
  Function  GetCardValue;     	external 'QCARD' index 10;
  Function  GetCardStatus;    	external 'QCARD' index 11;
  Function  GetCardBlocked;   	external 'QCARD' index 12;
  Function  IsCardDisabled;   	external 'QCARD' index 13;
  Function  GetCardX;	     	external 'QCARD' index 14;
  Function  GetCardY;	     	external 'QCARD' index 15;
  Function  GetUser1;	     	external 'QCARD' index 16;
  Function  GetUser2;	     	external 'QCARD' index 17;
  Function  GetUser3;	     	external 'QCARD' index 18;
  Function  GetUser4;	     	external 'QCARD' index 19;
  Procedure SetCardStatus;    	external 'QCARD' index 20;
  Procedure AdjustCardBlocked;  external 'QCARD' index 21;
  Procedure SetCardDisabled;	external 'QCARD' index 22;
  Procedure SetCardX;		external 'QCARD' index 23;
  Procedure SetCardY;		external 'QCARD' index 24;
  Procedure SetUser1;		external 'QCARD' index 25;
  Procedure SetUser2;		external 'QCARD' index 26;
  Procedure SetUser3;		external 'QCARD' index 27;
  Procedure SetUser4;		external 'QCARD' index 28;
  Function  InitDrag;		external 'QCARD' index 29;
  Function  PointInFreeCard;	external 'QCARD' index 30;
  Procedure SetActiveCard;	external 'QCARD' index 31;
  Procedure DoDrag;		external 'QCARD' index 32;
  Function  EndDrag;		external 'QCARD' index 33;
  Procedure ReturnDrag;		external 'QCARD' index 34;
  Function  PointInCardTop;	external 'QCARD' index 35;
  Procedure SetDefaultValues;   external 'QCARD' index 36;
  Procedure BlockDrag;		external 'QCARD' index 37;
  Function  EndBlockDrag;	external 'QCARD' index 38;
  Procedure ReturnBlockDrag;    external 'QCARD' index 39;
  Function  GetFreeDestination; external 'QCARD' index 40;
  Procedure AbortDrag;		external 'QCARD' index 41;
  Procedure SetCurrentBack;     external 'QCARD' index 42;
  Procedure SetOffSet;		external 'QCARD' index 43;
END.
{**********************************************************}
{*                 End of QCARD.PAS                       *}
{**********************************************************}