#define STRICT
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dll16.h"

#ifndef __GNUC__
#define INT int
#endif

/* dll-function prototype */
typedef int (FAR PASCAL *DLLFUNC)(LPSTR);

INT PASCAL WinMain(
    HINSTANCE hInst,
    HINSTANCE hPrevInst,
    LPSTR lpszCmd,
    INT nCmdShow)
{
    static char app_name[] = "dlltst";
    static char dll[] = "DLL16.DLL";
    static char dll_name[260];

    char buf[512];
    DLLFUNC lpFunc;
    HANDLE hLib;
    int i;

    GetModuleFileName(hInst, dll_name, 260);

    /* get directory for this module */
    for (i=0; dll_name[i]; i++)
	if (dll_name[i]=='.')
	    break;
    for ( ; i>0 ; i--)
	if (dll_name[i]=='\\') {
	    dll_name[i+1]=0;
	    break;
	}
    strcat(dll_name, dll);

    sprintf(buf, "DLL = %s", dll_name);
    MessageBox(NULL, buf, app_name, MB_OK);

    hLib = LoadLibrary(dll_name);
    if (hLib < 32) {
	MessageBox(NULL, "can't find dll", app_name, MB_OK);
	return 1;
    }

#ifndef __EMX__
    lpFunc = (DLLFUNC)
	GetProcAddress(hLib, MAKEINTRESOURCE( CHANGE_STRING ));
#else
    lpFunc = (DLLFUNC)
	GetProc32Address(hLib, (FARPROC) ChangeString);
#endif

    if (lpFunc == NULL) {
	MessageBox(NULL, "can't find procaddress", app_name, MB_OK);
	return 1;
    }

    sprintf(buf, "Hello Windows");
    MessageBox(NULL, buf, app_name, MB_OK);

    (*lpFunc) (buf);
    MessageBox(NULL, buf, app_name, MB_OK);

    FreeLibrary(hLib);

    return 0;
}
