unit Box;

interface

uses
  Forms, Graphics;

type
  Directions = (ne, nw, se, sw);
  TBox = class
  private
    x,y,linelen: Integer;
    angle: Real;
    dir: Directions;
    Canvas: TCanvas;
    procedure Check(var bChangedDir: Boolean; x,y: Integer);
  public
    constructor Init(C: TCanvas; LL: Integer);
    procedure Draw;
    procedure Rotate;
  end;

implementation

constructor TBox.Init(C: TCanvas; LL: Integer);
begin
  Canvas := C;
  linelen := LL;

  Randomize;
  x := Random(Screen.Width-LL)+1;
  y := Random(Screen.Height-LL)+1;
  angle := 15/180*3.1415;

  dir := sw;

  Canvas.Pen.Color := clRed;
  Canvas.Pen.Width := 1;
end;

procedure TBox.Check(var bChangedDir: Boolean; x,y: Integer);
begin
  if not bChangedDir then
  begin
    { Check out a side }
    if (x<=0) then
    begin
      case dir of
        nw: dir := ne;
        sw: dir := se;
      end;
      bChangedDir := True;
    end;
    { Check out a side }
    if (x>=Screen.Width) then
    begin
      case dir of
        ne: dir := nw;
        se: dir := sw;
      end;
      bChangedDir := True;
    end;
    { Check out a side }
    if (y<=0) then
    begin
      case dir of
        nw: dir := sw;
        ne: dir := se;
      end;
      bChangedDir := True;
    end;
    { Check out a side }
    if (y>=Screen.Height) then
    begin
      case dir of
        sw: dir := nw;
        se: dir := ne;
      end;
      bChangedDir := True;
    end;

  end;
end;

procedure TBox.Draw;
var
  dx, dy: Integer;
  bChangedDir: Boolean;
begin
  { Calculate dx and dy from angle }
  dx := Round(Cos(angle) * linelen);
  dy := Round(Sin(angle) * linelen);

  { Have not changed direction this time }
  bChangedDir := False;

  with Canvas do
  begin
    MoveTo(x, y);
    Check(bChangedDir, x+dx,y+dy); LineTo(x+dx,y+dy);
    Check(bChangedDir, x+dx+dy,y+dx+dy); LineTo(x+dx+dy,y+dx+dy);
    Check(bChangedDir, x+dy,y+dx); LineTo(x+dy,y+dx);
    Check(bChangedDir, x,y); LineTo(x,y);
  end;
end;

procedure TBox.Rotate;
begin
  Canvas.Pen.Color := clBlack;
  Draw;

  { Increase the angle }
  angle := angle + 0.1;

  case dir of
    nw: begin x := x-5; y := y-5; end;
    sw: begin x := x-5; y := y+5; end;
    se: begin x := x+5; y := y+5; end;
    ne: begin x := x+5; y := y-5; end;
  end;

  Canvas.Pen.Color := clRed;
  Draw;
end;

end.
