unit Dofix;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, FileCtrl;

type
  TfrmFix = class(TForm)
    Label1: TLabel;
    GroupBox1: TGroupBox;
    FileListBox1: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    FilterComboBox1: TFilterComboBox;
    cmdFIX: TBitBtn;
    cmdExit: TBitBtn;
    Label2: TLabel;
    cedTitle: TEdit;
    Label3: TLabel;
    procedure cmdFIXClick(Sender: TObject);
  private
    { Private declarations }
    procedure PutTitleInFile(FileName, Title: string);
  public
    { Public declarations }
  end;

var
  frmFix: TfrmFix;

implementation

{$R *.DFM}

procedure TfrmFix.PutTitleInFile(FileName, Title: string);
var
  fh, i, Pos, Len, Read, j: Integer;
  ShortName, tmp: string;
  Buffer: array [1..4096] of Byte;
begin
  ShortName := UpperCase(ExtractFileName(FileName));
  Len := Length(ShortName);

  fh := FileOpen(FileName, fmOpenReadWrite);
  { It should be here at the start of the file }
  Read := FileRead(fh, Buffer, sizeof(Buffer));

  { Do a simple search for the length of the
    file name, first }
  i:=1;
  Pos := 0;
  while (Pos=0) and (i < (sizeof(Buffer)-Len)) do
  begin
    if Buffer[i] = Len then
    begin
      for j:=0 to Len do tmp[j] := Char(Buffer[i+j]);
      if tmp=ShortName then Pos := i-1;
    end;
    i := i+1;
  end;
  if Pos=0 then
    MessageDlg('Could not find stamp in EXE file!', mtError,[mbOk], 0)
  else
  begin
    { Add some extra info Windows wants }
    Title := 'SCRNSAVE: ' + Title;
    { From beginnig of file }
    FileSeek(fh, Pos, 0);
    FileWrite(fh, Title, Length(Title)+1);
  end;
  FileClose(fh);
end;

procedure TfrmFix.cmdFIXClick(Sender: TObject);
var
  FileName, NewName: string;
begin
  { Filename with path }
  FileName := FileListBox1.FileName;

  if FileName='' then
  begin
    MessageDlg('Please choose an EXE file to fix', mtError,[mbOk], 0);
    exit;
  end;

  if cedTitle.Text='' then
  begin
    MessageDlg('Please give the screen saver a name', mtError,[mbOk], 0);
    exit;
  end;

  PutTitleInFile(FileName, cedTitle.Text);

  NewName := Copy(FileName,1,Length(FileName)-4) + '.scr';
  if not RenameFile(FileName, NewName) then
    MessageDlg('Could not rename the file ' + UpperCase(FileName) +
               ' to ' + UpperCase(NewName) +
               Chr(10) +
               'Rename the file and place it in the windows directory.',
               mtInformation,[mbOk], 0)
  else
    MessageDlg('The file ' + ExtractFileName(FileName) +
               ' has been fixed and has the extension ''.scr''.' +
               Chr(10) +
               'Place it in the windows directory.',
               mtInformation,[mbOk], 0);
  FileListBox1.Update;
end;

end.
