/*
 *  This file forms part of "TKERN" - "Troy's Kernel for Windows".
 *
 *  Copyright (C) 1994  Troy Rollo <troy@cbme.unsw.EDU.AU>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <windows.h>
#include <toolhelp.h>
#include <stdlib.h>
#include <memory.h>
#include <string.h>
#include <alloc.h>
#include <stdarg.h>
#include <errno.h>
#include <sys/tfile.h>
#include <sys/task.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <sys/tkern.h>

int	nSleepers = 0;	// Number of sleeping tasks

/*
 * We couldn't use PeekMessage because you can't seem to have 2 tkern tasks
 * using PeekMessage loops at the same time. GetMessages puts the current task
 * to sleep and marks it as sleeping. The file manager will issue a wakeup
 * call when an event has occurred on which sleeping tasks are waiting.
 * This will cause tkern to send a dummy message to all tasks which are sleeping.
 * That will cause the GetMessage call to return
 */

void	GetMessages(struct task *pt)
{
	MSG	msg;

	if (pt->nSignal)
	{
		(*pt->intrproc)(pt->nSignal);
		pt->nSignal = 0;
	}
	nSleepers++;
	pt->nFlags |= TF_ASLEEP;
	GetMessage(&msg, 0, 0, 0);
	if (msg.message != TKWM_WAKEUP)
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	if (pt->nFlags & TF_ASLEEP)
	{
		nSleepers--;
		pt->nFlags &= ~TF_ASLEEP;
	}
	if (pt->nSignal)
	{
		(*pt->intrproc)(pt->nSignal);
		pt->nSignal = 0;
	}
}

/* FlushMessages should be used only when there is no alternative */
void	FlushMessages(void)
{
	MSG	msg;

	while (PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
}


/*
 * This function is used by tkern_exec() to copy the argument and
 * environment vectors.
 */

void
Copy_Array(char ***dest, char **source)
{
	int	i;
	int	nBytes = sizeof(char *);
	char	*pchBuffer;
	char	**ppchVector;

	for (i = 0; source[i]; i++)
	{
		nBytes += strlen(source[i]) + 1;
	}
	nBytes += (i + 1) * sizeof(char *);
	ppchVector = (char **) malloc(nBytes);
	*dest = ppchVector;
	pchBuffer = (char *) (ppchVector + i + 1);
	while (*source)
	{
		*ppchVector++ = pchBuffer;
		strcpy(pchBuffer, *source);
		pchBuffer += strlen(pchBuffer) + 1;
		source++;
	}
	*ppchVector = 0;
}

