{$A+,B-,G+,I-,O-,P+,Q-,R-,S-,T-,V-,X+}
Unit Debug;
{ Unit:      Debug
  Version:   1.00
  Purpose:   useful functions for debug output
  Uses:      DbWin or monochrome monitor as output device
  Date:      01/21/94

  Developer: Peter Sawatzki (ps)
             Buchenhof 3, 58091 Hagen, Germany
 CompuServe: 100031,3002

  Date:    Author:
  08/01/93 ps     wrote it
  01/18/94 ps/jwp correct bug in debugoutput, add R- option
  01/21/94 ps     minor 'optimizations'

  Copyright (c) 1994 Peter Sawatzki. All Rights Reserved.

}
Interface
Uses
  WinTypes,
  WinProcs,
  WinDos,
  Strings;
Type
  Str2 = String[2];
  Str4 = String[4];
  Str8 = String[8];
  Str10 = String[10];
  PtrRec = Record
             Ofs, Seg: Word
           End;
  LongRec = Record
              LoWord, HiWord: Word
            End;

Procedure BreakPoint; Inline($CC);
Function HexB (b: Byte): Str2;
Function HexW (w: Word): Str4;
Function HexL (l: LongInt): Str8;
Function L2S (l: LongInt): Str10;
Function W2S (w: Word): Str10;
Function StrPasEx(Str: pChar): String;

Procedure AssignDebug (Var F: Text);

Implementation
Const
  HC: Array[0..$F] Of Char = '0123456789ABCDEF';

Function HexB (b: Byte): Str2;
Begin
  HexB[0]:= #2;
  HexB[1]:= HC[b Shr 4];
  HexB[2]:= HC[b And $F]
End;

Function HexW (w: Word): Str4;
Begin
  HexW[0]:= #4;
  HexW[1]:= HC[w Shr 12];
  HexW[2]:= HC[Hi(w) And $F];
  HexW[3]:= HC[Lo(w) Shr 4];
  HexW[4]:= HC[w And $F]
End;

Function HexL (l: LongInt): Str8;
Begin With LongRec(l) Do Begin
  HexL[0]:= #8;
  HexL[1]:= HC[HiWord Shr 12];
  HexL[2]:= HC[Hi(HiWord) And $F];
  HexL[3]:= HC[Lo(HiWord) Shr 4];
  HexL[4]:= HC[HiWord And $F];
  HexL[5]:= HC[LoWord Shr 12];
  HexL[6]:= HC[Hi(LoWord) And $F];
  HexL[7]:= HC[Lo(LoWord) Shr 4];
  HexL[8]:= HC[LoWord And $F]
End End;

Function L2S (l: LongInt): Str10;
Var
  pStr: ^Str10;
Begin
  Asm Les Di, @Result; Mov Word(pStr), Di; Mov Word(pStr+2), Es End;
  Str(l,pStr^)
End;

Function W2S (w: Word): Str10;
Var
  pStr: ^Str10;
Begin
  Asm Les Di, @Result; Mov Word(pStr), Di; Mov Word(pStr+2), Es End;
  Str(w,pStr^)
End;

Function StrPasEx(Str: pChar): String;
Begin
  If PtrRec(Str).Seg=0 Then
    StrPasEx:= '#'+L2S(Word(Str))
  Else
    StrPasEx:= StrPas(Str)
End;

{------------------------------------------ Debug output functions }

Function DebugOutput (Var F: tTextRec): Integer; Far;
Var
  TwoCh: Array[0..1] Of Char;
Begin
  With F Do If BufPos>0 Then Begin
    TwoCh[0]:= #0; TwoCh[1]:= #0;
    If BufPos=BufSize Then Begin
      Dec(BufPos);
      TwoCh[0]:= BufPtr^[BufPos]
    End;
    BufPtr^[BufPos]:= #0;
    OutputDebugString(pChar(BufPtr));
    If TwoCh[0]<>#0 Then
      OutputDebugString(TwoCh);
    BufPos:= 0
  End;
  DebugOutput:= 0
End;

Function DebugClose (Var F: tTextRec): Integer; Far;
Begin
  DebugClose:= 0
End;

Function DebugOpen (Var F: tTextRec): Integer; Far;
Begin With F Do Begin
  Mode:= fmOutput;
  InOutFunc:= @DebugOutput;
  FlushFunc:= @DebugOutput;
  CloseFunc:= @DebugClose;
  DebugOpen:= 0
End End;

Procedure AssignDebug (Var F: Text);
Begin With tTextRec(F) Do Begin
  Handle:= $FFFF;
  Mode:= fmClosed;
  BufSize:= SizeOf(Buffer);
  BufPtr:= @Buffer;
  OpenFunc:= @DebugOpen;
  Name[0]:= #0
End End;

Begin
  AssignDebug(Output);
  Rewrite(Output)
End.

