(*
{$A-,B-,D-,F-,G+,I-,K+,L-,N-,P-,Q-,R-,S-,T-,V+,W-,X+,Y-}
*)
{$M 8192,128}   { Stacksize is ignored }
Library MidLpBk;

{                   MIDI LoopBack Device                             }
{ (c) Hubert Winkler, Neunkirchnerstr.17, A-2732 Willendorf, Austria }
{   Send your comments to winkler@cobra.gud.siemens.co.at (office)   }


{ Based on Microsoft's Soundblaster Driver Source (MMDDK) }


{Version
  1.0 original release
  1.1 added Port-Naming
  1.2 never released

2.0 - Major Update : Multi Client (max. 4 In/10 Out !)
      Matrix is no more necessary !
      Splitted into 3 sources
        MLB_FIX MIDI OUT routines with FIXED+PERMANENT Code Segment
        MLB_NFIX MIDI Code with DISCARDABLE Code Segment
        midlpbk Configuration Code with DISCARDABLE Code Segment
}

{$D midi:Hubi's LoopBack - PD Edition}
{$C PRELOAD FIXED DISCARDABLE}

{$R MIDLPBK.RES}

{$DEFINE USE_CTL3D}

uses wintypes
    ,winprocs
    ,win31
    ,mmsystem
    ,strings
{$IFDEF USE_CTL3D}
    ,Ctl3D
{$ENDIF}
    ,Cpl
    ,MLB_FIX,MLB_nFIX;


{ ---------------------------------------------------------------------------
  Configuration Part
  --------------------------------------------------------------------------- }
const
      gszActivePorts : PChar = 'ActivePorts';

{set name of port[id]}
procedure SetPortName( name:PChar; id:integer );
var key:array [0..MAXPNAMELEN-1] of Char;
begin
   inc(id,Ord('1'));
   wvsprintf(key,gszPort,id);
   WritePrivateProfileString(gszSection,key,name,gszIniFile);
end;

procedure WriteConfig;
var buf : array [0..11] of Char;
begin
   wvsprintf(buf,'%d',gActivePorts);
   WritePrivateProfileString(gszSection,gszActivePorts,buf,gszIniFile);
end;

procedure ReadConfig;
begin
   gActivePorts:=GetPrivateProfileInt(gszSection,gszActivePorts,gNumPorts,gszIniFile);
   if gActivePorts<0 then gActivePorts:=0
   else if gActivePorts>gNumPorts then gActivePorts:= gNumPorts;
end;

var RenamePortName:PChar;
function RenamePort(Dialog: HWnd; Message, WParam: Word;
  LParam: Longint): Bool; export;
const id_edit = 100;
begin
  RenamePort := True;
  case Message of
    wm_InitDialog:
      begin
         RenamePortName := PChar(LParam);
         SendDlgItemMessage(Dialog,id_edit,WM_SETTEXT,0,LParam);
         SendDlgItemMessage(Dialog,id_edit,EM_LIMITTEXT,MAXPNAMELEN-1,0);
         Exit;
      end;
    wm_Command:
      if (WParam = id_Ok) then begin
        SendDlgItemMessage(Dialog,id_edit,WM_GETTEXT,MAXPNAMELEN-1,Longint(RenamePortName));
        EndDialog(Dialog, id_ok);
        Exit;
      end else if (WParam = id_Cancel) then begin
        EndDialog(Dialog, id_Cancel);
        Exit;
      end {else if (WParam = id_Default) then begin
      end};
  end;
  RenamePort := False;
end;

function HelpDlg(Dialog: HWnd; Message, WParam: Word;
  LParam: Longint): Bool; export;
begin
  HelpDlg:=False;
  if (Message=wm_Command) and (WParam = id_Ok) then begin
        EndDialog(Dialog, id_OK);
        HelpDlg:=True;
        Exit;
  end;
end;

var local_ActivePorts : integer;
function Config(Dialog: HWnd; Message, WParam: Word;
  LParam: Longint): Bool; export;
const id_Names = 101;
      id_NumActPort = 301;
      id_help = 99;

var i:Integer;
    x:bool;
    name:array[0..MaxPNameLen-1] of Char;
    pt : TPoint;

begin
  Config := True;
  case Message of
    wm_InitDialog:
      begin
         local_ActivePorts:=gActivePorts;
         for i:=0 to gNumPorts-1 do begin

            PortName(name,i);
            SendDlgItemMessage(Dialog,id_Names+i,WM_SETTEXT,0,LongInt(@name[0]));

            { if i>gActivePorts gray names }
            if i>=local_ActivePorts then begin
               EnableWindow(GetDlgItem(Dialog,id_Names+i),WordBool(False));
            end;
         end;
         CheckRadioButton(Dialog,id_NumActPort,id_NumActPort+gNumPorts-1,id_NumActPort+local_ActivePorts-1);
         Exit;
      end;
    wm_Command:
      if (WParam = id_Ok) then begin
        for i:=0 to gNumPorts-1 do begin
            SendDlgItemMessage(Dialog,id_Names+i,WM_GETTEXT,MAXPNAMELEN,LongInt(@name[0]));
            SetPortName(name,i);
        end;
        gActivePorts:=local_ActivePorts;
        WriteConfig;
        EndDialog(Dialog, id_OK);
        Exit;
      end else if (WParam = id_Cancel) then begin
        EndDialog(Dialog, id_Cancel);
        Exit;
      end else if (WParam = id_Help) then begin
        DialogBox(HInstance, PChar(3), Dialog, @HelpDlg);
        Exit;
      end else if (wParam >= id_NumActPort) and (wParam < id_NumActPort+gNumPorts) and (HiWord(LParam)=BN_CLICKED) then
         begin
           local_ActivePorts:=wParam - id_NumActPort+1;
           for i:=1 to gNumPorts do begin
               x := Bool(i<=local_ActivePorts);
               EnableWindow(GetDlgItem(Dialog,id_Names+i-1),x);
           end;
        end;
    WM_LBUTTONDBLCLK:
      begin
         pt.x := LoWord(LParam);
         pt.y := HiWord(LParam);
         i := GetDlgCtrlId(ChildWindowFromPoint(Dialog,pt));
         if ((i>=id_Names)and(i<id_Names+local_ActivePorts))
         then begin
            SendDlgItemMessage(Dialog,i,WM_GETTEXT,MAXPNAMELEN,LongInt(@name[0]));
            if DialogBoxParam(HInstance, PChar(2), Dialog, @RenamePort,Longint(@name[0]))=id_ok
            then SendDlgItemMessage(Dialog,i,WM_SETTEXT,0,LongInt(@name[0]));
         end;
     end;
  end;
  Config := False;
end;


{-------------------------------------------------------------------------
  INSTALLABLE DRIVER PART
 -------------------------------------------------------------------------}
function DrvDefDriverProc(DriverIdentifier: Longint; DriverId: THandle; Message:
Word; lParam1, lParam2: Longint): Longint; far; external 'MMSYSTEM' index 1104;

function DriverProc(
         dwDriverID :LongInt;
         hDriver    :WORD;
         uiMessage  :WORD;
         lParam1,
         LParam2:LongInt)
          : LongInt; export;
VAR old_ActivePorts : integer;
BEGIN
    case uiMessage of
    DRV_LOAD: begin
        ReadConfig;
        DriverProc := 1;
        end;
    DRV_FREE:
        DriverProc := 1;
    DRV_OPEN:
        DriverProc := 1;
    DRV_CLOSE:
        DriverProc := 1;
    DRV_ENABLE:
        DriverProc := 1;
    DRV_DISABLE:
        DriverProc := 1;
    DRV_QUERYCONFIGURE:
        DriverProc := 1;
    DRV_CONFIGURE:
        begin
           old_ActivePorts := gActivePorts;
{$IFDEF USE_CTL3D}
           Ctl3dRegister(HInstance);
           Ctl3dAutoSubclass(HInstance);
           DialogBox(HInstance, PChar(1), LoWord(lparam1), @Config);
           Ctl3dUnregister(HInstance);
{$ELSE}
           DialogBox(HInstance, PChar(1), LoWord(lparam1), @Config);
{$ENDIF}
           if old_ActivePorts<>gActivePorts then
              DriverProc := drv_Restart
           else
              DriverProc := 0;
        end;
   DRV_INSTALL:
        begin
         WriteConfig; { Create new system.ini entries }
         { PDrvConfigInfo(LParam2)^.lpszDCISectionName is "drivers" }
         { PDrvConfigInfo(LParam2)^.lpszDCIAliasName id "MIDI3" or so }
         DriverProc := drv_Restart;
        end;
    DRV_REMOVE:
        begin { Remove all related entries from system.ini }
         WritePrivateProfileString(gszSection,nil,nil,gszIniFile);
         DriverProc := drv_Restart;
        end
    else
        DriverProc := DrvDefDriverProc(dwDriverID, hDriver, uiMessage, lParam1, lParam2);
    end;
END;


{ ---------------------------------------------------------------------------
  Exported Functions
  --------------------------------------------------------------------------- }
exports
        DriverProc index 1,
        modMessage index 2,
        midMessage index 3;


{ ---------------------------------------------------------------------------
  Init variables
  --------------------------------------------------------------------------- }
VAR id,cl:integer;
BEGIN
   for id:=0 to gNumPorts-1 do begin
      for cl:=0 to gNumInClients-1 do begin
       gMidiInClient[id,cl].h_Midi := 0;
       gMIMC[id,cl].bStarted := false;
      end;
      for cl:=0 to gNumOutClients-1 do begin
       gMidiOutClient[id,cl].h_Midi := 0;
       gbMidiOutCurrentStatus[id,cl] := 0;
      end;
   end;
END.