// mainfrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "tooltest.h"
#include "toolopti.h"

#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(IDD_TOOLBAR, OnToolbar)
	ON_COMMAND(IDD_SAMPLEBUTTON, OnSampleButton)
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP_INDEX, CMDIFrameWnd::OnHelpIndex)
	ON_COMMAND(ID_HELP_USING, CMDIFrameWnd::OnHelpUsing)
	ON_COMMAND(ID_HELP, CMDIFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CMDIFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CMDIFrameWnd::OnHelpIndex)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars

// toolbar buttons - IDs are command buttons
static UINT BASED_CODE buttons[] =
{
	// same order as in the bitmap 'toolbar.bmp'
	ID_FILE_NEW,
	ID_FILE_OPEN,
	ID_FILE_SAVE,
		ID_SEPARATOR,
	ID_EDIT_CUT,
	ID_EDIT_COPY,
	ID_EDIT_PASTE,
		ID_SEPARATOR,
	ID_FILE_PRINT,
	ID_APP_ABOUT,
		ID_SEPARATOR,
	IDD_SAMPLEBUTTON,
};

static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadBitmap(IDR_MAINFRAME) ||
		!m_wndToolBar.SetButtons(buttons,
		  sizeof(buttons)/sizeof(UINT)))
	{
		TRACE("Failed to create toolbar\n");
		return -1;      // fail to create
	}

//
// This function sets the tool bar options that were read from the .ini
// file.  They are really already set because the toolbar constructor
// reads them, but if the toolbar is not displayed (I.E., the user leaves
// it off last time they exit) then this will turn it off again ...
//
	SetToolbarOptions(FALSE); // set them but don't display dialog
	
	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE("Failed to create status bar\n");
		return -1;      // fail to create
	}

	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

//
// These functions support the toolbar options dialog and initial setup
// up after toolbar creation (incase the user leaves it off)
//
void CMainFrame::OnToolbar()
{
	SetToolbarOptions(TRUE);
}

void CMainFrame::SetToolbarOptions(BOOL bDisplayDialog)
{
	CToolOptions ToolDlg;
	int iStatus;
	
	ToolDlg.m_StatusLine = m_wndToolBar.GetFlyby();
	ToolDlg.m_Popup = m_wndToolBar.GetTips();
	ToolDlg.m_BoxStyle = m_wndToolBar.GetTipStyle();
	ToolDlg.m_SystemFont = m_wndToolBar.GetTipFont();
	ToolDlg.m_Wait = m_wndToolBar.GetTipWait();
	ToolDlg.m_ToolBar = m_wndToolBar.GetToolbarDisplay();
	
	if (bDisplayDialog)
		iStatus = ToolDlg.DoModal ();
	else
		iStatus = IDOK;
			
	if (iStatus == IDOK) {
		m_wndToolBar.SetFlyby(ToolDlg.m_StatusLine);
		m_wndToolBar.SetTips(ToolDlg.m_Popup);
		m_wndToolBar.SetTipStyle(ToolDlg.m_BoxStyle);
		m_wndToolBar.SetTipFont(ToolDlg.m_SystemFont);
		m_wndToolBar.SetTipWait(ToolDlg.m_Wait);
		m_wndToolBar.SetToolbarDisplay(ToolDlg.m_ToolBar);
		RecalcLayout();
	}
}

void CMainFrame::OnSampleButton()
{
	MessageBeep(MB_ICONASTERISK);
	AfxMessageBox("Sample Button Pressed - See It Works ...");
	MessageBeep(MB_ICONHAND);
}