Option Explicit

' User type Test declaration example
Type test
   l2 As Long
   fs As String * 5
   l  As Long
   i  As Integer
   c  As Currency
End Type

' It is good practice to create a constant that matches the user type declaration.
' To be sure that both are in sync, keep them close to each other.
' The constant is then used when calling the the user type sort routine
Global Const TestTypeDeclaration_c = "Long, String*5, Long, Integer, Currency"

' You need to make a declaration for each user type you create. It is also a good
' idea to keep these declarations near the declaration of the user type.
Declare Sub SortIdxTest Lib "aavbsort.dll" Alias "SortIdxUserType" (array() As test, ByVal typeDeclaration As String, intArray() As Integer, ByVal elementIndexToSortOn As Integer)
Declare Sub SortAryTest Lib "aavbsort.dll" Alias "SortAryUserType" (array() As test, ByVal typeDeclaration As String, ByVal elementIndexToSortOn As Integer)


' Below is another example of a user type declaration
Type test2
   l  As Long
   i  As Integer
   st As String
   fs As String * 80
   c  As Currency
End Type

Global Const TestType2Declaration_c = "Long, Integer, String, String*80, Currency"

Declare Sub SortIdxTest2 Lib "aavbsort.dll" Alias "SortIdxUserType" (array() As test2, ByVal typeDeclaration As String, intArray() As Integer, ByVal elementIndexToSortOn As Integer)
Declare Sub SortAryTest2 Lib "aavbsort.dll" Alias "SortAryUserType" (array() As test2, ByVal typeDeclaration As String, ByVal elementIndexToSortOn As Integer)

